#!/usr/bin/python

#test kendall-tau median of permutations
#LRI, January 2018
#DIRO, April 2018

#export PYTHONPATH=$PYTHONPATH:/opt/ibm/ILOG/CPLEX_Studio128/cplex/python/2.7/x86-64_linux
#echo $PYTHONPATH

import cplex
import random
import math
import time
from os import listdir


def create_permutation(n):
  permutation = range(1,n+1)
  random.shuffle(permutation)
  return permutation

#ask the user for size of set and permutations
n = 20
#n = int(raw_input("Permutation size:"))
#print n
m = 3
#m = int(raw_input("Number of permutations:"))
#print m


nm = 0
ts = time.time()


listN = []

numberOf3CyclesStats = []
numberOfConstraintsStats = []

timeILPNormalStats = []
timeILPWith3CycleThmStats = []
time3HS = []

listOfSizes = [29, 20, 44, 64, 24, 67, 23, 42, 28, 11, 70, 67, 63, 23, 43, 21, 14, 23, 40, 52, 17, 23, 72, 20, 14, 55, 77, 56, 32, 71, 41, 24, 18, 69, 24, 44, 18, 17, 40, 73, 67, 12, 18, 45, 82, 26, 36, 70, 81, 52, 89, 18, 68, 37, 23, 87, 32, 60, 41, 23, 38, 30, 19, 19, 20, 18, 55, 21, 20, 30]

iterationNumber = 0
#reads all election files
listOfFiles = listdir("soc/")
for iteration in listOfSizes:
#for iteration in range(100):
	iterationNumber += 1
	#n = random.randint(10,100)
	n = iteration

	print m,n

	listN.append(n)

	#***********generate random instance***********
	#create a list of permutations
	Rankings = []
	for i in range(0,m):
	  pi = create_permutation(n)
	  #print pi
	  Rankings.append(pi)
	
	#write the set R
	writeFileName = "testData/random/ex%s.txt" % iterationNumber
	f = open(writeFileName,"w")
	f.write("{")
	for i in range(0,len(Rankings)-1):
	  f.write(str(Rankings[i]) + ",\n")
	f.write(str(Rankings[len(Rankings)-1]) + "}\n")
	f.close()



	#read a set of permutation from file
	#to do

	#empty matrice
	L = [] #left matrice
	C = [] #constraints matrice
	for i in range(0,n):
	  l = []
	  c = []
	  for j in range(0,n):
	    l.append(0)
	    c.append(False)
	  L.append(l)
	  C.append(c)

	#fill left matrice
	for pi in Rankings:
	  for i in range(0,n-1):
	    for j in range(i+1,n):
	      L[pi[i]-1][pi[j]-1] += 1

	#print matrice
	#print "L"
	#for l in L:
	#  print l


	#*********3-cycles thm*********

	constraintOk = False
	numberOfConstraints = 0
	numberOf3Cycles = 0

	for i in range(0,n):
	  for j in range(0,n):
	    if (i != j and L[i][j] > L[j][i]): #ij
	      constraintOk = True
	      for k in range(0,n):
		if i != k and j != k:
		  if (L[j][k] > L[k][j] and L[k][i] > L[i][k]): #jk ki
		    constraintOk = False
		    numberOf3Cycles += 1 #new 3-cycle = (i,j,k)
	      if (constraintOk == True):
		C[i][j] = True
		numberOfConstraints += 1

	#print "3-cycles thm solved: %s / %s (%f)" % (countConstraints, (n*(n-1)/2), float(countConstraints/ (n*(n-1)/2.0)))
	#print "%s" % (countConstraints)

	numberOf3CyclesStats.append(numberOf3Cycles)
	numberOfConstraintsStats.append(numberOfConstraints)
	maxNumberOf3Cycles = n*(n-1)*(n-2)/6
	maxNumberOfConstraints = n*(n-1)/2
	#print "numberOf3Cycles: %s / %s" % (numberOf3Cycles, maxNumberOf3Cycles)
	#print "numberOfConstraints: %s / %s" % (numberOfConstraints, maxNumberOfConstraints)

	#if (numberOf3Cycles == 0):
	#	print Rankings
	#	print electionFile


	#***********CPLEX API: building and solving a model***********
	#print "M3P ILP model"
	my_prob = cplex.Cplex() #initiate
	my_prob.set_results_stream(None) #mute
	my_prob.parameters.threads.set(1) #using only one thread
        my_prob.parameters.mip.tolerances.mipgap.set(0.0) #to get an optimal solution
        my_prob.parameters.timelimit.set(3600.0) #maximum 60 minutes of calculations

	my_prob.objective.set_sense(my_prob.objective.sense.minimize) #we want to minimize the objective function

	indicator_i = []
	indicator_j = []

	my_obj = []
	my_ub = []
	my_lb = []
	my_ctype = ""
	my_names = []

	#add all the variables, their bounds and the objective function
	for i in range(0,n):
	  for j in range(0,n):
	    if not i==j:
	      my_obj.append(L[j][i])
	      my_ub.append(1.0)
	      my_lb.append(0.0)
	      my_ctype += "B"
	      s = "x_%s_%s" % ((i+1), (j+1))
	      my_names.append(s)

	      indicator_i.append(i)
	      indicator_j.append(j)


	my_prob.variables.add(obj=my_obj, lb=my_lb, ub=my_ub, types=my_ctype, names=my_names)

	my_rhs = []
	my_rownames = []
	my_sense = ""
	rows = []

	#add the binary order constraints
	count = 0
	for i in range(0,n-1):
	  for j in range(i+1,n):
	    if not i==j:
	      my_rhs.append(1)
	      s = "c%s" % count
	      count+=1
	      my_rownames.append(s)
	      my_sense += "E"
	      first_var = "x_%s_%s" % ((i+1), (j+1))
	      second_var = "x_%s_%s" % ((j+1), (i+1))
	      row = [[first_var,second_var],[1.0,1.0]]
	      rows.append(row)

	      
	#add the transitivity constraints
	for i in range(0,n):
	  for j in range(0,n):
	    if i != j:
	      for k in range(0,n):
		if i != k and j != k:
		  my_rhs.append(1)
		  s = "c%s" % count
		  count+=1
		  my_rownames.append(s)
		  my_sense += "G"
		  first_var = "x_%s_%s" % ((i+1), (j+1))
		  second_var = "x_%s_%s" % ((j+1), (k+1))
		  third_var = "x_%s_%s" % ((k+1), (i+1))
		  row = [[first_var,second_var,third_var],[1.0,1.0,1.0]]
		  rows.append(row)



	my_prob.linear_constraints.add(lin_expr=rows, senses=my_sense,
				        rhs=my_rhs, names=my_rownames)

	start = my_prob.get_dettime()
	my_prob.solve() #solve
	end = my_prob.get_dettime()
	elapsed = end - start
	timeILPNormalStats.append(elapsed)
	#print " elapsed det time: %s" % elapsed

	#print " Solution value  = %s" % my_prob.solution.get_objective_value() #print optimal value
	solution = my_prob.solution.get_objective_value()

	#retrieving solution
	numcols = my_prob.variables.get_num()
	x = my_prob.solution.get_values()
	positions = [1]*n
	permutation = range(1,n+1)
	for i in range(numcols):
	  if x[i] == 1.0:
	    positions[indicator_j[i]]+=1
	#print positions
	positions, permutation = zip(*sorted(zip(positions, permutation)))
	#print permutation

	#write the ILP model into a file from cplex API
	#my_prob.write("M3P.lp")





	#***********CPLEX API: building and solving a model***********
	#print "M3P ILP model with 3-cycle thm"
	my_prob = cplex.Cplex() #initiate
	my_prob.set_results_stream(None) #mute
	my_prob.parameters.threads.set(1) #using only one thread
        my_prob.parameters.mip.tolerances.mipgap.set(0.0) #to get an optimal solution
        my_prob.parameters.timelimit.set(3600.0) #maximum 60 minutes of calculations

	my_prob.objective.set_sense(my_prob.objective.sense.minimize) #we want to minimize the objective function

	indicator_i = []
	indicator_j = []

	my_obj = []
	my_ub = []
	my_lb = []
	my_ctype = ""
	my_names = []

	#add all the variables, their bounds and the objective function
	for i in range(0,n):
	  for j in range(0,n):
	    if not i==j:
	      my_obj.append(L[j][i])
	      my_ub.append(1.0)
	      my_lb.append(0.0)
	      my_ctype += "B"
	      s = "x_%s_%s" % ((i+1), (j+1))
	      my_names.append(s)

	      indicator_i.append(i)
	      indicator_j.append(j)


	my_prob.variables.add(obj=my_obj, lb=my_lb, ub=my_ub, types=my_ctype, names=my_names)

	my_rhs = []
	my_rownames = []
	my_sense = ""
	rows = []

	#add the binary order constraints
	count = 0
	for i in range(0,n-1):
	  for j in range(i+1,n):
	    if not i==j:
	      my_rhs.append(1)
	      s = "c%s" % count
	      count+=1
	      my_rownames.append(s)
	      my_sense += "E"
	      first_var = "x_%s_%s" % ((i+1), (j+1))
	      second_var = "x_%s_%s" % ((j+1), (i+1))
	      row = [[first_var,second_var],[1.0,1.0]]
	      rows.append(row)

	#add the 3-cycle thm constraints
	count = 0
	for i in range(0,n):
	  for j in range(0,n):
	    if not i==j:
	      if (C[i][j] == True):
		my_rhs.append(1)
		s = "c%s" % count
		count+=1
		my_rownames.append(s)
		my_sense += "E"
		first_var = "x_%s_%s" % ((i+1), (j+1))
		row = [[first_var],[1.0]]
		rows.append(row)

	      
	#add the transitivity constraints
	for i in range(0,n):
	  for j in range(0,n):
	    if i != j:
	      for k in range(0,n):
		if i != k and j != k:
		  my_rhs.append(1)
		  s = "c%s" % count
		  count+=1
		  my_rownames.append(s)
		  my_sense += "G"
		  first_var = "x_%s_%s" % ((i+1), (j+1))
		  second_var = "x_%s_%s" % ((j+1), (k+1))
		  third_var = "x_%s_%s" % ((k+1), (i+1))
		  row = [[first_var,second_var,third_var],[1.0,1.0,1.0]]
		  rows.append(row)



	my_prob.linear_constraints.add(lin_expr=rows, senses=my_sense,
			                rhs=my_rhs, names=my_rownames)

	start = my_prob.get_dettime()
	my_prob.solve() #solve
	end = my_prob.get_dettime()
	elapsed = end - start
	timeILPWith3CycleThmStats.append(elapsed)
	#print " elapsed det time: %s" % elapsed

	#print " Solution value  = %s" % my_prob.solution.get_objective_value() #print optimal value
	solution_M3P = my_prob.solution.get_objective_value()

	#retrieving solution
	numcols = my_prob.variables.get_num()
	x = my_prob.solution.get_values()
	positions = [1]*n
	permutation = range(1,n+1)
	for i in range(numcols):
	  if x[i] == 1.0:
	    positions[indicator_j[i]]+=1
	#print positions
	positions, permutation = zip(*sorted(zip(positions, permutation)))
	#print " ",permutation

	#write the ILP model into a file from cplex API
	#my_prob.write("M3P.lp")






	#***********CPLEX API: building and solving a model 3HS***********
	#print "3HS ILP model"

	LB1 = 0
	for i in range(0,n-1):
	  for j in range(i+1,n):
	    LB1+=min(L[j][i],L[i][j])
	#print " LB1 = %s" % LB1

	my_prob = cplex.Cplex() #initiate
	my_prob.set_results_stream(None) #mute
	my_prob.parameters.threads.set(1) #using only one thread
        my_prob.parameters.mip.tolerances.mipgap.set(0.0) #to get an optimal solution
        my_prob.parameters.timelimit.set(3600.0) #maximum 60 minutes of calculations

	my_prob.objective.set_sense(my_prob.objective.sense.minimize) #we want to minimize the objective function

	indicator_i = []
	indicator_j = []

	my_obj = []
	my_ub = []
	my_lb = []
	my_ctype = ""
	my_names = []

	#add all the variables, their bounds and the objective function
	for i in range(0,n):
	  for j in range(0,n):
	    if not i==j:
	      my_obj.append(L[j][i]-min(L[j][i],L[i][j]))
	      my_ub.append(1.0)
	      my_lb.append(0.0)
	      my_ctype += "B"
	      s = "x_%s_%s" % ((i+1), (j+1))
	      my_names.append(s)

	      indicator_i.append(i)
	      indicator_j.append(j)


	my_prob.variables.add(obj=my_obj, lb=my_lb, ub=my_ub, types=my_ctype, names=my_names)

	my_rhs = []
	my_rownames = []
	my_sense = ""
	rows = []

	#add the binary order constraints for fake variables
	count = 0
	for i in range(0,n-1):
	  for j in range(i+1,n):
	    if not i==j:
	      my_rhs.append(1)
	      s = "c%s" % count
	      count+=1
	      my_rownames.append(s)
	      my_sense += "E"
	      first_var = "x_%s_%s" % ((i+1), (j+1))
	      second_var = "x_%s_%s" % ((j+1), (i+1))
	      row = [[first_var,second_var],[1.0,1.0]]
	      rows.append(row)

	      
	#add the 3-cycles covering constraints
	for i in range(0,n):
	  for j in range(0,n):
	    if i != j:
	      for k in range(0,n):
		if i != k and j != k:
		  if (L[j][i] > L[i][j] and L[k][j] > L[j][k] and L[i][k] > L[k][i]):
		    my_rhs.append(1)
		    s = "c%s" % count
		    count+=1
		    my_rownames.append(s)
		    my_sense += "G"
		    first_var = "x_%s_%s" % ((i+1), (j+1))
		    second_var = "x_%s_%s" % ((j+1), (k+1))
		    third_var = "x_%s_%s" % ((k+1), (i+1))
		    row = [[first_var,second_var,third_var],[1.0,1.0,1.0]]
		    rows.append(row)



	my_prob.linear_constraints.add(lin_expr=rows, senses=my_sense,
			                rhs=my_rhs, names=my_rownames)

	start = my_prob.get_dettime()
	my_prob.solve() #solve
	end = my_prob.get_dettime()
	elapsed = end - start
	time3HS.append(elapsed)
	#print " elapsed det time: %s" % elapsed

	#print " Solution value  = %s" % my_prob.solution.get_objective_value() #print optimal value
	#print " Solution total  = %s" % (my_prob.solution.get_objective_value()+LB1) #print optimal value

	solution_3HS = my_prob.solution.get_objective_value()+LB1

	#retrieving solution
	numcols = my_prob.variables.get_num()
	x = my_prob.solution.get_values()
	positions = [1]*n
	permutation = range(1,n+1)
	for i in range(numcols):
	  if x[i] == 1.0:
	    positions[indicator_j[i]]+=1
	#print positions
	positions, permutation = zip(*sorted(zip(positions, permutation)))
	#print " ",permutation

	#write the ILP model into a file from cplex API
	my_prob.write("3HS.lp")



	#test conjecture 2
	if (abs(solution_M3P - solution_3HS) > 0.001):
	  print "*************************************************"
	  print "****************NOT MATCHING*********************"
	  print "*************************************************"
	  #write the set R
	  s = "not_matching%s.txt" % nm
	  f = open(s,"w")
	  f.write("{")
	  for i in range(0,len(Rankings)-1):
	    f.write(str(Rankings[i]) + ",\n")
	  f.write(str(Rankings[len(Rankings)-1]) + "}\n")
	  f.close()
	  print "solution_M3P: ", solution_M3P
	  print "solution_3HS: ", solution_3HS
	solution_M3P = 0
	solution_3HS = 0







print "End"



print "listN"
for t in listN:
	print t
print " "

print "numberOf3CyclesStats"
for t in numberOf3CyclesStats:
	print t
print " "

print "numberOfConstraintsStats"
for t in numberOfConstraintsStats:
	print t
print " "

print "timeILPNormalStats"
for t in timeILPNormalStats:
	print t
print " "

print "timeILPWith3CycleThmStats"
for t in timeILPWith3CycleThmStats:
	print t
print " "

print "time3HS"
for t in time3HS:
	print t
print " "


st = time.time()-ts
print st, "sec"

