package ca.umontreal.iro.ift1155.handler02;

import java.util.Date;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Objects;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.app.Activity;
import android.view.Menu;
import android.view.View;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

public class MainActivity extends Activity {

	static Handler handler;
	TextView myTextView;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		myTextView = findViewById(R.id.myTextView);
		myTextView.setTextColor(ContextCompat.getColor(this, R.color.text_origine));
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
	
	public void buttonClick(View view){
		final String formats = "HH:mm:ss MM/dd/yyyy";

	    Runnable runnable = () -> {
			Message msg = handler.obtainMessage();
			Bundle bundle = new Bundle();
			SimpleDateFormat dateformat = new SimpleDateFormat(formats, Locale.US);
			String dateString = dateformat.format(new Date());
			bundle.putString("myKey", dateString);
			msg.setData(bundle);
			handler.sendMessage(msg);
		};
	    handler = new CustomHandler(this);
	    Thread mythread = new Thread(runnable);
		mythread.start();
	}
	
	static class CustomHandler extends Handler {

        final private MainActivity activity;

        CustomHandler(MainActivity activity) {
			super(Objects.requireNonNull(Looper.myLooper()));
            this.activity = activity;
        }

        @Override
        public void handleMessage(Message msg) {
        	
    		Bundle bundle = msg.getData();
    		String string = bundle.getString("myKey");
			activity.myTextView.setText(string);
			activity.myTextView.setTextColor(ContextCompat.getColor(activity,R.color.text_changed));
        }

    }
}
