package ca.umontreal.iro.ift1155.handler01;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.app.Activity;
import android.view.Menu;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;

import java.util.Objects;

public class MainActivity extends Activity {
	
	Handler handler;
	TextView myTextView;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		myTextView = findViewById(R.id.myTextView);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
	
	public void buttonClick(View view){
	    Runnable runnable = new Runnable() {
	    	public void run() {     	
	    		long endTime = System.currentTimeMillis() + 20*1000;
				while (System.currentTimeMillis() < endTime) {
			   		synchronized (this) {
			   			try {
			   				wait(endTime - System.currentTimeMillis());
		        		} catch (Exception e) {
                            e.printStackTrace();
                        }
		        	}
		        }
			    handler.sendEmptyMessage(0);
		    }
	    };
	    handler = new CustomHandler(this);
	    Thread mythread = new Thread(runnable);
		myTextView.setText(R.string.hello_world);
		myTextView.setTextColor(ContextCompat.getColor(this, R.color.text_origine));

		mythread.start();
	}
	
	static class CustomHandler extends Handler {

        private final MainActivity activity;

        CustomHandler(MainActivity activity) {
			super(Objects.requireNonNull(Looper.myLooper()));
            this.activity = activity;
        }

        @Override
        public void handleMessage(@NonNull Message msg) {
            activity.myTextView.setText(R.string.button_clic);
            activity.myTextView.setTextColor(ContextCompat.getColor(activity,R.color.text_changed));
        }
    }
}
