package ca.umontreal.iro.ift1155.recyclerview;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.os.Bundle;
import android.util.Log;
import android.view.View;

import java.util.ArrayList;
import java.util.Random;

public class MainActivity extends AppCompatActivity {

    RecyclerView mRecyclerView;
    ArrayList<Commentaire> data = new ArrayList<>();
    AdapterClass adapter;
    long id = 0;
    String TAG = "DIRO";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        mRecyclerView = findViewById(R.id.recyclerview);

        adapter = new AdapterClass(data);
        mRecyclerView.setAdapter(adapter);
        mRecyclerView.setLayoutManager(new LinearLayoutManager(this, RecyclerView.VERTICAL, false));

    }

    public void onClick(View view) {
        Commentaire comment;
        if (view.getId() == R.id.add) {
            String[] comments = new String[] { "Cool", "Very nice", "Hate it" };
            int nextInt = new Random().nextInt(3);
            // Save the new comment to the database
            comment = new Commentaire(id,comments[nextInt]);
            id++;
            data.add(comment);
            adapter.notifyItemInserted((int) id);
            Log.i(TAG,"add: " + comment.getComment() + " size: " + adapter.getItemCount());
        }
        if (view.getId() ==  R.id.delete){
            if (adapter.getItemCount() > 0){
                comment = data.get(0);
                data.remove(comment);
                adapter.notifyItemRemoved(0);
                Log.i(TAG,"del: " + comment.getComment() + " size: " + adapter.getItemCount());
            }
        }
    }

}