/*
	IFT1169 - utilisation de ptrnull C++11

20-octobre	-2016	v1.02	M.Lokbani	gcc 6.2.0 (Linux)
18-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1 (Linux)
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)


	contact: lokbani@iro.umontreal.ca


	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle

	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------

	ptrnull: 	nouveau mot clé, valeur constate assignable à tous les types de
	pointeurs. Cette valeur n'est pas un int et ne peut pas être convertie à un
	int (quoi que ...)

	Il permet de lever l'ambiguité dans le cas suivant:

	void fonction(int) {}
	void fonction(int*) {}

	fonction(NULL) => prend le 1er choix
	fonction(nullptr) => prend le 2e choix

*/


#include <iostream>

using namespace std;


void f(int x) {
	cout << "int" << '\n';
}
void f(char* p){
	cout << "char*" << '\n';
}

void g(int zz){
}

int main(){

	// erreur: invalid conversion from 'int' to 'int*'
	//int *t = 1;

	/* ok, 0 a l'équivalence d'un pointeur nul (on s'assure aussi
	qu'il reste compatible) */
	int *q = 0;
	char* p = nullptr;
	int* w = nullptr;
	char* p2 = 0;		// 0 ok et p==p2

	f(0);         		// appel f(int)
	f(nullptr);   		// appel f(char*)

	// erreur:
	// cannot convert 'std::nullptr_t' to 'int' for argument '1' to 'void g(int)'
	//g(nullptr);

	// erreur: cannot convert 'std::nullptr_t' to 'int' in initialization
	//int i = nullptr;

	// On fait semblant de faire quelque chose avec les pointeurs pour éviter
	// les avertissements
	cout << "q:" << &q << " ; p:" << &p << " ; w:" << &w << " ; p2:" \
																													<< &p2 << endl;

	return 0;
}


/*

	>./01_nullptr
		int
		char*
		q:0x7fffdf6c80c0 ; p:0x7fffdf6c80c8 ; w:0x7fffdf6c80d0 ; p2:0x7fffdf6c80d8
	>Exit code: 0

*/
