/*
	IFT1169 - utilisation de constructeur dans un constructeur C++11

20-octobre	-2016	v1.02	M.Lokbani	gcc 6.2.0 (Linux)
25-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1 avec -std=c++11
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)



	contact: lokbani@iro.umontreal.ca


	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle

	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------

	Delegating constructors : combien de fois auriez-vous aimé appeler un
	constructeur à partir d'un autre
		constructeur de la même classe?

			class Foo {
			public:
				Foo(char x);
				Foo(char x, int y);
			};

			Foo::Foo(char x) {
			  Foo(x, 0);  // Impossible!
			}


		Comme ce n'était pas possible, il fallait utiliser:
			- valeurs par défaut pour simuler un constructeur donné,

			class Foo {
			public:
				Foo(char x, int y=0);  // un constructeur pour 2!
			};

			- une fonction d'initialisation à part


			class Foo {
			public:
				Foo(char x);
				Foo(char x, int y);
			private:
				void init(char x, int y);
			};
			Foo::Foo(char x) {
				init(x, int(x) + 7);
			}
			Foo::Foo(char x, int y) {
				init(x, y);
			}
			void Foo::init(char x, int y) {
				// ...
			}


		Avec C++11, il est maintenant possible d'appeler un constructeur à partir
		d'un autre constructeur!


*/


#include <iostream>

class Foo {
public:
	Foo(char x);
	Foo(char x, int y);
};

Foo::Foo(char x,int y) {
	std::cout << "constructeur (char,int)" << '\n';
}

Foo::Foo(char x) {
	std::cout << "constructeur (char)" << '\n';
	Foo(x, 0);  // Maintenant c'est possible!
}


int main(){
	Foo x('s',8);
	Foo y('z');

	return 0;
}


/*

	>./02_construct
	constructeur (char,int)
	constructeur (char)
	constructeur (char,int)
	>Exit code: 0

*/
