/*
	IFT1169 - utilisation de narrowing C++11

20-octobre	-2016	v1.02	M.Lokbani	gcc 6.2.0 (Linux)
29-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1 avec -std=c++11, +qcqs corrections
22-avril		-2013	v1.00	M.Lokbani	gcc 7.2.3 (Linux)


	contact: lokbani@iro.umontreal.ca


	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle

	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------

	narrowing: conversions non sécurisées
		Permet de localiser une conversion dégradante (un arrondi)
		d'un type A vers un type B.

		La conversion d'un double vers un in est un exemple.


*/

#include <iostream>
#include <vector>

void f(int x) {}

int main(){

	int x = 7.3;		// conversion double en int, perte
	void f(int);
	f(7.3);			// conversion double en int, perte

	// warning: narrowing conversion of '7.2999999999999998e+0'
	// from 'double' to 'int' inside { } [-Wnarrowing]
	int x0 {7.3};		// erreur: approximation

	// warning: narrowing conversion of '7.2999999999999998e+0' from 'double'
	// to 'int' inside { } [-Wnarrowing]
	int x1 = {7.3};	// erreur: approximation
	double d = 7.0;

	// warning: narrowing conversion of 'd' from 'double'
	// to 'int' inside { } [-Wnarrowing]
	int x2{d};		// erreur: approximation (double vers int)
	char x3{7};		// ok: 7 iest int, pas d'approximation

	/*
	warning: narrowing conversion of '2.2999999999999998e+0' from 'double'
	 to 'int' inside { } [-Wnarrowing]
	warning: narrowing conversion of '2.2999999999999998e+0' from 'double'
	 to 'int' inside { } [-Wnarrowing]
	warning: narrowing conversion of '5.5999999999999996e+0' from 'double'
	 to 'int' inside { } [-Wnarrowing]
	warning: narrowing conversion of '5.5999999999999996e+0' from 'double'
	 to 'int' inside { } [-Wnarrowing]
	*/

  // erreur: erreur: approximation double a int
	std::vector<int> vi = { 1, 2.3, 4, 5.6 };

  // OK: 7 est un int, rentre dans un char
	char c1{7};

	// warning: narrowing conversion of '77777' from 'int'
	// to 'char' inside { } [-Wnarrowing]
	// warning: overflow in implicit constant conversion [-Woverflow]
	char c2{77777};  // erreur: approximation

	// Pour eviter les avertissements
	std::cout << "x: " << x << " ; x0: " << x0 << " ; x1: " << x1 << std::endl;
	std::cout << "x2: " << x2 << " ; x3: " << x3 << " ; c1: " << c1 << std::endl;
	std::cout << "c2: " << c2 << std::endl;

	return 0;

}
