/*
	IFT1169 - utilisation de enum C++11

20-octobre	-2016	v1.02	M.Lokbani	gcc 6.2.0 (Linux)
19-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1 avec -std=c++11
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)


	contact: lokbani@iro.umontreal.ca


	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle
	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------

	enum: la nouvelle version corrige certains dépassements de types

	Le nouveau enum est du type classe. Il combine le traditionnel enum en
	lui ajoutant les notions d'appartenance à la classe (membres de)
	et l'absence de conversion par défaut en int.
	On parle alors d'énumérations fortement typées.

*/

#include <iostream>

int main(){

	enum Alerte { vert, jaune, election, rouge }; // enum classique

	enum class Couleur { rouge, bleu };	// balise la portee et typage renforce
									// impossible d'exporter les éléments
									// impossible de les convertir en int

	enum class Lumieres { rouge, jaune, vert };

	// Erreur (par défaut en C++)
	// invalid conversion from 'int' to 'main()::Alerte'

	// Alerte a = 7;

	// Erreur conversion interdite
	// cannot convert 'int' to 'main()::Couleur' in initialization

	// Couleur c = 7;

	// Ok: conversion de Alert à int
	int a2 = rouge;
	std::cout << "a2: " << a2 << '\n';

	// Erreur dans C++98; ok dans C++11
	int a3 = Alerte::rouge;
	std::cout << "a3: " << a3 << '\n';


	// Erreur: 'bleu' was not declared in this scope
	// int a4 = bleu;

	// Erreur: cannot convert 'main()::Couleur' to 'int' in initialization
	// int a5 = Couleur::bleu;

	Couleur a6 = Couleur::bleu;   // ok

	// Erreur, ce n'est pas un int. Il faut donc définir l'opérateur de sortie
	// dans la classe Couleur
	// no match for ‘operator<<’ (operand types are ‘std::basic_ostream<char>’
	// and ‘main()::Couleur’)

	// std::cout << "a6: " << a6 << '\n';

	// On peut forcer une conversion explicite
	std::cout << static_cast<int>(a6) << std::endl;

	// Représentation compacte, le type est ici charactère
	// Attention, on ne peut pas spécifier n'importe quel type
	// On ne peut pas mettre double par exemple
	enum class CouleurBis : char { rouge, bleu };

		std::cout << static_cast<char>(CouleurBis::rouge) << std::endl;

	// Ici le type par défaut est int
	enum class LumieresBis { rouge, jaune, vert };

	return 0;
}

/*

	>./04_enum
		a2: 3
		a3: 3
		1
	>Exit code: 0

*/
