/*
	IFT1169 - utilisation de static_assert C++11

20-octobre	-2016	v1.03	M.Lokbani	gcc 6.2.0 (Linux) + FBOGUE
09-mars		-2015	v1.02	M.Lokbani	gcc 4.9.2  avec -std=c++11
18-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1 (Linux)  avec -std=c++11
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)

	contact: lokbani@iro.umontreal.ca


	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle

	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------

	static_assert:
			assert définie dans le lange C permet de tester l'état d'une instruction
			à l'execution.
			C++11 introduit le mot clé réservé "static_assert" pour tester l'état
			d'une instruction à la compilation.

	__cplusplus:
			dans C++11 la macro __cplusplus est initialisée avec une valeur supérieur
			à 199711L.
			C++ pre-C++98: __cplusplus est 1.
			C++98: __cplusplus est 19971L.
			C++0x/11: __cplusplus est 201103L.

*/

#include <iostream>

using namespace std;

template <typename T1, typename T2>
class T {
	T1 a;
	T2 b;
public:
	void affiche(){
		cout <<  "sizeof(T1): " << sizeof (T1) << " ; sizeof(T2): " \
																									<< sizeof (T2) << '\n';
	}
};

template <typename T1>
class T<T1, bool> {
	static_assert(sizeof(T1) == 0, "T<T1, bool> n'est pas autorise, desole!");
public:
	void affiche(){
		cout <<  "sizeof(T1): " << sizeof (T1) << '\n';
	}
};

int main(){

	// utilisation générale de assert
	std::cout <<  "sizeof(void*): " << sizeof (void *) << '\n';
	static_assert(sizeof(void *) == 8, "La génération d'un code en 64-bit  \
																											n'est pas supportee.");

	std::cout << "sizeof(int): " << sizeof (int) << '\n';
	static_assert(sizeof(int) >= 4, "int doit avoir une taille de 4 bytes \
																						(octets) pour utiliser ce code");

	std::cout << "__cplusplus " << __cplusplus << '\n';
	static_assert(__cplusplus > 199711L, "ce programme necessaite un \
																							compilateur compatible C++11");


	// utilisation de assert à l'intérieur de la classe

//#ifdef FBOGUE
	T<float, bool> f1;	// erreur de compilation
	f1.affiche(); // s'il n'y a pas eu d'erreur de compilation T1 = float = 4
//#endif

	T <float, int> i2;	// ok
	i2.affiche(); // s'il n'y a pas eu d'erreur de compilation T1 = float = 4

	return 0;
}


/*


	>./05_statasser
		sizeof(void*): 8
		sizeof(int): 4
		__cplusplus 201103
		sizeof(T1): 4
		sizeof(T1): 4 ; sizeof(T2): 4
	>Exit code: 0


	Si on active FBOGUE avec -DFBOGUE, on aura une erreur de compilation

	make 05_statasser_bogus
	g++ -Os -Wall -std=c++11 -DFBOGUE -pedantic -o 05_statasser_bogus
	  																												05_statasser.cpp
		05_statasser.cpp: In instantiation of ‘class T<float, bool>’:
		05_statasser.cpp:74:17:   required from here
		05_statasser.cpp:51:2: error: static assertion failed: T<T1, bool>
		 																						n'est pas autorise, desole!
		 static_assert(sizeof(T1) == 0, "T<T1, bool> n'est pas autorise, desole!");
		 ^~~~~~~~~~~~~
		makefile:49: recipe for target '05_statasser_bogus' failed
	make: *** [05_statasser_bogus] Error 1

*/
