/*
	IFT1169 - utilisation de chrono C++11

20-octobre	-2016	v1.02	M.Lokbani	gcc 6.2.0 (Linux)
18-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1 (Linux)
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)

	contact: lokbani@iro.umontreal.ca


	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle

	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------

	chrono : C++11 offre des méthodes et fonctions pour gérer simplement
	le temps. Cet ensemble est inclus dans le fichier <chrono>.


*/

#include <iostream>
#include <chrono>
#include <unistd.h>
#include <ctime>


int fibonacci(int n) {
	if (n < 10) return 1;
	return fibonacci(n-1) + fibonacci(n-2);
}

std::string asString (const std::chrono::system_clock::time_point& tp) {
	// convert to system time:
	std::time_t t = std::chrono::system_clock::to_time_t(tp);
	std::string ts = std::ctime(&t);    // convert to calendar time
	ts.resize(ts.size()-1);             // skip trailing newline
	return ts;
}


int main() {
	auto temps1 = std::chrono::system_clock::now();
	usleep(100000);
	auto temps2 = std::chrono::system_clock::now();

	std::cout << (temps2 - temps1).count() << " microsecondes." << std::endl;
	std::chrono::duration<double> nbrSecondes = (temps2 - temps1);

	std::cout << "en secondes: " << nbrSecondes.count() << std::endl;

	std::chrono::time_point<std::chrono::system_clock> debut, fin;
	debut = std::chrono::system_clock::now();

	int resultat = fibonacci(42);
	std::cout << "fibonacci(42): " << resultat << std::endl;

	fin = std::chrono::system_clock::now();

	int temps_ecoule_seconde = \
				std::chrono::duration_cast<std::chrono::seconds> (fin-debut).count();
	int temps_ecoule_microsecondes = \
		std::chrono::duration_cast<std::chrono::microseconds> (fin-debut).count();

	std::time_t temps_fin = \
			std::chrono::system_clock::to_time_t(std::chrono::system_clock::now());


	std::cout << "calul termine a " << std::ctime(&temps_fin) << \
			"temps ecoule (s): " << temps_ecoule_seconde << "s ; " \
			<< temps_ecoule_microsecondes << " micros\n";


	// print the epoch of this system clock:
	std::chrono::system_clock::time_point tp;
	std::cout << "epoch: " << asString(tp) << std::endl;

	// print current time:
	tp = std::chrono::system_clock::now();
	std::cout << "now:   " << asString(tp) << std::endl;

	// attention aux limites
	// std::numeric_limits<typename TP2::duration::rep>::min() : -9223372036854775808
	// std::numeric_limits<typename TP2::duration::rep>::max() : 9223372036854775807

	// print minimum time of this system clock:
	tp = std::chrono::system_clock::time_point::min();
    if( tp >= std::chrono::system_clock::time_point{} ) // sanity check
		std::cout << "min:   " << asString(tp) << '\n';
    else
		std::cout << "min: limite atteinte, ne sera pas correctement convertie => " << reinterpret_cast<long long&>(tp) << std::endl;

	// min: 1677-09-21T01:06:12
	
	// print maximum time of this system clock:
	tp = std::chrono::system_clock::time_point::max();
	std::cout << "max:   " << asString(tp) << std::endl;

	return 0;
}

/*

	./06_chrono
	100122252 microsecondes.
	en secondes: 0.100122
	fibonacci(42): 267914296
	calul termine a Thu Oct 20 22:16:07 2016
	temps ecoule (s): 0s ; 591829 micros
	epoch: Wed Dec 31 19:00:00 1969
	now:   Thu Oct 20 22:16:07 2016
	min:   Mon Sep 20 18:55:12 1677
	max:   Fri Apr 11 19:47:16 2262

*/
