/*
	IFT1169 - utilisation de auto C++11  (1ere partie)


20-octobre	-2016	v1.03	M.Lokbani	gcc 6.2.0 (Linux)
09-mars		-2015	v1.02	M.Lokbani	gcc 4.9.2  avec -std=c++11
18-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1 (Linux)
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)

	contact: lokbani@iro.umontreal.ca


	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle

	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------

	Inférence de types
			[wikipedia]
			L'inférence de types est un mécanisme qui permet à un compilateur
      ou un interpréteur de rechercher automatiquement les types associés à
      des expressions, sans qu'ils soient indiqués explicitement dans le code
      source.

			3 objectifs: plus de flexibilité, plus de concision, moins de redandance.


	auto: 	classe de stockage par défaut, une variable avec un durée de vie
      limitée. Cette variable est allouée dans la pile. Avec l'introduction
      du C++11, un nouveau sens a été donné à l'utilisation de "auto".

			[wikipedia]
			Le type sera automatiquement décidé par correspondance avec le type
      retourné par l'objet utilisé pour l'initialisation de la variable.
			Les variables étant déclarées avec auto devront donc impérativement
      être initialisées.

*/

#include <iostream>
#include <vector>

using namespace std;

int main() {
	auto a = 1 + 2;
	cout << "a: " << a << '\n';

	// Cette instruction va provoquer une erreur de compilation:
	// auto int c;
	// En effet le sens de "auto" a changé, le message d'erreur est:
	// [two or more data types in declaration of 'c']
	// initialisation permet de définir le type de la variable

	// On ne peut pas non plus déclarer ce qui suit:
	// auto x[10];
	// L'erreur: [error: 'x' declared as array of 'auto']
	// Comme les éléments du tableau ne sont pas initialisés, "auto"
	// ne peut pas déterminer leur type.

	return 0;

}

/*

	>./07_auto_01
		a: 3
	>Exit code: 0

*/
