/*
	IFT1169 - utilisation de auto C++11  (2e partie)


20-octobre	-2016	v1.03	M.Lokbani	gcc 6.2.0 (Linux)
09-mars		-2015	v1.02	M.Lokbani	gcc 4.9.2  avec -std=c++11
18-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1 (Linux)
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)

	contact: lokbani@iro.umontreal.ca

        
	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle
	
	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------

	Inférence de types
			[wikipedia]
			L'inférence de types est un mécanisme qui permet à un compilateur ou un interpréteur
			de rechercher automatiquement les types associés à des expressions, sans qu'ils soient
			indiqués explicitement dans le code source.
			
			3 objectifs: plus de flexibilité, plus de concision, moins de redandance.
			
	
	auto: 	classe de stockage par défaut, une variable avec un durée de vie limitée.
			Cette variable est allouée dans la pile. Avec l'introduction du C++11, un nouveau
			sens a été donné à l'utilisation de "auto".
		
			[wikipedia]
			Le type sera automatiquement décidé par correspondance avec le type retourné par
			l'objet utilisé pour l'initialisation de la variable.
			Les variables étant déclarées avec auto devront donc impérativement être initialisées.

*/

#include <iostream>
#include <vector>
 
using namespace std;


template<class T, class U>
void ajout(T t, U u){
	// Quel est le type de w? On laisse le compilateur prendre la bonne décision
	auto w = t + u;
	cout << "La somme est: " << w << endl;
}

int main() {
	
	ajout(3.5,4);
	ajout(3,4);
	ajout(3,4.5);

	return 0;

}

/*

	>./07_auto_02
		La somme est: 7.5
	>Exit code: 0

*/