/*
	IFT1169 - utilisation de auto C++11, classe vector (3e partie)


20-octobre	-2016	v1.03	M.Lokbani	gcc 6.2.0 (Linux)
09-mars		-2015	v1.02	M.Lokbani	gcc 4.9.2  avec -std=c++11
18-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1 (Linux)
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)


	contact: lokbani@iro.umontreal.ca


	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle

	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------

Inférence de types
    [wikipedia]
    L'inférence de types est un mécanisme qui permet à un compilateur
    ou un interpréteur de rechercher automatiquement les types associés à
    des expressions, sans qu'ils soient indiqués explicitement dans le code
    source.

    3 objectifs: plus de flexibilité, plus de concision, moins de redandance.


auto: 	classe de stockage par défaut, une variable avec un durée de vie
    limitée. Cette variable est allouée dans la pile. Avec l'introduction
    du C++11, un nouveau sens a été donné à l'utilisation de "auto".

    [wikipedia]
    Le type sera automatiquement décidé par correspondance avec le type
    retourné par l'objet utilisé pour l'initialisation de la variable.
    Les variables étant déclarées avec auto devront donc impérativement
    être initialisées.


	Après avoir expliqué cet exemple dans le chapitre #8, nous allons montrer
  l'utilisation de auto dans le cas du ocnteneur vector.

*/

#include <iostream>
#include <vector>

using namespace std;

// Afficher le contenu d'un vecteur
template<class T>
void affichage(const vector<T>& v){
	for (typename vector<T>::const_iterator p = v.begin(); p!=v.end(); ++p)
		cout << *p << "\n";
}

// Le même affichage mais en utilisant cette fois-çi "auto"
template<class T>
void printall(const vector<T>& v){
	for (auto p = v.begin(); p!=v.end(); ++p)
		cout << *p << "\n";
}


int main() {

	// déclare un vecteur w, de 4 éléments
	vector<int> w = {1,2,3,4};
	cout << "Contenu du vecteur w:\n";
	printall(w);

	// déclare un vecteur v, constant, de 5 éléments
	const std::vector<int> v = {9,10,11,12,13};
	cout << "Contenu du vecteur v:\n";
	affichage(v);

	// g aura le type int car v[0] est du type int, par la même occasion,
  // la variable g est initialisée avec la valeur stockée dans v[0]
	auto g = v[0];
	cout << "g: " << g << '\n';


	return 0;

}

/*

	>./07_auto_03
		Contenu du vecteur w:
		1
		2
		3
		4
		Contenu du vecteur v:
		9
		10
		11
		12
		13
		g: 9
	>Exit code: 0

*/
