/*
	IFT1169 - utilisation de for C++11

20-octobre	-2016	v1.03	M.Lokbani	gcc 6.2.0 (Linux)
14-mars		-2015	v1.02	M.Lokbani	gcc 4.9.2  avec -std=c++11
19-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1  avec -std=c++11
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)



	contact: lokbani@iro.umontreal.ca


	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle

	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------

	for:	à la sauce foreach de la STL. Cette commande existe en java.
		le but est de simplifier l'écriture d'une boucle

*/


#include <iostream>
#include <vector>
#include <map>

using namespace std;


void f(vector<int>& v) {
	// La variable x n'est pas une référence dans la boucle, elle ne peut
  // pas être modifiée
	for (auto x : v) cout << x << '\n';

	// La variable x est une référence, sa valeur peut changer durant
  // le traitement
	for (auto& x : v) ++x;

	cout << "Affichage apres avoir ajoute +1" << endl;
	for (auto x : v) cout << x << '\n';
}

int main(){

	vector<int> w = {1,2,3,4};
	cout << "Le contenu de w:"<< endl;
	f(w);

	cout << "Le contenu du tableau:"<< endl;
	for (const auto x : { 1,2,3,5,8,13,21,34 }) cout << x << '\n';

	int mon_tableau[5] = {21, 22, 23, 24, 25};

	for (int &x: mon_tableau)
		x *= 2;

	cout << "Le contenu de mon_ tableau apres ajustement:"<< endl;
	for (int x: mon_tableau) cout << x << '\n';

	map<int, string> nombres = { { 1, "un" }, { 2, "deux" }, { 3, "trois" } };

	cout << "Le contenu de la map <int,string>:"<< endl;
	for(auto i : nombres)
		cout << i.first << " => " << i.second << endl;

	
	return 0;
}


/*

	>./08_rangeof
		Le contenu de w:
		1
		2
		3
		4
		Affichage apres avoir ajoute +1
		2
		3
		4
		5
		Le contenu du tableau:
		1
		2
		3
		5
		8
		13
		21
		34
		Le contenu de mon_ tableau apres ajustement:
		42
		44
		46
		48
		50
		Le contenu de la map <int,string>:
		1 => un
		2 => deux
		3 => trois
	>Exit code: 0

*/
