/*
	IFT1169 - utilisation de chevrons C++11

20-octobre	-2016	v1.03	M.Lokbani	gcc 6.2.0 (Linux)
14-mars		-2015	v1.02	M.Lokbani	gcc 4.9.2  avec -std=c++11
18-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1  avec -std=c++11
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)


	contact: lokbani@iro.umontreal.ca


	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle

	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------

	chevrons:
			comment dire au compilateur que ">>" peut-être autre chose
			qu'un décalage binaire vers la droite?

			Par exemple, une imbrication de patrons de classes? La solution
			disponible consistait à toujours laisser un espace entre les deux
			chevrons fermants. Il n'est plus nécessaire de le faire dans
			la nouvelle version du compilateur.

*/

#include <iostream>
#include <vector>


int main(){

	// avant
	// std::vector<std::vector<int> > xyz = {{1,2,3},{1,4},{2,6,9}};

	// avec l'introduction des chevrons
	std::vector<std::vector<int>> matrice = {{1,2,3},{1,4},{2,6,9}};

	for (auto i: matrice) {
		for (auto x: i) std::cout << x << ' ';
		std::cout << '\n';
	}

	return 0;
}

/*

	>./09_chevrons
		1 2 3
		1 4
		2 6 9
	>Exit code: 0

*/
