/*
	IFT1169 - utilisation de decltype C++11 (2e partie)

20-octobre	-2016	v1.03	M.Lokbani	gcc 6.2.0 (Linux)
09-mars		-2015	v1.02	M.Lokbani	gcc 4.9.2  avec -std=c++11
18-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1 (Linux)  avec -std=c++11
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)


	contact: lokbani@iro.umontreal.ca

        
	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle
	
	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------

	Inférence de types
			[wikipedia]
			L'inférence de types est un mécanisme qui permet à un compilateur ou un interpréteur
			de rechercher automatiquement les types associés à des expressions, sans qu'ils soient
			indiqués explicitement dans le code source.

			3 objectifs: plus de flexibilité, plus de concision, moins de redandance.

	decltype:	nouveau mot clé réservé.
	
			[wikipedia]
			permet de typer une variable à partir du type d'une autre variable.

*/

#include <iostream>
#include <vector>

using namespace std;


/*
	1- Comment déterminer le type de retour dans un tel cas?
	
	template<class T, class U>
	??? multiplier(T x, U y){
		return x*y;
	}

	2- On peut utiliser "decltype", sauf que les variables x et y
	sont utilisées avant leur définition. Nous avons un problème
	de visibilité
	
	template<class T, class U>
	decltype(x*y) multiplier(T x, U y){
		return x*y;
	}

	3- Il y a cette solution .... beuuuuke! On se mêle les pinceaux facilement.
	
	template<class T, class U>
	decltype((*(T*)0)*(*(U*)0)) multiplier(T x, U y){
		return x*y;
	}
*/

// Le type de retour est celui de l'opérateur operator+(T,U)
/*
template<class T, class U>
auto ajouter(T x, U y) -> decltype(x * y){
    return x * y;
}
*/


// C++14
template<class T, class U>
decltype(auto) ajouter(T t, U u) {
    return t + u;
}


int main() {

	// La variable i est un int car initialisée avec une valeur entière
	auto i = 5;
	
	// La variable y est int aussi, déduction à partir du type de i
	decltype(i) y = 10;
	std::cout << "y: " << y << '\n';
	
	// On ajoute un réel à un entier. Le réel l'emporte
	auto b = ajouter(1, 1.2);
	std::cout << "b: " << b << '\n';

	auto c = ajouter(1, 1);
	std::cout << "c: " << c << '\n';
	
	return 0;
}


/*

	>./10_decltype_02
		y: 10
		b: 2.2
	>Exit code: 0

*/
