 /*
	IFT1169 - utilisation de liste d'initialisation C++11

20-octobre	-2016	v1.03	M.Lokbani	gcc 6.2.0 (Linux)
14-mars		-2015	v1.02	M.Lokbani	gcc 4.9.2  avec -std=c++11
19-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1  avec -std=c++11
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)

	contact: lokbani@iro.umontreal.ca

        
	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle

	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------
	
	La liste d'initialisation: 
			simplifier l'initialisation des éléments. Opération très utile dans le cas de la STL.
			
	Source (en partie): http://www.stroustrup.com/C++11FAQ.html#init-list

*/

#include <iostream>
#include <list>
#include <vector>
#include <map>
#include <initializer_list>
#include "11_listinit.h"

using namespace std;
 


int main(){

	// On définit un conteneur qu'on peut initialiser à partir initializer list
	
	MyArray<int> foo = { 3, 4, 6, 9 };
	cout << foo;

	
	vector<double> w;
	w.push_back(1);
	w.push_back(2);
	w.push_back(3);
	w.push_back(456);
	w.push_back(99.99);
	
	// initializer list pour des conteneurs
	
	vector<double> v = { 1, 2, 3.456, 99.99 };
	
	list<pair<string,string>> languages = {
		{"Nygaard","Simula"}, {"Richards","BCPL"}, {"Ritchie","C"}
	};
	
	map<vector<string>,vector<int>> years = {
		{ {"Maurice","Vincent", "Wilkes"},{1913, 1945, 1951, 1967, 2000} },
		{ {"Martin", "Ritchards"}, {1982, 2003, 2007} }, 
		{ {"David", "John", "Wheeler"}, {1927, 1947, 1951, 2004} }
	}; 

	years.insert({{"Bjarne","Stroustrup"},{1950, 1975, 1985}});
	
	
	return 0;
	
}



/*
	>./11_listinit
		3
		4
		6
		9
	>Exit code: 0

*/
