/*
	IFT1169 - utilisation de liste d'initialisation C++11

20-octobre	-2016	v1.03	M.Lokbani	gcc 6.2.0 (Linux)
14-mars		-2015	v1.02	M.Lokbani	gcc 4.9.2  avec -std=c++11
19-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1  avec -std=c++11
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)

	contact: lokbani@iro.umontreal.ca

        
	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle

	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------
	
	La liste d'initialisation: 
			simplifier l'initialisation des éléments. Opération très utile dans le cas de la STL.
			
	Source (en partie): http://www.stroustrup.com/C++11FAQ.html#init-list

*/

#include <iostream>
#include <list>
#include <vector>
#include <map>
#include <initializer_list>

using namespace std;


#ifndef XYZ
#define XYZ

template <class T> class MyArray;
template <class T> ostream& operator<<(ostream&, const MyArray<T>&);

template <class T>
class MyArray {
private:
	vector<T> m_Array;
 
public:
	MyArray() { }

	MyArray(const initializer_list<T>& il) {
		// L'opération est manuelle à partir de initializer_list x
		for (auto x: il) // nous allons itérer sur tous les éléments de the initializer list
			m_Array.push_back(x); // un push manuel dans le tableau
	}
	friend ostream& operator<<<> (ostream&, const MyArray<T>&);
	
	/*
		On pouvait aussi utiliser le "initializer_list" disponible avec "vector". Ce dernier va se charger
		de remplir mArray
		MyArray(const std::initializer_list<T>& x): m_Array(x) {}
	*/
};

template <class T>
ostream& operator<<(ostream& out, const MyArray<T>& zz){
	for (auto i: zz.m_Array) cout << i << '\n';
	return out;
}
#endif
