/*
	IFT1169 - utilisation de array C++11

20-octobre	-2016	v1.03	M.Lokbani	gcc 6.2.0 (Linux)
14-mars		-2015	v1.02	M.Lokbani	gcc 4.9.2  avec -std=c++11
19-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1  avec -std=c++11
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)


	contact: lokbani@iro.umontreal.ca


	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle

	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------

	array:
		int tab[5]; tableau à taille fixe. Le conteneur array offre ce type
		de tableau à taille fixe avec les propriétés associées à un conteneur
		STL (méthodes etc.)

		L'initialisation du tableau array nécessite l'utilisation d'une double
		acolade: {{ 1, 2, 3 }}.
		Dans le cas contraire un avertissement est affiché:
		warning: missing braces around initializer for
		'std::array<int, 6ul>::value_type [6] {aka int [6]}' [-Wmissing-braces]
		La raison de cet avertissement est liée à la nature de la classe array:

		template<typename T, std::size_t N>
		struct array {
			T array_impl[N];
		};

		Il se peut que cet avertissement soit levé lors des prochaines versions.

*/

#include <iostream>
#include <array>

int main(){

	std::array<int,6> a = {1, 2, 3 }; // 1 2 3 0 0 0
	a[3]=4;
	int x = a[5];		// x=0 car valeur par défaut égale à zéro.
	std::cout << "x: " << x << '\n';


	// cannot convert 'std::array<int, 6ul>' to 'int*' in initialization
	// erreur std::array n'est pas converti automatiquement à un pointeur
	// int* p1 = a;

	int* p2 = a.data();	// ok: retourne un pointeur vers le premier élément
	std::cout << "*p2: " << *p2 << '\n';


	// error: wrong number of template arguments (1, should be 2)
	// std::array<int> a3 = { 1, 2, 3 };

	std::array<int,0> a0;		// ok: mais pas d'elements
	std::cout << "taille de a0: " << a0.size() << std::endl;

	// int* p = a0.data();		// non spécifiée, attention!!!!
	// std::cout << "p: " << *p << '\n'; // Oups!  Segmentation fault!

	//Création d'un tableau à taille fixe de cinq entiers.
	std::array<int, 5> tableauFixe = {1, 2, 3, 4, 5 };

	//Affichage de tous ses éléments.
	for(int nombre : tableauFixe) {
		std::cout << nombre << std::endl;
	}

	//Affichage de sa taille.
	std::cout << "Taille : " << tableauFixe.size() << std::endl;


	//Modification d'éléments.
	tableauFixe[0] = 10;
	tableauFixe.at(1) = 40;
	//Affichage d'un élément précis sans vérification de limite.
	std::cout << tableauFixe[1] << std::endl;
	//Même chose sauf qu'il y a une vérification de limite.
	std::cout << tableauFixe.at(0) << std::endl;
	//Afficher le premier élément.
	std::cout << tableauFixe.front() << std::endl;
	//Afficher le dernier élément.
	std::cout << tableauFixe.back() << std::endl;

	if(not tableauFixe.empty()) {
		std::cout << "Le tableau n'est pas vide." << std::endl;
	}

	tableauFixe.fill(5); //Modifier tous les éléments pour la valeur 5.

	// Comment faire compliquer quand on peut simplifier les choses avec foreach
	for(std::array<int, 5>::iterator i(tableauFixe.begin()) ; \
																				i != tableauFixe.end() ; ++i) {
		std::cout << *i << std::endl;
	}



	return 0;

}


/*
	>./12_array
		x: 0
		*p2: 1
		taille de a0: 0
		1
		2
		3
		4
		5
		Taille : 5
		40
		10
		10
		5
		Le tableau n'est pas vide.
		5
		5
		5
		5
		5
	>Exit code: 0
*/
