/*
	IFT1169 - utilisation de lambda C++11

20-octobre	-2016	v1.03	M.Lokbani	gcc 6.2.0 (Linux)
14-mars			-2015	v1.02	M.Lokbani	gcc 4.9.2  avec -std=c++11
18-octobre	-2014	v1.01	M.Lokbani	gcc 4.9.1  avec -std=c++11
22-avril		-2013	v1.00	M.Lokbani	gcc 4.7.2.3 (Linux)


	contact: lokbani@iro.umontreal.ca


	Copyright (C) 1999-2016 Université de Montréal
	Département d'informatique et de Recherche Opérationnelle

	Mohamed Lokbani

	-- Tous Droits Réservés -- All Rights Reserved --


Description:
-------------------

	lambda : est une fonction anonyme qui n'a pas de nom. Elle évite
			l'utilisation de functor. Elle définit et construit implicitement
			une fonction objets sans nom, qui se comporte comme une fonction objets.

*/


#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <functional>

using namespace std;

struct compare {
	bool operator()(const string& s1, const string& s2) {
		return s1.size() < s2.size();
	}
};

int main() {

	vector<string> vs = {"This", "is", "a", "C++11", "exercise"};

	// Tri en utilisant un functor
	std::sort(vs.begin(), vs.end(), compare());

	cout << "Tri -1-" << endl;
	for (auto ivs: vs) cout << ivs << endl;

	vector<string> vw = {"This", "is", "a", "C++11", "exercise"};

	// Tri en utilisant Lambda
	// [] pour singifier Lambda, () ses paramètres, {} corps de la fonction
	std::sort(vw.begin(), vw.end(),[](const string& s1, const string& s2) {
				return (s1.size() < s2.size());
			}
	);

	cout << "Tri -2-" << endl;
	for (auto ivw: vw) cout << ivw << endl;


	int somme(0);

	// std::function un adaptateur générique de fonction
	// Pour l'utiliser, il faut inclure functional
	// Cette fonction a:
	// 				type argument: std::vector<int>
	// 				type retour: void
	// std::function<void (std::vector<int>)>
	//
	// Pour capturer une variable externe à la fonction, on la passe dans []
	// On peut la passer par valeur [somme] ou par référence [&somme]

	std::function<void (std::vector<int>)> sommeVecteur = \
																			[&somme](std::vector<int> vecteur) {
		for(int &x : vecteur) {
			somme += x;
		}
	};

	std::vector<int> nombres = { 1, 2, 3, 4, 5 };

	sommeVecteur(nombres);
	std::cout << "La somme des elements est:" << somme << std::endl;


	// Pour signifier le type de retour, on utilise ->
	// Dans cet exemple, le type de retour est un int
	std::function<int (int, int)> addition = [](int x, int y) -> int {
		return x + y;
	};


	// On pouvait utiliser auto, mais il y a des limitations ...
	auto xaddition = [](auto x, auto y) {
		return x + y;
	};

	// Valable avec C++14
	// auto zaddition = [](auto x,auto y) { return x + y;};
	// (pour x) error: use of ‘auto’ in lambda parameter declaration only
	// available with -std=c++14 or -std=gnu++14
	// (pour y) error: use of ‘auto’ in lambda parameter declaration only
	// available with -std=c++14 or -std=gnu++14
	// g++ -Os -Wall -std=c++14 -pedantic -o 13_lambda  13_lambda.cpp

	cout << "8+10=" << addition(8,10) << endl;

	cout << "8.5+10.5=" << xaddition(8.5,10.5) << endl;

	cout << "8+10.5=" << xaddition(8,10.5) << endl;

	return 0;
}

/*

	>./13_lambda
		Tri -1-
		a
		is
		This
		C++11
		exercise
		Tri -2-
		a
		is
		This
		C++11
		exercise
		La somme des elements est:15
		8+10=18
		8+10=18
	>Exit code: 0

*/
