/*

IFT1169 - Fonction générique variadique - arguments variables

05-décembre	- 2018 v1.00	M.Lokbani - GCC 8.2.0 avec -std=c++17


contact: lokbani@iro.umontreal.ca

        
    Copyright (C) 1999-2018 Université de Montréal
            Département d'informatique et de Recherche Opérationnelle
            Mohamed Lokbani
    -- Tous Droits Réservés -- All Rights Reserved --

Description:
------------
	Utilisation d'une fonction générique variadique pour afficher un nombre variable
	d'arguments.
	
	Le principe est simple: il y a un appel récursif jusqu'au traitement du dernier élément.
	Cet élément est pris en charge par une fonction à part qu'il faut prévoir. Elle sert comme
	arrêt à la récursivité.
		
	Source:
		https://msdn.microsoft.com/en-us/library/dn439779.aspx


*/


#include <iostream>  
  
using namespace std;  
  
void print() {  // 1
    cout << "x: " << endl;  
}  
  
template <typename T> void print(const T& t) {  //2
    cout << "y: " << t << endl;  
}  
  
template <typename First, typename... Rest> void print(const First& first, const Rest&... rest) {  //3
    cout << "z:" << first << ", "; 
	// Appels récursif en utilisant la syntaxe "expansion pack"
	// L'appel s'arrête au dernier. Il va faire appel à 2
    print(rest...);
}  
  
int main(){  
    print(); // appel 1  
    print(1); // appel 2
  
    // appel 3, au final il va appeler 2
    print(10, 20);  
    print(100, 200, 300);  
    print("first", 2, "third", 3.14159); 
	
	return 0;
}  

/*
	>01_variadique.exe
			x: 
			y: 1
			z:10, y: 20
			z:100, z:200, y: 300
			z:first, z:2, z:third, y: 3.14159
	>Exit code: 0
*/