/*

IFT1169 - Fonction générique variadique - arguments variables

05-décembre	- 2018 v1.00	M.Lokbani - GCC 8.2.0 avec -std=c++17


contact: lokbani@iro.umontreal.ca

        
    Copyright (C) 1999-2018 Université de Montréal
            Département d'informatique et de Recherche Opérationnelle
            Mohamed Lokbani
    -- Tous Droits Réservés -- All Rights Reserved --

Description:
------------
	Utilisation d'une fonction générique variadique pour sommer des éléments
	
	Le principe est simple: il y a un appel récursif jusqu'au traitement du dernier élément.
	Cet élément est pris en charge par une fonction à part qu'il faut prévoir. Elle sert comme
	arrêt à la récursivité.
		

*/

#include <iostream>


template<typename T>
T adder(T v) {
	std::cout << "A: " << v << std::endl;
	return v;
}


template<typename T, typename... Args>
T adder(T first, Args... args) {
	std::cout << "B: " << first << " ";
	return first + adder(args...);
}


int main(){
	long sum = adder(1, 2, 3, 8, 7);

	std::string s1 = "x", s2 = "aa", s3 = "bb", s4 = "yy";
	
	std::string ssum = adder(s1, s2, s3, s4);
	
	std::cout << sum << ":" << ssum << std::endl;

	return 0;
	
}


/*
	>02_variadique.exe
			B: 1 B: 2 B: 3 B: 8 A: 7
			B: x B: aa B: bb A: yy
			21:xaabbyy
	>Exit code: 0
*/