/*

IFT1169 - Fonction générique variadique - arguments variables

05-décembre	- 2018 v1.00	M.Lokbani - GCC 8.2.0 avec -std=c++17


contact: lokbani@iro.umontreal.ca

        
    Copyright (C) 1999-2018 Universite de Montreal
            Département d'informatique et de Recherche Operationnelle
            Mohamed Lokbani
    -- Tous Droits Reserves -- All Rights Reserved --

Description:
------------
	Utilisation d'une fonction générique variadique pour calculer la moyenne d'un nombre
	variable d'arguments.
	
	On n'avait pas besoin d'une fonction finale pour arrêter le calcul. Nous avons utilisé à la
	place une fonction (sizeof sur un parameter pack, depuis C++11) qui permet d'obtenir
	le nombre d'arguments.

	"typename T" permet de férinir le type de retour. Ainsi, lors de cet appel:
	
	moyenne<double>(a, b)
	
	template<typename T, class ... Args>
	
	"T" est représenté par le type double
	"Args" est représenté par (a,b)
	
*/

#include <iostream>

template<typename T, class ... Args>
	T moyenne(Args ... args){
		
    int numArgs = sizeof...(args); // on récupère le nombre d'arguments
    if (numArgs == 0)
        return T();           // on retourne la valeur par défaut du type en question

    T total = T(); // on initialise avec la valeur par défaut la somme totale
	
	// On calcule la somme des éléments
    for (auto value : {args...}){
        total += value;
    }

	// On calcule la moyenne: la somme/le nombre d'éléments
    return total / numArgs;
}

int main(){

	double a = 100.0, b = 200.0, c = 300.0, d = 400.0;

	std::cout << "a = " << a << "\nb = " << b << "\nc = " << c << "\nd = " << d << std::endl;

	std::cout << "La moyenne de a et b est: " << moyenne<double>(a, b) << std::endl; //100+200 = 300/2 = 150
	std::cout << "La moyenne de a, b et c est: " << moyenne<double>(a, b, c) << std::endl; // 100+200+300 = 600/3 = 200
 	std::cout << "La moyenne de a, b, c et d est: " << moyenne<double>(a, b, c, d) << std::endl; // 100+200+300+400 = 1000/4 = 250

	return 0;
}

/*

	>03_variadique.exe
			a = 100
			b = 200
			c = 300
			d = 400
			La moyenne de a et b est: 150
			La moyenne de a, b et c est: 200
			La moyenne de a, b, c et d est: 250
	>Exit code: 0

*/