/*

IFT1169 - Gestion de l'affichage en sortie avec "format".

22-novembre	- 2025 v1.00	M.Lokbani - GCC 15.2.0 avec -std=c++20


contact: lokbani@iro.umontreal.ca

        
    Copyright (C) 1999-2025 Universite de Montreal
            Département d'informatique et de Recherche Operationnelle
            Mohamed Lokbani
    -- Tous Droits Reserves -- All Rights Reserved --

Description:
------------
	Utilisation du formatage en sortie à l'aide de "format".
    
    Vous devez configurer  l'option std=c++20 pour que ce programme puisse
    compiler correctement.
    
*/


#include <format>
#include <iostream>
#include <string>
#include <chrono>

int main() {
    std::string nom = "Alice";
    int age = 30;
    double salaire = 55000.75;

    // Format basic
    // On utilise des accolades {} puis les noms des variables pour passer les valeurs à la méthode "format".
    std::string message1 = std::format("Nom: {}, Age: {}", nom, age);
    std::cout << message1 << std::endl;

    // On peut préciser aussi le format des nombres, dans cet exemple un nombre réel.
    // X.Yf X précise la longueur de la chaîne, Y représente le nombre de chiffres après la virgule.
    // 10.2f: 2 décimales + 1 point (virgule) + 7 chiffres.
    // Si l'on ne précise pas la longueur de la chaîne (.Yf) la longueur de la chaîne s’adapte au nombre de caractères à afficher. 
    // Il est possible d’aligner à gauche en utilisant le signe inférieur < à droite le signe > et au centre le signe ^
    
    std::string message2 = std::format("Salaire: ${:<10.2f}", salaire);
    std::cout << message2 << std::endl;

    // On récupère l'heure actuelle et on l'affiche en sortie dans un format approprié.
    auto now = std::chrono::system_clock::now();
    std::string message3 = std::format("L'heure actuelle est: {:%Y-%m-%d %H:%M:%S}", now);
    std::cout << message3 << std::endl;

    return 0;
}