/*

IFT1169 - Gestion de l'affichage en sortie avec "format".

22-novembre	- 2025 v1.00	M.Lokbani - GCC 15.2.0 avec -std=c++20


contact: lokbani@iro.umontreal.ca

        
    Copyright (C) 1999-2025 Universite de Montreal
            Département d'informatique et de Recherche Operationnelle
            Mohamed Lokbani
    -- Tous Droits Reserves -- All Rights Reserved --

Description:
------------
	Utilisation du formatage en sortie à l'aide de "format".
    
    Vous devez configurer  l'option std=c++20 pour que ce programme puisse
    compiler correctement.
    
*/

#include <format>
#include <iostream>
#include <string>

int main() {
    std::string nom = "World";
    int num = 42;
    double valeur = 123.456789;

    // Idem que 17_format.cpp
    std::string s1 = std::format("Bonjour, {}! Le numéro est {}.", nom, num);
    std::cout << s1 << std::endl;

    // Plusieurs variantes de format, réel, hexadécimal, entier avec alignement et taille en caractères
    std::string s2 = std::format("Value: {:.2f}, Number hex: {:#x}, aligned: {:<10}", valeur, num, nom);
    std::cout << s2 << std::endl;

    // On peut ordonner la position des arguments
    // Ici la valeur (10) est l'argument (0) et la valeur (20) est l'argument (1)
    // Nous avons inversé l'ordre d'affichage
    std::string s3 = std::format("Second: {1}, First: {0}", 10, 20);
    std::cout << s3 << std::endl;
    
    return 0;
}
