/*

IFT1169 - Gestion de l'affichage en sortie avec "format".

22-novembre	- 2025 v1.00	M.Lokbani - GCC 15.2.0 avec -std=c++23


contact: lokbani@iro.umontreal.ca

        
    Copyright (C) 1999-2025 Universite de Montreal
            Département d'informatique et de Recherche Operationnelle
            Mohamed Lokbani
    -- Tous Droits Reserves -- All Rights Reserved --

Description:
------------
	Utilisation de la fonction "print" nouvellement introduite
    dans C++23.
    
    Il y a print ou println (avec retour à la ligne)
    
    Vous devez configurer  l'option std=c++23 pour que ce programme puisse
    compiler correctement.
    
    Sur Windows, en plus d'avoir une version du compilateur qui accèpte le standard
    C++23, vous devez ajouter l'option -lstdc++exp lors de l'édition des liens.
    
    https://gcc.gnu.org/gcc-14/changes.html#libstdcxx
    
*/


#include <print>
#include <vector>

int main() {
    int num = 42;
    std::println("Le nombre est is {}.", num); 

    std::vector<int> v = {1, 2, 3, 4};

    // Imprime une version formatée du contenu du conteneur
    std::println("Le vecteur contient: {}", v);
    
    double valeur = 123.45;
    int compte = 10;
    std::string nom = "Usager";

    std::print("Valeur: {}, Compteur: {}, Nom: {}\n", valeur, compte, nom); // On utilise '\n' pour un retour à la ligne
    std::println("Valeur formatée: {:10.2f}, Compte: {:03d}", valeur, compte); // On utilise println pour un retour automatique
    
    return 0;
}
