;;; ACK -- One of the Kernighan and Van Wyk benchmarks.

(define (ack m n)
  (cond ((= m 0) (+ n 1))
        ((= n 0) (ack (- m 1) 1))
        (else (ack (- m 1) (ack m (- n 1))))))

(define (main . args)
  (run-benchmark
   "ack"
   1
   (lambda () (ack 3 9))
   (lambda (result) (equal? result 4093))))
