#! /usr/local/Gambit-C/bin/gsi-script

; File: "web-server.scm", Time-stamp: <2005-06-13 20:47:37 feeley>

; Copyright (C) 2004-2005 by Marc Feeley, All Rights Reserved.

; A minimal web server making it possible to access the filesystem
; using a browser.

;==============================================================================

(##include "gambit#.scm") ; import Gambit procedures and variables
(##include "http#.scm")   ; import HTTP procedures and variables
(##include "html#.scm")   ; import HTML procedures and variables
(##include "base64#.scm") ; import BASE64 procedures and variables

(declare
  (standard-bindings)
  (extended-bindings)
  (block)
  (not safe)
)

;==============================================================================

(define main
  (lambda (arg)
    (let ((port-number
           (string->number arg)))
      (http-server-start!
       (make-http-server
        port-number: port-number
        threaded?: #t
        GET: GET)))))

(define GET
  (lambda ()
    (with-exception-catcher
     (lambda (exc)
       (reply-html
        (<html>
         (<body>
          (<pre>
           (call-with-output-string
            ""
            (lambda (port) (##display-exception exc port))))))))
     (lambda ()
       (let* ((request (current-request))
              (uri (request-uri request))
              (path (uri-path uri)))
         (cond ((equal? path "/web-continuation-example")
                (web-continuation-example))
               (else
                (get-path path))))))))

(define get-path
  (lambda (path)
    (let ((type (file-type path)))
      (case type
        ((directory)
         (reply-html
          (<html>

           (<center>
            (<a>
             href: "/web-continuation-example"
             "Click here to try the web-continuation example"))

           (<h1> "Files in " path)

           (<ol>
            (map (lambda (fn)
                   (<li>
                    (<a> href: (path-expand fn path) fn)
                    " ("
                    (object->string
                     (with-exception-catcher
                      (lambda (exc) 'other)
                      (lambda () (file-type (path-expand fn path)))))
                    ")"))
                 (directory-files
                  (list path: path ignore-hidden: #f)))))))
        ((regular)
         (let* ((port (open-input-file path))
                (file (read-line port #f)))
           (close-input-port port)
           (let ((ext (path-extension path)))
             (if (or (string-ci=? ext ".htm")
                     (string-ci=? ext ".html"))
                 (reply (lambda () (display file)))
                 (reply-html (<html> (<body> (<pre> file))))))))
        (else
         (reply-html
          (<html>
           (<body>
            "Only directories and regular files can be displayed"))))))))

;==============================================================================

(define web-continuation-example
  (lambda ()

    ; check if we are resuming a continuation or starting the example

    (let* ((request (current-request))
           (uri (request-uri request))
           (query (uri-query uri)))
      (if query

          (let ((c (assoc "cont" query)))
            (if c
                (let ((cont (base64-string->u8vector (cdr c))))
                  ((u8vector->object cont) query))
                (reply-html
                 (<html>
                  (<body>
                   (<h1> "Something's wrong with the request..."))))))

          (calculator-start)))))

(define calculator-start
  (lambda ()
    (let ((new-number
           (show-sum-and-obtain-number
            '()
            title-embed)))
      (calculator-loop (list new-number)))))

(define calculator-loop
  (lambda (numbers-previously-entered)
    (let ((new-number
           (show-sum-and-obtain-number
            numbers-previously-entered
            plain-embed)))
      (calculator-loop (append numbers-previously-entered
                               (list new-number))))))

(define show-sum-and-obtain-number
  (lambda (numbers-previously-entered embed)
    (let ((sum (apply + numbers-previously-entered)))
      (obtain-number
       (lambda (stuff)
         (embed
          (<table>
           (if (null? numbers-previously-entered)
               '()
               (list
                (map (lambda (x)
                       (<tr> (<td>)
                             (<td> align: 'right x)))
                     numbers-previously-entered)
                (<tr> (<td>)
                      (<td> align: 'right "---------------------"))
                (<tr> (<td> "TOTAL:")
                      (<td> align: 'right bgcolor: "yellow" sum))))
           (<tr> (<td>)
                 (<td> stuff)))))))))

(define title-embed
  (lambda (stuff)
    (<html>
     (<body>
      (<h1> "Web-continuation example")
      (<p> "This page implements a simple calculator that adds the "
           "numbers that are entered by the user.")
      (<p> "You can use the " (<strong> "back") " button to undo the "
           "additions.  You can also clone the window and copy "
           "the URL to a different browser to start an independent "
            " branch of calculation.")
      (<p> "The web-server can be run interpreted or compiled.  It is "
           "much more efficient to use a compiled web-server because "
           "the continuations in the HTML file sent back to the browser "
           "will be much more compact.")
      (<p> "Enter the first number here: " stuff)))))

(define plain-embed
  (lambda (stuff)
    (<html>
     (<body>
      (<h1> "Web-continuation example")
      stuff))))

(define obtain-number
  (lambda (embed)
    (let ((number-str
           (obtain
            "number"
            (lambda (cont)
              (embed
               (<form>
                action: "/web-continuation-example"
                method: "GET"
                (<input> type: 'hidden
                         name: "cont"
                         value: (u8vector->base64-string cont))
                (<input> type: 'text name: "number")
                (<input> type: 'submit name: "submit" value: "ADD")))))))
      (or (string->number number-str)
          (obtain-number embed)))))

(define obtain
  (lambda (name embed)
    (let ((query
           (call/cc
            (lambda (k)
              (reply-html (embed (object->u8vector k)))
              (thread-terminate! (current-thread))))))
      (cdr (assoc name query)))))

;==============================================================================
