;==============================================================================

; File: "_t-c-2.scm", Time-stamp: <2005-09-10 11:13:51 feeley>

; Copyright (C) 1994-2005 by Marc Feeley, All Rights Reserved.

(include "fixnum.scm")

(include-adt "_envadt.scm")
(include-adt "_gvmadt.scm")
(include-adt "_ptreeadt.scm")
(include-adt "_sourceadt.scm")

'(begin;**************brad
(##include "../gsc/_utilsadt.scm")
(##include "../gsc/_ptree1adt.scm")
(##include "../gsc/_gvmadt.scm")
(##include "../gsc/_hostadt.scm")
)

;------------------------------------------------------------------------------
;
; Back end for C language (part 2)
; -----------------------

(define (targ-scan-procedure obj)
  (let* ((proc (car obj))
         (p (cdr obj)))

    (if targ-info-port
      (begin
        (display "  #<" targ-info-port)
        (if (proc-obj-primitive? proc)
          (display "primitive " targ-info-port)
          (display "procedure " targ-info-port))
        (write (string->canonical-symbol (proc-obj-name proc)) targ-info-port)
        (display ">" targ-info-port)))

    (set! targ-proc-name               (proc-obj-name proc))
    (set! targ-proc-code               (make-stretchable-vector #f))
    (set! targ-proc-code-length        0)
    (set! targ-proc-rd-res             (make-stretchable-vector #f))
    (set! targ-proc-wr-res             (make-stretchable-vector #f))
    (set! targ-proc-lbl-tbl            (queue-empty))
    (set! targ-proc-lbl-tbl-ord        (queue-empty))
    (set! targ-debug-info?             #f)
    (set! targ-var-descr-queue         (queue-empty))
    (set! targ-first-class-label-queue (queue-empty))

;;    (targ-repr-begin-proc!)

    (let ((x (proc-obj-code proc)))
      (if (bbs? x)
        (targ-scan-scheme-procedure x)
        (targ-scan-c-procedure x)))

;;    (targ-repr-end-proc!)

    (targ-cell-set! (caddr p) (+ targ-lbl-alloc 1))

    ; Assign label numbers sequentially, starting with "value" labels
    ; and then "goto" labels

    (let ((ord-lbls (queue->list targ-proc-lbl-tbl-ord)))
      (let loop2 ((l ord-lbls) (i 0) (val-lbls '()))
        (if (pair? l)
          (let ((x (car l)))
            (if (targ-lbl-val? x)
              (begin
                (targ-cell-set! (targ-lbl-num x) i)
                (loop2 (cdr l) (+ i 1) (cons x val-lbls)))
              (loop2 (cdr l) i val-lbls)))
          (let ((info (targ-debug-info)))
            (targ-use-obj info)
            (set! targ-lbl-alloc (+ targ-lbl-alloc (+ i 1)))
            (set-car! p
              (vector targ-proc-code
                      (reverse val-lbls)
                      targ-proc-rd-res
                      targ-proc-wr-res
                      info))
            (let loop3 ((l ord-lbls) (i i))
              (if (pair? l)
                (let ((x (car l)))
                  (if (and (targ-lbl-goto? x)
                           (not (targ-lbl-val? x)))
                    (begin
                      (targ-cell-set! (targ-lbl-num x) i)
                      (loop3 (cdr l) (+ i 1)))
                    (loop3 (cdr l) i)))))))))

    (if targ-info-port
      (newline targ-info-port))

    ))

(define (targ-debug-info)

  (define (number i lst)
    (if (null? lst)
      '()
      (cons (list->vect (cons i (car lst)))
            (number (+ i 1) (cdr lst)))))

  (if targ-debug-info?
    (vector (list->vect (number 0 (queue->list targ-first-class-label-queue)))
            (list->vect (queue->list targ-var-descr-queue)))
    #f))

(define (targ-scan-scheme-procedure bbs)

  (set! targ-proc-entry-lbl   (bbs-entry-lbl-num bbs))
  (set! targ-proc-lbl-counter (make-counter (bbs-next-lbl-num bbs)))

  (let loop ((prev-bb #f)
             (prev-gvm-instr #f)
             (l (bbs->code-list bbs)))
    (if (not (null? l))
      (let ((pres-bb (code-bb (car l)))
            (pres-gvm-instr (code-gvm-instr (car l)))
            (pres-slots-needed (code-slots-needed (car l)))
            (next-gvm-instr (if (null? (cdr l))
                              #f
                              (code-gvm-instr (cadr l)))))

        (targ-gen-gvm-instr prev-gvm-instr
                            pres-gvm-instr
                            next-gvm-instr
                            pres-slots-needed)

        (loop pres-bb pres-gvm-instr (cdr l))))))

(define (targ-scan-c-procedure c-proc)

  (define (ps-opnd opnd)
    (cond ((reg? opnd)
           (let ((n (reg-num opnd)))
             (cons 'psr n)))
          (else ; must be stack slot
           (list "PSSTK" (- (stk-num opnd) targ-proc-fp)))))

  (let* ((arity (c-proc-arity c-proc))
         (pc (targ-label-info arity #f))
         (pc-map (pcontext-map pc))
         (pc-fs (pcontext-fs pc))
         (ret (cdr (assq 'return pc-map)))
         (fs (+ arity 1))
         (lbl 2))

    (set! targ-proc-entry-lbl 1)

    (targ-start-bb pc-fs)

    (set! targ-proc-entry-frame targ-proc-exit-frame);********** for targ-update-fr but probably not needed since it can't be called from here!
    (targ-begin-fr) ; ************* not needed either

    (targ-emit-label-entry targ-proc-entry-lbl arity #f)
    (targ-ref-lbl-goto targ-proc-entry-lbl)

    (targ-emit (list "IF_NARGS_EQ" arity '("NOTHING")))
    (targ-emit (list "WRONG_NARGS"
                     (targ-ref-lbl-val targ-proc-entry-lbl)
                     arity 0 0))
    (targ-emit (list 'append
                     (list "DEF_GLBL" (targ-make-glbl "" targ-proc-name))
                     #\newline))

;;    (targ-repr-begin-block! 'entry targ-proc-entry-lbl)

    ; move arguments from registers to stack frame

    (let loop1 ((i 1))
      (if (and (<= i arity) (<= i targ-nb-arg-regs))
        (begin
          (targ-emit
            (targ-loc (make-stk (+ pc-fs i)) (targ-opnd (make-reg i))))
          (loop1 (+ i 1)))))

    ; store return address at top of stack frame

    (targ-emit
      (targ-loc (make-stk fs) (targ-opnd ret)))

;(targ-emit (targ-loc (make-stk (+ fs 1)) (targ-opnd (make-obj 1234567))));*********************
;(targ-emit (targ-loc (make-stk (+ fs 2)) (targ-opnd (make-obj 1234567))))
;(targ-emit (targ-loc (make-stk (+ fs 3)) (targ-opnd (make-obj 1234567))))
;(targ-emit (targ-loc (make-stk (+ fs 4)) (targ-opnd (make-obj 1234567))))

    ; setup new return address

    (targ-emit
      (targ-loc ret (targ-opnd (make-lbl lbl))))

    (targ-emit
      (targ-adjust-stack (targ-align-frame (+ fs targ-frame-reserve))))

    (targ-emit
      (list 'append (c-proc-body c-proc)))

    (targ-emit
      (list "JUMPPRM"
            '("NOTHING")
            (targ-opnd (make-reg 0))))

;;    (targ-repr-exit-block! #f)

;;    (targ-repr-end-block!)

    (targ-emit-label-return lbl fs (- fs 1) (targ-build-gc-map-all-live fs) #f)

;;    (targ-repr-begin-block! 'return lbl)

    (targ-emit (targ-adjust-stack 0))

;;    (targ-repr-exit-block! #f)

    (targ-emit
      (list "JUMPPRM"
            '("NOTHING")
            (targ-opnd (make-stk fs))))

;;    (targ-repr-end-block!)
))

;------------------------------------------------------------------------------

; Information attached to a procedure

(define targ-proc-name            #f) ; procedure's name
(define targ-proc-code            #f) ; code of the procedure
(define targ-proc-code-length     #f) ; length of code of the procedure
(define targ-proc-entry-lbl       #f) ; entry label
(define targ-proc-lbl-counter     #f) ; label counter
(define targ-proc-rd-res          #f) ; set of resources read from
(define targ-proc-wr-res          #f) ; set of resources written to
(define targ-proc-lbl-tbl         #f) ; table of all labels
(define targ-proc-lbl-tbl-ord     #f) ; table of all labels ordered by def time
(define targ-proc-fp              #f) ; frame pointer
(define targ-proc-hp              #f) ; heap pointer

(define targ-debug-info?             #f) ; generate debug information?
(define targ-var-descr-queue         #f)
(define targ-first-class-label-queue #f)

(define targ-proc-instr-node      #f)
(define targ-proc-entry-frame     #f)
(define targ-proc-exit-frame      #f)

; Emit a piece of code

(define (targ-emit code)
  (stretchable-vector-set! targ-proc-code targ-proc-code-length code)
  (set! targ-proc-code-length (+ targ-proc-code-length 1)))

; Emit a label

(define (targ-emit-label-simp lbl)
  (targ-emit-label lbl #f #f))

(define (targ-emit-label-entry lbl nb-parms label-descr)
  (targ-emit-label lbl 'proc (vector nb-parms 0)))

(define (targ-emit-label-subproc lbl nb-parms nb-closed label-descr)
  (targ-emit-label lbl 'proc (vector nb-parms nb-closed)))

(define (targ-emit-label-return lbl fs link gc-map label-descr)
  (targ-emit-label lbl 'return (vector 'normal fs link gc-map)))

(define (targ-emit-label-return-task lbl fs link gc-map label-descr)
  (targ-emit-label lbl 'return (vector 'task fs link gc-map)))

(define (targ-emit-label-return-internal lbl fs link gc-map label-descr)
  (targ-emit-label lbl 'return (vector 'internal fs link gc-map)))

; Add a label to the code stream

(define (targ-emit-label lbl class info)
  (let ((x (targ-get-lbl lbl)))
    (targ-emit (cons 'label x))
    (targ-add-label x class info)))

(define (targ-add-label lbl-struct class info)
  (vector-set! lbl-struct 2 class)
  (vector-set! lbl-struct 3 info)
  (queue-put! targ-proc-lbl-tbl-ord lbl-struct))

; Add label "n" to label table and return label object

(define (targ-get-lbl n)
  (let ((x (assq n (queue->list targ-proc-lbl-tbl))))
    (if x
      (cdr x)
      (let ((y (vector (targ-make-cell #f) ; eventual label number (set later)
                       #f                  ; used as a "goto" label?
                       #f                  ; class (not #f if "value" label)
                       #f)))               ; extra info if "value" label
        (queue-put! targ-proc-lbl-tbl (cons n y))
        y))))

(define (targ-lbl-num lbl-struct)
  (vector-ref lbl-struct 0))

; Mark a label as referenced for "value" and return eventual label number

(define (targ-ref-lbl-val n)
  (let ((x (targ-get-lbl n)))
    (targ-lbl-num x)))

(define (targ-lbl-val? lbl-struct)
  (vector-ref lbl-struct 2))

; Mark a label as target for "goto" and return eventual label number

(define (targ-ref-lbl-goto n)
  (let ((x (targ-get-lbl n)))
    (vector-set! x 1 #t)
    (targ-make-glbl (targ-lbl-num x) targ-proc-name)))

(define (targ-lbl-goto? lbl-struct)
  (vector-ref lbl-struct 1))

(define (targ-make-glbl n name)
  (list 'glbl n name))

; To generate new, unique labels

(define (targ-new-lbl)
  (targ-proc-lbl-counter))

(define (targ-heap-reserve space)
  (set! targ-proc-hp (+ targ-proc-hp space)))

(define (targ-heap-reserve-and-check space sn)
  (targ-heap-reserve space)
  (if (> (+ targ-proc-hp
            (* (targ-fp-cache-size) targ-flonum-space))
         targ-msection-biggest)
    (targ-update-fr-and-check-heap space sn)))

(define (targ-update-fr-and-check-heap space sn)
  (targ-update-fr targ-proc-entry-frame)
  (targ-check-heap space sn))

(define (targ-check-heap space sn)
  (let ((lbl (targ-new-lbl)))
    (targ-need-heap)
    (targ-emit (targ-adjust-stack sn))
;;    (targ-repr-exit-block! lbl)
    (targ-emit
      (list "CHECK_HEAP"
            (targ-ref-lbl-val lbl)
            (+ targ-msection-biggest space)))
;;    (targ-repr-end-block!)
    (targ-gen-label-return* lbl 'return-internal)
    (set! targ-proc-hp 0)))

(define (targ-poll sn)
  (let ((lbl (targ-new-lbl)))
    (targ-rd-fp)
    (targ-emit (targ-adjust-stack sn))
;;    (targ-repr-exit-block! lbl)
    (targ-emit
      (list "POLL" (targ-ref-lbl-val lbl)))
;;    (targ-repr-end-block!)
    (targ-gen-label-return* lbl 'return-internal)))

(define (targ-start-bb fs)
  (set! targ-proc-hp 0)
  (set! targ-proc-fp fs))

(define (targ-begin-fr) ; start of a floating point region
  (targ-fp-cache-init))

(define (targ-update-fr frame)
  (let* ((live
          (frame-live frame))
         (any-closed-live?
          (varset-intersects?
            live
            (list->varset (frame-closed frame)))))

    (define (live? var)
      (or (varset-member? var live)
          (and (eq? var closure-env-var) any-closed-live?)))

    (let loop1 ((i 1) (l (reverse (frame-slots frame))))
      (if (pair? l)
        (begin
          (if (live? (car l))
            (targ-fp-cache-write-if-dirty (make-stk i)))
          (loop1 (+ i 1) (cdr l)))
        (let loop2 ((i 0) (l (frame-regs frame)))
          (if (pair? l)
            (begin
              (if (live? (car l))
                (targ-fp-cache-write-if-dirty (make-reg i)))
              (loop2 (+ i 1) (cdr l)))))))))

; Management of resources

(define targ-nb-non-reg-res 2)

(define (targ-res-op i op)
  (let ((x (if (< i targ-nb-non-reg-res)
             (cons op (vector-ref '#("HEAP" "FP") i))
             (let ((j (- i targ-nb-non-reg-res)))
               (if (< j targ-nb-gvm-regs)
                 (cons op (string-append "R" (number->string j)))
                 (if (eq? op 'd-)
                   (let ((k (- j targ-nb-gvm-regs)))
                     (list "D_F64"
                           (targ-unboxed-index->code k)))
                   #f))))))
    (and x (list 'append " " x))))

(define (targ-unboxed-loc->index loc)
  (cond ((reg? loc)
         (reg-num loc))
        ((stk? loc)
         (+ (- (stk-num loc) 1) targ-nb-gvm-regs))
        (else
         (compiler-internal-error
           "targ-unboxed-loc->index, invalid 'loc'" loc))))

(define targ-use-fresh-fp-vars? #f)
(set! targ-use-fresh-fp-vars? #t)

(define (targ-unboxed-index->code i)
  (targ-need-unboxed i)
  (cond (targ-use-fresh-fp-vars?
         (list (string-append
                "F64V"
                (number->string i))))
        ((< i targ-nb-gvm-regs)
         (list (string-append
                "F64R"
                (number->string i))))
        (else
         (list (string-append
                "F64STK"
                (number->string (+ (- i targ-nb-gvm-regs) 1)))))))

(define (targ-unboxed-loc->code loc stamp)
  (targ-unboxed-index->code
    (if targ-use-fresh-fp-vars?
      stamp
      (targ-unboxed-loc->index loc))))

(define (targ-rd-res i)
  (stretchable-vector-set! targ-module-rd-res i #t)
  (stretchable-vector-set! targ-proc-rd-res i #t))

(define (targ-wr-res i)
  (targ-rd-res i)
  (stretchable-vector-set! targ-module-wr-res i #t)
  (stretchable-vector-set! targ-proc-wr-res i #t))

(define (targ-need-heap)
  (targ-wr-res 0))

(define (targ-rd-fp)
  (targ-rd-res 1))

(define (targ-wr-fp)
  (targ-wr-res 1))

(define (targ-rd-reg n)
  (targ-rd-res (+ n targ-nb-non-reg-res)))

(define (targ-wr-reg n)
  (targ-wr-res (+ n targ-nb-non-reg-res)))

(define (targ-need-unboxed n)
  (targ-wr-res
    (+ n (+ targ-nb-non-reg-res targ-nb-gvm-regs))))

(define (targ-use-all-res)
  (let loop ((i (- (+ targ-nb-non-reg-res targ-nb-gvm-regs) 1)))
    (if (>= i 0)
      (begin
        (targ-wr-res i)
        (loop (- i 1))))))

;------------------------------------------------------------------------------

(define (targ-add-var-descr! descr)

  (define (index x l)
    (let loop ((l l) (i 0))
      (cond ((not (pair? l))    #f)
            ((equal? (car l) x) i)
            (else               (loop (cdr l) (+ i 1))))))

  (let ((n (index descr (queue->list targ-var-descr-queue))))
    (if n
      n
      (let ((m (length (queue->list targ-var-descr-queue))))
        (queue-put! targ-var-descr-queue descr)
        m))))

(define (targ-add-first-class-label! node slots frame)

  (define (encode slot)
    (let ((v (car slot))
          (i (cdr slot)))
      (+ (* i 32768)
         (if (pair? v)
           (* (targ-add-var-descr! (map encode v)) 2)
           (+ (* (targ-add-var-descr! (var-name v)) 2)
              (if (var-boxed? v) 1 0))))))

  (define (closure-env-slot closure-vars stack-slots)
    (let loop ((i 1) (lst1 closure-vars) (lst2 '()))
      (if (null? lst1)
        lst2
        (let ((x (car lst1)))
          (if (not (frame-live? x frame))
            (loop (+ i 1)
                  (cdr lst1)
                  lst2)
            (let ((y (assq (var-name x) stack-slots)))
              (if (and y (not (eq? x (cadr y))))
                (begin
                  (if (< (var-lexical-level (cadr y))
                         (var-lexical-level x))
(let () (##namespace ("" pp));****************
(pp (list
'closure-vars: (map var-name closure-vars)
'stack-slots: (map car stack-slots)
'source: (source->expression (node-source node))
))
                    (compiler-internal-error
                     "targ-add-first-class-label!, variable conflict"))
);**************
                  (loop (+ i 1)
                        (cdr lst1)
                        lst2))
                (loop (+ i 1)
                      (cdr lst1)
                      (cons (cons x i) lst2)))))))))

  (define (accessible-slots)
    (let loop1 ((i 1)
                (lst1 slots)
                (lst2 '())
                (closure-env #f)
                (closure-env-index #f))
      (if (pair? lst1)
        (let* ((var (car lst1))
               (x (frame-live? var frame)))
          (cond ((pair? x) ; closure environment?
                 (if (or (not closure-env) (eq? var closure-env))
                   (loop1 (+ i 1)
                          (cdr lst1)
                          lst2
                          var
                          i)
                   (compiler-internal-error
                    "targ-add-first-class-label!, multiple closure environments")))
                ((or (not x) (temp-var? x)) ; not live or temporary var
                 (loop1 (+ i 1)
                        (cdr lst1)
                        lst2
                        closure-env
                        closure-env-index))
                (else
                 (let* ((name (var-name x))
                        (y (assq name lst2)))
                   (if (and y (not (eq? x (cadr y))))
                     (let ((level-x (var-lexical-level x))
                           (level-y (var-lexical-level (cadr y))))
                       (cond ((< level-x level-y)
                              (loop1 (+ i 1)
                                     (cdr lst1)
                                     lst2
                                     closure-env
                                     closure-env-index))
                             ((< level-y level-x)
                              (loop1 (+ i 1)
                                     (cdr lst1)
                                     (cons (cons name (cons x i)) (remq y lst2))
                                     closure-env
                                     closure-env-index))
                             (else
(let () (##namespace ("" pp));****************
(pp (list
'slots: (map var-name slots)
'source: (source->expression (node-source node))
))
                              (compiler-internal-error
                               "targ-add-first-class-label!, variable conflict"))))
);**********************
                     (loop1 (+ i 1)
                            (cdr lst1)
                            (cons (cons name (cons x i)) lst2)
                            closure-env
                            closure-env-index))))))
        (let* ((x
                (if closure-env
                  (closure-env-slot (frame-live? closure-env frame) lst2)
                  '()))
               (accessible-stack-slots
                (map cdr lst2)))
          (if (null? x)
            accessible-stack-slots
            (cons (cons x closure-env-index)
                  accessible-stack-slots))))))

  (let ((label-descr
         (cons (if (and node
                        targ-debug-option?)
                 (node-source node)
                 #f)
               (if (and node
                        (or targ-debug-option?
                            (environment-map? (node-env node))))
                 (begin
                   (set! targ-debug-info? #t)
                   (map encode (accessible-slots)))
                 '()))))
    (queue-put! targ-first-class-label-queue label-descr)
    label-descr))

;------------------------------------------------------------------------------

(define (targ-gen-gvm-instr prev-gvm-instr gvm-instr next-gvm-instr sn)

  (set! targ-proc-instr-node
    (comment-get (gvm-instr-comment gvm-instr) 'node))
  (set! targ-proc-exit-frame
    (gvm-instr-frame gvm-instr))
  (set! targ-proc-entry-frame
    (and prev-gvm-instr (gvm-instr-frame prev-gvm-instr)))

;  (write-gvm-instr gvm-instr ##stdout)(newline);*************

  (if targ-track-scheme-option?
    (let* ((src (node-source targ-proc-instr-node))
           (x (locat-filename-and-line (and src (source-locat src))))
           (filename (car x))
           (line (cdr x)))
      (if (< 0 (string-length filename))
        (targ-emit
         (list 'line line filename)))))

  (case (gvm-instr-type gvm-instr)

    ((label)
     (set! targ-proc-entry-frame targ-proc-exit-frame)
     (targ-start-bb (frame-size targ-proc-exit-frame))
     (case (label-type gvm-instr)
       ((simple)
        (targ-gen-label-simple (label-lbl-num gvm-instr)
                               sn))
       ((entry)
        (targ-gen-label-entry (label-lbl-num gvm-instr)
                              (label-entry-nb-parms gvm-instr)
                              (label-entry-opts gvm-instr)
                              (label-entry-keys gvm-instr)
                              (label-entry-rest? gvm-instr)
                              (label-entry-closed? gvm-instr)
                              sn))
       ((return)
        (targ-gen-label-return (label-lbl-num gvm-instr)
                               sn))
       ((task-entry)
        (targ-gen-label-task-entry (label-lbl-num gvm-instr)
                                   sn))
       ((task-return)
        (targ-gen-label-task-return (label-lbl-num gvm-instr)
                                    sn))
       (else
        (compiler-internal-error
          "targ-gen-gvm-instr, unknown label type"))))

    ((apply)
     (targ-gen-apply (apply-prim gvm-instr)
                     (apply-opnds gvm-instr)
                     (apply-loc gvm-instr)
                     sn))

    ((copy)
     (targ-gen-copy (copy-opnd gvm-instr)
                    (copy-loc gvm-instr)
                    sn))

    ((close)
     (targ-gen-close (close-parms gvm-instr)
                     sn))

    ((ifjump)
     (targ-gen-ifjump (ifjump-test gvm-instr)
                      (ifjump-opnds gvm-instr)
                      (ifjump-true gvm-instr)
                      (ifjump-false gvm-instr)
                      (ifjump-poll? gvm-instr)
                      (if (and next-gvm-instr
                               (memq (label-type next-gvm-instr)
                               '(simple task-entry)))
                        (label-lbl-num next-gvm-instr)
                        #f)))

    ((jump)
     (targ-gen-jump (jump-opnd gvm-instr)
                    (jump-nb-args gvm-instr)
                    (jump-poll? gvm-instr)
                    (jump-safe? gvm-instr)
                    (if (and next-gvm-instr
                             (memq (label-type next-gvm-instr)
                                   '(simple task-entry)))
                      (label-lbl-num next-gvm-instr)
                      #f)))

    (else
     (compiler-internal-error
       "targ-gen-gvm-instr, unknown 'gvm-instr'" gvm-instr))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-gen-label-simple lbl sn)
  (targ-emit-label-simp lbl)
  (targ-begin-fr)
;;  (targ-repr-begin-block! 'simple lbl)
)

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-gen-label-entry lbl nb-parms opts keys rest? closed? sn)

  (let ((label-descr (targ-add-first-class-label!
                       targ-proc-instr-node
                       '()
                       targ-proc-exit-frame)))
    (if (= lbl targ-proc-entry-lbl)
      (begin
        (targ-emit-label-entry lbl nb-parms label-descr)
        (targ-ref-lbl-val lbl)
        (targ-ref-lbl-goto lbl))
      (let ((nb-closed (length (frame-closed targ-proc-exit-frame))));******
        (targ-emit-label-subproc lbl nb-parms nb-closed label-descr))))

  (let* ((nb-parms-except-rest
          (- nb-parms (if rest? 1 0)))
         (nb-keys
          (if keys (length keys) 0))
         (nb-req-and-opt
          (- nb-parms-except-rest nb-keys))
         (nb-opts
          (length opts))
         (nb-req
          (- nb-req-and-opt nb-opts))
         (lbl*
          (targ-ref-lbl-val lbl))
         (defaults
          (append opts (map cdr (or keys '())))))

    (define (make-key-descriptor)
      (let loop ((lst1 keys) (lst2 '()))
        (if (null? lst1)
          (list->vect (reverse lst2))
          (let ((key (car lst1)))
            (loop (cdr lst1)
                  (cons (obj-val (cdr key)) (cons (car key) lst2)))))))

    (define (dispatch-on-nb-args nb-args)
      (if (> nb-args nb-req-and-opt)

        (targ-emit
         (if keys
           (list (if rest? "GET_KEY_REST" "GET_KEY")
                 lbl* nb-req nb-opts nb-keys
                 (targ-use-obj (make-key-descriptor)))
           (list (if rest? "GET_REST" "WRONG_NARGS")
                 lbl* nb-req nb-opts nb-keys)))

        (let ((nb-stacked (max 0 (- nb-args targ-nb-arg-regs)))
              (nb-stacked* (max 0 (- nb-parms targ-nb-arg-regs))))

          (define (setup-parameter i)
            (if (<= i nb-parms)
              (let* ((rest (setup-parameter (+ i 1)))
                     (src-reg (- i nb-stacked))
                     (src (cond ((<= i nb-args)
                                 (cons 'r src-reg))
                                ((and rest? (= i nb-parms))
                                 '("NUL"))
                                (else
                                 (targ-use-obj
                                  (obj-val
                                   (list-ref defaults (- i nb-req 1))))))))
                (if (<= i nb-stacked*)
                  (begin
                    (if (<= i nb-args) (targ-rd-reg src-reg))
                    (targ-rd-fp)
                    (targ-wr-fp)
                    (cons (list "PUSH" src) rest))
                  (if (and (<= i nb-args) (= nb-stacked nb-stacked*))
                    rest
                    (let ((dst-reg (- i nb-stacked*)))
                      (if (<= i nb-args) (targ-rd-reg src-reg))
                      (targ-wr-reg dst-reg)
                      (cons (list 'set-r dst-reg src) rest)))))
              '()))

          (let ((x (setup-parameter (+ nb-stacked 1))))
            (targ-emit (list "IF_NARGS_EQ"
                             nb-args
                             (if (null? x) '("NOTHING") (cons 'seq x)))))

          (dispatch-on-nb-args (+ nb-args 1)))))

    (dispatch-on-nb-args nb-req)

    (if (= lbl targ-proc-entry-lbl)
      (targ-emit (list 'append
                       (list "DEF_GLBL" (targ-make-glbl "" targ-proc-name))
                       #\newline)))

    (targ-begin-fr)
;;    (targ-repr-begin-block! 'entry lbl)
))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-gen-label-return lbl sn)
  (targ-gen-label-return* lbl 'return))

(define (targ-gen-label-return* lbl kind)
  (let ((frame targ-proc-entry-frame))

    (define (extend-vars l n)
      (cond ((= n 0) l)
            ((< n 0) (extend-vars (cdr l) (+ n 1)))
            (else    (extend-vars (cons empty-var l) (- n 1)))))

    (define (generate fs vars gc-map)
      (let ((label-descr
             (targ-add-first-class-label!
              targ-proc-instr-node
              vars
              frame))
            (link
             (pos-in-list ret-var vars)))
        (if link
          (begin
            (case kind
              ((return)
               (targ-emit-label-return lbl fs link gc-map label-descr)
;;               (targ-repr-begin-block! 'return lbl)
)
              ((return-task)
               (targ-emit-label-return-task lbl fs link gc-map label-descr)
;;               (targ-repr-begin-block! 'task-return lbl)
)
              ((return-internal)
               (targ-emit-label-return-internal lbl fs link gc-map label-descr)
;;               (targ-repr-begin-block! 'return-internal lbl)
)
              (else
               (compiler-internal-error
                 "targ-gen-label-return*, unknown label kind")))
            (targ-begin-fr))
          (compiler-internal-error
            "targ-gen-label-return*, no return address in frame"))))

    (if (eq? kind 'return-internal)
      (let* ((cfs
              targ-proc-fp)
             (cfs-after-alignment
              (targ-align-frame cfs))
             (regs
              (frame-regs frame))
             (return-var
              (make-temp-var 'return))
             (vars
              (append (reverse (extend-vars (frame-slots frame)
                                            (- cfs-after-alignment
                                               (frame-size frame))))
                      (reverse (extend-vars (reverse regs)
                                            (- targ-nb-gvm-regs
                                               (length regs))))
                      (list return-var)
                      (extend-vars '()
                                   (- (- (targ-align-frame
                                          (+ (+ targ-nb-gvm-regs 1)
                                             targ-frame-reserve))
                                         targ-frame-reserve)
                                      (+ targ-nb-gvm-regs 1)))))
             (gc-map
              (targ-build-gc-map
               vars
               (lambda (i var)
                 (or (frame-live? var frame)
                     (let ((j (- i cfs-after-alignment)))
                       (and (>= j 0) ; all saved GVM regs are live
                            (<= j targ-nb-gvm-regs))))))))
        (generate cfs vars gc-map))
      (let* ((fs ; remove frame reserve from actual frame size
              (- targ-proc-fp targ-frame-reserve))
             (vars
              (reverse (extend-vars (frame-slots frame)
                                    (- fs (frame-size frame)))))
             (gc-map
              (targ-build-gc-map
               vars
               (lambda (i var)
                 (frame-live? var frame)))))
        (generate fs vars gc-map)))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-gen-label-task-entry lbl sn)

  (targ-emit-label-simp lbl)

  (let ((fs (frame-size targ-proc-exit-frame)))
    (if (= fs 0)

      (begin
        (targ-rd-fp)
        (targ-wr-fp)
        (targ-emit '("PUSH" (r . 0))))

      (begin
       (targ-emit '("ADJFP" 1))
        (let loop ((i 0))
          (if (< i fs)
            (begin
              (targ-emit (list "SET_STK" (- i) (list "STK" (- (+ i 1)))))
              (loop (+ i 1)))
            (targ-emit (list "SET_STK" (- i) '(r . 0)))))))

    (targ-emit (list "TASK_PUSH" fs))

    (targ-begin-fr)
;;    (targ-repr-begin-block! 'task-entry lbl)
))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-gen-label-task-return lbl sn)
  (let ((lbl2 (targ-new-lbl))
        (fs (+ (frame-size targ-proc-exit-frame) 1)))

    (targ-start-bb fs)

    (targ-gen-label-return* lbl 'return-task)
    (targ-emit (list "TASK_POP" (targ-ref-lbl-val lbl2)))
;;    (targ-repr-exit-block! lbl2)
;;    (targ-repr-end-block!)
    (targ-gen-label-return* lbl2 'return)))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-gen-apply prim opnds loc sn)
  (let ((proc (proc-obj-inlinable prim)))
    (if proc
      (begin
        (proc opnds loc sn)
        (targ-heap-reserve-and-check 0 sn))
      (compiler-internal-error
        "targ-gen-apply, unknown 'prim'" prim))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-gen-copy opnd loc sn)
  (if opnd
    (targ-emit
     (targ-loc loc (targ-opnd opnd)))
;    (targ-emit (targ-loc loc (targ-opnd (make-obj 1234567))));***********************
)
  (targ-heap-reserve-and-check 0 sn))

'(;;
  (if targ-repr-enabled?

    (if (and (or (reg? opnd) (stk? opnd))
             (or (reg? loc) (stk? loc)))
      (let* ((loc-descrs
              (targ-block-loc-descrs targ-repr-current-block))
             (i
              (targ-repr-loc->index opnd))
             (descr
              (stretchable-vector-ref loc-descrs i))
             (have
              (targ-repr-have-reprs descr)))
        (if (targ-repr-empty? have)

          (targ-emit
            (targ-loc loc (targ-opnd opnd)))

          (let ((j (targ-repr-loc->index loc)))
            (let loop1 ((repr targ-repr-boxed))
              (if (< repr targ-repr-nb-reprs)
                (begin
                  (if (targ-repr-member? repr have)
                    (targ-emit
                      (if (= repr targ-repr-boxed)
                        (targ-repr-loc-boxed loc (targ-repr-opnd-boxed opnd))
                        (let ((type (vector-ref targ-repr-types (- repr 1))))
                          (list (string-append "SET_" type)
                                (targ-repr-unboxed-loc->code loc repr)
                                (targ-repr-unboxed-loc->code opnd repr))))))
                  (loop1 (+ repr 1)))))
            (stretchable-vector-set! loc-descrs j
              (targ-repr-have-reprs-set
                (stretchable-vector-ref loc-descrs j)
                have)))))

      (targ-emit
        (targ-loc loc (targ-opnd opnd))))

    (targ-emit
      (targ-loc loc (targ-opnd opnd)))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-gen-close parms sn)

  (define (close parms* sn*)
    (if (pair? parms*)

      (let* ((parm (car parms*))
             (lbl (closure-parms-lbl parm))
             (loc (closure-parms-loc parm))
             (opnds (closure-parms-opnds parm))
             (sn** (targ-sn-opnds opnds sn*)))
        (close (cdr parms*) (targ-sn-loc loc sn**))
        (let* ((x (targ-opnd loc))
               (elements (map targ-opnd opnds))
               (n (length elements)))
          (targ-emit
            (list "BEGIN_SETUP_CLO" n x (targ-ref-lbl-val lbl)))
          (for-each-index (lambda (elem i)
                            (targ-emit
                              (list "ADD_CLO_ELEM" i elem)))
                          elements)
          (targ-emit
            (list "END_SETUP_CLO" n))))

      (begin

        (targ-heap-reserve-and-check
          (apply +
                 (map (lambda (parm)
                        (targ-closure-space
                          (length (closure-parms-opnds parm))))
                      parms))
          sn*)

        (for-each (lambda (parm)
                    (let ((loc (closure-parms-loc parm))
                          (opnds (closure-parms-opnds parm)))
                      (targ-emit
                        (targ-loc loc (list "ALLOC_CLO" (length opnds))))))
                  parms))))

  (close (reverse parms) sn)

  (targ-heap-reserve-and-check 0 sn))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-gen-ifjump test opnds true-lbl false-lbl poll? next-lbl)
  (let ((x (proc-obj-test test)))
    (if x

      (let ((args-flo? (vector-ref x 0))
            (proc (vector-ref x 1)))

        (define (gen-if not? branch-lbl fall-lbl)
          (let ((fs (frame-size targ-proc-exit-frame)))
            (if (or (not args-flo?)
                    (begin
                      (targ-update-fr targ-proc-exit-frame)
                      (targ-end-of-block-checks-needed? poll?)))
              (let ((sn (targ-sn-opnds opnds fs)))
                (targ-update-fr targ-proc-entry-frame)
                (targ-end-of-block-checks poll? sn)))
            (targ-emit
              (targ-adjust-stack fs))
            (targ-emit
              (list "IF" (proc not? opnds fs)))
;;            (targ-repr-exit-block! branch-lbl)
            (targ-emit
              (list "GOTO" (targ-ref-lbl-goto branch-lbl)))
            (targ-emit
              '("END_IF"))
;;            (targ-repr-exit-block! fall-lbl)
            (if (not (eqv? fall-lbl next-lbl))
              (targ-emit
                (list "GOTO" (targ-ref-lbl-goto fall-lbl))))
;;            (targ-repr-end-block!)
))

        (if (eqv? true-lbl next-lbl)
          (gen-if #t false-lbl true-lbl)
          (gen-if #f true-lbl false-lbl)))

      (compiler-internal-error
        "targ-gen-ifjump, unknown 'test'" test))))

(define (targ-end-of-block-checks-needed? poll?)
  (or poll?
      (> targ-proc-hp 0)))

(define (targ-end-of-block-checks poll? sn)
  (if (> targ-proc-hp 0)
    (targ-check-heap 0 sn))
  (if poll?
    (targ-poll sn)))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-gen-jump opnd nb-args poll? safe? next-lbl)

  (targ-update-fr targ-proc-entry-frame)

  (let ((inlined
         (and (obj? opnd)
              (proc-obj? (obj-val opnd))
              nb-args
              (let* ((proc (obj-val opnd))
                     (jump-inliner (proc-obj-jump-inlinable proc)))
                (and jump-inliner
                     (jump-inliner nb-args poll? safe?))))))
    (if (not inlined)
      (let* ((fs (frame-size targ-proc-exit-frame))
             (sn (targ-sn-opnd opnd fs))
             (set-nargs (if nb-args (list "SET_NARGS" nb-args) #f)))

        (targ-end-of-block-checks poll? sn)

        (targ-emit
         (targ-adjust-stack fs))

        (cond ((lbl? opnd)
               (let ((n (lbl-num opnd)))
;;                 (targ-repr-exit-block! (if nb-args #f n))
                 (if (and next-lbl (= next-lbl n)) ; fall through?
                   (targ-emit set-nargs)
                   (targ-emit
                     (list 'seq
                           set-nargs
                           (list "GOTO" (targ-ref-lbl-goto n)))))))
              ((and (obj? opnd)
                    (proc-obj? (obj-val opnd))
                    nb-args)
               (let* ((proc (obj-val opnd))
                      (x (targ-use-prc proc #f)))
;;                 (targ-repr-exit-block! #f)
                 (if (eq? (car x) 'prm)
                   (targ-emit
                     (list "JUMPPRM"
                           set-nargs
                           x))
                   (let ((name (proc-obj-name proc)))
                     (if (targ-arg-check-avoidable? proc nb-args)
                       (targ-emit
                         (list "JUMPINT"
                               set-nargs
                               x
                               (targ-make-glbl "" name)))
                       (targ-emit
                         (list 'seq
                               set-nargs
                               (list "JUMPINT"
                                     '("NOTHING")
                                     x
                                     (targ-make-glbl 0 name)))))))))
              ((glo? opnd)
;;               (targ-repr-exit-block! #f)
               (targ-emit
                 (cons (begin
                         (targ-wr-reg (+ targ-nb-arg-regs 1))
                         (if safe? "JUMPGLOSAFE" "JUMPGLONOTSAFE"))
                       (cons (if nb-args set-nargs '("NOTHING"))
                             (cdr (targ-opnd opnd))))))
              (else
;;               (targ-repr-exit-block! #f)
               (targ-emit
                 (list (if nb-args
                         (begin
                           (targ-wr-reg (+ targ-nb-arg-regs 1))
                           (if safe? "JUMPGENSAFE" "JUMPGENNOTSAFE"))
                         "JUMPPRM")
                       (if nb-args set-nargs '("NOTHING"))
                       (targ-opnd opnd)))))

;;        (targ-repr-end-block!)
))))

(define (targ-arg-check-avoidable? proc nb-args)
  (let ((x (proc-obj-call-pat proc)))
    (if (and (pair? x) (null? (cdr x))) ; proc accepts a fixed nb of args?
      (let ((arg-count (car x)))
        (= arg-count nb-args))          ; nb of arguments = nb of parameters?
      #f)))

;------------------------------------------------------------------------------

'(;;

(define targ-repr-enabled? #f)
(set! targ-repr-enabled? #t)

(define targ-repr-graph #f)
(define targ-repr-current-block #f)

; Location representation descriptors.

(define targ-repr-boxed 0) ; must be 0
(define targ-repr-f64   1)

(define targ-repr-nb-reprs 2) ; # of possible representations (including boxed)
(define targ-repr-universal 3) ; (- (expt 2 targ-repr-nb-repr) 1)

(define targ-repr-types ; type name of each unboxed representation
  '#("F64"))

(define targ-repr-have-pos  0) ; bit position of "have" field (must be 0)
(define targ-repr-need-pos  2) ; bit position of "need" field
(define targ-repr-entry-pos 4) ; bit position of "entry" field

(define targ-repr-live1-mask  64) ; live at entry of block
(define targ-repr-live2-mask 128) ; live at exit of block
(define targ-repr-all-mask   255) ; (- (* 2 targ-repr-live2-mask) 1)
(define targ-repr-have-mask  252) ; (- targ-repr-all-mask targ-repr-universal)
(define targ-repr-entry-mask 207) ; (- targ-repr-all-mask
                                  ;    (* (expt 2 targ-repr-entry-pos)
                                  ;       targ-repr-universal))

(define (targ-repr-have-reprs descr)
  (bits-and descr targ-repr-universal))

(define (targ-repr-have-reprs-union descr reprs)
  (bits-or descr reprs))

(define (targ-repr-have-reprs-set descr reprs)
  (bits-or (bits-and descr targ-repr-have-mask) reprs))

(define (targ-repr-need-reprs descr)
  (bits-and (bits-shr descr targ-repr-need-pos) targ-repr-universal))

(define (targ-repr-need-reprs-union descr reprs)
  (bits-or descr (bits-shl reprs targ-repr-need-pos)))

(define (targ-repr-entry-reprs descr)
  (bits-and (bits-shr descr targ-repr-entry-pos) targ-repr-universal))

(define (targ-repr-entry-reprs-set descr reprs)
  (bits-or (bits-and descr targ-repr-entry-mask)
           (bits-shl reprs targ-repr-entry-pos)))

(define (targ-repr-live1-add descr)
  (bits-or descr targ-repr-live1-mask))

(define (targ-repr-live1? descr)
  (not (= (bits-and descr targ-repr-live1-mask) 0)))

(define (targ-repr-live2-add descr)
  (bits-or descr targ-repr-live2-mask))

(define (targ-repr-live2? descr)
  (not (= (bits-and descr targ-repr-live2-mask) 0)))

(define (targ-repr-equal-descr? descr1 descr2)
  (= descr1 descr2))

(define (targ-repr-included-reprs? reprs1 reprs2)
  (= (bits-and reprs1 reprs2) reprs1))

(define (targ-repr-empty)
  0)

(define (targ-repr-empty? reprs)
  (= reprs (targ-repr-empty)))

(define (targ-repr-member? repr reprs)
  (not (= (bits-and reprs (bits-shl 1 repr)) 0)))

(define (targ-repr-singleton repr)
  (bits-shl 1 repr))

(define (targ-repr-intersection reprs1 reprs2)
  (bits-and reprs1 reprs2))

(define (targ-make-block kind lbl entry-cell)
  (vector kind
          lbl
          entry-cell
          '()
          #f
          #f
          (make-stretchable-vector (targ-repr-empty))))

(define (targ-block-kind block)        (vector-ref block 0))
(define (targ-block-lbl block)         (vector-ref block 1))
(define (targ-block-entry-cell block)  (vector-ref block 2))
(define (targ-block-exits block)       (vector-ref block 3))
(define (targ-block-entry-fs block)    (vector-ref block 4))
(define (targ-block-exit-fs block)     (vector-ref block 5))
(define (targ-block-loc-descrs block)  (vector-ref block 6))

(define (targ-block-add-exit! block lbl cell)
  (vector-set! block 3
    (cons (cons lbl cell) (vector-ref block 3))))

(define (targ-block-entry-fs-set! block fs)
  (vector-set! block 4 fs))

(define (targ-block-exit-fs-set! block fs)
  (vector-set! block 5 fs))

(define (targ-repr-begin-proc!)
  (if targ-repr-enabled?
    (set! targ-repr-graph (make-stretchable-vector #f))))

(define (targ-repr-end-proc!)

  (define (compute-reprs-function src)
    (let ((exits (targ-block-exits src)))
      (if (not (null? (cdr exits)))
        (compute-reprs-function-2-known-exits src (caar exits) (caadr exits))
        (if (caar exits)
          (compute-reprs-function-1-known-exit src (caar exits))
          (compute-reprs-function-1-unknown-exit src)))))

  (define (compute-reprs-function-1-unknown-exit src)
    (lambda (src-descr i)
      (targ-repr-singleton targ-repr-boxed)))

  (define (compute-reprs-function-1-known-exit src dst)
    (let* ((dst-loc-descrs (targ-block-loc-descrs dst))
           (src-fs (targ-block-exit-fs src))
           (dst-fs (targ-block-entry-fs dst))
           (offs (- src-fs dst-fs)))
      (lambda (src-descr i)
        (let* ((src-have
                (targ-repr-have-reprs src-descr))
               (src-reprs
                (if (targ-repr-empty? src-have)
                  (targ-repr-need-reprs src-descr)
                  src-have)))
          (if (< i targ-nb-gvm-regs)
            (let ((dst-descr
                    (stretchable-vector-ref dst-loc-descrs i)))
              (stretchable-vector-set!
                dst-loc-descrs
                i
                (targ-repr-entry-reprs-set
                  dst-descr
                  (targ-repr-intersection
                    (targ-repr-entry-reprs dst-descr)
                    src-reprs)))
              (targ-repr-need-reprs dst-descr))
            (let* ((j
                    (- i offs))
                   (dst-descr
                     (if (>= j targ-nb-gvm-regs)
                       (stretchable-vector-ref dst-loc-descrs j)
                       0)))
              (if (>= j targ-nb-gvm-regs)
                (stretchable-vector-set!
                  dst-loc-descrs
                  j
                  (targ-repr-entry-reprs-set
                    dst-descr
                    (targ-repr-intersection
                      (targ-repr-entry-reprs dst-descr)
                      src-reprs))))
              (targ-repr-need-reprs dst-descr)))))))

  (define (compute-reprs-function-2-known-exits src dst1 dst2)
    (let* ((dst1-loc-descrs (targ-block-loc-descrs dst1))
           (dst2-loc-descrs (targ-block-loc-descrs dst2))
           (src-fs (targ-block-exit-fs src))
           (dst1-fs (targ-block-entry-fs dst1))
           (dst2-fs (targ-block-entry-fs dst2))
           (offs1 (- src-fs dst1-fs))
           (offs2 (- src-fs dst2-fs)))
      (lambda (src-descr i)
        (let* ((src-have
                (targ-repr-have-reprs src-descr))
               (src-reprs
                (if (targ-repr-empty? src-have)
                  (targ-repr-need-reprs src-descr)
                  src-have)))
          (if (< i targ-nb-gvm-regs)
            (let ((dst1-descr
                    (stretchable-vector-ref dst1-loc-descrs i))
                  (dst2-descr
                    (stretchable-vector-ref dst2-loc-descrs i)))
              (stretchable-vector-set!
                dst1-loc-descrs
                i
                (targ-repr-entry-reprs-set
                  dst1-descr
                  (targ-repr-intersection
                    (targ-repr-entry-reprs dst1-descr)
                    src-reprs)))
              (stretchable-vector-set!
                dst2-loc-descrs
                i
                (targ-repr-entry-reprs-set
                  dst2-descr
                  (targ-repr-intersection
                    (targ-repr-entry-reprs dst2-descr)
                    src-reprs)))
              (targ-repr-intersection
                (targ-repr-need-reprs dst1-descr)
                (targ-repr-need-reprs dst2-descr)))
            (let* ((j1
                    (- i offs1))
                   (j2
                    (- i offs2))
                   (dst1-descr
                     (if (>= j1 targ-nb-gvm-regs)
                       (stretchable-vector-ref dst1-loc-descrs j1)
                       0))
                   (dst2-descr
                     (if (>= j2 targ-nb-gvm-regs)
                       (stretchable-vector-ref dst2-loc-descrs j2)
                       0)))
              (if (>= j1 targ-nb-gvm-regs)
                (stretchable-vector-set!
                  dst1-loc-descrs
                  j1
                  (targ-repr-entry-reprs-set
                    dst1-descr
                    (targ-repr-intersection
                      (targ-repr-entry-reprs dst1-descr)
                      src-reprs))))
              (if (>= j2 targ-nb-gvm-regs)
                (stretchable-vector-set!
                  dst2-loc-descrs
                  j2
                  (targ-repr-entry-reprs-set
                    dst2-descr
                    (targ-repr-intersection
                      (targ-repr-entry-reprs dst2-descr)
                      src-reprs))))
              (targ-repr-intersection
                (targ-repr-need-reprs dst1-descr)
                (targ-repr-need-reprs dst2-descr))))))))

  (define (insert-exit-conversions src dst cell)
    (if dst
      (insert-known-exit-conversions src dst cell)
      (insert-unknown-exit-conversions src cell)))

  (define (insert-unknown-exit-conversions src cell)
    (let ((lst '())
          (src-loc-descrs (targ-block-loc-descrs src))
          (src-fs (targ-block-exit-fs src)))

      (define (conversion i j need-j)
        (let* ((descr-i
                (stretchable-vector-ref src-loc-descrs i))
               (have-i
                (targ-repr-have-reprs descr-i))
               (need-i
                (targ-repr-need-reprs descr-i))
               (reprs-i
                (if (targ-repr-empty? have-i)
                  (if (targ-repr-empty? need-i)
                    (targ-repr-singleton targ-repr-boxed)
                    need-i)
                  have-i))
               (reprs-j
                (if (targ-repr-empty? need-j)
                  (targ-repr-singleton targ-repr-boxed)
                  need-j)))

          (set! targ-proc-fp src-fs)

          (let loop1 ((r (+ targ-repr-boxed 1)))
            (if (< r targ-repr-nb-reprs)
              (begin
                (if (targ-repr-member? r reprs-j) ; needed in this repr?
                  (if (targ-repr-member? r reprs-i) ; already in this repr?
                    (if (not (= i j)) ; copying necessary?
                      (set! lst
                        (cons (targ-repr-unboxed-index-copy i j r)
                              lst)))
                    (set! lst
                      (cons (targ-repr-unboxed-copy
                              (targ-repr-from-boxed
                                (targ-repr-opnd-boxed (targ-repr-index->loc i))
                                r)
                              (targ-repr-unboxed-index->code j r)
                              r)
                            lst))))
                (loop1 (+ r 1)))))

          (if (not (or (targ-repr-included-reprs? reprs-j reprs-i)
                       (targ-repr-member? targ-repr-boxed reprs-i)))
            (let loop2 ((r (+ targ-repr-boxed 1)))
              (if (not (targ-repr-member? r reprs-i))
                (loop2 (+ r 1))
                (set! lst
                  (cons (targ-repr-to-boxed! (targ-repr-index->loc i) r)
                        lst)))))))

      (let loop ((i (- (+ targ-nb-gvm-regs src-fs) 1)))
        (if (>= i 0)
          (let ((descr-i (stretchable-vector-ref src-loc-descrs i)))
            (if (targ-repr-live2? descr-i)
              (conversion i i (targ-repr-empty)))
            (loop (- i 1)))))
      (targ-cell-set!
        cell
        (list 'append
              "/* exit representation: "
              (targ-repr-to-string
               src-loc-descrs
               targ-repr-have-reprs
               targ-repr-live2?)
              " */"
              #\newline
              (cons 'seq lst)
              #\newline))))

  (define (insert-known-exit-conversions src dst cell)
    (let* ((lst '())
           (src-loc-descrs (targ-block-loc-descrs src))
           (dst-loc-descrs (targ-block-loc-descrs dst))
           (src-fs (targ-block-exit-fs src))
           (dst-fs (targ-block-entry-fs dst))
           (offs (- src-fs dst-fs)))

      (define (conversion i j need-j)
        (let* ((descr-i
                (stretchable-vector-ref src-loc-descrs i))
               (have-i
                (targ-repr-have-reprs descr-i))
               (need-i
                (targ-repr-need-reprs descr-i))
               (reprs-i
                (if (targ-repr-empty? have-i)
                  (if (targ-repr-empty? need-i)
                    (targ-repr-singleton targ-repr-boxed)
                    need-i)
                  have-i))
               (reprs-j
                (if (targ-repr-empty? need-j)
                  (targ-repr-singleton targ-repr-boxed)
                  need-j)))

          (set! targ-proc-fp src-fs)

          (let loop1 ((r (+ targ-repr-boxed 1)))
            (if (< r targ-repr-nb-reprs)
              (begin
                (if (targ-repr-member? r reprs-j) ; needed in this repr?
                  (if (targ-repr-member? r reprs-i) ; already in this repr?
                    (if (not (= i j)) ; copying necessary?
                      (set! lst
                        (cons (targ-repr-unboxed-index-copy i j r)
                              lst)))
                    (set! lst
                      (cons (targ-repr-unboxed-copy
                              (targ-repr-from-boxed
                                (targ-repr-opnd-boxed (targ-repr-index->loc i))
                                r)
                              (targ-repr-unboxed-index->code j r)
                              r)
                            lst))))
                (loop1 (+ r 1)))))

          (if (not (or (targ-repr-included-reprs? reprs-j reprs-i)
                       (targ-repr-member? targ-repr-boxed reprs-i)))
            (let loop2 ((r (+ targ-repr-boxed 1)))
              (if (not (targ-repr-member? r reprs-i))
                (loop2 (+ r 1))
                (set! lst
                  (cons (targ-repr-to-boxed! (targ-repr-index->loc i) r)
                        lst)))))))

      (let loop ((i (- (+ targ-nb-gvm-regs src-fs) 1)))
        (if (>= i 0)
          (let ((j (if (< i targ-nb-gvm-regs) i (- i offs))))
            (if (and (>= i targ-nb-gvm-regs)
                     (< j targ-nb-gvm-regs))
              (conversion i i (targ-repr-empty))
              (let ((descr-j (stretchable-vector-ref dst-loc-descrs j)))
                (if (targ-repr-live1? descr-j)
                  (conversion i j (targ-repr-need-reprs descr-j)))))
            (loop (- i 1)))))
      (targ-cell-set!
        cell
        (list 'append
              "/* exit representation: "
              (targ-repr-to-string
               src-loc-descrs
               targ-repr-have-reprs
               targ-repr-live2?)
              " */"
              #\newline
              (cons 'seq lst)
              #\newline))))

  ; preprocess graph to access it faster

  (stretchable-vector-for-each
    (lambda (block lbl)
      (if block
        (for-each ; collapse each label reference to a block
          (lambda (x)
            (if (car x) ; #f indicates an unknown exit block
              (set-car! x
                        (stretchable-vector-ref
                          targ-repr-graph
                          (car x)))))
          (targ-block-exits block))))
    targ-repr-graph)

  (let loop1 ()
    (let ((changed? #f))

      (define (intersect-reprs src)
        (let ((loc-descrs (targ-block-loc-descrs src)))
          (stretchable-vector-for-each
            (lambda (descr i)
              (if (targ-repr-live1? descr)
                (let ((new
                       (targ-repr-need-reprs-union
                         descr
                         (targ-repr-entry-reprs descr))))
                  (stretchable-vector-set!
                    loc-descrs
                    i
                    (if (memq (targ-block-kind src)
                              '(entry return task-entry task-return))
                      new
                      (targ-repr-entry-reprs-set new targ-repr-universal))))))
            loc-descrs)))

      (define (propagate-repr src)
        (let ((compute-reprs (compute-reprs-function src))
              (loc-descrs (targ-block-loc-descrs src)))
          (stretchable-vector-for-each
            (lambda (descr i)
              (if (targ-repr-live2? descr)
                (let ((new
                       (targ-repr-need-reprs-union
                         descr
                         (compute-reprs descr i))))
                  (if (and (targ-repr-empty? (targ-repr-have-reprs descr))
                           (not (targ-repr-equal-descr? new descr)))
                    (begin
                      (set! changed? #t)
                      (stretchable-vector-set! loc-descrs i new))))))
            loc-descrs)))

      (let loop2 ((lbl (- (stretchable-vector-length targ-repr-graph) 1)))
        (if (>= lbl 0)
          (let ((block (stretchable-vector-ref targ-repr-graph lbl)))
            (if block
              (intersect-reprs block))
            (loop2 (- lbl 1)))))

      (let loop3 ((lbl (- (stretchable-vector-length targ-repr-graph) 1)))
        (if (>= lbl 0)
          (let ((block (stretchable-vector-ref targ-repr-graph lbl)))
            (if block
              (propagate-repr block))
            (loop3 (- lbl 1)))))

      (if changed?
        (loop1))))

  (let loop4 ((lbl (- (stretchable-vector-length targ-repr-graph) 1)))
    (if (>= lbl 0)
      (let ((block (stretchable-vector-ref targ-repr-graph lbl)))
        (if block
          (for-each
            (lambda (x)
              (insert-exit-conversions block (car x) (cdr x)))
            (targ-block-exits block)))
        (loop4 (- lbl 1)))))

  (let loop5 ((lbl (- (stretchable-vector-length targ-repr-graph) 1)))
    (if (>= lbl 0)
      (let ((block (stretchable-vector-ref targ-repr-graph lbl)))
        (if block
          (let ((cell (targ-block-entry-cell block)))
            (cond ((memq (targ-block-kind block)
                         '(entry return task-entry task-return))
                   (targ-cell-set!
                     cell
                     (list 'append
                           "/* entry representation: "
                           (targ-repr-to-string
                             (targ-block-loc-descrs block)
                             targ-repr-need-reprs
                             targ-repr-live1?)
                           " */"
                           #\newline
                           (begin
                             (set! targ-proc-fp (targ-block-entry-fs block))
                             (cons 'seq
                                   (targ-repr-setup-need
                                    (targ-block-loc-descrs block))))
                           #\newline)))
                  ((memq (targ-block-kind block)
                         '(return-internal))
                   (targ-cell-set!
                     cell
                     (list 'append
                           "/* entry representation: "
                           (targ-repr-to-string
                             (targ-block-loc-descrs block)
                             targ-repr-need-reprs
                             targ-repr-live1?)
                           " */"
                           #\newline
;                           (targ-repr-internal-need block)
                           #\newline)))
                  (else
                   (targ-cell-set!
                     cell
                     (list 'append
                           "/* entry representation: "
                           (targ-repr-to-string
                             (targ-block-loc-descrs block)
                             targ-repr-need-reprs
                             targ-repr-live1?)
                           " */"
                           #\newline))))))
        (loop5 (- lbl 1)))))

;  (targ-emit (list 'append (with-output-to-string (lambda () (pp targ-repr-graph)))))

  (if targ-repr-enabled?
    (set! targ-repr-graph #f))

  #f)


(define (targ-repr-unboxed-copy src dst repr)
  (let ((type (vector-ref targ-repr-types (- repr 1))))
    (list (string-append "SET_" type) dst src)))

(define (targ-repr-unboxed-index-copy src dst repr)
  (targ-repr-unboxed-copy
    (targ-repr-unboxed-index->code src repr)
    (targ-repr-unboxed-index->code dst repr)
    repr))

(define (targ-repr-setup-need loc-descrs)
  (let ((lst '()))
    (stretchable-vector-for-each
      (lambda (descr i)
        (if (targ-repr-live1? descr)
          (let ((need (targ-repr-need-reprs descr)))
            (let ((loc (targ-repr-index->loc i)))
              (let loop ((r (+ targ-repr-boxed 1)))
                (if (< r targ-repr-nb-reprs)
                  (begin
                    (if (targ-repr-member? r need)
                      (set! lst
                        (cons (targ-repr-from-boxed! loc r) lst)))
                    (loop (+ r 1)))))))))
      loc-descrs)
    lst))

(define (targ-repr-internal-need block)
  (set! targ-proc-fp (targ-block-entry-fs block))
  (let ((lst '())
        (loc-descrs (targ-block-loc-descrs block)))
    (set! lst (cons #\newline (cons "END" (cons #\newline lst))))
    (stretchable-vector-for-each
      (lambda (descr i)
        (if (targ-repr-live1? descr)
          (let ((need (targ-repr-need-reprs descr)))
            (let ((loc (targ-repr-index->loc i)))
              (let loop ((r (+ targ-repr-boxed 1)))
                (if (< r targ-repr-nb-reprs)
                  (begin
                    (if (targ-repr-member? r need)
                      (set! lst
                        (cons (targ-repr-from-boxed! loc r) lst)))
                    (loop (+ r 1)))))))))
      loc-descrs)
    (set! lst (cons #\newline (cons "TRAP" (cons #\newline lst))))
    (stretchable-vector-for-each
      (lambda (descr i)
        (if (targ-repr-live1? descr)
          (let ((need (targ-repr-need-reprs descr)))
            (if (not (targ-repr-member? targ-repr-boxed need))
              (let loop2 ((r (+ targ-repr-boxed 1)))
                (if (not (targ-repr-member? r need))
                  (loop2 (+ r 1))
                  (set! lst
                    (cons (targ-repr-to-boxed! (targ-repr-index->loc i) r)
                          lst))))))))
      loc-descrs)
    (set! lst (cons #\newline (cons "BEGIN" (cons #\newline lst))))
    (cons 'seq lst)))

;************
(define (targ-repr-to-string loc-descrs reprs-extract live?)
  (let ((str ""))
    (stretchable-vector-for-each
      (lambda (descr i)
        (if (live? descr)
          (let ((loc (targ-repr-index->loc i))
                (reprs (reprs-extract descr)))
            (set! str
              (string-append
                str
                "  "
                (loc->str loc)
                "="
                (reprs->str reprs))))))
      loc-descrs)
    str))

(define (loc->str loc)
  (if (reg? loc)
    (string-append "R" (number->string (reg-num loc)))
    (string-append "STK" (number->string (stk-num loc)))))

(define (reprs->str reprs)
  (let ((str "{"))
    (let loop ((r targ-repr-boxed) (sep ""))
      (if (< r targ-repr-nb-reprs)
        (if (targ-repr-member? r reprs)
          (begin
            (set! str
              (string-append str
                             sep
                             (if (= r targ-repr-boxed)
                               "boxed"
                               (vector-ref targ-repr-types (- r 1)))))
            (loop (+ r 1) ","))
          (loop (+ r 1) sep))))
    (string-append str "}")))




(define (targ-repr-for-each-live proc frame)
  (let* ((live
          (frame-live frame))
         (any-closed-live?
          (varset-intersects?
            live
            (list->varset (frame-closed frame)))))

    (define (live? var)
      (or (varset-member? var live)
          (and (eq? var closure-env-var) any-closed-live?)))

    (let ((slots (frame-slots frame)))
      (let loop1 ((i (length slots)) (lst slots))
        (if (pair? lst)
          (begin
            (if (live? (car lst))
              (proc (targ-repr-loc->index (make-stk i))))
            (loop1 (- i 1) (cdr lst)))
          (let ((regs (frame-regs frame)))
            (let loop2 ((i 0) (lst regs))
              (if (pair? lst)
                (begin
                  (if (live? (car lst))
                    (proc (targ-repr-loc->index (make-reg i))))
                  (loop2 (+ i 1) (cdr lst)))))))))))

(define (targ-repr-begin-block! kind lbl)
(targ-fp-cache-init);************
  (if targ-repr-enabled?
    (let ((cell (targ-make-cell #f))
          (fs (frame-size targ-proc-exit-frame)))
      (targ-emit cell)
      (set! targ-repr-current-block
        (targ-make-block kind lbl cell))
      (stretchable-vector-set!
        targ-repr-graph
        lbl
        targ-repr-current-block)
      (targ-block-entry-fs-set!
        targ-repr-current-block
        fs)
      (let ((loc-descrs (targ-block-loc-descrs targ-repr-current-block)))
        (if (memq kind
                  '(entry return task-entry task-return))
          (let loop ((i (- (+ targ-nb-gvm-regs fs) 1)))
            (if (>= i 0)
              (let ((descr (stretchable-vector-ref loc-descrs i)))
                (stretchable-vector-set!
                  loc-descrs
                  i
                  (targ-repr-need-reprs-union
                    descr
                    (targ-repr-singleton targ-repr-boxed)))
                (loop (- i 1))))))
        (targ-repr-for-each-live
          (lambda (i)
            (stretchable-vector-set!
              loc-descrs
              i
              (targ-repr-live1-add
                (stretchable-vector-ref loc-descrs i))))
          targ-proc-exit-frame)))))

(define (targ-repr-exit-block! lbl)
  (if targ-repr-enabled?
    (let ((cell (targ-make-cell #f)))
      (targ-emit cell)
      (targ-block-add-exit!
        targ-repr-current-block
        lbl
        cell))))

(define (targ-repr-end-block!)
  (if targ-repr-enabled?
    (begin
      (targ-block-exit-fs-set!
        targ-repr-current-block
        (frame-size targ-proc-exit-frame))
      (let ((loc-descrs (targ-block-loc-descrs targ-repr-current-block)))
        (targ-repr-for-each-live
          (lambda (i)
            (stretchable-vector-set!
              loc-descrs
              i
              (targ-repr-live2-add
                (stretchable-vector-ref loc-descrs i))))
          targ-proc-exit-frame))
      (set! targ-repr-current-block #f))))

(define (targ-repr-loc->index loc)
  (cond ((reg? loc)
         (reg-num loc))
        ((stk? loc)
         (+ (- (stk-num loc) 1) targ-nb-gvm-regs))
        (else
         (compiler-internal-error
           "targ-repr-loc->index, invalid 'loc'" loc))))

(define (targ-repr-index->loc i)
  (if (< i targ-nb-gvm-regs)
    (make-reg i)
    (make-stk (+ (- i targ-nb-gvm-regs) 1))))

(define (targ-repr-unboxed-index->code i repr)
  (let ((type (vector-ref targ-repr-types (- repr 1))))
    (targ-need-unboxed i repr)
    (if (< i targ-nb-gvm-regs)
      (list (string-append
              type
              "R"
              (number->string i)))
      (list (string-append
              type
              "STK"
              (number->string (+ (- i targ-nb-gvm-regs) 1)))))))

(define (targ-repr-index->code i repr)
  (if (= repr targ-repr-boxed)
    (if (< i targ-nb-gvm-regs)
      (cons 'r i)
      (list "STK" (- (+ (- i targ-nb-gvm-regs) 1) targ-proc-fp)))
    (targ-repr-unboxed-index->code i repr)))

(define (targ-repr-unboxed-loc->code loc repr)
  (targ-repr-unboxed-index->code
    (targ-repr-loc->index loc)
    repr))

(define (targ-repr-to-boxed! loc repr)
  (targ-repr-loc-boxed
    loc
    (targ-repr-to-boxed
      (targ-repr-unboxed-loc->code loc repr)
      repr)))

(define (targ-repr-from-boxed! loc repr)
  (let ((type (vector-ref targ-repr-types (- repr 1))))
    (list (string-append "SET_" type)
          (targ-repr-unboxed-loc->code loc repr)
          (targ-repr-from-boxed
            (targ-repr-opnd-boxed loc)
            repr))))

(define (targ-repr-opnd opnd repr)
  (if targ-repr-enabled?

    (if (or (reg? opnd) (stk? opnd))
      (let* ((loc-descrs
              (targ-block-loc-descrs targ-repr-current-block))
             (i
              (targ-repr-loc->index opnd))
             (descr
              (stretchable-vector-ref loc-descrs i))
             (have
              (targ-repr-have-reprs descr)))
        (cond ((targ-repr-empty? have)
               (stretchable-vector-set! loc-descrs i
                 (targ-repr-need-reprs-union
                   descr
                   (targ-repr-singleton repr))))
              ((not (targ-repr-member? repr have))
               (let loop ((r targ-repr-boxed))
                 (if (not (targ-repr-member? r have))
                   (loop (+ r 1))
                   (if (not (= r targ-repr-boxed))
                     (targ-emit (targ-repr-to-boxed! opnd r)))))
               (if (not (= repr targ-repr-boxed))
                 (targ-emit (targ-repr-from-boxed! opnd repr)))
               (stretchable-vector-set! loc-descrs i
                 (targ-repr-have-reprs-union
                   (targ-repr-have-reprs-union
                     descr
                     (targ-repr-singleton repr))
                   targ-repr-boxed))))
        (targ-repr-index->code i repr))
      (if (and (= repr targ-repr-f64)
               (obj? opnd)
               (eq? (targ-obj-type (obj-val opnd)) 'subtyped)
               (eq? (targ-obj-subtype (obj-val opnd)) 'flonum)
               targ-use-c-fp-constants?
               (not (targ-unusual-float? (obj-val opnd))))
        (obj-val opnd)
        (targ-repr-from-boxed (targ-repr-opnd-boxed opnd) repr)))

    (targ-repr-from-boxed (targ-repr-opnd-boxed opnd) repr)))

(define (targ-repr-from-boxed code repr)
  (if (= repr targ-repr-boxed)
    code
    (list (string-append (vector-ref targ-repr-types (- repr 1)) "UNBOX")
          code)))

(define (targ-repr-to-boxed code repr)
  (if (= repr targ-repr-boxed)
    code
    (begin
      (targ-need-heap)
      (list (string-append (vector-ref targ-repr-types (- repr 1)) "BOX")
            code))))

(define (targ-repr-opnd-boxed opnd)

  (cond ((reg? opnd)
         (let ((n (reg-num opnd)))
           (targ-rd-reg n)
           (cons 'r n)))

        ((stk? opnd)
         (targ-rd-fp)
         (list "STK" (- (stk-num opnd) targ-proc-fp)))

        ((glo? opnd)
         (let ((name (glo-name opnd)))
           (list "GLO"
                 (targ-use-glo name #f)
                 (targ-c-id-glo (symbol->string name)))))

        ((clo? opnd)
         (list "CLO"
               (targ-opnd (clo-base opnd))
               (clo-index opnd)))

        ((lbl? opnd)
         (let ((n (lbl-num opnd)))
           (list "LBL" (targ-ref-lbl-val n))))

        ((obj? opnd)
         (targ-use-obj (obj-val opnd)))

        (else
         (compiler-internal-error
           "targ-repr-opnd-boxed, unknown 'opnd'" opnd))))

(define (targ-repr-loc loc val repr)
  (if targ-repr-enabled?

    (if (or (reg? loc) (stk? loc))
      (let* ((loc-descrs
              (targ-block-loc-descrs targ-repr-current-block))
             (i
              (targ-repr-loc->index loc))
             (descr
              (stretchable-vector-ref loc-descrs i))
             (x
              (if (= repr targ-repr-boxed)
                (targ-repr-loc-boxed loc val)
                (let ((type (vector-ref targ-repr-types (- repr 1))))
                  (list (string-append "SET_" type)
                        (targ-repr-unboxed-loc->code loc repr)
                        val)))))
        (stretchable-vector-set! loc-descrs i
          (targ-repr-have-reprs-set
            descr
            (targ-repr-singleton repr)))
        x)
      (targ-repr-loc-boxed loc (targ-repr-to-boxed val repr)))

    (targ-repr-loc-boxed loc (targ-repr-to-boxed val repr))))

(define (targ-repr-loc-boxed loc val)

  (cond ((reg? loc)
         (let ((n (reg-num loc)))
           (targ-wr-reg n)
           (list 'set-r n val)))

        ((stk? loc)
         (targ-rd-fp)
         (list "SET_STK" (- (stk-num loc) targ-proc-fp) val))

        ((glo? loc)
         (let ((name (glo-name loc)))
           (list "SET_GLO"
                 (targ-use-glo name #t)
                 (targ-c-id-glo (symbol->string name))
                 val)))

        ((clo? loc)
         (list "SET_CLO"
               (targ-opnd (clo-base loc))
               (clo-index loc)))

        (else
         (compiler-internal-error
           "targ-repr-loc-boxed, unknown 'loc'" loc))))

(define (targ-opnd opnd) ; fetch a GVM operand in boxed form
  (targ-repr-opnd opnd targ-repr-boxed))

(define (targ-opnd-flo opnd) ; fetch a GVM operand as an unboxed flonum
  (targ-repr-opnd opnd targ-repr-f64))

(define (targ-loc loc val) ; store boxed value in GVM location
  (targ-repr-loc loc val targ-repr-boxed))

(define (targ-loc-flo loc val) ; store unboxed flonum to GVM location
  (targ-repr-loc loc val targ-repr-f64))
)

;------------------------------------------------------------------------------

(define (targ-opnd opnd) ; fetch GVM operand

  (if (and targ-fp-cache-enabled? (or (reg? opnd) (stk? opnd)))
    (targ-fp-cache-write-if-dirty opnd))

  (cond ((reg? opnd)
         (let ((n (reg-num opnd)))
           (targ-rd-reg n)
           (cons 'r n)))

        ((stk? opnd)
         (targ-rd-fp)
         (list "STK" (- (stk-num opnd) targ-proc-fp)))

        ((glo? opnd)
         (let ((name (glo-name opnd)))
           (list "GLO"
                 (targ-use-glo name #f)
                 (targ-c-id-glo (symbol->string name)))))

        ((clo? opnd)
         (list "CLO"
               (targ-opnd (clo-base opnd))
               (clo-index opnd)))

        ((lbl? opnd)
         (let ((n (lbl-num opnd)))
           (list "LBL" (targ-ref-lbl-val n))))

        ((obj? opnd)
         (targ-use-obj (obj-val opnd)))

        (else
         (compiler-internal-error
           "targ-opnd, unknown 'opnd'" opnd))))

(define (targ-loc loc val) ; store GVM location
  (let ((x (targ-loc-no-invalidate loc val)))

    (if (and targ-fp-cache-enabled? (or (reg? loc) (stk? loc)))
      (targ-fp-cache-invalidate loc))

    x))

(define (targ-loc-no-invalidate loc val) ; store GVM location without
                                         ; invalidating flonum cache
  (cond ((reg? loc)
         (let ((n (reg-num loc)))
           (targ-wr-reg n)
           (list 'set-r n val)))

        ((stk? loc)
         (targ-rd-fp)
         (list "SET_STK" (- (stk-num loc) targ-proc-fp) val))

        ((glo? loc)
         (let ((name (glo-name loc)))
           (list "SET_GLO"
                 (targ-use-glo name #t)
                 (targ-c-id-glo (symbol->string name))
                 val)))

        ((clo? loc)
         (list "SET_CLO"
               (targ-opnd (clo-base loc))
               (clo-index loc)))

        (else
         (compiler-internal-error
           "targ-loc, unknown 'loc'" loc))))

(define (targ-opnd-flo opnd) ; fetch unboxed flonum GVM operand
  (cond ((and targ-fp-cache-enabled? (or (reg? opnd) (stk? opnd)))
         (let ((stamp1 (targ-fp-cache-probe opnd)))
           (if stamp1
             (targ-unboxed-loc->code opnd stamp1)
             (let* ((stamp2 (targ-fp-cache-enter opnd #f))
                    (code (targ-unboxed-loc->code opnd stamp2)))
               (targ-emit
                 (list "SET_F64" code (list "F64UNBOX" (targ-opnd opnd))))
               code))))
        ((and (obj? opnd)
              (eq? (targ-obj-type (obj-val opnd)) 'subtyped)
              (eq? (targ-obj-subtype (obj-val opnd)) 'flonum)
              targ-use-c-fp-constants?
              (not (targ-unusual-float? (obj-val opnd))))
         (obj-val opnd))
        (else
         (list "F64UNBOX" (targ-opnd opnd)))))

(define (targ-loc-flo loc val fs) ; store unboxed flonum to GVM location
  (if (and targ-fp-cache-enabled? (or (reg? loc) (stk? loc)))
    (begin
      (targ-fp-cache-invalidate loc)
      (let* ((stamp (targ-fp-cache-enter loc #t))
             (code (targ-unboxed-loc->code loc stamp)))
        (list "SET_F64" code val)))
    (begin
      (targ-heap-reserve-and-check targ-flonum-space fs)
      (targ-loc loc (list "F64BOX" val)))))

;------------------------------------------------------------------------------

(define (targ-adjust-stack fs)
  (if (= targ-proc-fp fs)
    #f
    (let ((fp targ-proc-fp))
      (set! targ-proc-fp fs)
      (targ-rd-fp)
      (targ-wr-fp)
      (list "ADJFP" (- fs fp)))))

(define (targ-sn-opnd opnd sn)
  (cond ((stk? opnd)
         (max (stk-num opnd) sn))
        ((clo? opnd)
         (targ-sn-opnd (clo-base opnd) sn))
        (else
         sn)))

(define (targ-sn-opnds opnds sn)
  (if (pair? opnds)
    (targ-sn-opnd (car opnds) (targ-sn-opnds (cdr opnds) sn))
    sn))

(define (targ-sn-loc loc sn)
  (if loc
    (targ-sn-opnd loc sn)
    sn))

;------------------------------------------------------------------------------

; Floating point number cache management.

(define targ-use-c-fp-constants? #f)
(set! targ-use-c-fp-constants? #t)

(define targ-fp-cache-enabled? #f)
(set! targ-fp-cache-enabled? #t)

(define (targ-fp-cache-init)
  (set! targ-fp-cache (vector 0 '#() 0)))

(define (targ-fp-cache-size)
  (vector-ref targ-fp-cache 0))

(define (targ-fp-cache-write loc stamp)
  (targ-heap-reserve targ-flonum-space)
  (targ-emit
    (targ-loc-no-invalidate
      loc
      (list "F64BOX" (targ-unboxed-loc->code loc stamp)))))

(define (targ-fp-cache-write-if-dirty loc)
  (let ((v (vector-ref targ-fp-cache 1)))
    (let ((n (vector-length v)))
      (let loop ((i 0))
        (if (< i n)
          (let ((x (vector-ref v i)))
            (if (and x (vector-ref x 1) (eqv? (vector-ref x 0) loc))
              (begin
                (targ-fp-cache-write loc (vector-ref x 2))
                (vector-set! x 1 #f))
              (loop (+ i 1)))))))))

(define (targ-fp-cache-enter opnd dirty?) ; allocate new entry for opnd
  (let* ((v1
          (vector-ref targ-fp-cache 1))
         (stamp
          (let ((n (+ (vector-ref targ-fp-cache 2) 1)))
            (vector-set! targ-fp-cache 2 n)
            n))
         (entry
          (vector opnd dirty? stamp)))
    (let ((n (vector-length v1)))
      (let loop1 ((i 0))
        (if (< i n)
          (if (vector-ref v1 i)
            (loop1 (+ i 1))
            (vector-set! v1 i entry))
          (let ((v2 (make-vector (+ (* n 2) 1) #f)))
            (let loop2 ((i 0))
              (if (< i n)
                (begin
                  (vector-set! v2 i (vector-ref v1 i))
                  (loop2 (+ i 1)))))
            (vector-set! v2 n entry)
            (vector-set! targ-fp-cache 0 (+ n 1))
            (vector-set! targ-fp-cache 1 v2)))))
    stamp))

(define (targ-fp-cache-probe opnd) ; opnd must be a reg or stack slot
  (let ((v (vector-ref targ-fp-cache 1)))
    (let ((n (vector-length v)))
      (let loop ((i 0))
        (if (< i n)
          (let ((x (vector-ref v i)))
            (if (and x (eqv? (vector-ref x 0) opnd))
              (vector-ref x 2)
              (loop (+ i 1))))
          #f)))))

(define (targ-fp-cache-invalidate opnd) ; opnd must be a reg or stack slot
  (let ((v (vector-ref targ-fp-cache 1)))
    (let ((n (vector-length v)))
      (let loop ((i 0))
        (if (< i n)
          (let ((x (vector-ref v i)))
            (if (and x (eqv? (vector-ref x 0) opnd))
              (vector-set! v i #f))
            (loop (+ i 1))))))))

;==============================================================================

; DATABASE OF PRIMITIVES

(for-each targ-prim-proc-add!
          '(
            ("##c-code"  0            #t 0        0 (#f)   extended)
           ))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; Procedure specialization

(define (targ-spec name specializer-maker)
  (let ((proc-name (string->canonical-symbol name)))
    (let ((proc (targ-get-prim-info name)))
      (proc-obj-specialize-set! proc (specializer-maker proc proc-name)))))

; Safe specialization

(define (targ-s name)
  (lambda (proc proc-name)
    (let ((spec (targ-get-prim-info name)))
      (lambda (env args) spec))))

; Unsafe specialization

(define (targ-u name)
  (lambda (proc proc-name)
    (let ((spec (targ-get-prim-info name)))
      (lambda (env args) (if (not (safe? env)) spec proc)))))

; Safe arithmetic specialization

(define (targ-s-a fix-name flo-name)
  (targ-arith #t fix-name flo-name))

; Unsafe arithmetic specialization

(define (targ-u-a fix-name flo-name)
  (targ-arith #f fix-name flo-name))

(define (targ-arith fix-safe? fix-name flo-name)
  (lambda (proc proc-name)
    (let ((fix-spec (if fix-name (targ-get-prim-info fix-name) proc))
          (flo-spec (if flo-name (targ-get-prim-info flo-name) proc)))
      (lambda (env args)
        (let ((arith (arith-implementation proc-name env)))
          (cond ((eq? arith fixnum-sym)
                 (if (or fix-safe? (not (safe? env))) fix-spec proc))
                ((eq? arith flonum-sym)
                 (if (not (safe? env)) flo-spec proc))
                (else
                 proc)))))))

; Safe specialization for eqv? and ##eqv?

(define (targ-s-eqv?)
  (lambda (proc proc-name)
    (let ((spec (targ-get-prim-info "##eq?")))
      (lambda (env args)
        (if (and (= (length args) 2)
                 (or (eq? (arith-implementation proc-name env) fixnum-sym)
                     (targ-eq-testable-object? (car args))
                     (targ-eq-testable-object? (cadr args))))
          spec
          proc)))))

; Safe specialization for equal? and ##equal?

(define (targ-s-equal?)
  (lambda (proc proc-name)
    (let ((spec (targ-get-prim-info "##eq?")))
      (lambda (env args)
        (if (and (= (length args) 2)
                 (or (targ-eq-testable-object? (car args))
                     (targ-eq-testable-object? (cadr args))))
          spec
          proc)))))

(define (targ-eq-testable-object? obj)
  (and (not (void-object? obj)) ; the void-object denotes a non-constant
       (or (symbol-object? obj)
           (keyword-object? obj)
           (memq (targ-obj-type obj)
                 '(boolean null absent unused deleted void eof optional rest
                   key fixnum32 char)))))


;------------------------------------------------------------------------------

(define (targ-op name descr)
  (descr (targ-get-prim-info name)))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-apply-alloc compute-space side-effects? flo-result? f)
  (targ-setup-inlinable-proc
    side-effects?
    flo-result?
    (lambda (opnds sn)
      (targ-heap-reserve-and-check
        (compute-space (length opnds))
        (targ-sn-opnds opnds sn))
      (f opnds sn))))

(define (targ-apply-cons)
  (targ-apply-alloc
    (lambda (n) targ-pair-space)
    #f
    #f
    (targ-apply-simp-generator #f "CONS")))

(define (targ-apply-list)
  (targ-apply-alloc
    (lambda (n) (* n targ-pair-space))
    #f
    #f
    (lambda (opnds sn)
      (cond ((null? opnds)
             '("NUL"))
            ((null? (cdr opnds))
             (list "CONS" (targ-opnd (car opnds)) '("NUL")))
            (else
             (let* ((rev-elements (reverse (map targ-opnd opnds)))
                    (n (length rev-elements)))
               (targ-emit
                 (list "BEGIN_ALLOC_LIST" n (car rev-elements)))
               (for-each-index (lambda (elem i)
                                 (targ-emit
                                   (list "ADD_LIST_ELEM" (+ i 1) elem)))
                               (cdr rev-elements))
               (targ-emit
                 (list "END_ALLOC_LIST" n))
               (list "GET_LIST" n)))))))

(define (targ-apply-box)
  (targ-apply-alloc
    (lambda (n) targ-box-space)
    #f
    #f
    (targ-apply-simp-generator #f "BOX")))

(define (targ-apply-make-will)
  (targ-apply-alloc
    (lambda (n) targ-will-space)
    'expr ; this is an expression with side-effects
    #f
    (lambda (opnds sn)
      (targ-apply-simp-gen opnds #f "MAKEWILL"))))

(define (targ-apply-make-promise)
  (targ-apply-alloc
    (lambda (n) targ-promise-space)
    #f
    #f
    (targ-apply-simp-generator #f "MAKEPROMISE")))

(define (targ-apply-vector kind)
  (targ-setup-inlinable-proc
    #f
    #f
    (lambda (opnds sn)
      (let ((n (length opnds)))
        (if (and (eq? kind 'values) (= n 1))

          (targ-opnd (car opnds))

          (let ()

            (define (compute-space n)
              (case kind
                ((string)    (targ-string-space n))
                ((s8vector)  (targ-s8vector-space n))
                ((u8vector)  (targ-s8vector-space n))
                ((s16vector) (targ-s8vector-space (* n 2)))
                ((u16vector) (targ-s8vector-space (* n 2)))
                ((s32vector) (targ-s8vector-space (* n 4)))
                ((u32vector) (targ-s8vector-space (* n 4)))
                ((s64vector) (targ-s8vector-space (* n 8)))
                ((u64vector) (targ-s8vector-space (* n 8)))
                ((f32vector) (targ-s8vector-space (* n 4)))
                ((f64vector) (targ-s8vector-space (* n 8)))
                ((values)    (targ-vector-space n))
                ((structure) (targ-vector-space n))
                (else        (targ-vector-space n))))

            (define begin-allocator-name
              (case kind
                ((string)    "BEGIN_ALLOC_STRING")
                ((s8vector)  "BEGIN_ALLOC_S8VECTOR")
                ((u8vector)  "BEGIN_ALLOC_U8VECTOR")
                ((s16vector) "BEGIN_ALLOC_S16VECTOR")
                ((u16vector) "BEGIN_ALLOC_U16VECTOR")
                ((s32vector) "BEGIN_ALLOC_S32VECTOR")
                ((u32vector) "BEGIN_ALLOC_U32VECTOR")
                ((s64vector) "BEGIN_ALLOC_S64VECTOR")
                ((u64vector) "BEGIN_ALLOC_U64VECTOR")
                ((f32vector) "BEGIN_ALLOC_F32VECTOR")
                ((f64vector) "BEGIN_ALLOC_F64VECTOR")
                ((values)    "BEGIN_ALLOC_VALUES")
                ((structure) "BEGIN_ALLOC_STRUCTURE")
                (else        "BEGIN_ALLOC_VECTOR")))

            (define end-allocator-name
              (case kind
                ((string)    "END_ALLOC_STRING")
                ((s8vector)  "END_ALLOC_S8VECTOR")
                ((u8vector)  "END_ALLOC_U8VECTOR")
                ((s16vector) "END_ALLOC_S16VECTOR")
                ((u16vector) "END_ALLOC_U16VECTOR")
                ((s32vector) "END_ALLOC_S32VECTOR")
                ((u32vector) "END_ALLOC_U32VECTOR")
                ((s64vector) "END_ALLOC_S64VECTOR")
                ((u64vector) "END_ALLOC_U64VECTOR")
                ((f32vector) "END_ALLOC_F32VECTOR")
                ((f64vector) "END_ALLOC_F64VECTOR")
                ((values)    "END_ALLOC_VALUES")
                ((structure) "END_ALLOC_STRUCTURE")
                (else        "END_ALLOC_VECTOR")))

            (define add-element
              (case kind
                ((string)    "ADD_STRING_ELEM")
                ((s8vector)  "ADD_S8VECTOR_ELEM")
                ((u8vector)  "ADD_U8VECTOR_ELEM")
                ((s16vector) "ADD_S16VECTOR_ELEM")
                ((u16vector) "ADD_U16VECTOR_ELEM")
                ((s32vector) "ADD_S32VECTOR_ELEM")
                ((u32vector) "ADD_U32VECTOR_ELEM")
                ((s64vector) "ADD_S64VECTOR_ELEM")
                ((u64vector) "ADD_U64VECTOR_ELEM")
                ((f32vector) "ADD_F32VECTOR_ELEM")
                ((f64vector) "ADD_F64VECTOR_ELEM")
                ((values)    "ADD_VALUES_ELEM")
                ((structure) "ADD_STRUCTURE_ELEM")
                (else        "ADD_VECTOR_ELEM")))

            (define getter-operation
              (case kind
                ((string)    "GET_STRING")
                ((s8vector)  "GET_S8VECTOR")
                ((u8vector)  "GET_U8VECTOR")
                ((s16vector) "GET_S16VECTOR")
                ((u16vector) "GET_U16VECTOR")
                ((s32vector) "GET_S32VECTOR")
                ((u32vector) "GET_U32VECTOR")
                ((s64vector) "GET_S64VECTOR")
                ((u64vector) "GET_U64VECTOR")
                ((f32vector) "GET_F32VECTOR")
                ((f64vector) "GET_F64VECTOR")
                ((values)    "GET_VALUES")
                ((structure) "GET_STRUCTURE")
                (else        "GET_VECTOR")))

            (targ-heap-reserve-and-check
              (compute-space n)
              (targ-sn-opnds opnds sn))

            (let* ((flo? (or (eq? kind 'f32vector) (eq? kind 'f64vector)))
                   (elements (map (if flo? targ-opnd-flo targ-opnd) opnds)))
              (targ-emit
                (list begin-allocator-name n))
              (for-each-index (lambda (elem i)
                                (targ-emit
                                  (list add-element i elem)))
                              elements)
              (targ-emit
                (list end-allocator-name n))
              (list getter-operation n))))))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-apply-force)
  (lambda (prim)
    (proc-obj-inlinable-set!
      prim
      (lambda (opnds loc sn)
        (let ((lbl (targ-new-lbl))
              (opnd (car opnds))
              (sn* (targ-sn-loc loc sn)))

          (targ-update-fr targ-proc-entry-frame)
          (targ-emit (targ-adjust-stack sn*))
          (targ-emit (list "FORCE1"
                           (targ-ref-lbl-val lbl)
                           (targ-opnd opnd)))
;;          (targ-repr-exit-block! lbl)
;;          (targ-repr-end-block!)
          (targ-gen-label-return* lbl 'return-internal)
          (targ-emit (list "FORCE2"))
          (if loc
            (targ-emit (targ-loc loc (list "FORCE3")))))))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-apply-first-argument)
  (targ-setup-inlinable-proc*
    (lambda (opnds sn)
      (targ-opnd (car opnds)))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-apply-check-heap-limit)
  (lambda (prim)
    (proc-obj-inlinable-set!
      prim
      (lambda (opnds loc sn)
        (if (> targ-proc-hp 0)
          (targ-update-fr-and-check-heap 0 sn))
        (if loc
          (targ-emit
            (targ-loc loc (targ-opnd (make-obj false-object)))))))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-ifjump-simp flo? name)
  (targ-setup-test-proc*
    flo?
    (targ-ifjump-simp-generator flo? name)))

(define (targ-ifjump-fold flo? name)
  (targ-setup-test-proc*
    flo?
    (targ-ifjump-fold-generator flo? name)))

(define (targ-ifjump-fold-check name1 name2 fold-name)
  (targ-setup-test-proc*
    #f
    (targ-ifjump-fold-check-generator name1 name2 fold-name)))

(define (targ-ifjump-apply name)
  (targ-setup-inlinable-proc*
    (targ-apply-simp-generator #f name)))

(define (targ-apply-simp flo? side-effects? name); prim. with non-flonum result
  (targ-setup-inlinable-proc
    side-effects?
    #f
    (targ-apply-simp-generator flo? name)))

(define (targ-apply-fold flo? name0 name1 name2)
  (let ((generator (targ-apply-fold-generator flo? name0 name1 name2)))
    (if flo?
      (targ-apply-alloc
        (lambda (n) 0) ; targ-apply-alloc accounts for space for flonum result
        #f
        #t
        generator)
      (targ-setup-inlinable-proc
        #f
        #f
        generator))))

(define (targ-apply-simpflo flo? name) ; prim. with flonum result
  (targ-apply-alloc
    (lambda (n) 0) ; targ-apply-alloc accounts for space for flonum result
    #f
    #t
    (targ-apply-simp-generator flo? name)))

(define (targ-apply-simpflo2 flo? name1 name2) ; 1 or 2 arg prim. with flonum result
  (targ-apply-alloc
    (lambda (n) 0) ; targ-apply-alloc accounts for space for flonum result
    #f
    #t
    (lambda (opnds sn)
      (if (= (length opnds) 1)
        (targ-apply-simp-gen opnds flo? name1)
        (targ-apply-simp-gen opnds flo? name2)))))

(define (targ-apply-simpflo3 name); 3 arg prim. whose last arg is a flonum
  (targ-setup-inlinable-proc
    #t
    #f
    (lambda (opnds sn)
      (let* ((arg1 (targ-opnd (car opnds)))
             (arg2 (targ-opnd (cadr opnds)))
             (arg3 (targ-opnd-flo (caddr opnds))))
        (list name arg1 arg2 arg3)))))

(define (targ-apply-simpbig name) ; prim. with 32 or 64 bit bignum result
  (targ-apply-alloc
    (lambda (n) (targ-s8vector-space (* (quotient targ-max-adigit-width 8) 3))) ; space for 2^64-1 including 64 bit alignment  ;;;;;;;;;;ugly code!
    #f
    #f
    (lambda (opnds sn)
      (targ-apply-simp-gen opnds #f name))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-setup-test-proc* args-flo? generator)
  (lambda (prim)
    ((targ-setup-test-proc args-flo? generator)
     prim)
    ((targ-setup-inlinable-proc
       #f
       #f
       (lambda (opnds sn)
         (list "BOOLEAN" (generator opnds sn))))
     prim)))

(define (targ-setup-test-proc args-flo? generator)
  (lambda (prim)
    (proc-obj-test-set!
      prim
      (vector
        args-flo?
        (lambda (not? opnds fs)
          (let ((test (generator opnds fs)))
            (if not?
              (list "NOT" test)
              test)))))))

(define (targ-ifjump-simp-generator flo? name)
  (lambda (opnds fs)
    (targ-ifjump-simp-gen opnds flo? name)))

(define (targ-ifjump-simp-gen opnds flo? name)
  (let loop ((l opnds) (args '()))
    (if (pair? l)
      (let ((opnd (car l)))
        (loop (cdr l)
              (cons (if flo? (targ-opnd-flo opnd) (targ-opnd opnd))
                    args)))
      (cons name (reverse args)))))

(define (targ-ifjump-fold-generator flo? name)
  (lambda (opnds fs)
    (targ-ifjump-fold-gen opnds flo? name)))

(define (targ-ifjump-fold-gen opnds flo? name)

  (define (multi-opnds opnds)
    (let* ((opnd1 (car opnds))
           (opnd2 (cadr opnds))
           (opnd1* (if flo? (targ-opnd-flo opnd1) (targ-opnd opnd1)))
           (opnd2* (if flo? (targ-opnd-flo opnd2) (targ-opnd opnd2)))
           (r (list name opnd1* opnd2*)))
      (if (pair? (cddr opnds))
        (list "AND" r (multi-opnds (cdr opnds)))
        r)))

  (cond ((or (not (pair? opnds))
             (not (pair? (cdr opnds))))
         1)
        (else
         (multi-opnds opnds))))

(define (targ-ifjump-fold-check-generator name1 name2 fold-name)
  (lambda (opnds fs)
    (targ-ifjump-fold-check-gen opnds name1 name2 fold-name)))

(define (targ-ifjump-fold-check-gen opnds name1 name2 fold-name)

  (define (multi-opnds accum opnds)
    (let* ((opnd2 (targ-opnd (car opnds)))
           (r (list name2 accum opnd2)))
      (if (pair? (cdr opnds))
        (list "AND" r (multi-opnds (list fold-name accum opnd2) (cdr opnds)))
        r)))

  (if (not (pair? opnds))
    1
    (let ((opnd1 (targ-opnd (car opnds))))
      (if (not (pair? (cdr opnds)))
        (if name1
          (list name1 opnd1)
          1)
        (multi-opnds opnd1 (cdr opnds))))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (targ-setup-inlinable-proc* generator)
  (lambda (prim)
    ((targ-setup-test-proc
       #f ; safe to assume that arguments are not all flonums
       (lambda (opnds fs)
         (list "NOT" (list "FALSEP" (generator opnds fs)))))
     prim)
    ((targ-setup-inlinable-proc #f #f generator)
     prim)))

(define (targ-setup-inlinable-proc side-effects? flo-result? generator)
  (lambda (prim)
    (proc-obj-inlinable-set!
      prim
      (lambda (opnds loc sn)
        (if loc ; result is needed?
          (if (eq? side-effects? #t) ; generator generates a statement?
            (let ((x (generator opnds sn)))
              (targ-emit
                (if (eqv? (car opnds) loc)
                  x
                  (list 'seq x (targ-loc loc (targ-opnd (car opnds)))))))
            (let ((sn* (targ-sn-loc loc sn)))
              (let ((x (generator opnds sn*)))
                (targ-emit
                  (if flo-result?
                    (targ-loc-flo loc x sn*)
                    (targ-loc loc x))))))
          (if side-effects? ; only generate code for side-effect
            (let ((x (generator opnds sn)))
              (targ-emit
                (if (eq? side-effects? 'expr) (list "EXPR" x) x)))))))))

(define (targ-apply-simp-generator flo? name)
  (lambda (opnds sn)
    (targ-apply-simp-gen opnds flo? name)))

(define (targ-apply-simp-gen opnds flo? name)
  (let loop ((l opnds) (args '()))
    (if (pair? l)
      (let ((opnd (car l)))
        (loop (cdr l)
              (cons (if flo? (targ-opnd-flo opnd) (targ-opnd opnd))
                    args)))
      (cons name (reverse args)))))

(define (targ-apply-fold-generator flo? name0 name1 name2)
  (lambda (opnds sn)
    (targ-apply-fold-gen opnds flo? name0 name1 name2)))

(define (targ-apply-fold-gen opnds flo? name0 name1 name2)
  (if (not (pair? opnds))
    name0
    (let* ((o (car opnds))
           (r (if flo? (targ-opnd-flo o) (targ-opnd o))))
      (if (not (pair? (cdr opnds)))
        (list name1 r)
        (let loop ((l (cdr opnds)) (r r))
          (if (pair? l)
            (let ((opnd (car l)))
              (loop (cdr l)
                    (list name2
                          r
                          (if flo? (targ-opnd-flo opnd) (targ-opnd opnd)))))
            r))))))

;------------------------------------------------------------------------------

(define (targ-jump-inline name jump-inliner)
  (let ((prim (targ-get-prim-info name)))
    (proc-obj-jump-inlinable-set! prim jump-inliner)))

(define (targ-emit-jump-inline name safe? nb-args)
  (let* ((pc (targ-jump-info nb-args))
         (fs (pcontext-fs pc)))
    (for-each (lambda (x)
                (let ((opnd (cdr x)))
                  (targ-opnd
                   (if (stk? opnd)
                     (make-stk (+ targ-proc-fp (- (stk-num opnd) fs)))
                     opnd))))
              (cdr (pcontext-map pc)))
    (targ-emit
     (list (string-append "JUMP_" name (number->string nb-args))
           (list (if safe? "JUMPSAFE" "JUMPNOTSAFE"))))))

;------------------------------------------------------------------------------

; Table of inlinable operations (for 'apply' and 'ifjump' GVM instructions)

(define (targ-setup-inlinable)

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##type"             (targ-apply-simp #f #f "TYPE"))
(targ-op "##type-cast"        (targ-apply-simp #f #f "TYPECAST"))
(targ-op "##subtype"          (targ-apply-simp #f #f "SUBTYPE"))
(targ-op "##subtype-set!"     (targ-apply-simp #f #t "SUBTYPESET"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##not"              (targ-ifjump-simp #f "FALSEP"))
(targ-op "##null?"            (targ-ifjump-simp #f "NULLP"))
(targ-op "##unbound?"         (targ-ifjump-simp #f "UNBOUNDP"))
(targ-op "##eq?"              (targ-ifjump-simp #f "EQP"))
(targ-op "##eof-object?"      (targ-ifjump-simp #f "EOFP"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##fixnum?"          (targ-ifjump-simp #f "FIXNUMP"))
(targ-op "##special?"         (targ-ifjump-simp #f "SPECIALP"))
(targ-op "##pair?"            (targ-ifjump-simp #f "PAIRP"))
(targ-op "##subtyped?"        (targ-ifjump-simp #f "SUBTYPEDP"))
(targ-op "##subtyped.vector?" (targ-ifjump-simp #f "SUBTYPEDVECTORP"))
(targ-op "##subtyped.symbol?" (targ-ifjump-simp #f "SUBTYPEDSYMBOLP"))
(targ-op "##subtyped.flonum?" (targ-ifjump-simp #f "SUBTYPEDFLONUMP"))
(targ-op "##subtyped.bignum?" (targ-ifjump-simp #f "SUBTYPEDBIGNUMP"))
(targ-op "##vector?"          (targ-ifjump-simp #f "VECTORP"))
(targ-op "##ratnum?"          (targ-ifjump-simp #f "RATNUMP"))
(targ-op "##cpxnum?"          (targ-ifjump-simp #f "CPXNUMP"))
(targ-op "##structure?"       (targ-ifjump-simp #f "STRUCTUREP"))
(targ-op "##box?"             (targ-ifjump-simp #f "BOXP"))
(targ-op "##values?"          (targ-ifjump-simp #f "VALUESP"))
(targ-op "##meroon?"          (targ-ifjump-simp #f "MEROONP"))
(targ-op "##symbol?"          (targ-ifjump-simp #f "SYMBOLP"))
(targ-op "##keyword?"         (targ-ifjump-simp #f "KEYWORDP"))
(targ-op "##frame?"           (targ-ifjump-simp #f "FRAMEP"))
(targ-op "##continuation?"    (targ-ifjump-simp #f "CONTINUATIONP"))
(targ-op "##promise?"         (targ-ifjump-simp #f "PROMISEP"))
(targ-op "##will?"            (targ-ifjump-simp #f "WILLP"))
(targ-op "##gc-hash-table?"   (targ-ifjump-simp #f "GCHASHTABLEP"))
(targ-op "##mem-allocated?"   (targ-ifjump-simp #f "MEMALLOCATEDP"))
(targ-op "##procedure?"       (targ-ifjump-simp #f "PROCEDUREP"))
(targ-op "##return?"          (targ-ifjump-simp #f "RETURNP"))
(targ-op "##foreign?"         (targ-ifjump-simp #f "FOREIGNP"))
(targ-op "##string?"          (targ-ifjump-simp #f "STRINGP"))
(targ-op "##s8vector?"        (targ-ifjump-simp #f "S8VECTORP"))
(targ-op "##u8vector?"        (targ-ifjump-simp #f "U8VECTORP"))
(targ-op "##s16vector?"       (targ-ifjump-simp #f "S16VECTORP"))
(targ-op "##u16vector?"       (targ-ifjump-simp #f "U16VECTORP"))
(targ-op "##s32vector?"       (targ-ifjump-simp #f "S32VECTORP"))
(targ-op "##u32vector?"       (targ-ifjump-simp #f "U32VECTORP"))
(targ-op "##s64vector?"       (targ-ifjump-simp #f "S64VECTORP"))
(targ-op "##u64vector?"       (targ-ifjump-simp #f "U64VECTORP"))
(targ-op "##f32vector?"       (targ-ifjump-simp #f "F32VECTORP"))
(targ-op "##f64vector?"       (targ-ifjump-simp #f "F64VECTORP"))
(targ-op "##flonum?"          (targ-ifjump-simp #f "FLONUMP"))
(targ-op "##bignum?"          (targ-ifjump-simp #f "BIGNUMP"))
(targ-op "##char?"            (targ-ifjump-simp #f "CHARP"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##fixnum.max"       (targ-apply-fold #f #f       "FIXPOS" "FIXMAX"))
(targ-op "##fixnum.min"       (targ-apply-fold #f #f       "FIXPOS" "FIXMIN"))

(targ-op "##fixnum.+"         (targ-apply-fold #f "FIX_0"  "FIXPOS" "FIXADD"))
(targ-op "##fixnum.+?"        (targ-apply-fold #f "FIX_0"  #f       "FIXADDP"))
(targ-op "##fixnum.*"         (targ-apply-fold #f "FIX_1"  "FIXPOS" "FIXMUL"))
(targ-op "##fixnum.*?"        (targ-apply-fold #f "FIX_1"  #f       "FIXMULP"))
(targ-op "##fixnum.-"         (targ-apply-fold #f #f       "FIXNEG" "FIXSUB"))
(targ-op "##fixnum.-?"        (targ-apply-fold #f #f       "FIXNEGP""FIXSUBP"))
(targ-op "##fixnum.quotient"  (targ-apply-fold #f #f       #f       "FIXQUO"))
(targ-op "##fixnum.remainder" (targ-apply-fold #f #f       #f       "FIXREM"))
(targ-op "##fixnum.modulo"    (targ-apply-fold #f #f       #f       "FIXMOD"))
(targ-op "##fixnum.bitwise-ior"(targ-apply-fold #f "FIX_0"  "FIXPOS""FIXIOR"))
(targ-op "##fixnum.bitwise-xor"(targ-apply-fold #f "FIX_0"  "FIXPOS""FIXXOR"))
(targ-op "##fixnum.bitwise-and"(targ-apply-fold #f "FIX_M1" "FIXPOS""FIXAND"))
(targ-op "##fixnum.bitwise-not"(targ-apply-simp #f #f "FIXNOT"))
(targ-op "##fixnum.arithmetic-shift"      (targ-apply-simp #f #f "FIXASH"))
(targ-op "##fixnum.arithmetic-shift-left" (targ-apply-simp #f #f "FIXASHL"))
(targ-op "##fixnum.arithmetic-shift-right"(targ-apply-simp #f #f "FIXASHR"))
(targ-op "##fixnum.logical-shift-right"   (targ-apply-simp #f #f "FIXLSHR"))

(targ-op "##fixnum.zero?"     (targ-ifjump-simp #f "FIXZEROP"))
(targ-op "##fixnum.positive?" (targ-ifjump-simp #f "FIXPOSITIVEP"))
(targ-op "##fixnum.negative?" (targ-ifjump-simp #f "FIXNEGATIVEP"))
(targ-op "##fixnum.odd?"      (targ-ifjump-simp #f "FIXODDP"))
(targ-op "##fixnum.even?"     (targ-ifjump-simp #f "FIXEVENP"))
(targ-op "##fixnum.="         (targ-ifjump-fold #f "FIXEQ"))
(targ-op "##fixnum.<"         (targ-ifjump-fold #f "FIXLT"))
(targ-op "##fixnum.>"         (targ-ifjump-fold #f "FIXGT"))
(targ-op "##fixnum.<="        (targ-ifjump-fold #f "FIXLE"))
(targ-op "##fixnum.>="        (targ-ifjump-fold #f "FIXGE"))

(targ-op "##fixnum.->char"    (targ-apply-simp #f #f "FIXTOCHR"))
(targ-op "##fixnum.<-char"    (targ-apply-simp #f #f "FIXFROMCHR"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##flonum.->fixnum"  (targ-apply-simp #t #f "F64TOFIX"))
(targ-op "##flonum.<-fixnum"  (targ-apply-simpflo #f "F64FROMFIX"))

(targ-op "##flonum.max"       (targ-apply-fold #t #f      "F64POS" "F64MAX"))
(targ-op "##flonum.min"       (targ-apply-fold #t #f      "F64POS" "F64MIN"))

(targ-op "##flonum.+"         (targ-apply-fold #t "F64_0" "F64POS" "F64ADD"))
(targ-op "##flonum.*"         (targ-apply-fold #t "F64_1" "F64POS" "F64MUL"))
(targ-op "##flonum.-"         (targ-apply-fold #t #f      "F64NEG" "F64SUB"))
(targ-op "##flonum./"         (targ-apply-fold #t #f      "F64INV" "F64DIV"))
(targ-op "##flonum.abs"       (targ-apply-simpflo #t "F64ABS"))
(targ-op "##flonum.floor"     (targ-apply-simpflo #t "F64FLOOR"))
(targ-op "##flonum.ceiling"   (targ-apply-simpflo #t "F64CEILING"))
(targ-op "##flonum.round"     (targ-apply-simpflo #t "F64ROUND"))
(targ-op "##flonum.exp"       (targ-apply-simpflo #t "F64EXP"))
(targ-op "##flonum.log"       (targ-apply-simpflo #t "F64LOG"))
(targ-op "##flonum.sin"       (targ-apply-simpflo #t "F64SIN"))
(targ-op "##flonum.cos"       (targ-apply-simpflo #t "F64COS"))
(targ-op "##flonum.tan"       (targ-apply-simpflo #t "F64TAN"))
(targ-op "##flonum.asin"      (targ-apply-simpflo #t "F64ASIN"))
(targ-op "##flonum.acos"      (targ-apply-simpflo #t "F64ACOS"))
(targ-op "##flonum.atan"      (targ-apply-simpflo2 #t "F64ATAN" "F64ATAN2"))
(targ-op "##flonum.sqrt"      (targ-apply-simpflo #t "F64SQRT"))
(targ-op "##flonum.copysign"  (targ-apply-simpflo #t "F64COPYSIGN"))

(targ-op "##flonum.zero?"     (targ-ifjump-simp #t "F64ZEROP"))
(targ-op "##flonum.negative?" (targ-ifjump-simp #t "F64NEGATIVEP"))
(targ-op "##flonum.positive?" (targ-ifjump-simp #t "F64POSITIVEP"))
(targ-op "##flonum.finite?"   (targ-ifjump-simp #t "F64FINITEP"))
(targ-op "##flonum.nan?"      (targ-ifjump-simp #t "F64NANP"))
(targ-op "##flonum.<-fixnum-exact?" (targ-ifjump-simp #f "F64FROMFIXEXACTP"))
(targ-op "##flonum.="         (targ-ifjump-fold #t "F64EQ"))
(targ-op "##flonum.<"         (targ-ifjump-fold #t "F64LT"))
(targ-op "##flonum.>"         (targ-ifjump-fold #t "F64GT"))
(targ-op "##flonum.<="        (targ-ifjump-fold #t "F64LE"))
(targ-op "##flonum.>="        (targ-ifjump-fold #t "F64GE"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##char=?"           (targ-ifjump-fold #f "CHAREQP"))
(targ-op "##char<?"           (targ-ifjump-fold #f "CHARLTP"))
(targ-op "##char>?"           (targ-ifjump-fold #f "CHARGTP"))
(targ-op "##char<=?"          (targ-ifjump-fold #f "CHARLEP"))
(targ-op "##char>=?"          (targ-ifjump-fold #f "CHARGEP"))

(targ-op "##char-alphabetic?" (targ-ifjump-simp #f "CHARALPHABETICP"))
(targ-op "##char-numeric?"    (targ-ifjump-simp #f "CHARNUMERICP"))
(targ-op "##char-whitespace?" (targ-ifjump-simp #f "CHARWHITESPACEP"))
(targ-op "##char-upper-case?" (targ-ifjump-simp #f "CHARUPPERCASEP"))
(targ-op "##char-lower-case?" (targ-ifjump-simp #f "CHARLOWERCASEP"))
(targ-op "##char-upcase"      (targ-apply-simp #f #f "CHARUPCASE"))
(targ-op "##char-downcase"    (targ-apply-simp #f #f "CHARDOWNCASE"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##cons"             (targ-apply-cons))
(targ-op "##set-car!"         (targ-apply-simp #f #t "SETCAR"))
(targ-op "##set-cdr!"         (targ-apply-simp #f #t "SETCDR"))
(targ-op "##car"              (targ-ifjump-apply "CAR"))
(targ-op "##cdr"              (targ-ifjump-apply "CDR"))
(targ-op "##caar"             (targ-ifjump-apply "CAAR"))
(targ-op "##cadr"             (targ-ifjump-apply "CADR"))
(targ-op "##cdar"             (targ-ifjump-apply "CDAR"))
(targ-op "##cddr"             (targ-ifjump-apply "CDDR"))
(targ-op "##caaar"            (targ-ifjump-apply "CAAAR"))
(targ-op "##caadr"            (targ-ifjump-apply "CAADR"))
(targ-op "##cadar"            (targ-ifjump-apply "CADAR"))
(targ-op "##caddr"            (targ-ifjump-apply "CADDR"))
(targ-op "##cdaar"            (targ-ifjump-apply "CDAAR"))
(targ-op "##cdadr"            (targ-ifjump-apply "CDADR"))
(targ-op "##cddar"            (targ-ifjump-apply "CDDAR"))
(targ-op "##cdddr"            (targ-ifjump-apply "CDDDR"))
(targ-op "##caaaar"           (targ-ifjump-apply "CAAAAR"))
(targ-op "##caaadr"           (targ-ifjump-apply "CAAADR"))
(targ-op "##caadar"           (targ-ifjump-apply "CAADAR"))
(targ-op "##caaddr"           (targ-ifjump-apply "CAADDR"))
(targ-op "##cadaar"           (targ-ifjump-apply "CADAAR"))
(targ-op "##cadadr"           (targ-ifjump-apply "CADADR"))
(targ-op "##caddar"           (targ-ifjump-apply "CADDAR"))
(targ-op "##cadddr"           (targ-ifjump-apply "CADDDR"))
(targ-op "##cdaaar"           (targ-ifjump-apply "CDAAAR"))
(targ-op "##cdaadr"           (targ-ifjump-apply "CDAADR"))
(targ-op "##cdadar"           (targ-ifjump-apply "CDADAR"))
(targ-op "##cdaddr"           (targ-ifjump-apply "CDADDR"))
(targ-op "##cddaar"           (targ-ifjump-apply "CDDAAR"))
(targ-op "##cddadr"           (targ-ifjump-apply "CDDADR"))
(targ-op "##cdddar"           (targ-ifjump-apply "CDDDAR"))
(targ-op "##cddddr"           (targ-ifjump-apply "CDDDDR"))

(targ-op "##list"             (targ-apply-list))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##box"              (targ-apply-box))
(targ-op "##unbox"            (targ-ifjump-apply "UNBOX"))
(targ-op "##set-box!"         (targ-apply-simp #f #t "SETBOX"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##make-will"        (targ-apply-make-will))
(targ-op "##will-testator"    (targ-ifjump-apply "WILLTESTATOR"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##gc-hash-table-ref"     (targ-apply-simp #f #f "GCHASHTABLEREF"))
(targ-op "##gc-hash-table-set!"    (targ-apply-simp #f #f "GCHASHTABLESET"))
(targ-op "##gc-hash-table-rehash!" (targ-apply-simp #f #f "GCHASHTABLEREHASH"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##values"           (targ-apply-vector 'values))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##string"           (targ-apply-vector 'string))
(targ-op "##string-length"    (targ-apply-simp #f #f "STRINGLENGTH"))
(targ-op "##string-ref"       (targ-apply-simp #f #f "STRINGREF"))
(targ-op "##string-set!"      (targ-apply-simp #f #t "STRINGSET"))
(targ-op "##string-shrink!"   (targ-apply-simp #f #t "STRINGSHRINK"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##vector"           (targ-apply-vector 'vector))
(targ-op "##vector-length"    (targ-apply-simp #f #f "VECTORLENGTH"))
(targ-op "##vector-ref"       (targ-ifjump-apply "VECTORREF"))
(targ-op "##vector-set!"      (targ-apply-simp #f #t "VECTORSET"))
(targ-op "##vector-shrink!"   (targ-apply-simp #f #t "VECTORSHRINK"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##s8vector"         (targ-apply-vector 's8vector))
(targ-op "##s8vector-length"  (targ-apply-simp #f #f "S8VECTORLENGTH"))
(targ-op "##s8vector-ref"     (targ-apply-simp #f #f "S8VECTORREF"))
(targ-op "##s8vector-set!"    (targ-apply-simp #f #t "S8VECTORSET"))
(targ-op "##s8vector-shrink!" (targ-apply-simp #f #t "S8VECTORSHRINK"))

(targ-op "##u8vector"         (targ-apply-vector 'u8vector))
(targ-op "##u8vector-length"  (targ-apply-simp #f #f "U8VECTORLENGTH"))
(targ-op "##u8vector-ref"     (targ-apply-simp #f #f "U8VECTORREF"))
(targ-op "##u8vector-set!"    (targ-apply-simp #f #t "U8VECTORSET"))
(targ-op "##u8vector-shrink!" (targ-apply-simp #f #t "U8VECTORSHRINK"))

(targ-op "##s16vector"        (targ-apply-vector 's16vector))
(targ-op "##s16vector-length" (targ-apply-simp #f #f "S16VECTORLENGTH"))
(targ-op "##s16vector-ref"    (targ-apply-simp #f #f "S16VECTORREF"))
(targ-op "##s16vector-set!"   (targ-apply-simp #f #t "S16VECTORSET"))
(targ-op "##s16vector-shrink!"(targ-apply-simp #f #t "S16VECTORSHRINK"))

(targ-op "##u16vector"        (targ-apply-vector 'u16vector))
(targ-op "##u16vector-length" (targ-apply-simp #f #f "U16VECTORLENGTH"))
(targ-op "##u16vector-ref"    (targ-apply-simp #f #f "U16VECTORREF"))
(targ-op "##u16vector-set!"   (targ-apply-simp #f #t "U16VECTORSET"))
(targ-op "##u16vector-shrink!"(targ-apply-simp #f #t "U16VECTORSHRINK"))

(targ-op "##s32vector"        (targ-apply-vector 's32vector))
(targ-op "##s32vector-length" (targ-apply-simp #f #f "S32VECTORLENGTH"))
(targ-op "##s32vector-ref"    (targ-apply-simpbig "S32VECTORREF"))
(targ-op "##s32vector-set!"   (targ-apply-simp #f #t "S32VECTORSET"))
(targ-op "##s32vector-shrink!"(targ-apply-simp #f #t "S32VECTORSHRINK"))

(targ-op "##u32vector"        (targ-apply-vector 'u32vector))
(targ-op "##u32vector-length" (targ-apply-simp #f #f "U32VECTORLENGTH"))
(targ-op "##u32vector-ref"    (targ-apply-simpbig "U32VECTORREF"))
(targ-op "##u32vector-set!"   (targ-apply-simp #f #t "U32VECTORSET"))
(targ-op "##u32vector-shrink!"(targ-apply-simp #f #t "U32VECTORSHRINK"))

(targ-op "##s64vector"        (targ-apply-vector 's64vector))
(targ-op "##s64vector-length" (targ-apply-simp #f #f "S64VECTORLENGTH"))
(targ-op "##s64vector-ref"    (targ-apply-simpbig "S64VECTORREF"))
(targ-op "##s64vector-set!"   (targ-apply-simp #f #t "S64VECTORSET"))
(targ-op "##s64vector-shrink!"(targ-apply-simp #f #t "S64VECTORSHRINK"))

(targ-op "##u64vector"        (targ-apply-vector 'u64vector))
(targ-op "##u64vector-length" (targ-apply-simp #f #f "U64VECTORLENGTH"))
(targ-op "##u64vector-ref"    (targ-apply-simpbig "U64VECTORREF"))
(targ-op "##u64vector-set!"   (targ-apply-simp #f #t "U64VECTORSET"))
(targ-op "##u64vector-shrink!"(targ-apply-simp #f #t "U64VECTORSHRINK"))

(targ-op "##f32vector"        (targ-apply-vector 'f32vector))
(targ-op "##f32vector-length" (targ-apply-simp #f #f "F32VECTORLENGTH"))
(targ-op "##f32vector-ref"    (targ-apply-simpflo #f "F32VECTORREF"))
(targ-op "##f32vector-set!"   (targ-apply-simpflo3 "F32VECTORSET"))
(targ-op "##f32vector-shrink!"(targ-apply-simp #f #t "F32VECTORSHRINK"))

(targ-op "##f64vector"        (targ-apply-vector 'f64vector))
(targ-op "##f64vector-length" (targ-apply-simp #f #f "F64VECTORLENGTH"))
(targ-op "##f64vector-ref"    (targ-apply-simpflo #f "F64VECTORREF"))
(targ-op "##f64vector-set!"   (targ-apply-simpflo3 "F64VECTORSET"))
(targ-op "##f64vector-shrink!"(targ-apply-simp #f #t "F64VECTORSHRINK"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##bignum.negative?"        (targ-ifjump-simp #f "BIGNEGATIVEP"))
(targ-op "##bignum.adigit-length"    (targ-apply-simp #f #f "BIGALENGTH"))
(targ-op "##bignum.adigit-inc!"      (targ-apply-simp #f 'expr "BIGAINC"))
(targ-op "##bignum.adigit-dec!"      (targ-apply-simp #f 'expr "BIGADEC"))
(targ-op "##bignum.adigit-add!"      (targ-apply-simp #f 'expr "BIGAADD"))
(targ-op "##bignum.adigit-sub!"      (targ-apply-simp #f 'expr "BIGASUB"))
(targ-op "##bignum.mdigit-length"    (targ-apply-simp #f #f "BIGMLENGTH"))
(targ-op "##bignum.mdigit-ref"       (targ-apply-simp #f #f "BIGMREF"))
(targ-op "##bignum.mdigit-set!"      (targ-apply-simp #f #t "BIGMSET"))
(targ-op "##bignum.mdigit-mul!"      (targ-apply-simp #f 'expr "BIGMMUL"))
(targ-op "##bignum.mdigit-div!"      (targ-apply-simp #f 'expr "BIGMDIV"))
(targ-op "##bignum.mdigit-quotient"  (targ-apply-simp #f #f "BIGMQUO"))
(targ-op "##bignum.mdigit-remainder" (targ-apply-simp #f #f "BIGMREM"))
(targ-op "##bignum.mdigit-test?"     (targ-ifjump-simp #f "BIGMTESTP"))

(targ-op "##bignum.adigit-ones?"     (targ-ifjump-simp #f "BIGAONESP"))
(targ-op "##bignum.adigit-="         (targ-ifjump-simp #f "BIGAEQP"))
(targ-op "##bignum.adigit-<"         (targ-ifjump-simp #f "BIGALESSP"))
(targ-op "##bignum.adigit-zero?"     (targ-ifjump-simp #f "BIGAZEROP"))
(targ-op "##bignum.adigit-negative?" (targ-ifjump-simp #f "BIGANEGATIVEP"))
(targ-op "##bignum.->fixnum"         (targ-apply-simp #f #f "BIGTOFIX"))
(targ-op "##bignum.<-fixnum"         (targ-apply-simpbig "BIGFROMFIX"))
(targ-op "##bignum.adigit-shrink!"   (targ-apply-simp #f #t "BIGASHRINK"))
(targ-op "##bignum.adigit-copy!"     (targ-apply-simp #f #t "BIGACOPY"))
(targ-op "##bignum.adigit-cat!"      (targ-apply-simp #f #t "BIGACAT"))
(targ-op "##bignum.adigit-bitwise-and!"(targ-apply-simp #f #t "BIGAAND"))
(targ-op "##bignum.adigit-bitwise-ior!"(targ-apply-simp #f #t "BIGAIOR"))
(targ-op "##bignum.adigit-bitwise-xor!"(targ-apply-simp #f #t "BIGAXOR"))
(targ-op "##bignum.adigit-bitwise-not!"(targ-apply-simp #f #t "BIGANOT"))

(targ-op "##bignum.fdigit-length"    (targ-apply-simp #f #f "BIGFLENGTH"))
(targ-op "##bignum.fdigit-ref"       (targ-apply-simp #f #f "BIGFREF"))
(targ-op "##bignum.fdigit-set!"      (targ-apply-simp #f #t "BIGFSET"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##structure-direct-instance-of?"
         (targ-ifjump-simp #f "STRUCTUREDIOP"))
(targ-op "##structure-type"
         (targ-ifjump-apply "STRUCTURETYPE"))
(targ-op "##structure-type-set!"
         (targ-apply-simp #f #t "STRUCTURETYPESET"))
(targ-op "##structure"
         (targ-apply-vector 'structure))
(targ-op "##unchecked-structure-ref"
         (targ-ifjump-apply "UNCHECKEDSTRUCTUREREF"))
(targ-op "##unchecked-structure-set!"
         (targ-apply-simp #f #t "UNCHECKEDSTRUCTURESET"))

(targ-op "##type-id"          (targ-apply-simp #f #f "TYPEID"))
(targ-op "##type-name"        (targ-apply-simp #f #f "TYPENAME"))
(targ-op "##type-flags"       (targ-apply-simp #f #f "TYPEFLAGS"))
(targ-op "##type-super"       (targ-apply-simp #f #f "TYPESUPER"))
(targ-op "##type-fields"      (targ-apply-simp #f #f "TYPEFIELDS"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##closure-length"   (targ-apply-simp #f #f "CLOSURELENGTH"))
(targ-op "##closure-code"     (targ-apply-simp #f #f "CLOSURECODE"))
(targ-op "##closure-ref"      (targ-apply-simp #f #f "CLOSUREREF"))
(targ-op "##closure-set!"     (targ-apply-simp #f #t "CLOSURESET"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##global-var-ref"
         (targ-apply-simp #f #f "GLOBALVARREF"))
(targ-op "##global-var-primitive-ref"
         (targ-apply-simp #f #f "GLOBALVARPRIMREF"))
(targ-op "##global-var-set!"
         (targ-apply-simp #f #t "GLOBALVARSET"))
(targ-op "##global-var-primitive-set!"
         (targ-apply-simp #f #t "GLOBALVARPRIMSET"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##make-promise"     (targ-apply-make-promise))
(targ-op "##force"            (targ-apply-force))
(targ-op "##void"             (targ-apply-simp #f #f "VOID"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##first-argument"   (targ-apply-first-argument))
(targ-op "##check-heap-limit" (targ-apply-check-heap-limit))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op "##current-thread"   (targ-apply-simp #f #f "CURRENTTHREAD"))
(targ-op "##run-queue"        (targ-apply-simp #f #f "RUNQUEUE"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-op
  "##c-code"
  (lambda (prim)
    (proc-obj-inlinable-set!
      prim
      (lambda (opnds loc sn)
        (targ-use-all-res)
        (let ((n (length opnds)))
          (if (= n 0)
            (compiler-error
              "\"##c-code\" needs at least one argument")
            (let ((code (car opnds))
                  (args (map (lambda (opnd) (targ-opnd opnd))
                             (cdr opnds))))
              (if (and (obj? code)
                       (string? (obj-val code)))
                (let loop ((i (- n 1))
                           (rev-args (reverse args))
                           (lst1 (list "{ " c-id-prefix "SCMOBJ "
                                       c-id-prefix "RESULT;"
                                       #\newline
                                       (obj-val code)
                                       #\newline))
                           (lst2 (list #\newline
                                       "}")))
                  (if (null? rev-args)
                    (begin
                      (targ-emit (cons 'append lst1))
                      (if loc
                        (targ-emit (targ-loc loc '("RESULT"))))
                      (targ-emit (cons 'append (reverse lst2))))
                    (let ((arg (car rev-args)))
                      (loop (- i 1)
                            (cdr rev-args)
                            (append
                              (list "#define " c-id-prefix "ARG" i " " arg
                                    #\newline)
                              lst1)
                            (append
                              (list #\newline
                                    i "ARG" c-id-prefix "#undef ")
                              lst2)))))
                (compiler-error
                  "Argument 1 of \"##c-code\" must be a string constant")))))))))

)

(targ-setup-inlinable)

;------------------------------------------------------------------------------

; Table of jump-inlinable operations (for 'jump' GVM instructions)

(define (targ-setup-jump-inlinable)

(targ-jump-inline "##thread-save!"
  (lambda (nb-args poll? safe?)
    (and (< 0 nb-args)
         (< nb-args 5)
         (let ((fs (frame-size targ-proc-exit-frame)))
           (targ-end-of-block-checks #t fs) ; force a poll
           (targ-emit (targ-adjust-stack fs))
           (targ-emit-jump-inline "THREAD_SAVE" safe? nb-args)
           (targ-rd-fp)
           (targ-wr-fp)
           (targ-rd-reg 0)
           (targ-wr-reg 0)
           (targ-wr-reg (+ targ-nb-arg-regs 1))
           #t))))

(targ-jump-inline "##thread-restore!"
  (lambda (nb-args poll? safe?)
    (and (< 1 nb-args)
         (< nb-args 6)
         (let ((fs (frame-size targ-proc-exit-frame)))
           (targ-end-of-block-checks poll? fs)
           (targ-emit (targ-adjust-stack fs))
           (targ-emit-jump-inline "THREAD_RESTORE" safe? nb-args)
           (targ-rd-fp)
           (targ-wr-fp)
           (targ-wr-reg 0)
           (targ-wr-reg (+ targ-nb-arg-regs 1))
           #t))))

(targ-jump-inline "##continuation-capture"
  (lambda (nb-args poll? safe?)
    (and (< 0 nb-args)
         (< nb-args 5)
         (let ((fs (frame-size targ-proc-exit-frame)))
           (targ-end-of-block-checks poll? fs)
           (targ-emit (targ-adjust-stack fs))
           (targ-emit-jump-inline "CONTINUATION_CAPTURE" safe? nb-args)
           (targ-rd-fp)
           (targ-wr-fp)
           (targ-rd-reg 0)
           (targ-wr-reg 0)
           (targ-wr-reg (+ targ-nb-arg-regs 1))
           #t))))

(targ-jump-inline "##continuation-graft"
  (lambda (nb-args poll? safe?)
    (and (< 1 nb-args)
         (< nb-args 6)
         (let ((fs (frame-size targ-proc-exit-frame)))
           (targ-end-of-block-checks poll? fs)
           (targ-emit (targ-adjust-stack fs))
           (targ-emit-jump-inline "CONTINUATION_GRAFT" safe? nb-args)
           (targ-wr-fp)
           (targ-wr-reg 0)
           (targ-wr-reg (+ targ-nb-arg-regs 1))
           #t))))

(targ-jump-inline "##continuation-return"
  (lambda (nb-args poll? safe?)
    (and (= nb-args 2)
         (let ((fs (frame-size targ-proc-exit-frame)))
           (targ-end-of-block-checks poll? fs)
           (targ-emit (targ-adjust-stack fs))
           (targ-emit-jump-inline "CONTINUATION_RETURN" safe? nb-args)
           (targ-wr-fp)
           (targ-wr-reg 0)
           #t))))

)

(targ-setup-jump-inlinable)

;------------------------------------------------------------------------------

; Table of procedure specializations

(define (targ-setup-specializations)

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-spec "not"         (targ-s "##not"))
(targ-spec "null?"       (targ-s "##null?"))
(targ-spec "eq?"         (targ-s "##eq?"))
(targ-spec "eof-object?" (targ-s "##eof-object?"))

(targ-spec "pair?"       (targ-s "##pair?"))
(targ-spec "procedure?"  (targ-s "##procedure?"))
(targ-spec "vector?"     (targ-s "##vector?"))
(targ-spec "symbol?"     (targ-s "##symbol?"))
(targ-spec "keyword?"    (targ-s "##keyword?"))
(targ-spec "string?"     (targ-s "##string?"))
(targ-spec "char?"       (targ-s "##char?"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-spec "zero?"       (targ-s-a "##fixnum.zero?"     "##flonum.zero?"))
(targ-spec "positive?"   (targ-s-a "##fixnum.positive?" "##flonum.positive?"))
(targ-spec "negative?"   (targ-s-a "##fixnum.negative?" "##flonum.negative?"))
(targ-spec "odd?"        (targ-s-a "##fixnum.odd?"      #f))
(targ-spec "even?"       (targ-s-a "##fixnum.even?"     #f))

(targ-spec "max"         (targ-u-a "##fixnum.max"       "##flonum.max"))
(targ-spec "min"         (targ-u-a "##fixnum.min"       "##flonum.min"))

(targ-spec "+"           (targ-u-a "##fixnum.+"         "##flonum.+"))
(targ-spec "*"           (targ-u-a "##fixnum.*"         "##flonum.*"))
(targ-spec "-"           (targ-u-a "##fixnum.-"         "##flonum.-"))
(targ-spec "/"           (targ-u-a #f                   "##flonum./"))
(targ-spec "quotient"    (targ-u-a "##fixnum.quotient"  #f))
(targ-spec "remainder"   (targ-u-a "##fixnum.remainder" #f))
(targ-spec "modulo"      (targ-u-a "##fixnum.modulo"    #f))

(targ-spec "bitwise-ior" (targ-u-a "##fixnum.bitwise-ior" #f))
(targ-spec "bitwise-xor" (targ-u-a "##fixnum.bitwise-xor" #f))
(targ-spec "bitwise-and" (targ-u-a "##fixnum.bitwise-and" #f))
(targ-spec "bitwise-not" (targ-u-a "##fixnum.bitwise-not" #f))
(targ-spec "arithmetic-shift" (targ-u-a "##fixnum.arithmetic-shift" #f))

(targ-spec "="           (targ-s-a "##fixnum.="         "##flonum.="))
(targ-spec "<"           (targ-s-a "##fixnum.<"         "##flonum.<"))
(targ-spec ">"           (targ-s-a "##fixnum.>"         "##flonum.>"))
(targ-spec "<="          (targ-s-a "##fixnum.<="        "##flonum.<="))
(targ-spec ">="          (targ-s-a "##fixnum.>="        "##flonum.>="))

(targ-spec "abs"         (targ-u-a #f                   "##flonum.abs"))
(targ-spec "floor"       (targ-u-a #f                   "##flonum.floor"))
(targ-spec "ceiling"     (targ-u-a #f                   "##flonum.ceiling"))
(targ-spec "truncate"    (targ-u-a #f                   "##flonum.truncate"))
(targ-spec "round"       (targ-u-a #f                   "##flonum.round"))
(targ-spec "exp"         (targ-u-a #f                   "##flonum.exp"))
(targ-spec "log"         (targ-u-a #f                   "##flonum.log"))
(targ-spec "sin"         (targ-u-a #f                   "##flonum.sin"))
(targ-spec "cos"         (targ-u-a #f                   "##flonum.cos"))
(targ-spec "tan"         (targ-u-a #f                   "##flonum.tan"))
(targ-spec "asin"        (targ-u-a #f                   "##flonum.asin"))
(targ-spec "acos"        (targ-u-a #f                   "##flonum.acos"))
(targ-spec "atan"        (targ-u-a #f                   "##flonum.atan"))
(targ-spec "sqrt"        (targ-u-a #f                   "##flonum.sqrt"))

(targ-spec "exact->inexact" (targ-u-a "##flonum.<-fixnum" #f))
(targ-spec "inexact->exact" (targ-u-a "##flonum.->fixnum" #f))

;(targ-spec "integer->char" (targ-s "##fixnum.->char"))
;(targ-spec "char->integer" (targ-s "##fixnum.<-char"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-spec "char=?"     (targ-s "##char=?"))
(targ-spec "char<?"     (targ-s "##char<?"))
(targ-spec "char>?"     (targ-s "##char>?"))
(targ-spec "char<=?"    (targ-s "##char<=?"))
(targ-spec "char>=?"    (targ-s "##char>=?"))

(targ-spec "char-alphabetic?" (targ-u "##char-alphabetic?"))
(targ-spec "char-numeric?"    (targ-u "##char-numeric?"))
(targ-spec "char-whitespace?" (targ-u "##char-whitespace?"))
(targ-spec "char-upper-case?" (targ-u "##char-upper-case?"))
(targ-spec "char-lower-case?" (targ-u "##char-lower-case?"))
(targ-spec "char->integer"    (targ-u "##fixnum.<-char"))
(targ-spec "integer->char"    (targ-u "##fixnum.->char"))
(targ-spec "char-upcase"      (targ-u "##char-upcase"))
(targ-spec "char-downcase"    (targ-u "##char-downcase"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-spec "cons"       (targ-s "##cons"))
(targ-spec "set-car!"   (targ-u "##set-car!"))
(targ-spec "set-cdr!"   (targ-u "##set-cdr!"))
(targ-spec "car"        (targ-u "##car"))
(targ-spec "cdr"        (targ-u "##cdr"))
(targ-spec "caar"       (targ-u "##caar"))
(targ-spec "cadr"       (targ-u "##cadr"))
(targ-spec "cdar"       (targ-u "##cdar"))
(targ-spec "cddr"       (targ-u "##cddr"))
(targ-spec "caaar"      (targ-u "##caaar"))
(targ-spec "caadr"      (targ-u "##caadr"))
(targ-spec "cadar"      (targ-u "##cadar"))
(targ-spec "caddr"      (targ-u "##caddr"))
(targ-spec "cdaar"      (targ-u "##cdaar"))
(targ-spec "cdadr"      (targ-u "##cdadr"))
(targ-spec "cddar"      (targ-u "##cddar"))
(targ-spec "cdddr"      (targ-u "##cdddr"))
(targ-spec "caaaar"     (targ-u "##caaaar"))
(targ-spec "caaadr"     (targ-u "##caaadr"))
(targ-spec "caadar"     (targ-u "##caadar"))
(targ-spec "caaddr"     (targ-u "##caaddr"))
(targ-spec "cadaar"     (targ-u "##cadaar"))
(targ-spec "cadadr"     (targ-u "##cadadr"))
(targ-spec "caddar"     (targ-u "##caddar"))
(targ-spec "cadddr"     (targ-u "##cadddr"))
(targ-spec "cdaaar"     (targ-u "##cdaaar"))
(targ-spec "cdaadr"     (targ-u "##cdaadr"))
(targ-spec "cdadar"     (targ-u "##cdadar"))
(targ-spec "cdaddr"     (targ-u "##cdaddr"))
(targ-spec "cddaar"     (targ-u "##cddaar"))
(targ-spec "cddadr"     (targ-u "##cddadr"))
(targ-spec "cdddar"     (targ-u "##cdddar"))
(targ-spec "cddddr"     (targ-u "##cddddr"))

(targ-spec "list"       (targ-s "##list"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-spec "will?"          (targ-s "##will?"))
(targ-spec "make-will"      (targ-s "##make-will"))
(targ-spec "will-testator"  (targ-u "##will-testator"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-spec "box?"           (targ-s "##box?"))
(targ-spec "box"            (targ-s "##box"))
(targ-spec "unbox"          (targ-u "##unbox"))
(targ-spec "set-box!"       (targ-u "##set-box!"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-spec "values"         (targ-s "##values"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-spec "string"         (targ-u "##string"))
(targ-spec "string-length"  (targ-u "##string-length"))
(targ-spec "string-ref"     (targ-u "##string-ref"))
(targ-spec "string-set!"    (targ-u "##string-set!"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-spec "vector"         (targ-s "##vector"))
(targ-spec "vector-length"  (targ-u "##vector-length"))
(targ-spec "vector-ref"     (targ-u "##vector-ref"))
(targ-spec "vector-set!"    (targ-u "##vector-set!"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-spec "s8vector?"        (targ-s "##s8vector?"))
(targ-spec "s8vector"         (targ-u "##s8vector"))
(targ-spec "s8vector-length"  (targ-u "##s8vector-length"))
(targ-spec "s8vector-ref"     (targ-u "##s8vector-ref"))
(targ-spec "s8vector-set!"    (targ-u "##s8vector-set!"))

(targ-spec "u8vector?"        (targ-s "##u8vector?"))
(targ-spec "u8vector"         (targ-u "##u8vector"))
(targ-spec "u8vector-length"  (targ-u "##u8vector-length"))
(targ-spec "u8vector-ref"     (targ-u "##u8vector-ref"))
(targ-spec "u8vector-set!"    (targ-u "##u8vector-set!"))

(targ-spec "s16vector?"       (targ-s "##s16vector?"))
(targ-spec "s16vector"        (targ-u "##s16vector"))
(targ-spec "s16vector-length" (targ-u "##s16vector-length"))
(targ-spec "s16vector-ref"    (targ-u "##s16vector-ref"))
(targ-spec "s16vector-set!"   (targ-u "##s16vector-set!"))

(targ-spec "u16vector?"       (targ-s "##u16vector?"))
(targ-spec "u16vector"        (targ-u "##u16vector"))
(targ-spec "u16vector-length" (targ-u "##u16vector-length"))
(targ-spec "u16vector-ref"    (targ-u "##u16vector-ref"))
(targ-spec "u16vector-set!"   (targ-u "##u16vector-set!"))

(targ-spec "s32vector?"       (targ-s "##s32vector?"))
(targ-spec "s32vector"        (targ-u "##s32vector"))
(targ-spec "s32vector-length" (targ-u "##s32vector-length"))
(targ-spec "s32vector-ref"    (targ-u "##s32vector-ref"))
(targ-spec "s32vector-set!"   (targ-u "##s32vector-set!"))

(targ-spec "u32vector?"       (targ-s "##u32vector?"))
(targ-spec "u32vector"        (targ-u "##u32vector"))
(targ-spec "u32vector-length" (targ-u "##u32vector-length"))
(targ-spec "u32vector-ref"    (targ-u "##u32vector-ref"))
(targ-spec "u32vector-set!"   (targ-u "##u32vector-set!"))

(targ-spec "s64vector?"       (targ-s "##s64vector?"))
(targ-spec "s64vector"        (targ-u "##s64vector"))
(targ-spec "s64vector-length" (targ-u "##s64vector-length"))
(targ-spec "s64vector-ref"    (targ-u "##s64vector-ref"))
(targ-spec "s64vector-set!"   (targ-u "##s64vector-set!"))

(targ-spec "u64vector?"       (targ-s "##u64vector?"))
(targ-spec "u64vector"        (targ-u "##u64vector"))
(targ-spec "u64vector-length" (targ-u "##u64vector-length"))
(targ-spec "u64vector-ref"    (targ-u "##u64vector-ref"))
(targ-spec "u64vector-set!"   (targ-u "##u64vector-set!"))

(targ-spec "f32vector?"       (targ-s "##f32vector?"))
(targ-spec "f32vector"        (targ-u "##f32vector"))
(targ-spec "f32vector-length" (targ-u "##f32vector-length"))
(targ-spec "f32vector-ref"    (targ-u "##f32vector-ref"))
(targ-spec "f32vector-set!"   (targ-u "##f32vector-set!"))

(targ-spec "f64vector?"       (targ-s "##f64vector?"))
(targ-spec "f64vector"        (targ-u "##f64vector"))
(targ-spec "f64vector-length" (targ-u "##f64vector-length"))
(targ-spec "f64vector-ref"    (targ-u "##f64vector-ref"))
(targ-spec "f64vector-set!"   (targ-u "##f64vector-set!"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-spec "##structure-ref"  (targ-u "##unchecked-structure-ref"))
(targ-spec "##structure-set!" (targ-u "##unchecked-structure-set!"))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-spec "touch"            (targ-s "##force"))
(targ-spec "force"            (targ-s "##force"))
(targ-spec "void"             (targ-s "##void"))

(targ-spec "eqv?"             (targ-s-eqv?))
(targ-spec "##eqv?"           (targ-s-eqv?))
(targ-spec "equal?"           (targ-s-equal?))
(targ-spec "##equal?"         (targ-s-equal?))

(targ-spec "call-with-current-continuation"
                              (targ-s "##call-with-current-continuation"))

(targ-spec "current-thread"   (targ-s "##current-thread"))
)

(targ-setup-specializations)

;------------------------------------------------------------------------------

; Table of procedure call simplifiers

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; Procedure call simplification

(define (targ-simp name . folders)
  (let ((proc (targ-get-prim-info name)))
    (proc-obj-simplify-set!
     proc
     (lambda (ptree args)
       (let loop ((lst folders))
         (if (pair? lst)
           (let ((folder (car lst)))
             (or (folder ptree args)
                 (loop (cdr lst))))
           #f))))))

(define (targ-constant-folder op . type-patterns)
  (targ-constant-folder-with-ptree-maker
   (lambda (ptree arg-vals)
     (let ((result (apply op arg-vals)))
       (new-cst (node-source ptree) (node-env ptree)
         result)))
   type-patterns))

(define targ-constant-folder-gen targ-constant-folder)

(define (targ-constant-folder-fix op . type-patterns)
  (targ-constant-folder-with-ptree-maker
   (lambda (ptree arg-vals)
     (let ((result (apply op arg-vals)))
       (and (or (not (number? result))
                (targ-fixnum32? result))
            (new-cst (node-source ptree) (node-env ptree)
              result))))
   type-patterns))

(define (targ-constant-folder-flo op . type-patterns)
  (targ-constant-folder-with-ptree-maker
   (lambda (ptree arg-vals)
     (let ((result (apply op arg-vals)))
       (and (or (not (number? result))
                (targ-flonum? result))
            (new-cst (node-source ptree) (node-env ptree)
              result))))
   type-patterns))

(define (targ-constant-folder-with-ptree-maker ptree-maker type-patterns)
  (let ((type-patterns
         (if (null? type-patterns)
           (list (lambda (obj) #t))
           type-patterns)))
    (lambda (ptree args)

      (define (match? args type-pattern)
        (if (pair? args)
          (cond ((pair? type-pattern)
                 (and ((car type-pattern) (car args))
                      (match? (cdr args) (cdr type-pattern))))
                ((null? type-pattern)
                 #f)
                (else
                 (and (type-pattern (car args))
                      (match? (cdr args) type-pattern))))
          (not (pair? type-pattern))))

      (and (every? cst? args) ; are all arguments constants?
           (let ((arg-vals (map cst-val args)))
             (let loop ((type-pats type-patterns))
               (if (pair? type-pats)
                 (if (match? arg-vals (car type-pats))
                   (ptree-maker ptree arg-vals)
                   (loop (cdr type-pats)))
                 #f)))))))

(define (targ-constant-folder-ref op get-length type?)
  (lambda (ptree args)
    (and (every? cst? args) ; are all arguments constants?
         (let* ((arg-vals (map cst-val args))
                (vect (car arg-vals))
                (index (cadr arg-vals)))
           (and (type? vect)
                (integer? index)
                (exact? index)
                (not (< index 0))
                (< index (get-length vect))
                (let ((result (op vect index)))
                  (new-cst (node-source ptree) (node-env ptree)
                    result)))))))

(define (targ-setup-simplifiers)

(define (num? obj) (targ-number? obj))
(define (nz-num? obj) (targ-nonzero-number? obj))

(define (int? obj) (targ-integer? obj))
(define (nz-int? obj) (targ-nonzero-integer? obj))

(define (flo? obj) (targ-flonum? obj))
(define (nz-flo? obj) (targ-nonzero-flonum? obj))

(define (fix32? obj) (targ-fixnum32? obj))
(define (nz-fix32? obj) (targ-nonzero-fixnum32? obj))

(define (not-bigfix? obj)
  (not (and (targ-fixnum64? obj) (not (targ-fixnum32? obj)))))

(define (any obj) #t)

(define (alist? obj) (and (list? obj) (every? pair? obj)))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(targ-simp "##not"            (targ-constant-folder false-object?  ))
(targ-simp "boolean?"         (targ-constant-folder (lambda (obj)
                                                      (or (false-object? obj)
                                                          (eq? obj #t)))))
(targ-simp "##eqv?"           (targ-constant-folder eqv?           ))
(targ-simp "##eq?"            (targ-constant-folder eq?            ))
(targ-simp "equal?"           (targ-constant-folder equal?         ))
(targ-simp "##pair?"          (targ-constant-folder pair?          ))
;(targ-simp "##cons"           (targ-constant-folder cons           ))
(targ-simp "car"              (targ-constant-folder car            pair?))
(targ-simp "##car"            (targ-constant-folder car            pair?))
(targ-simp "cdr"              (targ-constant-folder cdr            pair?))
(targ-simp "##cdr"            (targ-constant-folder cdr            pair?))
;(targ-simp "caar"             (targ-constant-folder caar           ))
;(targ-simp "cadr"             (targ-constant-folder cadr           ))
;(targ-simp "cdar"             (targ-constant-folder cdar           ))
;(targ-simp "cddr"             (targ-constant-folder cddr           ))
;(targ-simp "caaar"            (targ-constant-folder caaar          ))
;(targ-simp "caadr"            (targ-constant-folder caadr          ))
;(targ-simp "cadar"            (targ-constant-folder cadar          ))
;(targ-simp "caddr"            (targ-constant-folder caddr          ))
;(targ-simp "cdaar"            (targ-constant-folder cdaar          ))
;(targ-simp "cdadr"            (targ-constant-folder cdadr          ))
;(targ-simp "cddar"            (targ-constant-folder cddar          ))
;(targ-simp "cdddr"            (targ-constant-folder cdddr          ))
;(targ-simp "caaaar"           (targ-constant-folder caaaar         ))
;(targ-simp "caaadr"           (targ-constant-folder caaadr         ))
;(targ-simp "caadar"           (targ-constant-folder caadar         ))
;(targ-simp "caaddr"           (targ-constant-folder caaddr         ))
;(targ-simp "cadaar"           (targ-constant-folder cadaar         ))
;(targ-simp "cadadr"           (targ-constant-folder cadadr         ))
;(targ-simp "caddar"           (targ-constant-folder caddar         ))
;(targ-simp "cadddr"           (targ-constant-folder cadddr         ))
;(targ-simp "cdaaar"           (targ-constant-folder cdaaar         ))
;(targ-simp "cdaadr"           (targ-constant-folder cdaadr         ))
;(targ-simp "cdadar"           (targ-constant-folder cdadar         ))
;(targ-simp "cdaddr"           (targ-constant-folder cdaddr         ))
;(targ-simp "cddaar"           (targ-constant-folder cddaar         ))
;(targ-simp "cddadr"           (targ-constant-folder cddadr         ))
;(targ-simp "cdddar"           (targ-constant-folder cdddar         ))
;(targ-simp "cddddr"           (targ-constant-folder cddddr         ))
(targ-simp "##null?"          (targ-constant-folder null?          ))
(targ-simp "list?"            (targ-constant-folder list?          ))
;(targ-simp "list"             (targ-constant-folder list           ))
(targ-simp "length"           (targ-constant-folder length         list?))
;(targ-simp "append"           (targ-constant-folder append         list?))
;(targ-simp "reverse"          (targ-constant-folder reverse        list?))
(targ-simp "list-ref"         (targ-constant-folder-ref
                               list-ref
                               length
                               list?))
(targ-simp "memq"             (targ-constant-folder memq
                                                    (list any list?)))
(targ-simp "memv"             (targ-constant-folder memv
                                                    (list any list?)))
(targ-simp "member"           (targ-constant-folder member
                                                    (list any list?)))
(targ-simp "assq"             (targ-constant-folder assq
                                                    (list any alist?)))
(targ-simp "assv"             (targ-constant-folder assv
                                                    (list any alist?)))
(targ-simp "assoc"            (targ-constant-folder assoc
                                                    (list any alist?)))
(targ-simp "##symbol?"        (targ-constant-folder symbol-object? ))
;(targ-simp "symbol->string"   (targ-constant-folder symbol->string
;                                                    symbol-object?))
(targ-simp "string->symbol"   (targ-constant-folder string->symbol ))
(targ-simp "number?"          (targ-constant-folder number?        ))
(targ-simp "complex?"         (targ-constant-folder complex?       ))
(targ-simp "real?"            (targ-constant-folder real?          ))
(targ-simp "rational?"        (targ-constant-folder rational?      ))
(targ-simp "integer?"         (targ-constant-folder integer?       ))
(targ-simp "exact?"           (targ-constant-folder exact?         num?))
(targ-simp "inexact?"         (targ-constant-folder inexact?       num?))
(targ-simp "="                (targ-constant-folder-gen =          num?))
(targ-simp "##fixnum.="       (targ-constant-folder-fix =          fix32?))
(targ-simp "##flonum.="       (targ-constant-folder-flo =          flo?))
(targ-simp "<"                (targ-constant-folder-gen <          real?))
(targ-simp "##fixnum.<"       (targ-constant-folder-fix <          fix32?))
(targ-simp "##flonum.<"       (targ-constant-folder-flo <          flo?))
(targ-simp ">"                (targ-constant-folder-gen >          real?))
(targ-simp "##fixnum.>"       (targ-constant-folder-fix >          fix32?))
(targ-simp "##flonum.>"       (targ-constant-folder-flo >          flo?))
(targ-simp "<="               (targ-constant-folder-gen <=         real?))
(targ-simp "##fixnum.<="      (targ-constant-folder-fix <=         fix32?))
(targ-simp "##flonum.<="      (targ-constant-folder-flo <=         flo?))
(targ-simp ">="               (targ-constant-folder-gen >=         real?))
(targ-simp "##fixnum.>="      (targ-constant-folder-fix >=         fix32?))
(targ-simp "##flonum.>="      (targ-constant-folder-flo >=         flo?))
(targ-simp "zero?"            (targ-constant-folder-gen zero?      num?))
(targ-simp "##fixnum.zero?"   (targ-constant-folder-fix zero?      fix32?))
(targ-simp "##flonum.zero?"   (targ-constant-folder-flo zero?      flo?))
(targ-simp "positive?"         (targ-constant-folder-gen positive? real?))
(targ-simp "##fixnum.positive?"(targ-constant-folder-fix positive? fix32?))
(targ-simp "##flonum.positive?"(targ-constant-folder-flo positive? flo?))
(targ-simp "negative?"         (targ-constant-folder-gen negative? real?))
(targ-simp "##fixnum.negative?"(targ-constant-folder-fix negative? fix32?))
(targ-simp "##flonum.negative?"(targ-constant-folder-flo negative? flo?))
(targ-simp "odd?"             (targ-constant-folder-gen odd?       int?))
(targ-simp "##fixnum.odd?"    (targ-constant-folder-fix odd?       fix32?))
(targ-simp "even?"            (targ-constant-folder-gen even?      int?))
(targ-simp "##fixnum.even?"   (targ-constant-folder-fix even?      fix32?))
(targ-simp "max"              (targ-constant-folder-gen max        real?))
(targ-simp "##fixnum.max"     (targ-constant-folder-fix max        fix32?))
(targ-simp "##flonum.max"     (targ-constant-folder-flo max        flo?))
(targ-simp "min"              (targ-constant-folder-gen min        real?))
(targ-simp "##fixnum.min"     (targ-constant-folder-fix min        fix32?))
(targ-simp "##flonum.min"     (targ-constant-folder-flo min        flo?))
(targ-simp "+"                (targ-constant-folder-gen +          num?))
(targ-simp "##fixnum.+"       (targ-constant-folder-fix +          fix32?))
(targ-simp "##fixnum.+?"      (targ-constant-folder-gen +          int?))
(targ-simp "##flonum.+"       (targ-constant-folder-flo +          flo?))
(targ-simp "*"                (targ-constant-folder-gen *          num?))
(targ-simp "##fixnum.*"       (targ-constant-folder-fix *          fix32?))
(targ-simp "##fixnum.*?"      (targ-constant-folder-gen *          int?))
(targ-simp "##flonum.*"       (targ-constant-folder-flo *          flo?))
(targ-simp "-"                (targ-constant-folder-gen -          num?))
(targ-simp "##fixnum.-"       (targ-constant-folder-fix -          fix32?))
(targ-simp "##fixnum.-?"      (targ-constant-folder-gen -          int?))
(targ-simp "##flonum.-"       (targ-constant-folder-flo -          flo?))
(targ-simp "/"                (targ-constant-folder-gen /
                                                        (list nz-num?)
                                                        (cons num?
                                                              (cons nz-num?
                                                                    nz-num?))))
(targ-simp "##flonum./"       (targ-constant-folder-flo /
                                                        (list nz-flo?)
                                                        (cons flo?
                                                              (cons nz-flo?
                                                                    nz-flo?))))
(targ-simp "abs"              (targ-constant-folder-gen abs        real?))
(targ-simp "##flonum.abs"     (targ-constant-folder-gen abs        flo?))
(targ-simp "quotient"         (targ-constant-folder-gen quotient
                                                        (list int? nz-int?)))
(targ-simp "##fixnum.quotient"(targ-constant-folder-fix quotient
                                                        (list fix32? nz-fix32?)))
(targ-simp "remainder"        (targ-constant-folder-gen remainder
                                                        (list int? nz-int?)))
(targ-simp "##fixnum.remainder"(targ-constant-folder-fix remainder
                                                        (list fix32? nz-fix32?)))
(targ-simp "modulo"           (targ-constant-folder-gen modulo
                                                        (list int? nz-int?)))
(targ-simp "##fixnum.modulo"  (targ-constant-folder-fix modulo
                                                        (list fix32? nz-fix32?)))
(targ-simp "gcd"              (targ-constant-folder-gen gcd        int?))
(targ-simp "lcm"              (targ-constant-folder-gen lcm        int?))
(targ-simp "numerator"        (targ-constant-folder-gen numerator  rational?))
(targ-simp "denominator"      (targ-constant-folder-gen denominator rational?))
(targ-simp "floor"            (targ-constant-folder-gen floor      real?))
(targ-simp "##flonum.floor"   (targ-constant-folder-flo floor      flo?))
(targ-simp "ceiling"          (targ-constant-folder-gen ceiling    real?))
(targ-simp "##flonum.ceiling" (targ-constant-folder-flo ceiling    flo?))
(targ-simp "truncate"         (targ-constant-folder-gen truncate   real?))
(targ-simp "##flonum.truncate"(targ-constant-folder-flo truncate   flo?))
(targ-simp "round"            (targ-constant-folder-gen round      real?))
(targ-simp "##flonum.round"   (targ-constant-folder-flo round      flo?))
(targ-simp "rationalize"      (targ-constant-folder-gen rationalize real?))
(targ-simp "exp"              (targ-constant-folder-gen exp        num?))
(targ-simp "##flonum.exp"     (targ-constant-folder-flo exp        flo?))
(targ-simp "log"              (targ-constant-folder-gen log        nz-num?))
(targ-simp "##flonum.log"     (targ-constant-folder-flo log        nz-flo?))
(targ-simp "sin"              (targ-constant-folder-gen sin        num?))
(targ-simp "##flonum.sin"     (targ-constant-folder-flo sin        flo?))
(targ-simp "cos"              (targ-constant-folder-gen cos        num?))
(targ-simp "##flonum.cos"     (targ-constant-folder-flo cos        flo?))
(targ-simp "tan"              (targ-constant-folder-gen tan        num?))
(targ-simp "##flonum.tan"     (targ-constant-folder-flo tan        flo?))
(targ-simp "asin"             (targ-constant-folder-gen asin       num?))
(targ-simp "##flonum.asin"    (targ-constant-folder-flo asin       flo?))
(targ-simp "acos"             (targ-constant-folder-gen acos       num?))
(targ-simp "##flonum.acos"    (targ-constant-folder-flo acos       flo?))
(targ-simp "atan"             (targ-constant-folder-gen atan       num?))
(targ-simp "##flonum.atan"    (targ-constant-folder-flo atan       flo?))
(targ-simp "sqrt"             (targ-constant-folder-gen sqrt       num?))
(targ-simp "##flonum.sqrt"    (targ-constant-folder-flo sqrt       flo?))
(targ-simp "expt"             (targ-constant-folder-gen expt       num?))
(targ-simp "make-rectangular" (targ-constant-folder-gen make-rectangular real?))
(targ-simp "make-polar"       (targ-constant-folder-gen make-polar     real?))
(targ-simp "real-part"        (targ-constant-folder-gen real-part      num?))
(targ-simp "imag-part"        (targ-constant-folder-gen imag-part      num?))
(targ-simp "magnitude"        (targ-constant-folder-gen magnitude      num?))
(targ-simp "angle"            (targ-constant-folder-gen angle          num?))
(targ-simp "exact->inexact"   (targ-constant-folder-gen exact->inexact num?))
(targ-simp "inexact->exact"   (targ-constant-folder-gen inexact->exact num?))
;(targ-simp "number->string"   (targ-constant-folder number->string num?))
(targ-simp "string->number"   (targ-constant-folder string->number string?))
(targ-simp "##char?"          (targ-constant-folder char?          ))
(targ-simp "char=?"           (targ-constant-folder char=?         char?))
(targ-simp "char<?"           (targ-constant-folder char<?         char?))
(targ-simp "char>?"           (targ-constant-folder char>?         char?))
(targ-simp "char<=?"          (targ-constant-folder char<=?        char?))
(targ-simp "char>=?"          (targ-constant-folder char>=?        char?))
(targ-simp "char-ci=?"        (targ-constant-folder char-ci=?      char?))
(targ-simp "char-ci<?"        (targ-constant-folder char-ci<?      char?))
(targ-simp "char-ci>?"        (targ-constant-folder char-ci>?      char?))
(targ-simp "char-ci<=?"       (targ-constant-folder char-ci<=?     char?))
(targ-simp "char-ci>=?"       (targ-constant-folder char-ci>=?     char?))
(targ-simp "char-alphabetic?" (targ-constant-folder char-alphabetic? char?))
(targ-simp "char-numeric?"    (targ-constant-folder char-numeric?  char?))
(targ-simp "char-whitespace?" (targ-constant-folder char-whitespace? char?))
(targ-simp "char-upper-case?" (targ-constant-folder char-upper-case? char?))
(targ-simp "char-lower-case?" (targ-constant-folder char-lower-case? char?))
(targ-simp "char->integer"    (targ-constant-folder char->integer  char?))
;(targ-simp "integer->char"    (targ-constant-folder integer->char  ))
(targ-simp "char-upcase"      (targ-constant-folder char-upcase    char?))
(targ-simp "char-downcase"    (targ-constant-folder char-downcase  char?))
(targ-simp "##string?"        (targ-constant-folder string?        ))
;(targ-simp "make-string"      (targ-constant-folder make-string    ))
;(targ-simp "string"           (targ-constant-folder string         char?))
(targ-simp "string-length"    (targ-constant-folder string-length  string?))
(targ-simp "string-ref"       (targ-constant-folder-ref
                               string-ref
                               string-length
                               string?))
(targ-simp "string=?"         (targ-constant-folder string=?       string?))
(targ-simp "string<?"         (targ-constant-folder string<?       string?))
(targ-simp "string>?"         (targ-constant-folder string>?       string?))
(targ-simp "string<=?"        (targ-constant-folder string<=?      string?))
(targ-simp "string>=?"        (targ-constant-folder string>=?      string?))
(targ-simp "string-ci=?"      (targ-constant-folder string-ci=?    string?))
(targ-simp "string-ci<?"      (targ-constant-folder string-ci<?    string?))
(targ-simp "string-ci>?"      (targ-constant-folder string-ci>?    string?))
(targ-simp "string-ci<=?"     (targ-constant-folder string-ci<=?   string?))
(targ-simp "string-ci>=?"     (targ-constant-folder string-ci>=?   string?))
;(targ-simp "substring"        (targ-constant-folder substring      ))
;(targ-simp "string-append"    (targ-constant-folder string-append  string?))
(targ-simp "##vector?"        (targ-constant-folder vector-object? ))
;(targ-simp "make-vector"      (targ-constant-folder make-vector    ))
;(targ-simp "vector"           (targ-constant-folder vector         ))
(targ-simp "vector-length"    (targ-constant-folder vector-length
                                                    vector-object?))
(targ-simp "vector-ref"       (targ-constant-folder-ref
                               vector-ref
                               vector-length
                               vector-object?))
(targ-simp "##procedure?"     (targ-constant-folder proc-obj?      ))
;(targ-simp "apply"            (targ-constant-folder apply          ))
(targ-simp "input-port?"      (targ-constant-folder input-port?    ))
(targ-simp "output-port?"     (targ-constant-folder output-port?   ))
(targ-simp "##eof-object?"    (targ-constant-folder end-of-file-object?))
;(targ-simp "list-tail"        (targ-constant-folder list-tail      ))
;(targ-simp "string->list"     (targ-constant-folder string->list   string?))
;(targ-simp "list->string"     (targ-constant-folder list->string   ))
;(targ-simp "string-copy"      (targ-constant-folder string-copy    string?))
;(targ-simp "vector->list"     (targ-constant-folder vector->list
;                                                    vector-object?))
;(targ-simp "list->vector"     (targ-constant-folder list->vector   list?))
(targ-simp "##keyword?"       (targ-constant-folder keyword-object?))
;(targ-simp "keyword->string"  (targ-constant-folder keyword-object->string))
(targ-simp "string->keyword"  (targ-constant-folder string->keyword-object))
(targ-simp "##void"           (targ-constant-folder (lambda () void-object)))

(targ-simp "##fixnum?"        (targ-constant-folder fix32?         not-bigfix?))
(targ-simp "##flonum?"        (targ-constant-folder flo?           ))
)

(targ-setup-simplifiers)

(define (targ-setup-expanders)

(define (targ-exp name expander)
  (let ((proc (targ-get-prim-info name)))
    (proc-obj-expandable-set!
     proc
     expander)))

(define (setup-c...r-primitive pattern)

  (define (gen-name pattern)

    (define (ads pattern)
      (if (= pattern 1)
        ""
        (string-append (if (odd? pattern) "d" "a")
                       (ads (quotient pattern 2)))))

    (string-append "c" (ads pattern) "r"))

  (define **pair?-sym (string->canonical-symbol "##pair?"))
  (define **car-sym (string->canonical-symbol "##car"))
  (define **cdr-sym (string->canonical-symbol "##cdr"))

  (define (c...r pattern x)
    (if (= pattern 1)
        x
        (let ((y (c...r (quotient pattern 2) x)))
          (if (pair? y)
              (if (odd? pattern) (cdr y) (car y))
              #f))))

  (define (expander ptree oper args generate-call check-run-time-binding)
    (let ((source (node-source ptree))
          (env (node-env ptree)))

      (define (op-prim pattern)
        (if (odd? pattern) **cdr-sym **car-sym))

      (define (gen-tst-pair pattern var body check)
        (new-tst source env
          (let ((x (and check (check)))
                (y (gen-call-prim source env **pair?-sym (list var))))
            (if x
              (new-conj source env x y)
              y))
          (gen-call-prim source env (op-prim pattern) (list var))
          body))

      (define (gen-c...r pattern var)
        (if (< pattern 4)
          (gen-tst-pair
           pattern
           var
           (new-cst source env
             #f)
           check-run-time-binding)
          (let ((vars (gen-temp-vars source '(#f))))
            (new-call source env
              (gen-prc source env
                vars
                (gen-tst-pair
                 pattern
                 (car vars)
                 (new-cst source env
                   #f)
                 #f))
              (list (gen-c...r (quotient pattern 2) var))))))

      (let* ((vars1
              (gen-temp-vars source '(#f)))
             (call
              (generate-call vars1)))
        (gen-prc source env
          vars1
          (if (< pattern 4)
            (gen-tst-pair pattern (car vars1) call check-run-time-binding)
            (new-call source env
              (let ((vars2 (gen-temp-vars source '(#f))))
                (gen-prc source env
                  vars2
                  (gen-tst-pair pattern (car vars2) call #f)))
              (list (gen-c...r (quotient pattern 2) (car vars1)))))))))

  (let* ((name
          (gen-name pattern))
         (**name
          (string-append "##" name)))
    (targ-exp name expander)))

(define (setup-c...r-primitives)
  (let loop ((pattern 2))
    (if (< pattern 32)
        (begin
          (setup-c...r-primitive pattern)
          (loop (+ pattern 1))))))

(define (setup-numeric-primitives)

  (define **fixnum?-sym (string->canonical-symbol "##fixnum?"))

  (define **fixnum.+-sym (string->canonical-symbol "##fixnum.+"))
  (define **fixnum.+?-sym (string->canonical-symbol "##fixnum.+?"))

  (define **fixnum.*-sym (string->canonical-symbol "##fixnum.*"))
  (define **fixnum.*?-sym (string->canonical-symbol "##fixnum.*?"))

  (define **fixnum.--sym (string->canonical-symbol "##fixnum.-"))
  (define **fixnum.-?-sym (string->canonical-symbol "##fixnum.-?"))

  (define **fixnum.quotient-sym (string->canonical-symbol "##fixnum.quotient"))
  (define **fixnum.remainder-sym (string->canonical-symbol "##fixnum.remainder"))
  (define **fixnum.modulo-sym (string->canonical-symbol "##fixnum.modulo"))

  (define **fixnum.=-sym (string->canonical-symbol "##fixnum.="))
  (define **fixnum.<-sym (string->canonical-symbol "##fixnum.<"))
  (define **fixnum.>-sym (string->canonical-symbol "##fixnum.>"))
  (define **fixnum.<=-sym (string->canonical-symbol "##fixnum.<="))
  (define **fixnum.>=-sym (string->canonical-symbol "##fixnum.>="))

  (define **flonum?-sym (string->canonical-symbol "##flonum?"))

  (define **flonum.+-sym (string->canonical-symbol "##flonum.+"))
  (define **flonum.*-sym (string->canonical-symbol "##flonum.*"))
  (define **flonum.--sym (string->canonical-symbol "##flonum.-"))
  (define **flonum./-sym (string->canonical-symbol "##flonum./"))

  (define **flonum.=-sym (string->canonical-symbol "##flonum.="))
  (define **flonum.<-sym (string->canonical-symbol "##flonum.<"))
  (define **flonum.>-sym (string->canonical-symbol "##flonum.>"))
  (define **flonum.<=-sym (string->canonical-symbol "##flonum.<="))
  (define **flonum.>=-sym (string->canonical-symbol "##flonum.>="))

  (define (gen-type-checks
           source
           env
           vars
           check-run-time-binding
           check-prim
           tail
           succeed-checks
           fail-checks)
    (let ((type-checks
           (gen-uniform-type-checks source env
             vars
             (lambda (var)
               (gen-call-prim source env check-prim (list var)))
             tail)))
      (if (or type-checks
              check-run-time-binding)
        (new-tst source env
          (if type-checks
            (if check-run-time-binding
              (new-conj source env
                (check-run-time-binding)
                type-checks)
              type-checks)
            (check-run-time-binding))
          (succeed-checks)
          (fail-checks))
        (succeed-checks))))

  (define (gen-case check-prim prim)
    (lambda (source
             env
             vars
             check-run-time-binding
             overflow
             fail-checks)
      (gen-type-checks
       source
       env
       vars
       check-run-time-binding
       check-prim
       #f
       (lambda ()
         (gen-call-prim source env prim vars))
       fail-checks)))

  (define (gen-case-overflow check-prim gen-special-case gen-op)
    (lambda (source
             env
             vars
             check-run-time-binding
             overflow
             fail-checks)

      (define (gen-fold result-var vars intermediate-result-vars)
        (if (null? vars)
          (new-ref source env
            result-var)
          (let ((var (car intermediate-result-vars)))
            (new-call source env
              (gen-prc source env
                (list var)
                (new-tst source env
                  (new-ref source env
                    var)
                  (gen-fold var
                            (cdr vars)
                            (cdr intermediate-result-vars))
                  (overflow)))
              (list (gen-op source env result-var (car vars)))))))

      (gen-type-checks
       source
       env
       vars
       check-run-time-binding
       check-prim
       #f
       (lambda ()
         (gen-special-case source env
           vars
           overflow
           (lambda ()
             (gen-fold (car vars)
                       (cdr vars)
                       (gen-temp-vars source (cdr vars))))))
       fail-checks)))

  (define (no-case source
                   env
                   vars
                   check-run-time-binding
                   overflow
                   fail-checks)
    (fail-checks))

  (define (make-numeric-expander fixnum-case flonum-case)

    (define (expander ptree oper args generate-call check-run-time-binding)
      (let* ((source
              (node-source ptree))
             (env
              (node-env ptree))
             (mostly-arith
              (mostly-arith-implementation (var-name (ref-var oper)) env))
             (cases
              (cond ((eq? mostly-arith mostly-fixnum-sym)
                     (cons fixnum-case no-case))
                    ((eq? mostly-arith mostly-flonum-sym)
                     (cons flonum-case no-case))
                    ((eq? mostly-arith mostly-fixnum-flonum-sym)
                     (cons fixnum-case flonum-case))
                    ((eq? mostly-arith mostly-flonum-fixnum-sym)
                     (cons flonum-case fixnum-case))
                    (else
                     (cons no-case no-case)))))
        (if (and (eq? (car cases) no-case)
                 (eq? (cdr cases) no-case))
          #f
          (let ((vars (gen-temp-vars source args)))
            (gen-prc source env
              vars
              (let* ((generic-call
                      (lambda ()
                        (generate-call vars)))
                     (cases-expansion
                      ((car cases) source env
                       vars
                       (and (eq? (cdr cases) no-case)
                            check-run-time-binding)
                       generic-call
                       (lambda ()
                         ((cdr cases) source env
                          vars
                          (and (eq? (car cases) no-case)
                               check-run-time-binding)
                          generic-call
                          generic-call)))))
                (if (and check-run-time-binding
                         (not (eq? (car cases) no-case))
                         (not (eq? (cdr cases) no-case)))
                  (new-tst source env
                    (check-run-time-binding)
                    cases-expansion
                    (generic-call))
                  cases-expansion)))))))

    expander)

  (define (make-fixnum-division-expander succeed-checks)

    (define (expander ptree oper args generate-call check-run-time-binding)
      (let* ((source
              (node-source ptree))
             (env
              (node-env ptree))
             (mostly-arith
              (mostly-arith-implementation (var-name (ref-var oper)) env)))
        (and (or (eq? mostly-arith mostly-fixnum-sym)
                 (eq? mostly-arith mostly-fixnum-flonum-sym)
                 (eq? mostly-arith mostly-flonum-fixnum-sym))
             (let* ((vars
                     (gen-temp-vars source args))
                    (generic-call
                     (lambda ()
                       (generate-call vars))))
               (gen-prc source env
                 vars
                 (gen-type-checks
                  source
                  env
                  vars
                  check-run-time-binding
                  **fixnum?-sym
                  (new-call source env
                    (new-ref-extended-bindings source **not-sym env)
                    (list (new-call source env
                            (new-ref-extended-bindings source **eqv?-sym env)
                            (list (new-ref source env
                                    (cadr vars))
                                  (new-cst source env
                                    0)))))
                  (lambda ()
                    (succeed-checks source env vars generic-call))
                  generic-call))))))

    expander)

  (targ-exp
   "+"
   (make-numeric-expander
    (gen-case-overflow
     **fixnum?-sym
     (lambda (source env vars overflow otherwise)
       (cond ((null? vars)
              (new-cst source env
                0))
             ((null? (cdr vars))
              (new-ref source env
                (car vars)))
             (else
              (otherwise))))
     (lambda (source env var1 var2)
       (gen-call-prim source env
         **fixnum.+?-sym
         (list var1 var2))))
    (gen-case **flonum?-sym **flonum.+-sym)))

  (targ-exp
   "*"
   (make-numeric-expander
    (gen-case-overflow
     **fixnum?-sym
     (lambda (source env vars overflow otherwise)
       (cond ((null? vars)
              (new-cst source env
                1))
             ((null? (cdr vars))
              (new-ref source env
                (car vars)))
             (else
              (new-tst source env
                (gen-disj-multi source env
                  (map (lambda (var)
                         (new-call source env
                           (new-ref-extended-bindings source **eqv?-sym env)
                           (list (new-ref source env
                                   var)
                                 (new-cst source env
                                   0))))
                       (reverse (cdr vars))))
                (new-cst source env
                  0)
                (otherwise)))))
     (lambda (source env var1 var2)
       (new-tst source env
         (new-call source env
           (new-ref-extended-bindings source **eqv?-sym env)
           (list (new-ref source env
                   var2)
                 (new-cst source env
                   -1)))
         (gen-call-prim source env
           **fixnum.-?-sym
           (list var1))
         (gen-call-prim source env
           **fixnum.*?-sym
           (list var1 var2)))))
    (gen-case **flonum?-sym **flonum.*-sym)))

  (targ-exp
   "-"
   (make-numeric-expander
    (gen-case-overflow
     **fixnum?-sym
     (lambda (source env vars overflow otherwise)
       (cond ((null? (cdr vars))
              (let ((var (car (gen-temp-vars source '(#f)))))
                (new-call source env
                  (gen-prc source env
                    (list var)
                    (new-tst source env
                      (new-ref source env
                        var)
                      (new-ref source env
                        var)
                      (overflow)))
                  (list (gen-call-prim source env
                          **fixnum.-?-sym
                          vars)))))
             (else
              (otherwise))))
     (lambda (source env var1 var2)
       (gen-call-prim source env
         **fixnum.-?-sym
         (list var1 var2))))
    (gen-case **flonum?-sym **flonum.--sym)))

  (targ-exp
   "/"
   (make-numeric-expander
    no-case
    (gen-case **flonum?-sym **flonum./-sym)))

  (targ-exp
   "quotient"
   (make-fixnum-division-expander
    (lambda (source env vars generic-call)
      (new-tst source env
        (new-call source env
          (new-ref-extended-bindings source **eqv?-sym env)
          (list (new-ref source env
                  (cadr vars))
                (new-cst source env
                  -1)))
        (new-disj source env
          (gen-call-prim source env
            **fixnum.-?-sym
            (list (car vars)))
          (generic-call))
        (gen-call-prim source env
          **fixnum.quotient-sym
          vars)))))

  (targ-exp
   "remainder"
   (make-fixnum-division-expander
    (lambda (source env vars generic-call)
      (gen-call-prim source env
        **fixnum.remainder-sym
        vars))))

  (targ-exp
   "modulo"
   (make-fixnum-division-expander
    (lambda (source env vars generic-call)
      (gen-call-prim source env
        **fixnum.modulo-sym
        vars))))

  (targ-exp
   "="
   (make-numeric-expander
    (gen-case **fixnum?-sym **fixnum.=-sym)
    (gen-case **flonum?-sym **flonum.=-sym)))

  (targ-exp
   "<"
   (make-numeric-expander
    (gen-case **fixnum?-sym **fixnum.<-sym)
    (gen-case **flonum?-sym **flonum.<-sym)))

  (targ-exp
   ">"
   (make-numeric-expander
    (gen-case **fixnum?-sym **fixnum.>-sym)
    (gen-case **flonum?-sym **flonum.>-sym)))

  (targ-exp
   "<="
   (make-numeric-expander
    (gen-case **fixnum?-sym **fixnum.<=-sym)
    (gen-case **flonum?-sym **flonum.<=-sym)))

  (targ-exp
   ">="
   (make-numeric-expander
    (gen-case **fixnum?-sym **fixnum.>=-sym)
    (gen-case **flonum?-sym **flonum.>=-sym)))
)

(setup-c...r-primitives)
(setup-numeric-primitives)

)

(targ-setup-expanders)

;------------------------------------------------------------------------------
