;==============================================================================

; File: "_gsi.scm", Time-stamp: <2005-09-12 00:15:55 feeley>

; Copyright (C) 1994-2005 by Marc Feeley, All Rights Reserved.

(include "../lib/header.scm")

;------------------------------------------------------------------------------

(##define-macro (macro-extension-file)
  "gambcext")

(##define-macro (macro-initialization-file)
  "gambcini")

(##define-macro (interpreter-or x)
  #t)

(define-prim (##main-gsi/gsc)

  (define (process-initialization-file)

    (define (try filename)
      (##string?
       (##load filename
               (lambda (script-line script-path) #f)
               #f
               #f)))

    (or (try (macro-initialization-file))
        (let ((homedir (##path-expand "~")))
          (try (##string-append homedir (macro-initialization-file))))))

  (define (read-source-from-string str name)
    (let ((port
           (##open-input-string str)))
      (if name
        (macro-port-name-set!
         port
         (lambda (port) name)))
      (let* ((rt
              (macro-character-port-input-readtable port))
             (x
              (##read-all-as-a-begin-expr-from-port
               port
               rt
               ##wrap-datum
               ##unwrap-datum
               (macro-readtable-start-syntax rt)
               #f)))
        (##vector-ref x 1))))

  (define (interpreter-interactive-or-batch-mode arguments)
    (let loop ((lst arguments)
               (batch-mode? #f))
      (if (##pair? lst)
        (let ((file
               (##car lst))
              (rest
               (##cdr lst)))
          (if (option? file)
            (let ((option-name (convert-option file)))
              (cond ((##string=? option-name "")
                     (##repl-debug)
                     (loop rest
                           #t))
                    ((##string=? option-name "e")
                     (if (##pair? rest)
                       (let ((src (read-source-from-string
                                   (##car rest)
                                   #f)))
                         (##eval-top src ##interaction-cte)
                         (loop (##cdr rest)
                               #t))
                       (begin
                         (warn-missing-argument-for-option "e")
                         (loop rest
                               #t))))
                    (else
                     (warn-unknown-option option-name)
                     (loop rest
                           batch-mode?))))
            (let* ((starter
                    #f)
                   (script-callback
                    (lambda (script-line script-path)
                      (if script-line
                        (let ((language-and-tail
                               (##extract-language-and-tail
                                script-line)))
                          (set! starter
                            (if language-and-tail
                              (let ((language (##car language-and-tail)))
                                (##readtable-setup-for-language!
                                 ##main-readtable
                                 language)
                                (##start-main language))
                              ##exit))
                          (set! ##processed-command-line
                            (##cons script-path rest)))))))

              (##load file
                      script-callback
                      #t
                      #t)

              (if starter
                (starter)
                (loop rest
                      #t)))))
        (if (##not batch-mode?)
          (##repl-debug-main)
          (##exit)))))

  (define (compiler-batch-mode options arguments)

    (define (c-file? file)
      (##string=? (##path-extension file) ".c"))

    (let* ((opts (##map ##car options))
           (sym-opts (##map ##string->symbol opts)))

      (let loop1 ((lst arguments)
                  (nb-scheme-files 0))
        (if (##pair? lst)

          (let ((file (##car lst))
                (rest (##cdr lst)))
            (cond ((option? file)
                   (let ((option-name (convert-option file)))
                     (warn-unknown-option option-name)
                     (loop1 rest
                            (##fixnum.+ nb-scheme-files 1))))
                  ((c-file? file)
                   (loop1 rest
                          nb-scheme-files))
                  (else
                   (loop1 rest
                          (##fixnum.+ nb-scheme-files 1)))))

          (let* ((gen-c?
                  (##member "c" opts))
                 (gen-dynamic?
                  (##member "dynamic" opts))
                 (link?
                  (##not (or gen-c? gen-dynamic?)))
                 (output
                  (let ((x (##assoc "o" options)))
                    (cond ((##not x)
                           #f)
                          (gen-dynamic?
                           (warn-dynamic-object-file-and-o-option)
                           #f)
                          ((and (##not link?) (##fixnum.< 1 nb-scheme-files))
                           (warn-multiple-output-files-and-o-option)
                           #f)
                          (else
                           (##cdr x)))))
                 (pre
                  (##assoc "prelude" options))
                 (post
                  (##assoc "postlude" options))
                 (cc-options
                  (let ((x (##assoc "cc-options" options)))
                    (if x
                      (##cdr x)
                      "")))
                 (ld-options
                  (let ((x (##assoc "ld-options" options)))
                    (if x
                      (##cdr x)
                      ""))))

            (if (or pre post)
              (set! wrap-program
                (lambda (program)
                  (let ((file
                         (##container->file
                          (##locat-container
                           (##source-locat program)))))
                    (##sourcify
                     (##cons (##sourcify 'begin program)
                             (##append
                              (if pre
                                (let ((pre-src
                                       (read-source-from-string
                                        (##cdr pre)
                                        (and file
                                             (##string-append
                                              file
                                              ".prelude")))))
                                  (##list pre-src))
                                '())
                              (##cons program
                                      (if post
                                        (let ((post-src
                                               (read-source-from-string
                                                (##cdr post)
                                                (and file
                                                     (##string-append
                                                      file
                                                      ".postlude")))))
                                          (##list post-src))
                                        '()))))
                     program)))))

            (let loop2 ((lst arguments)
                        (rev-roots '()))
              (if (##pair? lst)

                (let ((file (##car lst))
                      (rest (##cdr lst)))
                  (if (option? file)
                    (loop2 rest
                           rev-roots)
                    (let ((root (##path-strip-extension file)))
                      (if (c-file? file)

                        (loop2 rest
                               (##cons root rev-roots))

                        (begin
                          (if (##fixnum.< 1 nb-scheme-files)
                            (##repl
                             (lambda (first output-port)
                               (##write-string file output-port)
                               (##write-string ":\n" output-port)
                               #t)))
                          (if (##not
                               (if gen-dynamic?
                                 (compile-file
                                  file
                                  sym-opts
                                  cc-options
                                  ld-options)
                                 (let ((out (or (and (##not link?) output)
                                                (macro-absent-obj))))
                                   (compile-file-to-c
                                    file
                                    sym-opts
                                    out))))
                              (##exit-abnormally))
                          (loop2 rest
                                 (##cons (##path-strip-directory root)
                                         rev-roots)))))))

                (let* ((flat?
                        (##member "flat" opts))
                       (base
                        (let ((x (##assoc "l" options)))
                          (cond ((##not x)
                                 #f)
                                ((or (##not link?) flat?)
                                 (warn-no-incremental-link)
                                 #f)
                                (else
                                 (##cdr x))))))

                  (if link?
                    (if (##not (##null? rev-roots))
                      (let ((roots (##reverse rev-roots)))
                        (if flat?
                          (link-flat
                           roots
                           (or output (macro-absent-obj)))
                          (link-incremental
                           roots
                           (or output (macro-absent-obj))
                           (or base (macro-absent-obj))))))
                    (if flat?
                      (warn-c-or-dynamic-and-flat)))

                  (##exit)))))))))

  (define (warn-missing-argument-for-option opt)
    (##repl
     (lambda (first output-port)
       (##write-string
        "*** WARNING -- Missing argument for option \""
        output-port)
       (##write-string opt output-port)
       (##write-string "\"\n" output-port)
       #t)))

  (define (warn-unknown-option opt)
    (##repl
     (lambda (first output-port)
       (##write-string
        "*** WARNING -- Unknown or improperly placed option: "
        output-port)
       (##write opt output-port)
       (##newline output-port)
       #t)))

  (define (warn-dynamic-object-file-and-o-option)
    (##repl
     (lambda (first output-port)
       (##write-string
        "*** WARNING -- Dynamic object file: \"o\" option ignored\n"
        output-port)
       #t)))

  (define (warn-multiple-output-files-and-o-option)
    (##repl
     (lambda (first output-port)
       (##write-string
        "*** WARNING -- Multiple output files: \"o\" option ignored\n"
        output-port)
       #t)))

  (define (warn-no-incremental-link)
    (##repl
     (lambda (first output-port)
       (##write-string
        "*** WARNING -- No incremental link: \"l\" option ignored\n"
        output-port)
       #t)))

  (define (warn-c-or-dynamic-and-flat)
    (##repl
     (lambda (first output-port)
       (##write-string
        "*** WARNING -- \"c\" or \"dynamic\" option was specified: \"flat\" option ignored\n"
        output-port)
       #t)))

  (define (option? arg)
    (and (##fixnum.< 0 (##string-length arg))
         (##char=? (##string-ref arg 0) #\-)))

  (define (convert-option arg)
    (##substring arg 1 (##string-length arg)))

  (define (split-command-line
           arguments
           options-with-no-args
           options-with-args
           cont)
    (let loop1 ((args arguments)
                (rev-options '()))
      (if (and (##pair? args)
               (option? (##car args)))

        (let ((opt (convert-option (##car args)))
              (rest (##cdr args)))
          (cond ((##member opt options-with-no-args)
                 (loop1 rest
                        (##cons (##cons opt #f) rev-options)))
                ((##member opt options-with-args)
                 (if (##pair? rest)
                   (loop1 (##cdr rest)
                          (##cons (##cons opt (##car rest)) rev-options))
                   (begin
                     (warn-missing-argument-for-option opt)
                     (loop1 rest rev-options))))
                (else
                 (cont (##reverse rev-options) args))))

        (cont (##reverse rev-options) args))))

  (let ((gambcdir (##path-expand "~~")))
    (##load (##string-append gambcdir (macro-extension-file))
            (lambda (script-line script-path) #f)
            #f
            #f))

  (let ((language-and-tail
         (##extract-language-and-tail (##car ##processed-command-line))))

    (if language-and-tail
      (let ((language (##car language-and-tail)))
        (##readtable-setup-for-language! ##main-readtable language)))

    (split-command-line
      (##cdr ##processed-command-line)
      '("f" "i")
      '()
      (lambda (main-options arguments)
        (let ((skip-initialization-file?
               (##assoc "f" main-options))
              (force-interpreter?
               (or language-and-tail
                   (##assoc "i" main-options))))
          (split-command-line
            arguments
            (if (interpreter-or force-interpreter?)
              '()
              '("c" "flat" "dynamic"
                "warnings" "verbose" "report" "expansion" "gvm"
                "check" "force" "debug" "track-scheme"))
            (if (interpreter-or force-interpreter?)
              '()
              '("o" "l" "prelude" "postlude" "cc-options" "ld-options"))
            (lambda (known-options arguments)

              (if (##not skip-initialization-file?)
                (process-initialization-file))

              (if (or (##null? arguments)
                      (interpreter-or force-interpreter?))
                (interpreter-interactive-or-batch-mode arguments)
                (compiler-batch-mode known-options arguments)))))))))

(##main-set! ##main-gsi/gsc)

(define-prim (main . args) ; predefine main procedure so scripts don't have to
  0)

(##namespace (""))
