//
//  main.swift
//
//  Created by Guy Lapalme on 2023-07-25.
//

import Foundation

// a few examples of direct calls to Block methods

//let noir = Block("***\n***\n***")
let noir = Block("*","*")
noir.print()
//let blanc = Block("   \n   \n   ")
let blanc = Block(" "," ")
blanc.print()

let noir_blanc = noir.add(right: blanc)
let blanc_noir = blanc.add(right: noir)
noir_blanc.print()
blanc_noir.print()

let ligne_pair = noir_blanc.repeating(horizontal: 4)
let ligne_impair = blanc_noir.repeating(horizontal: 4)
ligne_pair.print()
ligne_impair.print()

let bande = ligne_pair.add(bottom: ligne_impair)
let damier = bande.repeating(vertical: 4,".")
print("damier")
damier.print()

let mots = "Voici les mots à placer dans la pyramide qui devient de plus en plus longue".split(separator: " ")
let nbMots = mots.count
var iMot=1
var pyramide = Block(String(mots[0]),".",width:10)
for i in 2...10 {
    var ligne = Block(String(mots[iMot]),".",width:10)
    iMot += 1
    for _ in 0..<i {
        if (iMot>=nbMots){break}
        ligne = ligne.add(right: Block(String(mots[iMot]),".",width:10))
        iMot += 1
    }
    pyramide = pyramide.add(bottom: ligne)
    if (iMot>=nbMots){break}
}
pyramide.print()


func t(_ text:String) -> Block {
    return Block(text,".",width:10,height:3)
}

// tests with Result builder
print("Result builder")
let rb = Horiz {
    t("bonjour")
    Vert{
        t("les")
        t("bons")
    }
    t("amis")
}
print(rb)

let test=false
Vert {
    t("voici")
    if (test) {
        Horiz {
            t("les")
            t("mots")
            t("à")
        }
    } else {
        t("à")
        Horiz {
            t("placer")
            t("dans")
            t("la")
            t("pyramide")
        }
    }
    for i in 1...3 {
        t(String(i))
    }
}.print()

// now finally the real example for comparing result builder with the original
func b(_ text:String)->Block {
    Block(text,".",width: 15,height:2)
}

Block("here is\na\nlong text",".",width:10,height:3).print()

// without ResultBuilder
b("Hello\nGrüß Gott").add(
    bottom:[b("to").add(right:[b("the"),b("world")]),
            b("thank").add(right:b("you"))]).print()

// with ResultBuilder
Vert{
    b("Allo\nHello\nGuten Tag")
    Horiz {
        b("to")
        b("the")
        b("world")
    }
    Horiz {
        b("thank")
        b("you")
    }
}.print()

// Checkerboard with Result builder

let black = Block("*","*") // create a 3x3 block of 9 "*"
let white = Block(" "," ") // create a 3x3 block of 9 " "

print("with result builder")
Vert("+"){
    for i in 1..<8 {
        Horiz {
            if i%2 == 0 {
                for _ in 1...4 {black ; white}
            } else {
                for _ in 1...4 {white ; black}
            }
        }
    }
}.print()

/*
 ++++++++++++++++++++++++++
 +   ***   ***   ***   ***+
 +   ***   ***   ***   ***+
 +   ***   ***   ***   ***+
 +***   ***   ***   ***   +
 +***   ***   ***   ***   +
 +***   ***   ***   ***   +
 +   ***   ***   ***   ***+
 +   ***   ***   ***   ***+
 +   ***   ***   ***   ***+
 +***   ***   ***   ***   +
 +***   ***   ***   ***   +
 +***   ***   ***   ***   +
 +   ***   ***   ***   ***+
 +   ***   ***   ***   ***+
 +   ***   ***   ***   ***+
 +***   ***   ***   ***   +
 +***   ***   ***   ***   +
 +***   ***   ***   ***   +
 +   ***   ***   ***   ***+
 +   ***   ***   ***   ***+
 +   ***   ***   ***   ***+
 ++++++++++++++++++++++++++
*/
print("without result builder")
// without result builder
let odd_line = black.add(left: white).repeating(horizontal: 4)
let even_line = white.add(left:black).repeating(horizontal: 4)
odd_line.add(bottom: even_line).repeating(vertical: 4).border("+").print()

Vert{
    for i in 1...5 {
        Horiz {
            for j in 1...i {
                Block(String(i*(i-1)/2+j),width:4)
            }
        }
    }
}.print()

// Pascal's Triangle
// factorial
func fact(_ n:Int) -> Int{
    n == 0 ? 1 : (1...n).reduce(1,*)
}

// number of combinations of k objects within n
func C(_ n:Int,_ k:Int) -> Int{
//    fact(n)/(fact(k)*fact(n-k))
    k == 0 || k == n ? 1 : (n-k+1...n).reduce(1,*)/fact(k)
}

Vert{
    for n in 0...5 {
        Horiz {
            for k in 0...n {
                Block(String(C(n,k)),width:4)
            }
        }
    }
}.print()

/*
           1
         1   1
       1   2   1
     1   3   3   1
   1   4   6   4   1
 1   5   10  10  5   1
*/


// "backward" block stacking

func cube(_ t:String)->Block {
    Block(" "+t+" "," ")
}

cube("A").add(top:cube("B")).add(left:cube("C").add(bottom: cube(" "))).print()

// example of the document
Block("We\nlove\nSwiftUI",".").print()
Block("We\nlove\nSwiftUI")
    .add(right:Block("|").repeating(vertical: 4))
    .add(right:[Block("truly"),Block("so"," ")])
    .add(bottom:Block("very much","~",width:10))
    .border("+").print()

Vert("+") {
    Horiz {
        Block("We\nlove\nSwiftUI")
        Vert {for _ in 0..<4 {Block("|")}}
        Block("truly")
        Block("so"," ")
    }
    Block("very much","~",width:10)
}.print()
/*
 +++++++++++++++++++
 +  We   |         +
 + love  |truly so +
 +SwiftUI|         +
 +       |         +
 +  ~~~~~~~~~~~~   +
 +  ~very much ~   +
 +  ~~~~~~~~~~~~   +
 +++++++++++++++++++
 */
