//
//  ContentView.swift
//  Show-two-dice
//
//  Created by Guy Lapalme on 2023-08-11.
//

import SwiftUI

// custom view for an image over a text with a red border with padding
struct ImageNameView:View {
    let image:String          // mandatory parameter
    var name:String = "one"  // optional parameter
    var body: some View {
        VStack {
            Image(systemName:image).imageScale(.large)
            Text(name).fontWeight(.bold)
        }.padding()
         .border(.red)
    }
}

// use the custom view multiple times
struct ContentView: View {
    var body: some View {
        VStack {
            HStack {
               ImageNameView(image: "die.face.1")
               ImageNameView(image: "die.face.6",name: "six")
            }
            Text("Sweet sixteen")
        }.padding().border(.blue)
    }
}

// use the ContentView for the Preview (useful for designing)
struct ContentView_Previews: PreviewProvider {
    static var previews: some View {
        ContentView()
    }
}
