//
//  DieView.swift
//  Yahtzee
//
//  Created by Guy Lapalme on 2023-08-08.
//

import SwiftUI

@Observable class Dice_17 {
    var dice  = [Int](repeating: 0, count: 5)
    var fixed = [Bool](repeating:false, count:5)
 
    func clear_fixed(){
        for i in dice.indices {
            fixed[i] = false
            dice[i] = 0
        }
    }
    
    func roll(){
        for i in dice.indices {
            if !fixed[i] {
                dice[i] = Int.random(in: 1...6)
            }
        }
    }
}

struct DieView_17:View {
    @Binding var value:Int
    @Binding var fixed:Bool
    @Environment(SelectColor_17.self) var selectColor:SelectColor_17
    
    var body: some View {
        Image(systemName:value==0 ? "squareshape" :("die.face."+String(value)))
            .resizable()
            .aspectRatio(contentMode: .fit)
            .frame(width: 50, height: 50)
            .background(fixed ? selectColor.color : .clear)
            .onTapGesture {fixed.toggle()}
    }
}

struct DiceView_17:View {
    @State var dice:Dice_17
    
    var body: some View {
        ForEach (dice.dice.indices,id: \.self) {i in
            DieView_17(value: $dice.dice[i],fixed: $dice.fixed[i])
        }
    }
}

