//
//  SectionView.swift
//  Yahtzee
//
//  Created by Guy Lapalme on 2023-08-08.
//

import SwiftUI

@Observable class Section_17 {
    var names:[String]
    var scores:[Int] = []
    var selected:[Bool] = []
    
    init(_ names:[String]){
        self.names = names
        self.init_scores()
     }
    
    func init_scores(){
        scores = [Int](repeating: -1, count: names.count)
        selected = [Bool](repeating: false, count: names.count)
    }
    
    func clear_unselected(){
        for i in selected.indices {
            if !selected[i] {
                scores[i] = -1
            }
        }
    }
        
    func set_scores(values:[Int]){
        for i in values.indices {
            if !selected[i] {
                scores[i]=values[i]
            }
        }
    }
    
    func all_selected()->Bool {
        selected.allSatisfy {$0}
    }
    
    func any_selected()->Bool{  // for debugging end of game
        selected.contains(true)
    }
    
    func total() -> Int {
        zip(selected,scores).filter{$0.0}.map{$1}.reduce(0,+)
    }
}

struct CategoryView_17:View {
    var kind:String
    @Binding var score:Int
    var body: some View {
        HStack{
            Text(kind)
            Spacer()
            Text(score<0 ? "—" : String(score))
        }
        .padding(.horizontal)
        .font(.title2)
    }
}

struct SectionView_17:View {
    @State var section:Section_17
    let action:()->Void // call back on parent...
    @Environment(SelectColor_17.self) var selectColor:SelectColor_17

    var body: some View {
        VStack{
            ForEach(section.names.indices,id: \.self) {
                i in CategoryView_17(kind:section.names[i], score: $section.scores[i])
                    .background(section.selected[i] ? selectColor.color : .clear)
                    .onTapGesture {
                        if !section.selected[i]{
                            section.selected[i] = true
                            action()
                        }
                    }
            }
        }.padding(.vertical).border(.black)
    }
}

