//
//  DieView.swift
//  Yahtzee
//
//  Created by Guy Lapalme on 2023-08-08.
//

import SwiftUI

class Dice:ObservableObject {
    @Published var dice  = [Int](repeating: 0, count: 5)
    @Published var fixed = [Bool](repeating:false, count:5)
 
    func clear_fixed(){
        for i in dice.indices {
            fixed[i] = false
            dice[i] = 0
        }
    }
    
    func roll(){
        for i in dice.indices {
            if !fixed[i] {
                dice[i] = Int.random(in: 1...6)
            }
        }
    }
}

struct DieView:View {
    @Binding var value:Int
    @Binding var fixed:Bool
    @EnvironmentObject var selectColor:SelectColor
    
    var body: some View {
        Image(systemName:value==0 ? "squareshape"
                                  :("die.face."+String(value)))
            .resizable()
            .aspectRatio(contentMode: .fit)
            .frame(width: 50, height: 50)
            .background(fixed ? selectColor.color : .clear)
            .onTapGesture {fixed.toggle()}
    }
}

struct DiceView:View {
    @ObservedObject var dice:Dice
    
    var body: some View {
        ForEach (dice.dice.indices,id: \.self) {i in
            DieView(value: $dice.dice[i],fixed: $dice.fixed[i])
        }
    }
}

