//
//  score.swift
//  Yahtzee
//
//  Created by Guy Lapalme on 2023-08-08.
//

import Foundation

//    Table taken from
//       Optimal Solitaire Yahtzee Strategies, Tom Verhoeff,2000
//
//    Category        |Condition     | Score
//    -----------------------------------------
//    Aces            | —            | sum 1s
//    Twos            | —            | sum 2s
//    Threes          | —            | sum 3s
//    Fours           | —            | sum 4s
//    Fives           | —            | sum 5s
//    Sixes           | —            | sum 6s
//    Upper Sec Bonus | U.S.Tot ≥ 63 | 35 once
//    Three of a Kind | ≥ 3 equals   | sum values
//    Four of a Kind  | ≥ 4 equals∗  | sum values
//    Full House      | 2+3 equals   | 25
//    Small Straight  | ≥ 4 in seq.∗ | 30
//    Large Straight  | 5 in seq.∗   | 40
//    Yahtzee         | 5 equals     | 50
//    Chance          | —            | sum values
//    Extra Y. Bonus  | 5 equals &
//                    |  50 at Y.    | 100 each
//    GRAND TOTAL     | —            | sum above
//

func yathzeeScores(dice:[Int])->([Int],[Int]) {
    func sum_values()->Int {
        (1...6).reduce(0){acc,i in acc+i*nbDice[i]}
    }
    // compute number of dice of each value
    var nbDice = [Int](repeating: 0, count: 7) // add dummy 0 at the start
    for i in 0..<5 {nbDice[dice[i]] += 1}
    // compute scores for upper section
    var upper_scores:[Int] = []
    for i in 1..<nbDice.count {
        upper_scores.append(nbDice[i]*i)
    }
    // compute scores for lower section
    var lower_scores:[Int] = [Int](repeating: 0, count: 7)
    if nbDice.lastIndex(where: {$0==3}) != nil {
        lower_scores[0] = sum_values() // three of a kind
    }
    if nbDice.lastIndex(where: {$0==4}) != nil {
        lower_scores[1] = sum_values()  // four of a kind
        // can also be considered as a three of a kind
        lower_scores[0] = sum_values()
    }
    if nbDice.contains(where: {$0==3}) && nbDice.contains(where: {$0==2}){
        lower_scores[2] = 25 // full house
    }
    let k = nbDice.firstIndex(where: {$0 != 0})! // index of first non-zero
    let straight_l = (nbDice[k...].firstIndex(where: {$0 == 0}) ?? 7)-k // length
    if straight_l >= 4 {
        lower_scores[3] = 30 // small straight
        if straight_l==5 {
            lower_scores[4] = 40 // large straight
        }
    }
    if nbDice.lastIndex(where: {$0==5}) != nil{
        lower_scores[5] = 50 // Yahtzee
        // can also be considered as a three or a four of a kind
        lower_scores[0] = sum_values()
        lower_scores[1] = sum_values()
    }
    lower_scores[6] = sum_values()    // chance
    return (upper_scores,lower_scores)
}
