/**
        * Ce programme sert  montrer l'hritage
        * en Java

        * @author Mohamed Lokbani (ide de dpart Decker & Hishfield: programming.java)

        * @version 1.2
*/



import java.awt.*;
import java.awt.Point;
import java.applet.Applet;


/**
   Classe: Dessine
   Description: Dessine est une interface qui contient la mthode abstraite "dessine".
*/

interface Dessine {

    /**
       Mthode: dessine
       mthode abstraite
       @param g Un graphique
    */
    public void dessine(Graphics g);

}

/**
   Classe: ObjetGeom
   Description: la classe "ObjetGeom" abstraite, elle permet de manipuler un
   objet gomtrique donn.
*/



abstract class ObjetGeom {

    // Un Point reprr par ses coordonnes x,y
    protected Point lepoint;
    // les dimensions d'un "objet" largeur + hauteur
    protected Dimension dimension;

    /**
       Mthode: deplace
       mthode permettant de dplacer la position d'un Point.
       @param x : coordonne X
       @param y : coordonne Y
    */

    public void deplace(int x, int y) {
	lepoint.x = x;
	lepoint.y = y;
    }


    /**
       Mthode: superficie
       mthode abstraite permettant de calculer la superficie d'une figure
       @return a <code>double</code> la valeur de la superficie
    */
    abstract public double superficie();

}

/**
   Classe: Rect
   Description: la classe "Rect" hrite des proprits de la classe "ObjetGeom" et elle implmante
   la mthode "dessine" se trouvant dans l'interface "Dessine".
*/

class Rect extends ObjetGeom implements Dessine {

    /**
       Mthode: constructeur Rect
       @param x : coordonne X
       @param Y : coordonne Y
       @param diml : largeur
       @param dimh : hauteur
    */ 
    Rect(int x, int y, int diml, int dimh) {
	super.lepoint = new Point(x,y);
	super.dimension = new Dimension(diml,dimh);
    }

    /**
       Mthode: superficie
       definition de la "superficie" mthode abstraite de la classe "ObjetGeom"
       @return a <code>double</code> la superficie de la figure
    */     
    public double superficie() {
	return (double) (dimension.width * dimension.height);
    }

    /**
       Mthode: dessine
       definition de "dessine" mthode abstraite de l'interface "Dessine"
       Elle permet de dessiner un rectangle  la position dfinie par "lepoint"
       et d'une dimension dfinie par "dimension".
       @param g Un graphique
    */

    public void dessine(Graphics g) {
	g.drawRect(lepoint.x,lepoint.y,dimension.width,dimension.height);
    }
}

/**
   Classe: drawRect
   Description: la classe "drawRect" est une applet. Elle hrite des proprits
   de la classe "java.applet.Applet".

*/


public class drawRect extends java.applet.Applet {

    /**
       Mthode: paint
       permet de dessiner un "graphic".
       @param g Un graphique
    */

    public void paint(Graphics g) {

	Rect unRect = new Rect(10,20,100,140);

	unRect.dessine(g);
    }
}




