/**
        * Ce programme sert  montrer le polymorphisme
        * en Java

        * @author Claude Delannoy (Programmer en Java)
        * @author Mohamed Lokbani (commentaires + quelques ajustements)

        * @version 1.2
*/



/**
   Classe Point
   Elle permet d'afficher les coordonnes d'un
   point et d'identifier que l'objet qui fait
   l'appel est un point.
*/

class Point {

    private int x,y;

    /**
      Constructeur pour construire un Point
      @param x : coordonne x
      @param y : coordonne y
    */

      
    public Point (int x, int y){
	this.x = x;
	this.y = y;
    }

    /**
      Mthode permettant d'afficher que nous
      avons  faire  un Point, et nous informe
      des coordonnes de ce Point, dans l'espace
      x,y.
    */
   

    public void affiche() {
	identifie();
	System.out.println(" Mes coordonnes sont : " + x + " " + y);
    }


   /**
      Mthode permettant d'identifier que l'objet
      qui fait l'appel est un Point.
    */
   

    public void identifie() {
	System.out.println("Je suis un point ");
    }

}

/**
   Classe Pointcol
   Elle reprsente un Point color.

   quelques points  retenir ...

   - Pointcol hrite les mthodes de la classe Point:
   affiche et identifie.

   - on va quand mme redfinir la mthode identifie
   de ce fait la mthode identifie de la classe de
   base va tre masque (ne sera plus accssible
    partir de la classe drive).

   - on ne dfinit pas la mthode affiche, nous allons
   donc utiliser celle de la classe de base, en cas
   d'appel.

   - les membres x et y de la classe Point ne sont
   pas accssibles de la classe Pointcol car ils
   sont "private" dans la classe de base Point.


*/


class Pointcol extends Point {

    
    private byte couleur;


    /**
      Constructeur pour construire un Point color
      @param x : coordonne x
      @param y : coordonne y
      @param couleur : la couleur du Point

    */


    public Pointcol (int x, int y,byte couleur){
	// appel du constructeur de la classe de base
	super(x,y);
	// initilise les champs donnes de la classe
	// drive
	this.couleur = couleur;
    }

    /**
      Mthode permettant d'identifier que l'objet
      qui fait l'appel est un Point color.
    */

    public void identifie() {
	System.out.println("Je suis un point color de couleur " + couleur);
    }
}

public class exo1 {

    public static void main (String args[]){

	// on instancie un tableau de Point.

	Point [] tabPts = new Point[4];
	
	// on affecte  ce tableau des rfrences
	//  des objets de type Point et Pointcol

	tabPts[0] = new Point(0,2);
	tabPts[1] = new Pointcol(1,5,(byte)3);
	tabPts[2] = new Pointcol(2,8,(byte)9);
	tabPts[3] = new Point(1,2);
	
	/*
	  on fait appel  "affiche" ... nous sommes en prsence
	  d'une seule mthode "affiche" dfinie dans la classe
	  Point. Pour la classe Pointcol elle va hriter cette
	  mthode, de ce fait elle aura elle aussi accs.

	  Quand est-il pour "identifie" qui a t redfinie
	  dans la classe drive (Pointcol)?

	  Polymorphisme:
	  Mme message envoy  deux objets diffrents, provoque
	  des rponses diffrentes!

	  
	  tabPts[0] & tabPts[3] font rfrence  des objets
	  de type Point ; alors que tabPts[1] & tabPts[2] font
	  rfrence  des objets de type Pointcol, et les
	  4 objets vont appeler la mthode "affiche" qui contient
	  un appel  la mthode "identifie":

	  Pour tabPts[0] & tabPts[3] c'est la mthode "identifie"
	  de Point qui va tre appele, alors que pour tabPts[1]
	  & tabPts[2] c'est la mthode "identifie" de Pointcol
	  qui sera appele, cela est d  la notion de polymorphisme.

	  Le choix de la mthode se fait donc  l'excution et non
	  pas  la compilation.

	*/

	for (int i=0; i<tabPts.length;i++)
	    tabPts[i].affiche();

	System.exit(0);


    }

}



/*

===>inclure jdk

===>java exo1

Je suis un point
 Mes coordonnes sont : 0 2
Je suis un point color de couleur 3
 Mes coordonnes sont : 1 5
Je suis un point color de couleur 9
 Mes coordonnes sont : 2 8
Je suis un point
 Mes coordonnes sont : 1 2                    

*/
