/*
 * ====================================================================
 * Copyright (c) 1995-2000 Purple Technology, Inc. All rights
 * reserved.
 * 
 * PLAIN LANGUAGE LICENSE: Do whatever you like with this code, free
 * of charge, just give credit where credit is due. If you improve it,
 * please send your improvements to code@purpletech.com. Check
 * http://www.purpletech.com/code/ for the latest version and news.
 *
 * LEGAL LANGUAGE LICENSE: Redistribution and use in source and binary
 * forms, with or without modification, are permitted provided that
 * the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided
 * with the distribution.
 *
 * 3. The names of the authors and the names "Purple Technology,"
 * "Purple Server" and "Purple Chat" must not be used to endorse or
 * promote products derived from this software without prior written
 * permission. For written permission, please contact
 * server@purpletech.com.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND PURPLE TECHNOLOGY ``AS
 * IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * AUTHORS OR PURPLE TECHNOLOGY BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ====================================================================
 *
 **/



import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;


/**
 * M.Lokbani (25 Novembre 2001)
 * Le texte original accompagnant ce fichier est en anglais et se trouve
 *  cette adresse url (C'est  lire):
 *
 * http://www.purpletech.com:8080/code/src/com/purpletech/servlets/CookieDetector.java
 *
 * Essayez en activant/dsactivant l'option des cookies.
 *
 * 
 * Cette servlet peut renvoyer le client vers une URL parmi un choix de
 * deux (URLs) en fonction de l'option cookies: si elle est activ (ou
 * bien le client accepte les cookies) ou pas (ou bien le client refuse
 * les cookies). La seconde URL envoie un message du genre "acceptez les
 * cookies de mon site, sinon il vous sera difficile de naviguer correctement
 * sur les pages web de mon site". 
 *
 * Les vnements vont avoir lieu comme suit: 
 *
 *     Le client invoque la servlet 
 *     La servlet dpose un cookie chez le client 
 *     La servlet pointe le client vers lui mme avec un volet (flag) du style "ceci est la phase de test" 
 *     La phase de test dtecte si
 *           Le client accepte les cookies 
 *           Le client refuse les cookies ou bien le navigateur ne supporte pas les cookies 
 *     En fonction du rsultat la servlet renvoie le client vers la page approprie 
 **/


public class CookieDetector extends HttpServlet {

    String probeName = "CookieDetector.probe";
    
    public void doGet(HttpServletRequest req, HttpServletResponse res)
	throws IOException, ServletException
    {
	log("doGet");
	Cookie cookie;
	int port = req.getServerPort();
	String self = req.getScheme() + "://" + req.getServerName() +
	    (port == 80 ? "" : ":"+port) + req.getServletPath();
	log("self = " + self);
	String phase = req.getParameter("phase");
	log("phase = " + phase);
	if (phase == null) {
	    cookie = new Cookie(probeName, req.getServletPath());
	    cookie.setComment("Will this get dropped?");
	    cookie.setMaxAge(-1);
	    //	   cookie.setPath(req.getServletPath());
	    res.addCookie(cookie);
	    res.sendRedirect( self + "?phase=check" );
	}
	else if (phase.equals("check")) {
	    Cookie[] cookies = req.getCookies();
	    boolean hasCookies = false;
	    if (cookies != null) {
		for (int i = 0; i < cookies.length; i++) {
		    log("cookie " + cookies[i].getName() + "=" + cookies[i].getValue());
		    if (cookies [i].getName ().equals (probeName)) {
			if (cookies[i].getValue().equals(req.getServletPath()))
			{
			    hasCookies = true;
			    break;
			}
		    }
		}
	    }
	    String where;
	    String message = "";
	    if (hasCookies) {
		where = getInitParameter("urlCookies");
		if (where == null || where.equals("")) {
		    where = null;
		    message = "Client allows cookies";
		}
	    }
	    else {
		where = getInitParameter("urlNoCookies");
		if (where == null || where.equals("")) {
		    where = null;
		    message = "Client does not allow cookies";
		}		
	    }
	    if (where == null) {
		res.setContentType("text/plain");
		res.getWriter().println(message);
	    }
	    else {
		res.sendRedirect(where);
	    }
	}
    }
}

