//------------------------------------------------------
// module  : Chrono.h
// auteur  : 
// date    : dc. 2000
// version : 1.0
// langage : C++
// modifi : 30/03/02
// doc     : 
// rf.    :  
//------------------------------------------------------

#ifndef UTILITIES_H
#define UTILITIES_H

#include <sys/timeb.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <stdio.h>

using namespace std;

#define MSEC   0
#define SECOND 1
#define MINUTE 2
#define HOUR   3
#define DAY    4

class Chrono
{
 public:
  Chrono();
  void reset();
  int elapsed(short = MSEC);
  int lastelapsed(short = MSEC);
  void print(short = MSEC);
  void fprint(char*,short = MSEC);

 private:
  timeb Start;
  timeb FstLap;
  timeb SecLap;
  int lastdifference;

};

inline Chrono::Chrono()
{
  reset();
}

inline void 
Chrono::reset()
{
  ftime(&Start);
  FstLap = Start;
  lastdifference = 0;
}

inline int 
Chrono::elapsed(short unit)
{
  int calcdiff, temp;

  ftime(&FstLap);
  // difference between Start and FirstLap 
  calcdiff = (1000 *(int)difftime(FstLap.time, Start.time))
    + (FstLap.millitm - Start.millitm);

  switch (unit)
    {
    case MSEC:
      temp = calcdiff;
      break;
    case SECOND:
      temp = calcdiff/1000;
      break;
    case MINUTE:
      temp = calcdiff/60000;
      break;
    case HOUR:
      temp = calcdiff/3600000;
      break;
    case DAY:
      temp = calcdiff/86400000;
      break;
    default:  //MSEC
      temp = calcdiff;
      break;
    }

  lastdifference = calcdiff;
  return temp;
}

inline int 
Chrono::lastelapsed(short unit)
{
  int calcdiff, temp;

  ftime(&SecLap);
  // difference between FirstLap and the SecondLap 
  calcdiff = (1000 *(int)difftime(SecLap.time, FstLap.time))
           + (SecLap.millitm - FstLap.millitm);

  switch (unit)
    {
    case MSEC:
      temp = calcdiff;
      break;
    case SECOND:
      temp = calcdiff/1000;
      break;
    case MINUTE:
      temp = calcdiff/60000;
      break;
    case HOUR:
      temp = calcdiff/3600000;
      break;
    case DAY:
      temp = calcdiff/86400000;
      break;
    default:  //MSEC
      temp = calcdiff;
      break;
    }

  lastdifference = calcdiff;
  // Initialize the FstLap value for next time use. 
  FstLap = SecLap;
  return temp;
}

inline void 
Chrono::print(short unit)
{
  int day, hour, minute, second, msec;

  cout << " > Elapsed Time: ";
  day = lastdifference/86400000;
  if (day > 0 || unit == DAY)
    cout << day << " day, ";
  if (unit == DAY)
    return;

  hour = (lastdifference - (day*86400000))/3600000;
  if (day > 0 || hour > 0 || unit == HOUR)
    cout << hour << " hours, ";
  if (unit == HOUR)
    return;

  minute = (lastdifference - (day*86400000 +hour*3600000))/60000;
  if (day > 0 || hour > 0 || minute > 0 || unit == MINUTE)
    cout << minute << " minutes, ";
  if (unit == MINUTE)
    return;

  second = (lastdifference - (day*86400000 +hour*3600000 +minute *60000))/1000;
  if (day > 0 || hour > 0 || minute > 0 || second > 0 || unit == SECOND)
    cout << second << " seconds, ";
  if (unit == SECOND)
    return;

  msec = lastdifference % 1000;
  cout << msec << " msecs, ";

  cout << endl;
}

inline void 
Chrono::fprint(char* buff, short unit)
{
  int day, hour, minute, second, msec;
  char buftmp[1000];

  strcpy(buff,"\n > Elapsed Time: ");
  day = lastdifference/86400000;
  if (day > 0 || unit == DAY) { sprintf(buftmp," %d days ",day); strcat(buff,buftmp); }
  if (unit == DAY)
    return;

  hour = (lastdifference - (day*86400000))/3600000;
  if (day > 0 || hour > 0 || unit == HOUR) { sprintf(buftmp," %d hours ", hour); strcat(buff,buftmp); }
  if (unit == HOUR)
    return;

  minute = (lastdifference - (day*86400000 +hour*3600000))/60000;
  if (day > 0 || hour > 0 || minute > 0 || unit == MINUTE) { sprintf(buftmp," %d minutes ", minute); strcat(buff,buftmp); }
  if (unit == MINUTE)
    return;

  second = (lastdifference - (day*86400000 +hour*3600000 +minute *60000))/1000;
  if (day > 0 || hour > 0 || minute > 0 || second > 0 || unit == SECOND) { sprintf(buftmp," %d seconds ", second); strcat(buff,buftmp); }
  if (unit == SECOND)
    return;

  msec = lastdifference % 1000;
  sprintf(buftmp," %d msecs \n", msec); 
  strcat(buff,buftmp);
}

#endif

