/***********************************************/
/***********************************************/
/* module  : algorithme EstimMixtDist.cc       */
/***********************************************/
/***********************************************/

/********************************************/
/*FICHIERS INCLUS                           */
/********************************************/
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/resource.h>

#include "EstimMixtDist.h"

/********************************************/
/*DEFINITIONS                               */
/********************************************/
float*   fmatrix_allocate_1d(int);
float**  fmatrix_allocate_2d(int,int);

/********************************************/
/*VARIABLES GLOBALES                        */
/********************************************/
char Name_img[NCHAR];
int nbclass;
int method;
int myseed;
int minsizeregion;
float ThetaPar;
int FlgSeg;

//-------------------------
//--- Windows -------------
//-------------------------
#include <X11/Xutil.h>

Display   *display;
int	  screen_num;
int 	  depth;
Window	  root;
Visual*	  visual;
GC	  gc;

/************************************************************************/
/* OPEN_DISPLAY()							*/
/************************************************************************/
int open_display()
{
  if ((display=XOpenDisplay(NULL))==NULL)
   { printf("Connection impossible\n");
     return(-1); }

  else
   { screen_num=DefaultScreen(display);
     visual=DefaultVisual(display,screen_num);
     depth=DefaultDepth(display,screen_num);
     root=RootWindow(display,screen_num);
     return 0; }
}

/************************************************************************/
/* FABRIQUE_WINDOW()							*/
/* Cette fonction crée une fenetre X et l'affiche à l'écran.	        */
/************************************************************************/
Window fabrique_window(char *nom_fen,int x,int y,int width,int height,int zoom)
{
  Window                 win;
  XSizeHints      size_hints;
  XWMHints          wm_hints;
  XClassHint     class_hints;
  XTextProperty  windowName, iconName;

  char *name=nom_fen;

  if(zoom<0) { width/=-zoom; height/=-zoom; }
  if(zoom>0) { width*=zoom;  height*=zoom;  }

  win=XCreateSimpleWindow(display,root,x,y,width,height,1,0,255);

  size_hints.flags=PPosition|PSize|PMinSize;
  size_hints.min_width=width;
  size_hints.min_height=height;

  XStringListToTextProperty(&name,1,&windowName);
  XStringListToTextProperty(&name,1,&iconName);
  wm_hints.initial_state=NormalState;
  wm_hints.input=True;
  wm_hints.flags=StateHint|InputHint;
  class_hints.res_name=nom_fen;
  class_hints.res_class=nom_fen;

  XSetWMProperties(display,win,&windowName,&iconName,
                   NULL,0,&size_hints,&wm_hints,&class_hints);

  gc=XCreateGC(display,win,0,NULL);

  XSelectInput(display,win,ExposureMask|KeyPressMask|ButtonPressMask| 
               ButtonReleaseMask|ButtonMotionMask|PointerMotionHintMask| 
               StructureNotifyMask);

  XMapWindow(display,win);
  return(win);
}

/****************************************************************************/
/* CREE_XIMAGE()							    */
/* Crée une XImage à partir d'un tableau de float                           */
/* L'image peut subir un zoom.						    */
/****************************************************************************/
XImage* cree_Ximage(float** mat,int z,int length,int width)
{
  int lgth,wdth,lig,col,zoom_col,zoom_lig;
  float somme;
  unsigned char	 pix;
  unsigned char* dat;
  XImage* imageX;

  /*Zoom positiv*/
  /*------------*/
  if (z>0)
  {
   lgth=length*z;
   wdth=width*z;

   dat=(unsigned char*)malloc(lgth*(wdth*4)*sizeof(unsigned char));
   if (dat==NULL)
      { printf("Impossible d'allouer de la memoire.");
        exit(-1); }

  for(lig=0;lig<lgth;lig=lig+z) for(col=0;col<wdth;col=col+z)
   { 
    pix=(unsigned char)mat[lig/z][col/z];
    for(zoom_lig=0;zoom_lig<z;zoom_lig++) for(zoom_col=0;zoom_col<z;zoom_col++)
      { 
       dat[((lig+zoom_lig)*wdth*4)+((4*(col+zoom_col))+0)]=pix;
       dat[((lig+zoom_lig)*wdth*4)+((4*(col+zoom_col))+1)]=pix;
       dat[((lig+zoom_lig)*wdth*4)+((4*(col+zoom_col))+2)]=pix;
       dat[((lig+zoom_lig)*wdth*4)+((4*(col+zoom_col))+3)]=pix; 
       }
    }
  } /*--------------------------------------------------------*/

  /*Zoom negatif*/
  /*------------*/
  else
  {
   z=-z;
   lgth=(length/z);
   wdth=(width/z);

   dat=(unsigned char*)malloc(lgth*(wdth*4)*sizeof(unsigned char));
   if (dat==NULL)
      { printf("Impossible d'allouer de la memoire.");
        exit(-1); }

  for(lig=0;lig<(lgth*z);lig=lig+z) for(col=0;col<(wdth*z);col=col+z)
   {  
    somme=0.0;
    for(zoom_lig=0;zoom_lig<z;zoom_lig++) for(zoom_col=0;zoom_col<z;zoom_col++)
     somme+=mat[lig+zoom_lig][col+zoom_col];
           
     somme/=(z*z);    
     dat[((lig/z)*wdth*4)+((4*(col/z))+0)]=(unsigned char)somme;
     dat[((lig/z)*wdth*4)+((4*(col/z))+1)]=(unsigned char)somme;
     dat[((lig/z)*wdth*4)+((4*(col/z))+2)]=(unsigned char)somme;
     dat[((lig/z)*wdth*4)+((4*(col/z))+3)]=(unsigned char)somme; 
   }
  } /*--------------------------------------------------------*/

  imageX=XCreateImage(display,visual,depth,ZPixmap,0,(char*)dat,wdth,lgth,16,wdth*4);
  return (imageX);
}


//--------------------//
//-- LOAD/SAVE/FILE --//
//--------------------//
void GetLengthWidth(char*,int*,int*);
void load_image_pgm(char*,float**,int,int);
void SaveImagePgm(char*,float**,int,int);


//----------------------------------------------------------
// Get Length and Width
//----------------------------------------------------------
void GetLengthWidth(char* path,int* length,int* width)
{
 unsigned char var;
 int   temp;
 char* tempc;
 char stringTmp1[100];
 char stringTmp2[100];
 int ta1,ta2;
 FILE *fic;

  //ouverture du fichier
  fic=fopen(path,"r");
  if (fic==NULL)
    { printf("\n- Grave erreur a l'ouverture de %s -\n",path);
      exit(-1); }

  //recuperation de l'entete
  tempc=fgets(stringTmp1,100,fic);
  for(;;) { temp=fread(&var,1,1,fic); if (var==35) tempc=fgets(stringTmp2,100,fic);
            else break; }
  fseek(fic,-1,SEEK_CUR);
  temp=fscanf(fic,"%d %d",&ta1,&ta2);
   
  //enregistrement
  (*length)=ta2; 
  (*width)=ta1;

  //fermeture du fichier
  //printf("(ack=%d%s)",temp,tempc);
  tempc++;
  printf("(ack=%d)",temp);
  fclose(fic);
}

/*----------------------------------------------------------*/
/* Sauvegarde de l'image de nom <name> au format pgm        */
/*----------------------------------------------------------*/
void SaveImagePgm(char* name,float** mat,int length,int width)
 {
  int i,j;
  char buff[NCHAR];
  FILE* fic;
  time_t tm;

  /*--extension--*/
  strcpy(buff,name);
  strcat(buff,".pgm");

  /*--ouverture fichier--*/
  fic=fopen(buff,"w");
    if (fic==NULL) 
        { printf(" Probleme dans la sauvegarde de %s",buff); 
          exit(-1); }
  printf("\n Sauvegarde de %s au format pgm\n",name);

  /*--sauvegarde de l'entete--*/
  fprintf(fic,"P5");
  if (ctime(&tm)==NULL) fprintf(fic,"\n#\n");
  else fprintf(fic,"\n# IMG Module, %s",ctime(&tm));
  fprintf(fic,"%d %d",width,length);
  fprintf(fic,"\n255\n");

  /*--enregistrement--*/
     for(i=0;i<length;i++)
      for(j=0;j<width;j++) 
        fprintf(fic,"%c",(char)mat[i][j]);
   
  /*--fermeture fichier--*/
   fclose(fic); 
 } 

//----------------------------------------------------------
// Chargement de l'image de nom <name> (en pgm)             
//----------------------------------------------------------
void load_image_pgm(char* path,float** img,int lgth,int wdth)
 {
  int i,j;
  char* tempc;
  unsigned char var;
  char header[100];
  char* ptr;
  int ta;
  FILE *fic;

  //enregistrement du chemin;
   if (strstr(path,".pgm")==NULL) strcat(path,".pgm");

   //ouverture du fichier
  fic=fopen(path,"r");
  if (fic==NULL) 
   { printf("\n ->> Grave erreur a l'ouverture de %s -\n",path);
     exit(-1); }

  tempc=fgets(header,100,fic);
  if ( (header[0]!=80) ||    /* 'P' */
       (header[1]!=53) ) {   /* '5' */
       fprintf(stderr,"Image %s is not PGM.\n",path);
       exit(1); }

  tempc=fgets(header,100,fic);
  while(header[0]=='#') tempc=fgets(header,100,fic);
 
  ta=strtol(header,&ptr,0);
  ta=atoi(ptr);
  tempc=fgets(header,100,fic);
  ta=strtol(header,&ptr,0);
   
  //chargement dans la matrice
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)  
    { ta=(int)fread(&var,1,1,fic);
      img[i][j]=(int)var; }

  //fermeture du fichier
  //printf("(ack=%d%s)",ta,tempc);
  tempc++;
  printf("(ack=%d)",ta);
  fclose(fic);
 }

/*----------------------------------------------------------*/
/* Recal                                                    */
/*----------------------------------------------------------*/
void Recal(float** mat,int lgth,int wdth)
{
 int i,j;
 float max,min;

 /*Initialisation*/
 min=mat[0][0];

 /*Recherche du min*/
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    if (mat[i][j]<min) min=mat[i][j];

 /*plus min*/
   for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    mat[i][j]-=min;

   max=mat[0][0];
 /*Recherche du max*/
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) 
    if (mat[i][j]>max) max=mat[i][j];

 /*Recalibre la matrice*/
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
   mat[i][j]*=(GREY_LEVEL/max);      
}

//----------------------------------------------------------
// calcule le nombre de differences a chaque iteration
//----------------------------------------------------------
float Difference(float** pmatl1,float** pmatl2,int lgth,int wdth)
{
 int i,j;
 float chgt=0;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
 if ((pmatl1[i][j])!=(pmatl2[i][j])) chgt++;   

 chgt/=(lgth*wdth);
 return chgt;
}

//----------------------------------------------------------
// calcule le nombre de differences a chaque iteration
//----------------------------------------------------------
float DifferenceP(float** pmatl1,float** pmatl2,int lgth,int wdth)
{
 int i,j,k,l;
 long int chgt=0;
 float chgtP=0.0;
 int SUB=4;

 for(i=0;i<lgth;i+=SUB) for(j=0;j<wdth;j+=SUB)
 for(k=0;k<lgth;k+=SUB) for(l=0;l<wdth;l+=SUB)
    { if (((pmatl1[i][j])==(pmatl1[k][l])) && ((pmatl2[i][j])==(pmatl2[k][l]))) continue;
      if (((pmatl1[i][j])!=(pmatl1[k][l])) && ((pmatl2[i][j])!=(pmatl2[k][l]))) continue;
      else chgt++; }

 chgtP=(float)chgt/(CARRE((lgth*wdth)/CARRE(SUB)));
 return chgtP;
}

//----------------------------------------------------------
// calcule le nombre de differences a chaque iteration
//----------------------------------------------------------
void CreateGroundTruth(float** img,int lgth,int wdth)
{
 int i,j;
 for(i=0;i<(lgth/2);i++)  for(j=0;j<(wdth/2);j++) img[i][j]=0;
 for(i=(lgth/2);i<lgth;i++) for(j=0;j<(wdth/2);j++) img[i][j]=1;
 for(i=0;i<(lgth/2);i++)  for(j=(wdth/2);j<wdth;j++) img[i][j]=2; 
 for(i=(lgth/2);i<lgth;i++) for(j=(wdth/2);j<wdth;j++) img[i][j]=3; 
}

/*********************************************************/
/* enregistre les arguments de la ligne de commande      */
/*********************************************************/
void read_arguments(int argc,char** argv)
  {
   int i;

   if (argc<2)
      { printf("\n Usage [fichier d'entree] -[options]"); 
        printf("\n les options sont (# nombre),valeurs par defaut montre dans ()");
        printf("\n -c # nombre de classe (4)");
        printf("\n -m # methode Estimation   >> 0:Kmean  1:EM   2:SEM  3:ECI");
        printf("\n -s # methode Segmentation >> 1:ICM   2:ICM_stoch   3:MPM   4:SMAP");
	printf("\n -r # elimine petite region de taille # (%d)",MIN_SIZE_REGION);
        printf("\n -e # valeur de la seed (0)");
        printf("\n -t # valeur de Theta (Smap) (%.4f)",ThetaPar);
        printf("\n\n Exemple: %s ImgSynth_500.pgm -c 4 -s 1",argv[0]);
        printf("\n Exemple: %s ImgSynth_2000.pgm -c 4 -m 1 -s 1",argv[0]);
        printf("\n Exemple: %s ImgSynth_3000.pgm -c 4 -m 2 -s 2",argv[0]);
	printf("\n Exemple: %s ImgSynth_3000.pgm -c 4 -m 2 -s 4",argv[0]);
	printf("\n Exemple: %s ImgSynth_3000.pgm -c 4 -m 2 -s 4 -r 6",argv[0]);
	printf("\n");
	printf("\n Exemple Image Non Carre");
	printf("\n Exemple: %s ImgSynth_3000_NS.pgm -c 4 -s 1",argv[0]);
        printf("\n Exemple: %s ImgSynth_3000_NS.pgm -c 4 -m 1 -s 1",argv[0]);
        printf("\n Exemple: %s ImgSynth_3000_NS.pgm -c 4 -m 2 -s 2",argv[0]);
	printf("\n Exemple: %s ImgSynth_3000_NS.pgm -c 4 -m 2 -s 4",argv[0]);
        printf("\n Exemple: %s ImgSynth_3000_NS.pgm -c 4 -m 0 -s 4",argv[0]);
	printf("\n Exemple: %s ImgSynth_3000_NS.pgm -c 4 -m 2 -s 4 -r 6",argv[0]);
        printf("\n Exemple: %s ImgSynth_3000_NS.pgm -c 4 -m 2 -s 4 -r 6",argv[0]);	
        printf("\n\n\n");
        exit(-1); }

   strcpy(Name_img,argv[1]);
   for(i=2;i<argc;i++)
     {
      switch(argv[i][1])
          {
           case 'm': method=atoi(argv[++i]);         break;
           case 'c': nbclass=atoi(argv[++i]);        break;
           case 'e': myseed=atoi(argv[++i]);         break;
	   case 's': FlgSeg=atoi(argv[++i]);         break;
           case 't': ThetaPar=atof(argv[++i]);       break;
	   case 'r': minsizeregion=atoi(argv[++i]);  break;
           } 
     } 
  }


/*****************************************************/
/* PROGRAMME PRINCIPAL                               */
/*****************************************************/
int main(int argc,char** argv)
 {
  int k;
  int flag;
  int ThreshMV,ThreshMAP;

  XEvent ev;
  Window win_ppicture1,win_ppicture2,win_ppicture3;
  XImage *x_ppicture1,*x_ppicture2,*x_ppicture3;
  char nomfen_ppicture1[NCHAR],nomfen_ppicture2[NCHAR],nomfen_ppicture3[NCHAR];

  //Stack Size Increased (512 MB)
 const rlim_t kStackSize=512*1024*1024;   
 struct rlimit rl;
 int result=getrlimit(RLIMIT_STACK,&rl);
 if (result==0)
 if (rl.rlim_cur<kStackSize)
    {  rl.rlim_cur=kStackSize;
       result=setrlimit(RLIMIT_STACK,&rl);
       if (result!=0) fprintf(stderr,"setrlimit returned result = %d\n",result); } 

  //>Valeurs par defauts
  method=0;
  nbclass=4;
  ThetaPar=0.99; //>(Smap)
  myseed=0;
  minsizeregion=MIN_SIZE_REGION; //>*RemoveSamallRegion)
  flag=0; 
  FlgSeg=0;
  
  //>Enregistre arguments <ligne de commande>
  read_arguments(argc,argv);
 
  //>Load Image_&_Memory Allocation
  int length,width;
  GetLengthWidth(Name_img,&length,&width);
  printf("\n Taille de l'image: [%d::%d]",length,width);
  fflush(stdout);

  float** img=fmatrix_allocate_2d(length,width);
  float** img1=fmatrix_allocate_2d(length,width);
  float** img2=fmatrix_allocate_2d(length,width); 
  float** img3=fmatrix_allocate_2d(length,width); 
  float** imgGT=fmatrix_allocate_2d(length,width); 
  float** ppara=fmatrix_allocate_2d(nbclass,NBPAR);
  float* hyperpar=fmatrix_allocate_1d(NB_HYPERPAR);

  load_image_pgm(Name_img,img,length,width);
  for(k=0;k<NB_HYPERPAR;k++) hyperpar[k]=VALUE_HYPERPAR;

  CreateGroundTruth(imgGT,length,width);

  
 /*-----------------------------------------------*/
 /*-DISTRIBUTION MIXTURE ESTIMATION---------------*/
 /*-----------------------------------------------*/

  //> [K-Mean]
  int SIZE=9;
  k_mean MyKmean(nbclass,SIZE,length,width,myseed);
  MyKmean.Estimate(img,ppara);
  MyKmean.fillpict_LabelImg(img1);
  MyKmean.fillpict_DistributionMixture(img2);
  MyKmean.fillpict_LabelMatx(img3);
  printf("\n [Classification Error::%.2f/100]",100*DifferenceP(imgGT,img3,length,width));
  fflush(stdout);

  //> [EM]
  if (method==1)
     { EM MyEm(nbclass,1,length,width);
       MyEm.EM_Estimate(img,ppara);
       MyEm.fillpict_LabelImg(img1);
       MyEm.fillpict_DistributionMixture(img2); 
       MyEm.fillpict_LabelMatx(img3); 
       printf("\n [Classification Error::%.2f/100]",100*DifferenceP(imgGT,img3,length,width));  
       ThreshMV=MyEm.MV_TresholdForTwoDistribMixture(0,1);
       ThreshMAP=MyEm.MAP_TresholdForTwoDistribMixture(0,1);
       printf("\n\n > [MV:%d][MAP:%d]",ThreshMV,ThreshMAP); }

  //> [SEM]
  if (method==2)
     { SEM MySem(nbclass,1,length,width);
       MySem.SEM_Estimate(img,ppara,1);
       MySem.fillpict_LabelImg(img1);
       MySem.fillpict_DistributionMixture(img2); 
       MySem.fillpict_LabelMatx(img3); 
       printf("\n [Classification Error::%.2f/100]",100*DifferenceP(imgGT,img3,length,width));  
       ThreshMV=MySem.MV_TresholdForTwoDistribMixture(0,1);
       ThreshMAP=MySem.MAP_TresholdForTwoDistribMixture(0,1);
       printf("\n\n > [MV:%d][MAP:%d]",ThreshMV,ThreshMAP); }

  //> [ECI]
  if (method==3)
     { ECI MyEci(nbclass,1,length,width);
       MyEci.ECI_Estimate(img,ppara,hyperpar);
       MyEci.fillpict_LabelImg(img1);
       MyEci.fillpict_DistributionMixture(img2); 
       MyEci.fillpict_LabelMatx(img3); 
       printf("\n [Classification Error::%.2f/100]",100*DifferenceP(imgGT,img3,length,width));  
       ThreshMV=MyEci.MV_TresholdForTwoDistribMixture(0,1);
       ThreshMAP=MyEci.MAP_TresholdForTwoDistribMixture(0,1);
       printf("\n\n > [MV:%d][MAP:%d]",ThreshMV,ThreshMAP); }


 /*-----------------------------------------------*/
 /*-SEGMENTATION----------------------------------*/
 /*-----------------------------------------------*/

  //> [ICM] (--Segmentation--)
  if (FlgSeg==1)
    { ICM MyIcm(nbclass,1,length,width);
      MyIcm.ICM_Estimate(img,ppara,hyperpar,img1); 
      Recal(img1,length,width);  
      MyIcm.fillpict_LabelMatx(img3); 
      printf("\n [Classification Error::%.2f/100]",100*DifferenceP(imgGT,img3,length,width));  }

  //> [ICM (stoch)] (--Segmentation--)
  if (FlgSeg==2)
    { ICM MyIcm(nbclass,1,length,width);
      MyIcm.ICM_Estimate_Seed(img,ppara,hyperpar,img1,myseed); 
      Recal(img1,length,width);  
      MyIcm.fillpict_LabelMatx(img3); 
      printf("\n [Classification Error::%.2f/100]",100*DifferenceP(imgGT,img3,length,width));  }

  //> [MPM] (--Segmentation--)
  if (FlgSeg==3)
    { MPM MyMpm(nbclass,1,length,width);
      MyMpm.MPM_Estimate(img,ppara,hyperpar,img1); 
      Recal(img1,length,width);  
      MyMpm.fillpict_LabelMatx(img3); 
      printf("\n [Classification Error::%.2f/100]",100*DifferenceP(imgGT,img3,length,width));  }

  //> [SMAP] (--Segmentation--)
  int depth=6;
  int versus=1;
  if (FlgSeg==4)
    { SMAP MySmap(nbclass,1,length,width,depth);
      MySmap.SMAP_Estimate(img,ppara,ThetaPar,versus,img1);    
      Recal(img1,length,width);    
      MySmap.fillpict_LabelMatx(img3); 
      printf("\n [Classification Error::%.2f/100]",100*DifferenceP(imgGT,img3,length,width));  }

  
 /*-----------------------------------------------*/
 /*-REMOVE SMALL REGIONS--------------------------*/
 /*-----------------------------------------------*/
  int nbreg;
  if (minsizeregion)
     { printf("\n\n  Elimine petites regions :");
       for(k=0;k<3;k++) if (!FuseSmallRegions(img1,length,width,&nbreg,minsizeregion))  break;
       Recal(img1,length,width);
       CopyMat(img3,img1,length,width);
       printf("\n  [New Classification Error::%.2f/100]",100*DifferenceP(imgGT,img3,length,width)); }

  //>Sauvegarde 
  //SaveImagePgm((char*)"ImgSeg1",imgGT,length,width);
  //SaveImagePgm((char*)"ImgSeg2",img3,length,width);

 /*-------------------------------------------------*/

  //>Visu sous XWINDOW 
  //ouverture session graphique/
  if (open_display()<0) { printf((char*)"impossible d'ouvrir une session graphique"); exit(-1); }
   
   sprintf(nomfen_ppicture1,"IMAGE-1-:%s",Name_img);
   sprintf(nomfen_ppicture2,"IMAGE-2-:%s",Name_img);
   sprintf(nomfen_ppicture3,"IMAGE-3-:%s",Name_img);
   win_ppicture1=fabrique_window(nomfen_ppicture1,10,10,width,length,ZOOM);
   win_ppicture2=fabrique_window(nomfen_ppicture2,10,10,width,length,ZOOM);
   win_ppicture3=fabrique_window(nomfen_ppicture3,10,10,width,length,ZOOM);
   x_ppicture1=cree_Ximage(img1,ZOOM,length,width);
   x_ppicture2=cree_Ximage(img2,ZOOM,length,width);
   x_ppicture3=cree_Ximage(img,ZOOM,length,width);
   printf("\n\n\n pour quitter,appuyer sur la barre d'espace\n\n\n");

   /*boucle d'evenements*/
   for(;;)
   {

     XNextEvent(display,&ev);
     switch(ev.type)
      {
       case Expose:
       XPutImage(display,win_ppicture1,gc,x_ppicture1,0,0,0,0,x_ppicture1->width,x_ppicture1->height);
       XPutImage(display,win_ppicture2,gc,x_ppicture2,0,0,0,0,x_ppicture2->width,x_ppicture2->height);        
       XPutImage(display,win_ppicture3,gc,x_ppicture3,0,0,0,0,x_ppicture3->width,x_ppicture3->height);

       break;

       case KeyPress:
       XDestroyImage(x_ppicture1);
       XDestroyImage(x_ppicture2);
       XDestroyImage(x_ppicture3);
       XFreeGC(display,gc);
       XCloseDisplay(display);
       flag=1;
       break; 
       }
     if (flag==1) break;

   } 
   //fin de la session graphique -------*/
 
   // retour sans probleme 
   printf("\n\n c'est fini... \n\n");
   return 0; 	
    
 }
