//------------------------------------------------------
// module  : EstimMixtDist.h
// auteur  : Mignotte Max
// date    : 
// langage : C++
// modifié :             
//------------------------------------------------------

#ifndef ESTIMMIXDIST_H
#define ESTIMMIXDIST_H

//------------------------------------------------
// FICHIERS INCLUS -------------------------------
//------------------------------------------------
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <new>

#include "FunctionMCDCCL.h"

//------------------------------------------------
// CONSTANTES & DEFINITIONS ----------------------
//------------------------------------------------
//#define ZOOM 1

#define CARRE(X) ((X)*(X))
#define DIST(a,b,c,d,e,f,g,h) sqrt(CARRE(a-b)+CARRE(c-d)+CARRE(e-f)+CARRE(g-h))
#define SWAPF(X,Y) {float T=Y; Y=X; X=T; }

#define DEBUG 0

#define NBPIX 256
#define NCHAR 200
#define PI 3.14159
#define GREY_LEVEL 255
#define COLOR_HISTO 200
#define BIGNUMB 1000000

#define NB_ATTRIBUTS 4
#define NBPAR 4
#define NB_HYPERPAR 4
#define VALUE_HYPERPAR 1

#define ITER 30
#define ITER_ICM 40
#define CHGT_ICM  4
#define ITERMINI 10
#define STOPCOND 0.1
#define NBECH 4
#define NB_LABEL_FIELD 1

#define CHGT_MPM  10
#define ITERMINI_MPM 5
#define ITERMAX_MPM 50

#define COEF 0.0015
#define VAR 2

#define MIN_SIZE_REGION 0

//------------------------------------------------
// CLASSE KMEAN ----------------------------------
//------------------------------------------------
class KMEAN
 {
  public:
   typedef struct { float par1,par2,par3,par4;
                    float pix;
                    int label;} swindow;

   swindow* pswindow;

   int width,length; 
   int nbclass;
   int nbwindows; 
   int size;
   int myseed;

   float* histo;
   float** pmatl;
   float**  ppar;
   float*** pmatp;
  
   public:
   KMEAN(int,int,int,int,int);
   virtual ~KMEAN();
   
   void KMEAN_Estimate(float**,float**);

   void fillpict_LabelImg(float**);
   void fillpict_DistributionMixture(float**);
   void fillpict_LabelMatx(float**);
   void fillpict_MVLabel(float**);
 
   protected:
   void  fillarrayswindow(float**);
   void  normalizeswindow();
   int   cluster();
   void  computemean();
   void  compute_mean_estimates();
   void  ClassifyPar();

   float funcgauss(short,float,float,float);
   void  visu_screen(int);
   void  copy_ppar(int,float**);
   void  init_label_matrix();
   void  fill_init_matp(float**);
   float funcraleygh(short,float,float,float);
   void  histo_picture(float**);
   float dist_kolmogorov(float*,int);
};

//------------------------------------------------
// CLASSE ESTIMATOR ------------------------------
//------------------------------------------------
class estimator
 {
  public:
   float**    pmatl;

  protected:
   int width,length; 
   int nbclass,law;

   float*   histo;
   float**  ppar;
   float**  pparmoy;   
   float*** pmatp;
   float*** pparstock;

   public:
   estimator(int,int,int,int);
   virtual ~estimator();

   void fillpict_LabelImg(float**);
   void fillpict_DistributionMixture(float**);
   void fillpict_LabelMatx(float**);
   int MV_TresholdForTwoDistribMixture(int,int);
   int MAP_TresholdForTwoDistribMixture(int,int);
 
   void ClassifyPar();
   void moypar();
   void fill_pparstock(int);
   float varpparstock();

   float dist_kolmogorov();
   float khi_2();  
   void  visu_screen(int);
   void  visu_screen_weib(int);
   float randomize(void);
   float funcraleygh(short,float,float,float);
   float funcgauss(short,float,float,float);
   float funcweibull(short,float,float,float,float);
   void  histo_picture(float**);
   void  fill_picture(float**);
   void  init_label_matrix();  
};

//------------------------------------------------
// CLASSE EM        ------------------------------
//------------------------------------------------
class EM:public estimator
 { 
   public:
   float dist_kolmo;

   public:
   EM(int,int,int,int);
   virtual ~EM();
   
   void EM_Estimate(float**,float**);
   void EM_Estimate(float**,float**,int);
    
   protected:
   void fill_matp(float**);
   void compute_EMparameter(float**);
   void compute_Nk();
};

//------------------------------------------------
// CLASSE SEM       ------------------------------
//------------------------------------------------
class SEM:public estimator
 {
   public:
   float dist_kolmo;

   public:
   SEM(int,int,int,int);
   virtual ~SEM();
   
   void SEM_Estimate(float**,float**,int);
   void SEM_Estimate(float**,float**,int,int);
    
   protected:
   void compute_parameter(float**);
   void weib_estimate(float**);
   void fill_matp(float**);
   void choose_label();
   void init_random_matrix();
};

//------------------------------------------------
// CLASSE ECI       ------------------------------
//------------------------------------------------
class ECI:public estimator
 {
   protected:
   float*** pparstockf;
  
   public:
   ECI(int,int,int,int);
   virtual ~ECI();
   
   void ECI_Estimate(float**,float**,float*);
   void ECI_Estimate(float**,float**,float*,int);
    
   protected:
   virtual void choose_gibbs_label(int,int);
   float data_connexion_nrj(float**,int,int,int);
   float contextual_nrj(float*,int,int,short);
   void gibbs_sampler(float**,float*);

   void compute_parameter(float**,float**);
   void fill_init_matp(float**);
   void init_label_matrix();
   void findmin2(float**,float**,int,float);
   void visu_screen2(float**,int);
   float varpparstock(float***,float**,int);
   void moypar(float***,int,float**);
   void fill_pparstock(float***,float**,int,int);
};

//------------------------------------------------
// CLASSE ICM       ------------------------------
//------------------------------------------------
class ICM:public ECI
 {
   protected:
   float** pmatl_bis;

   public:
   ICM(int,int,int,int);
   virtual ~ICM();
   
   void ICM_Estimate(float**,float**,float*,float**);
   void ICM_Estimate_(float**,float**,float*,float**); 
   void ICM_Estimate_Seed(float**,float**,float*,float**,int);
   void ML_Estimate(float**,float**,float**);

   double Uniform_PCL(float);
   double contextual_nrj_PCL(float*,int,int,int);
   void gibbs_sampler_PCL(float**,float*,int***,float);
   void fill_init_matp_PCL(float**,int,int,int***,float);
   double compute_nrj_PCL(float**,float**,float*,int***,float);
   
   void ICM_Estimate_PCL(float**,float*,float**,int***);
   void MPM_Estimate_PCL(float**,float*,float**,int***);
   
   protected:
   void  gibbs_sampler_Pix(float**,float*,int,int);
   void  choose_gibbs_label(int,int);
   float compute_nrj(float**,float**,float*);
   int   diff_pmatl(float**,float**); 
   void  CopyMatrix(float**,float**);
};

//------------------------------------------------
// CLASSE MPM ------------------------------------
//------------------------------------------------
class MPM:public ECI
 {
  protected:
  float**  pmatl_MPM;
  float*** pmat_acc;
  int IterMini,IterMax;

  public:
  MPM(int,int,int,int);
  virtual ~MPM();
  void MPM_Estimate(float**,float**,float*,float**);
   
  protected:  
  void inc_mat_acc();
  void init_label_mpm_matrix(float**); 
  float compute_nrj(float**,float**,float*);
  int   diff_pmatl(float**,float**); 
  void  CopyMatrix(float**,float**);
 };

//------------------------------------------------
// CLASSE SMAP     -------------------------------
//------------------------------------------------
class SMAP:public ECI
 {

  public:
   int** pyrmat;
   int** pyrmat_init;
   int** pyrmat_pict;
   int size_pyrmat;
   float****  py_pmatp;
   int***     py_pmatl;
   int***     py_pmatl_init;
   int***     py_pmatl_pict;
   
   int width_max,length_max;
   int depth,nbclass,law,versus;
   float theta; 
   
  public:
  SMAP(int,int,int,int,int);
  SMAP(int,int,int);
  ~SMAP();
  void SMAP_Estimate(float**,float**,float,int,float**);
  void SMAP_MCD(int***,float**,float,int,float**,float);
  void SMAP_MCD(int***,float**,float,float**,float);
  void SMAP_MCD_PonPoff(float**);
  
  //>Gestion
  void fine_to_coarse(int);
  void coarse_to_fine(int);
  void coarse_to_fine_v2(int);
  void init_top_py_pmatl(int,int***);
  int odd(int);
  float funcraleygh(short,float,float,float);
  float funcgauss(short,float,float,float);
  float funcweibull(short,float,float,float,float);
  void  fill_init_matp(float**,float***,float**); 
  void  fillpict_LabelMatx(float**);

  int*** allocate_pyramide_pmatl(int,int,int);
  void free_pyramide_pmatl(int***,int);
  float**** allocate_pyramide_pmatp(int,int,int,int);
  void free_pyramide_pmatp(float****,int,int);
  void encadre_py_pmatl(int***,int,int);
  void encadre_py_pmatl(int***,int,int,int);
  void convert_pypmatl_pyrmat(int***,int**,int,int);
  int size_bigpicture(int,int);
  void copy_square_mat(float**,float**,int);
  void copy_square_mat(int**,float**,int);
  void copy_mat(int**,float**,int,int);
  void multires(float**,int,int,int***);
  void Recal(float**,int,int);
  void Recal(int**,int,int); 
};

//---------------
//---CLEAN-------
//---------------
void CopyMatrix(float**,float**,int,int);
void Paint(float**,float**,int,int,int,int,int);
int FuseSmallRegions(float**,int,int,int*,int);
void Duplique(float**,float**,int);
void Duplique(int**,int**,int);
void Duplique(int**,int**,int,int);

//------------------------------------------------
// CLASSE SCMAP       ----------------------------
// [2 classes PCL]
//------------------------------------------------
class SCMAP
 {
   public:
   int Length,Width,Depth;
   float** HyperPar;
   int*** py_pmatl;
   int*** py_pmatl_bis;
   float**  pmatl;     //**//
   float**  pmatl_bis; //**//
   float*** pmatp;     //**//
   float** ppictureSeg;

   public:
   SCMAP(int,int,int);
   virtual ~SCMAP();
   
   double Uniform_PCL(float);
   double Funcgauss_PCL(float,float,float,float);
   int diff_pmatl(int**,int**,int,int);
   int diff_pmatl_(int**,int**,int,int);
   int diff_pmatl(float**,float**,int,int);
   int*** allocate_pyramide(int,int,int);
   void free_pyramide(int***,int);
   
   double contextual_nrj_PCL(float*,int,int,int);  //**//
   void gibbs_sampler_PCL(float**,float*,int***,float); //**//
   void fill_init_matp_PCL(float**,int,int,int***,float); //**//
   double compute_nrj_PCL(float**,float**,float*,int***,float); //**//
   void ICM_Estimate_PCL(float**,float*,float**,int***); //**//

   double data_nrj_Block_PCL(float**,int,int,int,int,int***,float);
   double contextual_nrj_Block_PCL(int,int,int,int,int***,float**);
   double compute_nrj_Block_PCL(float**,int***,int,float*,int***,float);
   void SCMAP_Estimate_PCL(float**,float*,float**,int***);
};



#endif
