//------------------------------------------------------
// module  : FunctionMCDCCL.cc
// auteur  : Mignotte Max
// date    :
// version : 1.0
// langage : C++
// labo    : DIRO
//------------------------------------------------------
// 

//------------------------------------------------
// FICHIERS INCLUS -------------------------------
//------------------------------------------------
#include "FunctionMCDCCL.h"
#include "MCDCCL.h"

//-------------------------//
//-- Matrice de Flottant --//
//-------------------------//
//---------------------------------------------------------
//  alloue de la memoire pour une matrice 1d de float
//----------------------------------------------------------
float* fmatrix_allocate_1d(int hsize)
 {
  float* matrix;
  matrix=new float[hsize]; return matrix; 
 }

//---------------------------------------------------------
//  alloue de la memoire pour une matrice 1d de float
//----------------------------------------------------------
float* fmatrix_allocate_1d(long int hsize)
 {
  float* matrix;
  matrix=new float[hsize]; return matrix; 
 }

//----------------------------------------------------------
//  alloue de la memoire pour une matrice 2d de float
//----------------------------------------------------------
float** fmatrix_allocate_2d(int vsize,int hsize)
 {
  float** matrix;
  float *imptr;

  matrix=new float*[vsize];
  imptr=new  float[(hsize)*(vsize)];
  for(int i=0;i<vsize;i++,imptr+=hsize) matrix[i]=imptr;
  return matrix;
 }

//----------------------------------------------------------
// alloue de la memoire pour une matrice 3d de float
//----------------------------------------------------------
float*** fmatrix_allocate_3d(int dsize,int vsize,int hsize)
 {
  float*** matrix;

  matrix=new float**[dsize];

  for(int i=0;i<dsize;i++)
    matrix[i]=fmatrix_allocate_2d(vsize,hsize);
  return matrix;
 }

//-----------------------//
//-- Matrice d'entiers --//
//-----------------------//
//---------------------------------------------------------
//  alloue de la memoire pour une matrice 1d de int
//----------------------------------------------------------
int* imatrix_allocate_1d(int hsize)
 {
  int* matrix;
  matrix=new int[hsize]; return matrix; }

//----------------------------------------------------------
//  alloue de la memoire pour une matrice 2d de int
//----------------------------------------------------------
int** imatrix_allocate_2d(int vsize,int hsize)
 {
  int** matrix;
  int*  imptr;

  matrix=new int*[vsize];
  imptr=new  int[(hsize)*(vsize)];
  for(int i=0;i<vsize;i++,imptr+=hsize) matrix[i]=imptr;
  return matrix;
 }

//----------------------------------------------------------
// alloue de la memoire pour une matrice 3d de int
//----------------------------------------------------------
int*** imatrix_allocate_3d(int dsize,int vsize,int hsize)
 {
  int*** matrix;

  matrix=new int**[dsize];

  for(int i=0;i<dsize;i++)
    matrix[i]=imatrix_allocate_2d(vsize,hsize);
  return matrix;
 }

//----------------------------------------------------------
// alloue de la memoire pour une matrice 4d de int
//----------------------------------------------------------
int**** imatrix_allocate_4d(int fsize,int dsize,int vsize,int hsize)
 {
  int**** matrix;

  matrix=new int***[fsize];

  for(int i=0;i<fsize;i++)
    matrix[i]=imatrix_allocate_3d(dsize,vsize,hsize);
  return matrix;
 }

//---------------------------//
//--- Liberation memoire ----//
//---------------------------//
//----------------------------------------------------------
// libere la memoire de la matrice 1d de float
//----------------------------------------------------------
void free_fmatrix_1d(float* pmat)
{ delete[] pmat; }

//----------------------------------------------------------
// libere la memoire de la matrice 2d de float
//----------------------------------------------------------
void free_fmatrix_2d(float** pmat)
{ delete[] (pmat[0]);
  delete[] pmat;}

//----------------------------------------------------------
// libere la memoire de la matrice 3d de float
//----------------------------------------------------------
void free_fmatrix_3d(float*** pmat,int dsize)
{
 for(int i=0;i<dsize;i++)
  {
   delete[] (pmat[i][0]);
   delete[] (pmat[i]);
   }
 delete[] (pmat);
}

//----------------------------------------------------------
// libere la memoire de la matrice 1d de int
//----------------------------------------------------------
void free_imatrix_1d(int* pmat)
{ delete[] pmat; }

//----------------------------------------------------------
// libere la memoire de la matrice 2d de int
//----------------------------------------------------------
void free_imatrix_2d(int** pmat)
{ delete[] (pmat[0]);
  delete[] pmat;}

//----------------------------------------------------------
// libere la memoire de la matrice 3d de int
//----------------------------------------------------------
void free_imatrix_3d(int*** pmat,int dsize)
{
 for(int i=0;i<dsize;i++)
  {
   delete[] (pmat[i][0]);
   delete[] (pmat[i]);
   }
 delete[] (pmat);
}

//----------------------------------------------------------
// libere la memoire de la matrice 4d de int
//----------------------------------------------------------
void free_imatrix_4d(int**** pmat,int fsize,int dsize)
{
 for(int i=0;i<fsize;i++)
  free_imatrix_3d(pmat[i],dsize);
  
 delete[] (pmat);
}

//--------------------//
//-- Matrix Gestion --//
//--------------------//
//----------------------------------------------------------
// copie une matrice dans une autre
//----------------------------------------------------------
void CopyMat(float** mat1,float** mat2,int lgth,int wdth)
{
 int i,j;

  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
  mat1[i][j]=mat2[i][j]; 
}

//----------------------------------------------------------
// copie une matrice dans une autre
//----------------------------------------------------------
void CopyMat(float*** mat1,float** mat2,int lgth,int wdth)
{
  int i,j,k;

  for(k=0;k<3;k++) for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
  mat1[k][i][j]=mat2[i][j]; 
}

/*----------------------------------------------------------*/
/* Recal                                                    */
/*----------------------------------------------------------*/
void Recal(float** mat,int lgth,int wdth)
{
 int i,j;
 float max,min;

 /*Initialisation*/
 max=-1000000.0;
 min=100000000;

 /*Recherche du min*/
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    if (mat[i][j]<min) min=mat[i][j];

 /*plus min*/
   for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    mat[i][j]-=min;

 /*Recherche du max*/
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) 
    if (mat[i][j]>max) max=mat[i][j];

 /*Recalibre la matrice*/
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
   if (max) mat[i][j]*=(GREY_LEVEL/max);      
}

/*----------------------------------------------------------*/
/* Recal                                                    */
/*----------------------------------------------------------*/
void Recal(int** mat,int lgth,int wdth)
{
 int i,j;
 float max,min;

 /*Initialisation*/
 max=-1000000;
 min=100000000;

 /*Recherche du min*/
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    if (mat[i][j]<min) min=mat[i][j];

 /*plus min*/
   for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    mat[i][j]-=min;

 /*Recherche du max*/
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) 
    if (mat[i][j]>max) max=mat[i][j];

 /*Recalibre la matrice*/
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
 if (max) mat[i][j]=(int)((float)mat[i][j]*((float)GREY_LEVEL/(float)max));      
}

//----------------------------------------------------------
// RecalImgWithSat
//----------------------------------------------------------
void RecalImgWithSat(float** Img,int lgth,int wdth,float pourc)
{
 int i,j,k;
 float min,max;
 int minGL,maxGL;
 const int NBGREYLEVELS=256;
  
 //>Presentation
 //printf("\n > RecalImgWithSat_[%.0f/100]",pourc*100);
 //fflush(stdout);

 //>AllocateMemory
 float** ImgTmp=fmatrix_allocate_2d(lgth,wdth);
 float* VctHist=fmatrix_allocate_1d(NBGREYLEVELS);

 //>Histo[Img]
 for(k=0;k<NBGREYLEVELS;k++)  VctHist[k]=0;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) VctHist[(int)Img[i][j]]++;
 for(k=0;k<NBGREYLEVELS;k++) VctHist[k]/=(lgth*wdth);

 //>SeekMinMax_For_SaturatedPixels
 min=0.0;
 for(k=0;k<NBGREYLEVELS;k++)
    { min+=VctHist[k];
      if (min>pourc) break; }
 minGL=k;

 max=0.0;
 for(k=(NBGREYLEVELS-1);k>0;k--)
    { max+=VctHist[k];
      if (max>pourc) break; }
 maxGL=k;

 //printf("_[min/max>%d::%d]",minGL,maxGL);
 //fflush(stdout);

 //>Recal_Between_[minG:maxGL]
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    { if (Img[i][j]<=minGL) Img[i][j]=0;
      if (Img[i][j]>=maxGL) Img[i][j]=maxGL; }
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) Img[i][j]=255.0*((Img[i][j]-minGL)/(maxGL-minGL));

 //>Verif
 minGL=(NBGREYLEVELS-1);
 maxGL=0;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    { if (Img[i][j]<minGL) minGL=Img[i][j];
      if (Img[i][j]>maxGL) maxGL=Img[i][j]; }
 //printf("_[min/max>%d::%d]",minGL,maxGL);
 //fflush(stdout);
 
 //>FreeMemory
 if (ImgTmp)  free_fmatrix_2d(ImgTmp);
 if (VctHist) free_fmatrix_1d(VctHist);
}

//----------------------------------------------------------
// Calcule le nombre de differences a chaque iteration
//----------------------------------------------------------
int DiffMatNb(float** pmatl1,float** pmatl2,int lgth,int wdth)
{
 int i,j;
 int chg;

 //>Compte NbChgt
 chg=0;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) if (pmatl1[i][j]!=pmatl2[i][j]) chg++; 
       
 return chg;
}

//----------------------------------------------------------
// DiffBetween
//----------------------------------------------------------
float DiffBetween(float** ImgSegWB,float** ImgGtrWB,int lgth,int wdth)
{
 int i,j;
 float nb=0;

 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    { if (ImgSegWB[i][j]*ImgGtrWB[i][j]) nb++;
      if ((ImgSegWB[i][j]==0)&&(ImgGtrWB[i][j]==0)) nb++; }

 nb=100*(nb/(lgth*wdth));
 return nb;
}

//----------------------------------------------------------
// InitZero
//----------------------------------------------------------
void InitZero(float** Mat,int lgth,int wdth)
{
 int i,j;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)  Mat[i][j]=0.0;
}

//----------------------------------------------------------
// InitZero
//----------------------------------------------------------
void InitZero(float*** Mat,int Nb,int lgth,int wdth)
{
 int i,j,k;
 for(k=0;k<Nb;k++) for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)  Mat[k][i][j]=0.0;
}

//----------------------------------------------------------
// AddToMatrix
//----------------------------------------------------------
void AddToMatrix(float** MatAcc,float** Mat,int lgth,int wdth)
{
 int i,j;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)  MatAcc[i][j]+=Mat[i][j];
}

//----------------------------------------------------------
// MeanMatrix
//----------------------------------------------------------
void MeanMatrix(float*** VctMatrix,int lgth,int wdth,int nb,float** MeanMatrix)
{
 int i,j,k;
 float tmp;

 //>MainLoop
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    { tmp=0.0;
      for(k=0;k<nb;k++) tmp+=VctMatrix[k][i][j];
      tmp/=(nb);
      MeanMatrix[i][j]=tmp; }
}

//--------------//
// RANDOM ------//
//--------------//
//----------------------------------------------------------
// Nombre aleatoire entre zero et un
//----------------------------------------------------------
float randomize(void)
{ return ((float)rand()/RAND_MAX); }

//----------------------------------------------------------
// Nombre aleatoire entier entre zero et un
//----------------------------------------------------------
int RandIntBetween(int min,int max)
{
 float scale=max-min;
 float val=min+(scale*randomize())+0.5;
 return (int)val;
}

//----------//
//-- FILE --//
//----------//
//----------------------------------------------------------
// Get Length and Width
//----------------------------------------------------------
void GetLengthWidth(char* path,int* length,int* width)
{
 unsigned char var;
 int   temp;
 char* tempc;
 char stringTmp1[100];
 char stringTmp2[100];
 int ta1,ta2;
 FILE *fic;

  //ouverture du fichier
  fic=fopen(path,"r");
  if (fic==NULL)
    { printf("\n- Grave erreur a l'ouverture de %s -\n",path);
      exit(-1); }

  //recuperation de l'entete
  tempc=fgets(stringTmp1,100,fic);
  for(;;) { temp=fread(&var,1,1,fic); if (var==35) tempc=fgets(stringTmp2,100,fic);
            else break; }
  fseek(fic,-1,SEEK_CUR);
  temp=fscanf(fic,"%d %d",&ta1,&ta2);
   
  //enregistrement
  (*length)=ta2; 
  (*width)=ta1;
  if (0) printf("[%d][%c]",temp,*tempc);

  //fermeture du fichier
  fclose(fic);
}

//----------------------------------------------------------
// load ppm image 
//----------------------------------------------------------
void LoadImagePpm(char* path,float*** data,int length,int width)
 {
  int i,j;
  int   temp;
  char* tempc;
  unsigned char varr,varb,varv;  
  char header[100];
  char* ptr;
  int ta1,ta2,ta3;
  FILE *fic;

  //Open file
  fic=fopen(path,"r");
  if (fic==NULL)
    { printf("\n -> Grave erreur a l'ouverture de %s !\n",path);
      exit(-1); }

  tempc=fgets(header,100,fic);
  if ( (header[0]!=80) ||    /* 'P' */
       (header[1]!=54) ) {   /* '6' */
       fprintf(stderr,"Image %s is not PPM.\n",path);
       exit(1); }

  tempc=fgets(header,100,fic);
  while(header[0]=='#') tempc=fgets(header,100,fic);
 
  ta1=strtol(header,&ptr,0);
  ta2=atoi(ptr);
  tempc=fgets(header,100,fic);
  ta3=strtol(header,&ptr,0);
    
  //Load
  for(i=0;i<length;i++) for(j=0;j<(width*3);j+=3)  
      {
       temp=fread(&varr,1,1,fic);
       temp=fread(&varv,1,1,fic);
       temp=fread(&varb,1,1,fic);    
       data[0][i][j/3]=varr;        
       data[1][i][j/3]=varv;        
       data[2][i][j/3]=varb;
      }

  //Close file
  if (0) printf("[%d][%s][%d:%d:%d]",temp,tempc,ta1,ta2,ta3);
  fclose(fic);
 }

//----------------------------------------------------------
// Sauvegarde de l'image de nom <name> au format pgm                        
//----------------------------------------------------------                
void SaveImagePgm(char* bruit,char* name,int** mat,int lgth,int wdth)
{
 int i,j;
 char buff[300];
 FILE* fic;

  //--extension--
  strcpy(buff,bruit);
  strcat(buff,name);
  strcat(buff,".pgm");

  //--ouverture fichier--
  fic=fopen(buff,"wb");
    if (fic==NULL) 
        { printf("Probleme dans la sauvegarde de %s",buff); 
          exit(-1); }
    printf("\n >> Sauvegarde dans -> %s au format pgm",buff);

  //--sauvegarde de l'entete--
  fprintf(fic,"P5");
  fprintf(fic,"\n# IMG Module");
  fprintf(fic,"\n%d %d",wdth,lgth);
  fprintf(fic,"\n255\n");

  //--enregistrement--
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) 
	fprintf(fic,"%c",(char)mat[i][j]);
   
  //--fermeture fichier--
   fclose(fic); 
}

//----------------------------------------------------------
// Sauvegarde de l'image de nom <name> au format pgm                        
//----------------------------------------------------------                
void SaveImagePgm(char* bruit,char* name,float** mat,int lgth,int wdth)
{
 int i,j;
 char buff[300];
 FILE* fic;

  //--extension--
  strcpy(buff,bruit);
  strcat(buff,name);
  strcat(buff,".pgm");

  //--ouverture fichier--
  fic=fopen(buff,"wb");
    if (fic==NULL) 
        { printf("Probleme dans la sauvegarde de %s",buff); 
          exit(-1); }
    printf("\n >> Sauvegarde dans -> %s au format pgm",buff);

  //--sauvegarde de l'entete--
  fprintf(fic,"P5");
  fprintf(fic,"\n# IMG Module");
  fprintf(fic,"\n%d %d",wdth,lgth);
  fprintf(fic,"\n255\n");

  //--enregistrement--
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) 
	fprintf(fic,"%c",(char)mat[i][j]);
   
  //--fermeture fichier--
   fclose(fic); 
}

//----------------------------------------------------------
// Sauvegarde de l'image de nom <name> au format ppm        
//----------------------------------------------------------
void SaveImagePpm(char* Path_out,char* Name,float*** matrvb,int lgth,int wdth)
 {
  int i,j;
  char buff[200];
  FILE* fuser;

  //extension
  strcpy(buff,Path_out);
  strcat(buff,Name);
  strcat(buff,".ppm");
  //if (strstr(buff,".ppm")==NULL) strcat(buff,".ppm");

  //ouverture fichier
  fuser=fopen(buff,"w");
    if (fuser==NULL) 
        { printf(" probleme dans la sauvegarde de %s",buff); 
          exit(-1); }

  //affichage
  printf("\n sauvegarde dans -> %s au format %s [%d][%d]",buff,".ppm",wdth,lgth);
  fflush(stdout);

  //sauvegarde de l'entete
  fprintf(fuser,"P6");
  fprintf(fuser,"\n# IMG Module");
  fprintf(fuser,"\n%d %d",wdth,lgth);
  fprintf(fuser,"\n255\n");

  //enregistrement
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) 
    {
     fprintf(fuser,"%c",(char)matrvb[0][i][j]);
     fprintf(fuser,"%c",(char)matrvb[1][i][j]);
     fprintf(fuser,"%c",(char)matrvb[2][i][j]);
    }
       
  //fermeture fichier
   fclose(fuser); 
 }

//---------------------
//---------------------
//---REDUCTION SIZE----
//---------------------
//---------------------
//----------------------------------------------------------
// multiresolution
//----------------------------------------------------------
void Multires(float** MatIn,int lgth,int wdth,float** MatOut,int scale)
{ 
 int i,j,ii,jj;
 int row,col;
 float sum_pix;
 int cpt;
 int lgthR,wdthR;
 lgthR=lgth/scale;
 wdthR=wdth/scale;
 //printf("\n [scale::%d]  [%d::%d > %d::%d] \n",scale,lgth,wdth,lgthR,wdthR);
 //fflush(stdout);

  //Loop
 if (scale>1)
 for(i=0;i<lgthR;i++) for(j=0;j<wdthR;j++)
    {  row=(int)(i*scale);
       col=(int)(j*scale);
       sum_pix=0.0;  
       cpt=0;
       for(ii=row;ii<(row+scale);ii++) for(jj=col;jj<(col+scale);jj++)
	  { sum_pix+=MatIn[ii][jj];  cpt++; }	            
       if (cpt!=0) sum_pix/=cpt;    
       if ((i<lgthR)&&(j<wdthR)) MatOut[i][j]=(int)(sum_pix+0.5); }

 if (scale==1) for(i=0;i<lgthR;i++) for(j=0;j<wdthR;j++) MatOut[i][j]=MatIn[i][j];
}

//----------------------------------------------------------
// multiresolution
//----------------------------------------------------------
void Multires(int** MatIn,int lgth,int wdth,int** MatOut,int scale)
{ 
 int i,j,ii,jj;
 int row,col;
 float sum_pix;
 int cpt;
 int lgthR,wdthR;
 lgthR=lgth/scale;
 wdthR=wdth/scale;

  //Loop
 for(i=0;i<lgthR;i++) for(j=0;j<wdthR;j++)
    {  row=(int)(i*scale);
       col=(int)(j*scale);
       sum_pix=0.0;  
       cpt=0;
       for(ii=row;ii<(row+scale);ii++) for(jj=col;jj<(col+scale);jj++)
	  { sum_pix+=MatIn[ii][jj];  cpt++; }	            
       if (cpt!=0) sum_pix/=cpt;    
       if ((i<lgthR)&&(j<wdthR)) MatOut[i][j]=(int)(sum_pix+0.5); }
}

//----------------------------------------------------------
// DecreasedSize
//----------------------------------------------------------
void DecreasedSize(float*** ImgB,float*** ImgA,float*** ImgG,int* lgth,int* wdth,int* scale)
{
 int i,j,k;
 int ScaleFactor;
 int length,width;
 int lgthR,wdthR;

 length=(*lgth);
 width=(*wdth);
 ScaleFactor=(int)(MAX(length,width)/MAXLGTHIMG);
 //printf(" [%d:%d]:Scale=%d",length,width,ScaleFactor);
 //fflush(stdout);
 lgthR=length/ScaleFactor;
 wdthR=width/ScaleFactor;

  //>AllocationMemory
 float*** MatImgB=fmatrix_allocate_3d(TROIS,lgthR,wdthR);
 float*** MatImgA=fmatrix_allocate_3d(TROIS,lgthR,wdthR);	
 float*** MatImgG=fmatrix_allocate_3d(TROIS,lgthR,wdthR);

 //>Reduction_[Before-After]-[GroundTruth]
 Multires(ImgB[0],length,width,MatImgB[0],ScaleFactor);
 Multires(ImgA[0],length,width,MatImgA[0],ScaleFactor);
 Multires(ImgB[1],length,width,MatImgB[1],ScaleFactor);
 Multires(ImgA[1],length,width,MatImgA[1],ScaleFactor);
 Multires(ImgB[2],length,width,MatImgB[2],ScaleFactor);
 Multires(ImgA[2],length,width,MatImgA[2],ScaleFactor);

 Multires(ImgG[0],length,width,MatImgG[0],ScaleFactor);
 Multires(ImgG[1],length,width,MatImgG[1],ScaleFactor);
 Multires(ImgG[2],length,width,MatImgG[2],ScaleFactor);

 //>Binarisation-[GroundTruth]
 for(k=0;k<TROIS;k++) for(i=0;i<lgthR;i++) for(j=0;j<wdthR;j++)
    { if (MatImgG[k][i][j]<128) MatImgG[k][i][j]=0;
      else MatImgG[k][i][j]=255; }

 //>In_PPM
 for(k=0;k<TROIS;k++) for(i=0;i<lgthR;i++) for(j=0;j<wdthR;j++)
    { ImgB[k][i][j]=MatImgB[k][i][j];
      ImgA[k][i][j]=MatImgA[k][i][j];
      ImgG[k][i][j]=MatImgG[k][i][j]; }	

 //>DEBUG
 //SaveImagePpm((char*)"",(char*)"PictB",ImgB,lgthR,wdthR);
 //SaveImagePpm((char*)"",(char*)"PictA",ImgA,lgthR,wdthR);
 //SaveImagePpm((char*)"",(char*)"PictG",ImgG,lgthR,wdthR);
 //exit(-1);
 
 //>End
 if (MatImgB) free_fmatrix_3d(MatImgB,TROIS);
 if (MatImgA) free_fmatrix_3d(MatImgA,TROIS);
 if (MatImgG) free_fmatrix_3d(MatImgG,TROIS);
 (*lgth)=lgthR;
 (*wdth)=wdthR;
 (*scale)=ScaleFactor;
}

//----------------------------------------------------------
// DecreasedSizeByTwo
//----------------------------------------------------------
void DecreasedSizeByTwo(float*** ImgB,float*** ImgA,float*** ImgG,int* lgth,int* wdth,int* scale)
{
 int i,j,k;
 int ScaleFactor;
 int length,width;
 int lgthR,wdthR;

 printf(" > DecreasedSizeByTwo");
 length=(*lgth);
 width=(*wdth);
 ScaleFactor=2;
 //printf(" [%d:%d]:Scale=%d",length,width,ScaleFactor);
 //fflush(stdout);
 lgthR=length/ScaleFactor;
 wdthR=width/ScaleFactor;

  //>AllocationMemory
 float*** MatImgB=fmatrix_allocate_3d(TROIS,lgthR,wdthR);
 float*** MatImgA=fmatrix_allocate_3d(TROIS,lgthR,wdthR);	
 float*** MatImgG=fmatrix_allocate_3d(TROIS,lgthR,wdthR);

 //>Reduction_[Before-After]-[GroundTruth]
 Multires(ImgB[0],length,width,MatImgB[0],ScaleFactor);
 Multires(ImgA[0],length,width,MatImgA[0],ScaleFactor);
 Multires(ImgB[1],length,width,MatImgB[1],ScaleFactor);
 Multires(ImgA[1],length,width,MatImgA[1],ScaleFactor);
 Multires(ImgB[2],length,width,MatImgB[2],ScaleFactor);
 Multires(ImgA[2],length,width,MatImgA[2],ScaleFactor);

 Multires(ImgG[0],length,width,MatImgG[0],ScaleFactor);
 Multires(ImgG[1],length,width,MatImgG[1],ScaleFactor);
 Multires(ImgG[2],length,width,MatImgG[2],ScaleFactor);

 //>Binarisation-[GroundTruth]
 for(k=0;k<TROIS;k++) for(i=0;i<lgthR;i++) for(j=0;j<wdthR;j++)
    { if (MatImgG[k][i][j]<128) MatImgG[k][i][j]=0;
      else MatImgG[k][i][j]=255; }

 //>In_PPM
 for(k=0;k<TROIS;k++) for(i=0;i<lgthR;i++) for(j=0;j<wdthR;j++)
    { ImgB[k][i][j]=MatImgB[k][i][j];
      ImgA[k][i][j]=MatImgA[k][i][j];
      ImgG[k][i][j]=MatImgG[k][i][j]; }	

 //>DEBUG
 //SaveImagePpm((char*)"",(char*)"PictB",ImgB,lgthR,wdthR);
 //SaveImagePpm((char*)"",(char*)"PictA",ImgA,lgthR,wdthR);
 //SaveImagePpm((char*)"",(char*)"PictG",ImgG,lgthR,wdthR);
 //exit(-1);
 
 //>End
 if (MatImgB) free_fmatrix_3d(MatImgB,TROIS);
 if (MatImgA) free_fmatrix_3d(MatImgA,TROIS);
 if (MatImgG) free_fmatrix_3d(MatImgG,TROIS);
 (*lgth)=lgthR;
 (*wdth)=wdthR;
 (*scale)=(*scale)*ScaleFactor;
}

//----------------------------------------------------
// Interpolation bilineaire                           
//----------------------------------------------------
void InterpolBilineaire(int** imgIn,int** imgOut,int lgth,int wdth,float sc)  
{
 int i,j;
 int col_inf,col_sup;
 int row_inf,row_sup;
 float row,col;
 float t,u;
 float ng;
 float scale;

 //>MainLoop
 scale=(1.0/(float)sc);
 for(i=0;i<(scale*lgth);i++) for(j=0;j<(scale*wdth);j++)
     {
      col=(float)j/(float)scale;
      row=(float)i/(float)scale;

      col_inf=(int)(col);
      col_sup=(int)(col+1);
      row_inf=(int)(row);
      row_sup=(int)(row+1);

      if (col_sup>(wdth-1))  col_sup-=wdth;
      if (row_sup>(lgth-1))  row_sup-=lgth;

      t=(col-col_inf)/(col_sup-col_inf);
      u=(row-row_inf)/(row_sup-row_inf);
     	
      ng=(1-t)*(1-u)*imgIn[row_inf][col_inf];
      ng+=t*(1-u)*imgIn[row_inf][col_sup];
      ng+=t*u*imgIn[row_sup][col_sup];
      ng+=(1-t)*u*imgIn[row_sup][col_inf];
      imgOut[i][j]=(int)ng;   
     }
}

//----------------------------------------------------
// Interpolation bilineaire
//    [imgIn] > [imgOut] (1/sc)(lgth) (1/sc)(wdth)
//----------------------------------------------------
void InterpolBilineaire(float** imgIn,float** imgOut,int lgth,int wdth,float sc)  
{
 int i,j;
 int col_inf,col_sup;
 int row_inf,row_sup;
 float row,col;
 float t,u;
 float ng;
 float scale;

 //>MainLoop
 scale=(1.0/(float)sc);
 for(i=0;i<(scale*lgth);i++) for(j=0;j<(scale*wdth);j++)
     {
      col=(float)j/(float)scale;
      row=(float)i/(float)scale;

      col_inf=(int)(col);
      col_sup=(int)(col+1);
      row_inf=(int)(row);
      row_sup=(int)(row+1);

      if (col_sup>(wdth-1))  col_sup-=wdth;
      if (row_sup>(lgth-1))  row_sup-=lgth;

      t=(col-col_inf)/(col_sup-col_inf);
      u=(row-row_inf)/(row_sup-row_inf);
     	
      ng=(1-t)*(1-u)*imgIn[row_inf][col_inf];
      ng+=t*(1-u)*imgIn[row_inf][col_sup];
      ng+=t*u*imgIn[row_sup][col_sup];
      ng+=(1-t)*u*imgIn[row_sup][col_inf];
      imgOut[i][j]=(int)ng;   
     }
}

//-----------------//
//-- HISTO MANIP --//
//-----------------//
//-----------------------------------------------------
// calcul de l'histogramme                           
//-----------------------------------------------------
void Compute_histo(float** img,int lgth,int wdth,float* hist)
{
 int i,j;

  //initialisation
  for(i=0;i<GREY_LEVEL;i++) hist[i]=0.0;

  //calcul de l'histogramme
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    if ((img[i][j]>0)&&(img[i][j]<GREY_LEVEL))
       hist[(int)(img[i][j]+0.5)]++;
 
  //normalisation
  for(i=0;i<GREY_LEVEL;i++)  hist[i]/=(float)(wdth*lgth);
}

//------------------------------------------------
// Specif. histo[img_in] sur histo[img_out]
// (img_in possédant le même histo que img_out)
//------------------------------------------------
void SpecifHisto(float** img_in,int lgth_in,int wdth_in,float** img_out,int lgth_out,int wdth_out)
 {
  int i,j;
  float Hist_Img1[GREY_LEVEL+1],Hist_Img2[GREY_LEVEL+1];
  float Vect_Img1[GREY_LEVEL+1],Vect_Img2[GREY_LEVEL+1],Vect_Img3[GREY_LEVEL+1];

  //--------Egalisation------------
  //Initialisation
  for(i=0;i<=GREY_LEVEL;i++)
    { Hist_Img1[i]=Hist_Img2[i]=0.0;
      Vect_Img1[i]=Vect_Img2[i]=Vect_Img3[i]=0.0; }

  //Calcule histo[img_in]
  Compute_histo(img_in,lgth_in,wdth_in,Hist_Img1);

  //Calcule T::fonctRepartition[img_in]>Vect_Img1
  for(i=0;i<=GREY_LEVEL;i++)
    { if (i>0)  Vect_Img1[i]=Vect_Img1[i-1]+Hist_Img1[i];
      else      Vect_Img1[i]=Vect_Img1[i]; }
  for(i=0;i<=GREY_LEVEL;i++) Vect_Img1[i]=(int)((Vect_Img1[i]*255)+0.5);

  //Egalise histo[img_in]
  for(i=0;i<lgth_in;i++) for(j=0;j<wdth_in;j++)
     img_in[i][j]=(int)Vect_Img1[(int)(img_in[i][j])];

  //========================

  //Calcule histo[img_out]
  Compute_histo(img_out,lgth_out,wdth_out,Hist_Img2);

  //Calcule G::fonctRepartition[img_out]>Vect_Img2
  for(i=0;i<=GREY_LEVEL;i++)
    { if (i>0)  Vect_Img2[i]=Vect_Img2[i-1]+Hist_Img2[i];
      else      Vect_Img2[i]=Vect_Img2[i]; }
  for(i=0;i<=GREY_LEVEL;i++) Vect_Img2[i]=(int)((Vect_Img2[i]*255)+0.5);

  //Calcule G^-1 (avec G=Vect_Img2)>Vect_Img3
  for(i=0;i<=GREY_LEVEL;i++)
    { Vect_Img3[i]=i;
      for(j=GREY_LEVEL;j>0;j--) if (Vect_Img2[j]>i) Vect_Img3[i]=j; }

  //Specif. histo[img_in]>histo[img_out]
  for(i=0;i<lgth_in;i++) for(j=0;j<wdth_in;j++)
  if ((int)(img_in[i][j])<(GREY_LEVEL+1)) img_in[i][j]=(int)Vect_Img3[(int)(img_in[i][j])];
 }

//------------------------------------------------
// Double Specif. histo [img_in::img_out]
//------------------------------------------------
void DoubleSpecifHisto(float** img1,float** img2,int lgth,int wdth)
{
 //>DoubleHistoSpecif
 SpecifHisto(img1,lgth,wdth,img2,lgth,wdth);
 SpecifHisto(img2,lgth,wdth,img1,lgth,wdth);
}

//----------------------------------------------------------
// Rempli une matrice (carree) ImgHist de
// l'histogramme de MatObs
// et du mélange de distribution (2 lois Gauss)
//----------------------------------------------------------
void FillPictHist(float** ImgHist,int SzImgHist,float** MatObs,int lgth,int wdth,float** ParExpDistMixt)
{
 int i,j,c,p;
 int k;
 int row,col;
 double FctStrchLgthHist;
 float tmp,tp;
 const int MAXGREYLEVEL=256;

 //Presentation
 printf("\n > FillPictHist");
 fflush(stdout);

 //AllocateMemory_Initialization
 for(i=0;i<SzImgHist;i++) for(j=0;j<SzImgHist;j++) ImgHist[i][j]=GREY_LEVEL;
 float* VctHist=fmatrix_allocate_1d(MAXGREYLEVEL);
 for(k=0;k<MAXGREYLEVEL;k++) VctHist[k]=0.0;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) VctHist[(int)(MatObs[i][j]+0.5)]++;
 for(k=0;k<MAXGREYLEVEL;k++) VctHist[k]/=(lgth*wdth);
 FctStrchLgthHist=6000.0;  //--HERE !!!!

 //Draw_Img_Histogram
 for(p=0;p<MAXGREYLEVEL;p++)
   { tmp=(int)(VctHist[p]*FctStrchLgthHist); 
     if (tmp>=SzImgHist) tmp=(SzImgHist-1);
     for(tp=tmp;tp>0;tp--) 
        {  row=SzImgHist-tp;
           col=p;
	   ImgHist[row][col]=(GREY_LEVEL/2); } }

 //Draw_Mixture_Two_Gaussians
 float pp;
 for(c=0;c<2;c++)
    { for(pp=0;pp<MAXGREYLEVEL;pp+=0.1)
	 { tmp=FctStrchLgthHist*funcgauss((float)pp,ParExpDistMixt[c][0],ParExpDistMixt[c][1],ParExpDistMixt[c][2]);
           if (tmp>=SzImgHist) tmp=(SzImgHist-1);
           row=SzImgHist-tmp;
           col=pp;
	   if (row<SzImgHist) ImgHist[row][col]=0; } }

 //>Free_Memory
 if (VctHist) free_fmatrix_1d(VctHist);
}

//----------------------------------------------------------
// function Normal
//----------------------------------------------------------
float funcgauss(float val,float coef,float moy,float var)
{
 return ((coef)*(1/(sqrt(2*PI*var)))*exp(-1*(CARRE(val-moy)/(2*var))));
}


//-----------//
//--RESULTS--//
//-----------//
//----------------------------------------------------------
// ConfusionMatrix
//----------------------------------------------------------
void ConfusionMatrix(float*** ImgCon,float** ImgSegWB,float** ImgGtrWB,int lgth,int wdth,float* Res)
{
 int i,j;
 long int TN,TP,FP,FN;
 float pTN,pTP,pFP,pFN;
 float Prec;
 int NbPix;
 
 //_Main_loop_
 //-----------
 TN=TP=FP=FN=0;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    { //>--TN--
     if ((!ImgGtrWB[i][j])&&(!ImgSegWB[i][j]))
        { ImgCon[0][i][j]=255;
	  ImgCon[1][i][j]=255;
	  ImgCon[2][i][j]=255;
	  TN++; }

     //>--TP--
     if ((ImgGtrWB[i][j])&&(ImgSegWB[i][j]))
        { ImgCon[0][i][j]=255;
	  ImgCon[1][i][j]=0;
	  ImgCon[2][i][j]=0;
	  TP++; }

     //>--FP--
     if ((!ImgGtrWB[i][j])&&(ImgSegWB[i][j]))
        { ImgCon[0][i][j]=0;
	  ImgCon[1][i][j]=0;
	  ImgCon[2][i][j]=255;
	  FP++; }

     //>--FN--
     if ((ImgGtrWB[i][j])&&(!ImgSegWB[i][j]))
        { ImgCon[0][i][j]=0;
	  ImgCon[1][i][j]=255;
	  ImgCon[2][i][j]=255;
	  FN++; } }

 //>Result
 NbPix=lgth*wdth;
 pTN=100.0*(float)TN/(float)NbPix;
 pTP=100.0*(float)TP/(float)NbPix;
 pFP=100.0*(float)FP/(float)NbPix;
 pFN=100.0*(float)FN/(float)NbPix;
 Res[0]=pTN;
 Res[1]=pTP;
 Res[2]=pFP;
 Res[3]=pFN;
 Prec=pTN+pTP;
 printf("\n > [TN=%.3f][TP=%.3f][FP=%.3f][FN=%.3f]>>[%.5f]",pTN,pTP,pFP,pFN,Prec);
 fflush(stdout);
}

//----------------------------------------------------------
// F-Measure
//----------------------------------------------------------
float FMeasure(float** ImgSegWB,float** ImgGtrWB,int lgth,int wdth)
{
 int i,j;
 long int TN,TP,FP,FN;
 float pTN,pTP,pFP,pFN;
 float Prec;
 float Precision,Recall,FMeasure;
 int NbPix;
 
 //_Main_loop_
 //-----------
 TN=TP=FP=FN=0;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    { //>--TN--
     if ((!ImgGtrWB[i][j])&&(!ImgSegWB[i][j])) TN++;
     //>--TP--
     if ((ImgGtrWB[i][j])&&(ImgSegWB[i][j])) TP++;
     //>--FP--
     if ((!ImgGtrWB[i][j])&&(ImgSegWB[i][j])) FP++;
     //>--FN--
     if ((ImgGtrWB[i][j])&&(!ImgSegWB[i][j])) FN++;  }

 //>Result
 NbPix=lgth*wdth;
 pTN=100.0*(float)TN/(float)NbPix;
 pTP=100.0*(float)TP/(float)NbPix;
 pFP=100.0*(float)FP/(float)NbPix;
 pFN=100.0*(float)FN/(float)NbPix;
 Prec=pTN+pTP;
 if (0) printf("\n > [TN=%.3f][TP=%.3f][FP=%.3f][FN=%.3f]>>[%.5f]",pTN,pTP,pFP,pFN,Prec);
 Precision=(float)TP/((float)TP+(float)FP);
 Recall=(float)TP/((float)TP+(float)FN);
 FMeasure=(2*Precision*Recall)/(Precision+Recall);
 if ((TP==0)&&(FP==0)) { FMeasure=0.0; printf("**********"); }
 if (TP==0) FMeasure=0.0;
 printf("\n > [Precision=%.3f][Recall=%.3f]>>[Fmeasure=%.3f]",Precision,Recall,FMeasure);
 fflush(stdout);
 return FMeasure;
}

//----------------------------------------------------------
// Precision
//----------------------------------------------------------
float Precis(float** ImgSegWB,float** ImgGtrWB,int lgth,int wdth)
{
 int i,j;
 long int TN,TP;
 float pTN,pTP;
 float Precision;
 int NbPix;
 
 //_Main_loop_
 //-----------
 TN=TP=0;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    { //>--TN--
     if ((!ImgGtrWB[i][j])&&(!ImgSegWB[i][j])) TN++;
     //>--TP--
     if ((ImgGtrWB[i][j])&&(ImgSegWB[i][j])) TP++;  }

 //>Result
 NbPix=lgth*wdth;
 pTN=100.0*(float)TN/(float)NbPix;
 pTP=100.0*(float)TP/(float)NbPix;
 Precision=pTN+pTP;
 printf(" [Precision=%.3f]",Precision);
 fflush(stdout);
 return Precision;
}

//------------//
//-- GESTION--//
//------------//
//----------------------------------------------------------
// AbsDiff      
//----------------------------------------------------------
void AbsDiff(float** MatAft,float** MatTmp1,float** MatTmp2,int lgth,int wdth)
{
 int i,j;

 //>Loop
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
 MatTmp2[i][j]=fabs(MatAft[i][j]-MatTmp1[i][j]);
}

//----------------------------------------------------------
// Diff      
//----------------------------------------------------------
void Diff(float** MatAft,float** MatTmp1,float** MatTmp2,int lgth,int wdth)
{
 int i,j;

 //>Loop
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
 MatTmp2[i][j]=(MatAft[i][j]-MatTmp1[i][j]);
}

//----------------------------------------------------------
// MedianFilter     
//----------------------------------------------------------
void MedianFilter(int*** VctWin,int Knn,int Lgth,int Wdth,int** WinOut)
{
 int i,j,k;
  
 //>AllocateMemory
 int* Vct=imatrix_allocate_1d(Knn);

 //>MainLoop
 for(i=0;i<Lgth;i++) for(j=0;j<Wdth;j++)
    { for(k=0;k<Knn;k++) Vct[k]=VctWin[k][i][j];
      InsertionSort(Vct,Knn);
      WinOut[i][j]=Vct[Knn/2]; }

 //>FreeMemory
 if (Vct) free_imatrix_1d(Vct);
}

//----------------------------------------------------------
// Insertion_sort 
//----------------------------------------------------------
void InsertionSort(int* a,int size)
{
 int i,j,k;
 for (i=1;i<size;++i)
     { 
      k=a[i];
      j=i-1;
      while ((j>=0)&&(k<a[j]))
        { a[j + 1] = a[j];
          --j; }
        a[j+1]=k;
     }
}

//----------------------------------------------------------
// MeanFilter     
//----------------------------------------------------------
void MeanFilter(int*** VctWin,int Knn,int Lgth,int Wdth,int** WinOut)
{
 int i,j,k;
 float sum;
  
 //>MainLoop
 for(i=0;i<Lgth;i++) for(j=0;j<Wdth;j++)
    { sum=0.0;
      for(k=0;k<Knn;k++) sum+=VctWin[k][i][j];
      sum=sum/Knn;
      WinOut[i][j]=(int)(sum+0.5); }
}

//----------------------------------------------------------
// Grad
//----------------------------------------------------------     
void Grad(float** MatIn,int lgth,int wdth)
 { 
  int i,j;
  float tmp,max;

  //AllocMemoire
  float** MatGrd=fmatrix_allocate_2d(lgth,wdth);

  //>Init
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) MatGrd[i][j]=0.0;

  //>Gradient
  for(i=1;i<(lgth-1);i++) for(j=1;j<(wdth-1);j++)
     { tmp=CARRE(MatIn[i+1][j]-MatIn[i-1][j])+CARRE(MatIn[i][j+1]-MatIn[i][j-1]);  
       tmp=sqrt(tmp); 
       MatGrd[i][j]=tmp; }
     
  //>Normalize
  max=0.0;
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) { if (MatGrd[i][j]>max) max=MatGrd[i][j]; }
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)   MatGrd[i][j]=((MatGrd[i][j]*255.0)/max);
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)   MatIn[i][j]=MatGrd[i][j];

  //Liberation Memoire
  if (MatGrd) free_fmatrix_2d(MatGrd);
 }

//----------------------------------------------------------
// FctLog
//----------------------------------------------------------     
void FctLog(float** MatIn,int lgth,int wdth)
 { 
  int i,j;
  float max;

  //AllocMemoire
  float** MatLog=fmatrix_allocate_2d(lgth,wdth);

  //>Init
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) MatLog[i][j]=0.0;

  //>Gradient
  for(i=1;i<(lgth-1);i++) for(j=1;j<(wdth-1);j++) MatLog[i][j]=log(1+MatIn[i][j]);
     
  //>Normalize
  max=0.0;
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) { if (MatLog[i][j]>max) max=MatLog[i][j]; }
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)   MatLog[i][j]=((MatLog[i][j]*255.0)/max);
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)   MatIn[i][j]=MatLog[i][j];

  //Liberation Memoire
  if (MatLog) free_fmatrix_2d(MatLog);
 }

//----------------------------------------------------------
// EdgeBooster
//----------------------------------------------------------     
void EdgeBooster(float** MatIn,int lgth,int wdth,float kk)
 { 
  int i,j;
  float sum,tmp,max;

  //AllocMemoire_&_Init
  float** MatTmp=fmatrix_allocate_2d(lgth,wdth);
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) MatTmp[i][j]=0.0;

  //>Gradient
  for(i=1;i<(lgth-1);i++) for(j=1;j<(wdth-1);j++)
     { sum=0.0;
       sum=4*MatIn[i][j];
       sum+=2*MatIn[i-1][j];
       sum+=2*MatIn[i+1][j];
       sum+=2*MatIn[i][j-1]; 
       sum+=2*MatIn[i][j+1]; 
       sum+=1*MatIn[i+1][j+1]; 
       sum+=1*MatIn[i-1][j-1];
       sum+=1*MatIn[i-1][j+1];
       sum+=1*MatIn[i+1][j-1]; 
       sum/=16.0;
       sum+=0.5;
       tmp=(kk*MatIn[i][j]-sum);
       MatTmp[i][j]=(int)(tmp); }

  //>Check
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
     { if (MatTmp[i][j]<0) MatTmp[i][j]=0;
       if (MatTmp[i][j]>255) MatTmp[i][j]=255;	}	  
     
  //>Normalize
  max=0.0;
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) { if (MatTmp[i][j]>max) max=MatTmp[i][j]; }
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)   MatTmp[i][j]=((MatTmp[i][j]*255.0)/max);
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)   MatIn[i][j]=MatTmp[i][j];

  //Liberation Memoire
  if (MatTmp) free_fmatrix_2d(MatTmp);
 }

//----------------------------------------------------------
// GaussianFilter
//----------------------------------------------------------
void GaussianFilter(float** mt,int lgth,int wdth,int Nb) 
{
 int i,j,k;
 float tmp;

 //MemoryAllocation
 float** mat_tmp=fmatrix_allocate_2d(lgth,wdth);

 //Filtre Gaussian
 for(k=0;k<Nb;k++)
   {
    for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) mat_tmp[i][j]=mt[i][j];
 
    for(i=1;i<(lgth-1);i++) for(j=1;j<(wdth-1);j++)
       { tmp=0.0;
         tmp+=4*mt[i][j];
         tmp+=2*mt[i+1][j]; tmp+=2*mt[i-1][j]; tmp+=2*mt[i][j+1]; tmp+=2*mt[i][j-1];
         tmp+=mt[i+1][j+1]; tmp+=mt[i-1][j-1]; tmp+=mt[i+1][j-1]; tmp+=mt[i-1][j+1];
         tmp/=16.0;
         mat_tmp[i][j]=tmp; }

    for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)  mt[i][j]=mat_tmp[i][j];
   }

 //FreeMemory
 free_fmatrix_2d(mat_tmp);
}

//----------------------------------------------------------*/
//  MedianFilter                                               
//----------------------------------------------------------*/
void MedianFilter(float** mat,int lgth,int wdth,int size)
{
 int i,j,k,l,m;
 int nb;
 float tmp;

 float** mat_tmp;
 float* vect;

 //reservation memoire
 mat_tmp=fmatrix_allocate_2d(lgth,wdth);
 vect=fmatrix_allocate_1d(size*size);

 //recopie matrice
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    mat_tmp[i][j]=mat[i][j];

 //Filtre median
 for(i=(size/2);i<(lgth-(size/2));i++) for(j=(size/2);j<(wdth-(size/2));j++)
   {
    nb=0;

    for(k=-(size/2);k<=(size/2);k++) for(l=-(size/2);l<=(size/2);l++)  
        vect[nb++]=mat_tmp[i+k][j+l];

    for(l=0;l<((size*size)-1);l++) for(m=0;m<((size*size)-1);m++)
       if (vect[m]>vect[m+1]) 
	  { tmp=vect[m];
            vect[m]=vect[m+1];
            vect[m+1]=tmp; } 

   mat[i][j]=vect[((size*size)/2)+1]; 
   }

 //liberation memoire
 free_fmatrix_2d(mat_tmp);
 free(vect); 
}

//----------------------------------------------------------
// FilterMat                                              
//----------------------------------------------------------
void FilterMat(int*** MatGaussParam,int lgth,int wdth,int NbMap,int Nb,int Methd)
{
 int i,j,k;

 //>ÀllocMemory_&_Transf
 float** Mat=fmatrix_allocate_2d(lgth,wdth);
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) Mat[i][j]=MatGaussParam[NbMap][i][j];

 //>Filtering_&_Transf
 if (Methd==0) for(k=0;k<Nb;k++) GaussianFilter(Mat,lgth,wdth,1);
 if (Methd==1) for(k=0;k<Nb;k++) MedianFilter(Mat,lgth,wdth,3);
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) MatGaussParam[NbMap][i][j]=Mat[i][j];

 //>FreeMemory
 free_fmatrix_2d(Mat);
}

//---------------
//---------------
//---K-MEAN------
//---------------
//---------------
//----------------------------------------------------------
// Identical                      
//----------------------------------------------------------
int Identical(float* VctPts,float** MtxCtrs,int nbcl,int nbpar)
{
 int k,l;
 int value=0;

 for(k=0;k<nbcl;k++) 
   { value=1;
     for(l=0;l<nbpar;l++) if (VctPts[l]!=MtxCtrs[k][l]) value=0;
     if (value) return value; }
    
 return value;
}

//----------------------------------------------------------
//  KMean  
//----------------------------------------------------------
void Kmean(float** MatrixPts,int NbClusters,int NbPts,int NbParam,int* VctLabel,int Seed,int Verbose)
{
 int i,j,k,l;
 int classe;
 float aleat;
 int nb;
 float  dist,distmin;
 int flag;
 const int NBITERMAX=10;
 
 //Allocation memoire
 float** MatrixCtrs=fmatrix_allocate_2d(NbClusters,NbParam);
 
 //Presentation
 if (Verbose) printf("\n  <Seed:%d> -> Funct.Kmean",Seed);
 srand(Seed);

 //--------------------------------------------------------------
 // -[0]- Initialize Centroid
 // --------------------------------------------------------------
  if (0)                    
  for(i=0;i<NbClusters;i++) 
     { aleat=(i+1)*(NbPts/(NbClusters+2));
       for(k=0;k<NbParam;k++) MatrixCtrs[i][k]=MatrixPts[(int)aleat][k]; } 

  if (1)
  for(i=0;i<NbClusters;i++) 
   { nb=0;
     do { aleat=(int)((randomize())*NbPts-1); nb++; }
     while((i)&&(nb<100)&&(Identical(MatrixPts[(int)aleat],MatrixCtrs,NbClusters,NbParam)));
     if ((Verbose)&&(nb>0)) printf("[%d]",nb);
     for(k=0;k<NbParam;k++) MatrixCtrs[i][k]=MatrixPts[(int)aleat][k]; } 
  //------------------------------------------------------------------
    
 //================================================================
 //BOUCLE =========================================================
 //================================================================
 for(l=0;l<NBITERMAX;l++)
   {  
       //-[1]- Select_Cluster_Membership
       //-------------------------------
       flag=0; classe=0;

       for(j=0;j<NbPts;j++)
          { distmin=BIGNUMBER;  

           for(i=0;i<NbClusters;i++)
              { dist=0.0; 
                         
                //for(k=0;k<NbParam;k++) dist+=CARRE(MatrixCtrs[i][k]-MatrixPts[j][k]);  //A-Tester
                for(k=0;k<NbParam;k++) dist+=abs(MatrixCtrs[i][k]-MatrixPts[j][k]);
		     
                if (dist<distmin) { distmin=dist; classe=i; }
	      }            
           if (VctLabel[j]!=classe) { VctLabel[j]=classe; flag++; }
	  }

       //-[2]- Stop Criterion & Info
       //---------------------------
       if ((!flag)&&(l>2))  break;
       if (Verbose) { printf("[%d>%d]",l,flag); fflush(stdout); }
          
       
       //-[3]- Update Centroids For Each Clusters
       //----------------------------------------
        for(i=0;i<NbClusters;i++) 
	  {  
           nb=0;    
	   for(k=0;k<NbParam;k++) MatrixCtrs[i][k]=0;
                      
	   for(j=0;j<NbPts;j++) if (VctLabel[j]==i)
	      { nb++;
                for(k=0;k<NbParam;k++) MatrixCtrs[i][k]+=MatrixPts[j][k]; }

           for(k=0;k<NbParam;k++) if (nb) MatrixCtrs[i][k]/=nb;
          }

   }//==============================================================
 //================================================================= 

 //FreeMemory
 if (MatrixCtrs) free_fmatrix_2d(MatrixCtrs);
}

//----------------------------------------------------------     
// KmeanEstimate
//----------------------------------------------------------     
void KmeanEstimate(float** Img,int lgth,int wdth,int NbLabel,float** VctPar,int Seed,int Verbose)
{
  int i,j;
  const int NbFeat=1;
  float prop0,prop1,mean0,mean1,var0,var1;
 
 //>Init-Memory
 int* VctLabel=imatrix_allocate_1d(lgth*wdth);
 float** VctFeat=fmatrix_allocate_2d(lgth*wdth,NbFeat);
 int**   MatSeg=imatrix_allocate_2d(lgth,wdth);
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) VctFeat[(i*wdth)+j][0]=Img[i][j];
 
 //>K-Mean
 printf("\n\n [KMEAN]");
 Kmean(VctFeat,NbLabel,(lgth*wdth),NbFeat,VctLabel,Seed,Verbose);
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)  MatSeg[i][j]=VctLabel[(i*wdth)+j];

 //>FillVctPar
 prop0=prop1=0.0;
 mean0=mean1=0.0;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    {  if (MatSeg[i][j]==0) {  prop0++; mean0+=Img[i][j]; }
       if (MatSeg[i][j])    {  prop1++; mean1+=Img[i][j]; } }
 mean0/=prop0;
 mean1/=prop1;

 var0=var1=0.0;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    {  if (MatSeg[i][j]==0) var0+=CARRE(Img[i][j]-mean0);
       if (MatSeg[i][j])    var1+=CARRE(Img[i][j]-mean1);  }
 var0/=prop0;
 var1/=prop1;

 VctPar[0][0]=prop0/(lgth*wdth);
 VctPar[1][0]=prop1/(lgth*wdth);
 VctPar[0][1]=mean0;
 VctPar[1][1]=mean1;
 VctPar[0][2]=var0;
 VctPar[1][2]=var1;

 if (mean0>mean1) { SWAP(VctPar[0][0],VctPar[1][0]);
                    SWAP(VctPar[0][1],VctPar[1][1]);
		    SWAP(VctPar[0][2],VctPar[1][2]); }
 
 printf("\n [%.2f::%.0f::%.0f]",VctPar[0][0],VctPar[0][1],VctPar[0][2]);
 printf("\n [%.2f::%.0f::%.0f]",VctPar[1][0],VctPar[1][1],VctPar[1][2]);
 fflush(stdout);

 //>FreeMemory
 if (VctFeat)  free_fmatrix_2d(VctFeat);
 if (VctLabel) free_imatrix_1d(VctLabel);
 if (MatSeg)   free_imatrix_2d(MatSeg);
}


//----------------------//
//-- MODEL <CCL> -------//
//----------------------//
//----------------------------------------------------------
// Symmetry                       
//----------------------------------------------------------                
void MakeSymmetry(int** ImgIn,int** ImgOut,int sz,int nb)
{
 int i,j;

 //>Memory_Allocation
 int**  ImgTmp=imatrix_allocate_2d(sz,sz);

 //>Symmetry
 if (nb==0) { for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgOut[i][j]=ImgIn[i][j]; }
 if (nb==1) { for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgOut[j][sz-1-i]=ImgIn[i][j]; }
 if (nb==2) { for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgOut[sz-1-i][sz-1-j]=ImgIn[i][j]; }
 if (nb==3) { for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgOut[sz-1-j][i]=ImgIn[i][j]; }

 if (nb==4) { for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgOut[i][j]=ImgIn[i][j];
              for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgTmp[i][j]=ImgOut[i][j];
              for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgOut[i][sz-1-j]=ImgTmp[i][j]; }

 if (nb==5) { for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgOut[j][sz-1-i]=ImgIn[i][j];
              for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgTmp[i][j]=ImgOut[i][j];
              for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgOut[i][sz-1-j]=ImgTmp[i][j]; }

 if (nb==6) { for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgOut[sz-1-i][sz-1-j]=ImgIn[i][j];
              for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgTmp[i][j]=ImgOut[i][j];
              for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgOut[i][sz-1-j]=ImgTmp[i][j]; }

 if (nb==7) { for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgOut[sz-1-j][i]=ImgIn[i][j];
              for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgTmp[i][j]=ImgOut[i][j];
              for(i=0;i<sz;i++) for(j=0;j<sz;j++) ImgOut[i][sz-1-j]=ImgTmp[i][j]; }
 
 //>FreeMemory 
 if (ImgTmp) free_imatrix_2d(ImgTmp);
}

//----------------------------------------------------------
// EstimateGaussianPar                     
//----------------------------------------------------------                
void EstimateGaussianPar(int*** MatCorGL,int NbEch,int row,int col,int*** MatGaussPar)
{
 int k; 
 float Moy,Var;
 
 Moy=0.0;
 for(k=0;k<NbEch;k++) Moy+=MatCorGL[k][row][col];
 Moy/=NbEch;
 Moy+=0.5;

 Var=0.0;
 for(k=0;k<NbEch;k++)  Var+=CARRE(MatCorGL[k][row][col]-Moy);
 Var/=(NbEch-1);
 Var+=0.5;

 MatGaussPar[0][row][col]=Moy;
 MatGaussPar[1][row][col]=Var;
}

//----------------------------------------------------------
// EstimateGaussianPar
// [30%]-[] Trimmed Estimator
//----------------------------------------------------------                
void EstimateGaussianParRobust(int*** MatCorGL,int NbEch,int row,int col,int*** MatGaussPar,float Trim,int OptEst)
{
 int k,l,m; 
 float Moy,Var;
 int tmp,nb;
 float NbEchTrimmed;
 float TRIMMED=Trim;

 //>AllocateMemory
 int* vect=imatrix_allocate_1d(NbEch);
 for(k=0;k<NbEch;k++) vect[k]=MatCorGL[k][row][col];

 //>Sort
 for(l=0;l<(NbEch-1);l++) for(m=0;m<(NbEch-1);m++)
  if (vect[m]>vect[m+1]) 
     { tmp=vect[m];
       vect[m]=vect[m+1];
       vect[m+1]=tmp; }

 //>[OptEst=0]:::Trimmed-Mean-Var-Estimator
 NbEchTrimmed=(int)(TRIMMED*0.5*NbEch);
 //printf("[NbEchTrimmed=%d]",(int)NbEchTrimmed);
 for(k=0;k<NbEchTrimmed;k++) vect[k]=-1;
 for(k=(NbEch-1);k>=(NbEch-1-NbEchTrimmed);k--) vect[k]=-1;
 
 nb=0;
 Moy=0.0;
 for(k=0;k<NbEch;k++)
    { if (vect[k]>=0)
	 { nb++;
	   Moy+=MatCorGL[k][row][col]; } }	    
 Moy/=nb;
 Moy+=0.5;

 nb=0;
 Var=0.0;
 for(k=0;k<NbEch;k++)
    { if (vect[k]>=0)
	 { nb++;
           Var+=CARRE(MatCorGL[k][row][col]-Moy); } }
 Var/=(nb-1);
 Var+=0.5;

 MatGaussPar[0][row][col]=Moy;
 MatGaussPar[1][row][col]=Var;

 //>[OptEst=1]:::HSM-Mean-Estimator
 if (OptEst==1)  MatGaussPar[0][row][col]=HalfSampleMode(vect,NbEch);

 //>[OptEst=2]:::Shorth-Mean-Estimator
 if (OptEst==2)  MatGaussPar[0][row][col]=Shorth(vect,NbEch);

 //>[OptEst=3]:::lms-Mean-Estimator
 if (OptEst==3)  MatGaussPar[0][row][col]=LeastMedianOfSquares(vect,NbEch);

 //>FreeMemory
 free_imatrix_1d(vect);
}

//----------------------------------------------------------
// funcgauss
//----------------------------------------------------------
float funcgauss(int val,float moy,float var)
{
return (float)((1/(sqrt(2*PI*var)))*exp(-1*(CARRE((float)val-moy))/(2*var)));
}

//----------------------------------------------------------
// FillBinomProbMatrix             
//----------------------------------------------------------                
void FillBinomProbMatrix(float*** MatProb,int lgth,int wdth,int*** MatGaussPar,float** ImgAft)
{
 int i,j,k;
 int val;
 float sum;

 //MainLoop
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    { val=ImgAft[i][j];
      MatProb[0][i][j]=funcgauss(val,MatGaussPar[0][i][j],MatGaussPar[1][i][j]);
      MatProb[1][i][j]=(1.0/256.0);

      sum=0.0;
      for(k=0;k<2;k++)  sum+=MatProb[k][i][j];
      for(k=0;k<2;k++)  MatProb[k][i][j]/=sum; }
}

//----------------------------------------------------------
//  GiveRangeGreyLevelValues  (Linear complexity)       
//----------------------------------------------------------     
int GiveRangeGreyLevelValues(float** Img,int lgth,int wdth,float prop)
{
 int i,j,k;
 float min,max;
 float NbPixEachSide;
 int nb;

  //>FindRange
  const int NBGREYLEVEL=256;
  int* vect=imatrix_allocate_1d(NBGREYLEVEL);
  for(k=0;k<NBGREYLEVEL;k++) vect[k]=0.0;
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) vect[(int)Img[i][j]]++;
			
  NbPixEachSide=(int)(((1.0-prop)/2)*lgth*wdth);
  printf("[NbPixEachSide=%.0f]",NbPixEachSide);
  fflush(stdout);

  nb=0;
  for(k=0;k<NBGREYLEVEL;k++)
     { nb+=vect[k];
       if (nb>NbPixEachSide) break; }
  min=(k-1);

  nb=0;
  for(k=(NBGREYLEVEL-1);k>=0;k--)
     { nb+=vect[k];
       if (nb>NbPixEachSide) break; }
  max=(k-1);

  printf("\n >  Stat:[min%.0f:max%.0f]>",min,max);
  fflush(stdout);

  //>FreeMemory
  free_imatrix_1d(vect);

  //>Return
  return (max-min);   
}

//----------------------//
//----------------------//
//-- MODEL <FRCT> ------//
//----------------------//
//----------------------------------------------------------
//----------------------------------------------------------
//  EstimateNScaleSimilarity      
//----------------------------------------------------------    
//----------------------------------------------------------
void EstimateNScaleSimilarity(float** ImgBef,int lgth,int wdth,		\
			      float Scale,int SzW,int*** FrctFile,int Kn,int Eps_)
{
 int i,j,k,l,m,r,c,p;
 int simnb;
 int posr,posc;
 int cpt;
 int HalfLgth=(int)((float)lgth/Scale);
 int HalfWdth=(int)((float)wdth/Scale);

 //>DEBUG
 //printf("[HlfLgth:%d][HlfWdth:%d]",HalfLgth,HalfWdth);
  
 //>ModelParameters_
 const int nb_sym=8;
 const int EPS=Eps_;
 const int KNN=Kn;        
 const int n_pts=(HalfLgth*HalfWdth*nb_sym);  
 const int dim=(SzW*SzW);

 //>AnnParameters_&_Allocation_
 ANNpointArray data_pts;
 ANNpoint       query_pt;
 ANNidxArray    nn_idx;
 ANNdistArray   dists;
 ANNkd_tree      *the_tree;

 query_pt=annAllocPt(dim);
 data_pts=annAllocPts(n_pts,dim);
 nn_idx=new ANNidx[KNN];
 dists=new ANNdist[KNN];

 //>AllocateMemory_&_Init_
 int** SquWinIn=imatrix_allocate_2d(SzW,SzW);
 int** SquWinOut=imatrix_allocate_2d(SzW,SzW);
 int** PosPix=imatrix_allocate_2d(3,n_pts);
 
 float** ImgBefLR=fmatrix_allocate_2d(lgth/Scale,wdth/Scale);
 if (Scale>=1) Multires(ImgBef,lgth,wdth,ImgBefLR,Scale);
 if (Scale<1)  InterpolBilineaire(ImgBef,ImgBefLR,SzW,SzW,Scale);         

 //>_BuildTreeSearchStructureIn_[ImgBefWBLR]
 //printf("\n    :A::Build_Tree_Search_Structure_...[sc=%.1f][Knn=%d]",Scale,Kn);
 //fflush(stdout);
 cpt=0;
 for(i=0;i<(HalfLgth-SzW+1);i++) for(j=0;j<(HalfWdth-SzW+1);j++)
    { for(k=0;k<SzW;k++) for(l=0;l<SzW;l++) SquWinIn[k][l]=ImgBefLR[i+k][j+l];
      
      for(m=0;m<nb_sym;m++)
	 { MakeSymmetry(SquWinIn,SquWinOut,SzW,m);
           for(r=0;r<SzW;r++) for(c=0;c<SzW;c++) data_pts[cpt][(r*SzW)+c]=SquWinOut[r][c];
	   //if ((Scale==1)&&(m==0)) for(r=0;r<SzW;r++) for(c=0;c<SzW;c++) data_pts[cpt][(r*SzW)+c]=255; //>A-ESSAYER
	   PosPix[0][cpt]=m;
	   PosPix[1][cpt]=i;
	   PosPix[2][cpt]=j;
	   cpt++; }   
    }
 //printf("...[NbPtsQTree:%d]",cpt);
 //fflush(stdout);
 the_tree=(ANNkd_tree*)new ANNkd_tree(data_pts,cpt,dim);

 //>BuildCorrespondanceIn_[ImgBefWB]
 //printf("\n    :B::Build_NCorrespondance_...[sc=%.1f][Knn:%d]",Scale,KNN);
 //fflush(stdout);
 cpt=0;
 for(i=0;i<(lgth-SzW+1);i+=SzW) for(j=0;j<(wdth-SzW+1);j+=SzW)
    { for(k=0;k<SzW;k++) for(l=0;l<SzW;l++) SquWinIn[k][l]=ImgBef[i+k][j+l];

      for(r=0;r<SzW;r++) for(c=0;c<SzW;c++) query_pt[(r*SzW)+c]=SquWinIn[r][c];
      the_tree->annkSearch(query_pt,KNN,nn_idx,dists,EPS);

      for(p=0;p<KNN;p++)
         { simnb=PosPix[0][nn_idx[p]];
           posr=PosPix[1][nn_idx[p]];
           posc=PosPix[2][nn_idx[p]];
           FrctFile[cpt][p][0]=i;
           FrctFile[cpt][p][1]=j;
           FrctFile[cpt][p][2]=posr;
           FrctFile[cpt][p][3]=posc;
           FrctFile[cpt][p][4]=simnb;
           FrctFile[cpt][p][5]=dists[p]; }
      cpt++;
    }
 //printf("...[>NbWnds:%d]",cpt);
 fflush(stdout);
 
 //>FreeMemory
 if (data_pts!=NULL)  delete data_pts;
 if (the_tree!=NULL)  delete the_tree;
 if (dists!=NULL)     delete dists;
 if (query_pt!=NULL)  delete query_pt;
 if (nn_idx!=NULL)    delete nn_idx;
 if (SquWinIn)  free_imatrix_2d(SquWinIn);
 if (SquWinOut) free_imatrix_2d(SquWinOut);
 if (PosPix)    free_imatrix_2d(PosPix);
 if (ImgBefLR)  free_fmatrix_2d(ImgBefLR);
}

//----------------------------------------------------------
//----------------------------------------------------------
//  KNNFractalIter     
//----------------------------------------------------------
//----------------------------------------------------------
void KNNFractalIter(float** ImgInit,int lgth,int wdth,float** ImgOut,\
		    int SzW,float Scale,int*** FrctFile,int NbRowFctFile,int NbIter,int Kn,int Meth)
{
 int i,j,k,l,m,t,p;
 int row,col;
 int posr,posc;
 int transf;
 float ResErr;
 const int VERSION=0;

  //>AllocateMemory_&_Init_
 int** SquWinHR=imatrix_allocate_2d(SzW*Scale,SzW*Scale);
 int** SquWinIn=imatrix_allocate_2d(SzW,SzW);
 int** SquWinOut=imatrix_allocate_2d(SzW,SzW);
 int** SquWinTarget=imatrix_allocate_2d(SzW,SzW);
 int*** VctSquWinOut=imatrix_allocate_3d(Kn,SzW,SzW);
 float** ImgTmp=fmatrix_allocate_2d(lgth,wdth);

 //>Init
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) ImgOut[i][j]=ImgInit[i][j];  
 if (VERSION) for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) ImgTmp[i][j]=ImgInit[i][j]; 

 //>MainLoop-------------------------
 for(t=0;t<NbIter;t++)
    {
     //printf("-");
     //fflush(stdout);
     for(m=0;m<NbRowFctFile;m++)
        {
          row=FrctFile[m][0][0];
          col=FrctFile[m][0][1];
	  if ((row==-1)||(col==-1)) break;
	  //>DEBUG
	  //printf("[r%d:c%d]",row,col);
	  //fflush(stdout);
	  
	  for(p=0;p<Kn;p++)
	     {
              posr=Scale*FrctFile[m][p][2];
              posc=Scale*FrctFile[m][p][3];
              transf=FrctFile[m][p][4];
      
              for(k=0;k<(SzW*Scale);k++) for(l=0;l<(SzW*Scale);l++) SquWinHR[k][l]=ImgOut[posr+k][posc+l];
              if (Scale>=1) Multires(SquWinHR,(SzW*Scale),(SzW*Scale),SquWinIn,Scale);
              if (Scale<1)  InterpolBilineaire(SquWinHR,SquWinIn,(SzW*Scale),(SzW*Scale),Scale);        
	      
	      MakeSymmetry(SquWinIn,SquWinOut,SzW,transf);
              for(k=0;k<SzW;k++) for(l=0;l<SzW;l++) VctSquWinOut[p][k][l]=SquWinOut[k][l];
	     }
	  
	  //if (Meth==0) MeanFilter(VctSquWinOut,Kn,SzW,SzW,SquWinOut);
	  //if (Meth==1) MedianFilter(VctSquWinOut,Kn,SzW,SzW,SquWinOut);
	  //if (Meth==2) { for(k=0;k<SzW;k++) for(l=0;l<SzW;l++) SquWinTarget[k][l]=ImgInit[row+k][col+l]; 
	  //               BestFilter(VctSquWinOut,Kn,SzW,SzW,SquWinOut,SquWinTarget); }
	  if (Meth==3) { for(k=0;k<SzW;k++) for(l=0;l<SzW;l++) SquWinTarget[k][l]=ImgInit[row+k][col+l]; 
	                 BestNFilter(VctSquWinOut,Kn,SzW,SzW,SquWinOut,SquWinTarget,Kn/2);
	                }

	 if (!VERSION) for(k=0;k<SzW;k++) for(l=0;l<SzW;l++) ImgOut[row+k][col+l]=SquWinOut[k][l];   
	 if (VERSION)  for(k=0;k<SzW;k++) for(l=0;l<SzW;l++) ImgTmp[row+k][col+l]=SquWinOut[k][l]; 
	}

     ResErr=0.0;
     for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) ResErr+=CARRE(ImgInit[i][j]-ImgOut[i][j]);
     ResErr=sqrt(ResErr/(lgth*wdth));
     if (VERSION) for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) ImgOut[i][j]=ImgTmp[i][j]; 
     //printf("\n > [Method:%d][Iter:%d][ResEr=%.2f <Knn:%d>]",Meth,t,ResErr,Kn);
     //fflush(stdout);
    }//-------------------------------

 //>FreeMemory
 if (SquWinHR)  free_imatrix_2d(SquWinHR);
 if (SquWinIn)  free_imatrix_2d(SquWinIn);
 if (SquWinOut) free_imatrix_2d(SquWinOut);
 if (SquWinTarget) free_imatrix_2d(SquWinTarget);
 if (ImgTmp)    free_fmatrix_2d(ImgTmp);
}

//----------------------------------------------------------
// BestFilter
//----------------------------------------------------------
void BestFilter(int*** VctWin,int Knn,int Lgth,int Wdth,int** WinOut,int** WinTgt)
{
 int i,j,k;
 float Diff,MinDiff;
  
 //>MainLoop
 for(k=0;k<Knn;k++)
    {
     MinDiff=100000000;
     Diff=0.0;
     for(i=0;i<Lgth;i++) for(j=0;j<Wdth;j++) Diff+=CARRE(VctWin[k][i][j]-WinTgt[i][j]) ;
     if (Diff<MinDiff)
        { MinDiff=Diff;
	  for(i=0;i<Lgth;i++) for(j=0;j<Wdth;j++) WinOut[i][j]=VctWin[k][i][j]; }
    }
}

//----------------------------------------------------------
// BestNNFilter
//----------------------------------------------------------
void BestNFilter(int*** VctWin,int Knn,int Lgth,int Wdth,int** WinOut,int** WinTgt,int Bnn)
{
 int i,j,k,l;
 float tmp,diff,sum;

 //>AllocateMemory_&_Init_
 float* VctDiff=fmatrix_allocate_1d(Knn);
 int** SquWin=imatrix_allocate_2d(Lgth,Wdth);
 
 //>MainLoop
 for(k=0;k<Knn;k++)
    { diff=0.0;
      for(i=0;i<Lgth;i++) for(j=0;j<Wdth;j++) diff+=CARRE(VctWin[k][i][j]-WinTgt[i][j]) ;
      VctDiff[k]=diff; }

 for(k=0;k<Knn;k++)
 for(l=0;l<(Knn-1);l++)
    {
     if (VctDiff[l]>VctDiff[l+1])
	{ for(i=0;i<Lgth;i++) for(j=0;j<Wdth;j++) SquWin[i][j]=VctWin[l][i][j];
	  for(i=0;i<Lgth;i++) for(j=0;j<Wdth;j++) VctWin[l][i][j]=VctWin[l+1][i][j];
	  for(i=0;i<Lgth;i++) for(j=0;j<Wdth;j++) VctWin[l+1][i][j]=SquWin[i][j];
	  tmp=VctDiff[l];
	  VctDiff[l]=VctDiff[l+1];
 	  VctDiff[l+1]=tmp; }
    }

 for(i=0;i<Lgth;i++) for(j=0;j<Wdth;j++)
    { sum=0.0;
      for(k=0;k<Bnn;k++) sum+=VctWin[k][i][j];
      sum=sum/Bnn;
      WinOut[i][j]=(int)(sum+0.5); }

 //>FreeMemory
 if (VctDiff)  free_fmatrix_1d(VctDiff);
 if (SquWin)   free_imatrix_2d(SquWin); 
} 


//>>>>>>>>>>>>>>>>>>>>>>>>>
//>> HIGH_LEVEL <FRCT> >>//
//>>>>>>>>>>>>>>>>>>>>>>>>>
//----------------------------------------------------------
// EstimFrctDiffMap
//----------------------------------------------------------
void EstimFrctDiffMap(float** ImgBef,float** ImgAft,float** ImgDiff,int lgth,int wdth,\
	                 int SzwDim,float Scale,int Knn,int Eps,float PourcSat)
{
 int i,j,k,l,m;
 int NbRowFrctFile;

 const int NBITER=3;  
 const int METHOD_RECONST=3;

 //>Memory_Allocation 
 float** MatTmp1=fmatrix_allocate_2d(lgth,wdth);
 float** MatTmp2=fmatrix_allocate_2d(lgth,wdth);
 float** ImgBefP=fmatrix_allocate_2d(lgth,wdth);
 float** ImgAftP=fmatrix_allocate_2d(lgth,wdth);
 InitZero(MatTmp1,lgth,wdth);
 InitZero(MatTmp2,lgth,wdth);
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) ImgBefP[i][j]=ImgBef[i][j];
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) ImgAftP[i][j]=ImgAft[i][j];

 //>Pre-Treatment?
 //DoubleSpecifHisto(ImgBefP,ImgAftP,lgth,wdth);

 //>Allocate_Frctal_File
 NbRowFrctFile=(int)(lgth/SzwDim)*((int)(wdth/SzwDim));
 int*** FrctFile=imatrix_allocate_3d(NbRowFrctFile,Knn,6);
 for(k=0;k<NbRowFrctFile;k++) for(l=0;l<Knn;l++) for(m=0;m<6;m++)  FrctFile[k][l][m]=-1;

 //>Estimation
 printf("\n  <W:%d Sc:%.1f> Fractal_Estimation/",SzwDim,Scale);
 fflush(stdout);
 EstimateNScaleSimilarity(ImgBefP,lgth,wdth,Scale,SzwDim,FrctFile,Knn,Eps);
 printf("Reconstruction/");
 fflush(stdout);
 KNNFractalIter(ImgAftP,lgth,wdth,MatTmp1,SzwDim,Scale,FrctFile,NbRowFrctFile,NBITER,Knn,METHOD_RECONST);
 //if (0)
 //   { Recal(MatTmp1,lgth,wdth);                                      //--SAVE--
 //     SaveImagePgm((char*)"",(char*)"Reconst16",MatTmp1,lgth,wdth); } //--SAVE--
 printf("Difference/");
 fflush(stdout);
 AbsDiff(ImgAft,MatTmp1,MatTmp2,lgth,wdth); 
 Recal(MatTmp2,lgth,wdth);
 RecalImgWithSat(MatTmp2,lgth,wdth,PourcSat);

 //>Transfert
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) ImgDiff[i][j]=MatTmp2[i][j];
				   
 //>FreeMemory
  if (MatTmp1)   free_fmatrix_2d(MatTmp1);
  if (MatTmp2)   free_fmatrix_2d(MatTmp2);
  if (ImgBefP) free_fmatrix_2d(ImgBefP);
  if (ImgAftP) free_fmatrix_2d(ImgAftP);
}


//----------------------//
//-- MODE --------------//
//----------------------//
//----------------------------------------------------------
// CallHalfSampleMode
//----------------------------------------------------------
float CallHalfSampleMode(int* Vct,int NbEch,int opt)
{
 int l,m;
 int tmp;
  
 //>Sort
 for(l=0;l<(NbEch-1);l++) for(m=0;m<(NbEch-1);m++)
  if (Vct[m]>Vct[m+1]) 
     { tmp=Vct[m];
       Vct[m]=Vct[m+1];
       Vct[m+1]=tmp; }

 //>DEBUG
 //printf("\n");
 //for(m=0;m<NbEch;m++) printf("[%d]",Vct[m]);
 //fflush(stdout);

 //>HalfSampleMode
 if (opt==0) return HalfSampleMode(Vct,NbEch);
 if (opt==1) return Shorth(Vct,NbEch);
 if (opt==2) return LeastMedianOfSquares(Vct,NbEch);
 return -1;
}

//----------------------------------------------------------
// HalfSampleMode
//----------------------------------------------------------
float HalfSampleMode(int* VctVal,int n)
{
 int i,j;
 float w,wmin,NN;
   
 if (n==1) return (VctVal[0]); 
 if (n==2) return ((VctVal[0]+VctVal[1])/2.0); 
 if (n==3)
    { if ((VctVal[1]-VctVal[0])<(VctVal[2]-VctVal[1]))  return ((VctVal[0]+VctVal[1])/2.0);
      if ((VctVal[1]-VctVal[0])>(VctVal[2]-VctVal[1]))  return ((VctVal[1]+VctVal[2])/2.0);
      if ((VctVal[1]-VctVal[0])==(VctVal[2]-VctVal[1])) return VctVal[1]; }

 if (n>3)
    { wmin=(VctVal[n-1]-VctVal[0]);
      NN=ceilf((float)n/2.0);

      j=0;
      for(i=0;i<=(n-NN);i++)
	{ w=VctVal[i+(int)NN-1]-VctVal[i];
	   if (w<wmin) { wmin=w; j=i; } }
      return HalfSampleMode(&VctVal[j],(int)NN); }

 return -1;
}

//----------------------------------------------------------
// Shorth
//----------------------------------------------------------
float Shorth(int* VctVal,int n)
{
 int i,j,k;
 float w,wmin,NN;
 float tmp;
   
 if (n==1) return (VctVal[0]); 
 if (n==2) return ((VctVal[0]+VctVal[1])/2.0); 
 if (n==3)
    { if ((VctVal[1]-VctVal[0])<(VctVal[2]-VctVal[1]))  return ((VctVal[0]+VctVal[1])/2.0);
      if ((VctVal[1]-VctVal[0])>(VctVal[2]-VctVal[1]))  return ((VctVal[1]+VctVal[2])/2.0);
      if ((VctVal[1]-VctVal[0])==(VctVal[2]-VctVal[1])) return VctVal[1]; }

 if (n>3)
    { wmin=(VctVal[n-1]-VctVal[0]);
      NN=ceilf((float)n/2.0);

      j=0;
      for(i=0;i<=(n-NN);i++)
	{ w=VctVal[i+(int)NN-1]-VctVal[i];
	  if (w<wmin) { wmin=w; j=i; } }

      tmp=0.0;
      for(k=j;k<NN;k++) tmp+=VctVal[k];
      tmp/=(NN-j);
      return tmp; }

 return -1;
}

//----------------------------------------------------------
// LMS (LeastMedianOfSquares)
//----------------------------------------------------------
float LeastMedianOfSquares(int* VctVal,int n)
{
 int i,j;
 float w,wmin,NN;
 float tmp;
   
 if (n==1) return (VctVal[0]); 
 if (n==2) return ((VctVal[0]+VctVal[1])/2.0); 
 if (n==3)
    { if ((VctVal[1]-VctVal[0])<(VctVal[2]-VctVal[1]))  return ((VctVal[0]+VctVal[1])/2.0);
      if ((VctVal[1]-VctVal[0])>(VctVal[2]-VctVal[1]))  return ((VctVal[1]+VctVal[2])/2.0);
      if ((VctVal[1]-VctVal[0])==(VctVal[2]-VctVal[1])) return VctVal[1]; }

 if (n>3)
    { wmin=(VctVal[n-1]-VctVal[0]);
      NN=ceilf((float)n/2.0);

      j=0;
      for(i=0;i<=(n-NN);i++)
	{ w=VctVal[i+(int)NN-1]-VctVal[i];
	  if (w<wmin) { wmin=w; j=i; } }

      tmp=(VctVal[(int)NN-1]+VctVal[j])/2.0;
      //printf("[%d::%d]",VctVal[(int)NN-1],VctVal[j]);
      return tmp; }
 
return -1;
}
