//------------------------------------------------------
// module  : FunctionMCDCCL.h
// auteur  : Mignotte Max
// date    :
// version : 1.0
// langage : C++
// labo    : DIRO
// note    :
//------------------------------------------------------
// 

//------------------------------------------------
// FICHIERS INCLUS -------------------------------
//------------------------------------------------
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <new>
#include <time.h>
#include <sys/resource.h>

#include "MCDCCL.h"

//------------------------------------------------
// DEFINITIONS -----------------------------------
//------------------------------------------------
#define PI  3.14159
#define GREY_LEVEL 255
#define BIGNUMBER 100000000
#define TROIS 3
#define NCHAR 200
#define MAXLGTHIMG 450

#define CARRE(X) ((X)*(X))
#define SWAP(a,b)  { float tmpp=(a); (a)=(b); (b)=tmpp; }
#define MAX(i,j)  ((i)>(j)?(i):(j))
#define MIN(i,j)  ((j)>(i)?(i):(j))

//------------------------------------------------
// FunctionMCDCCL.cc
//------------------------------------------------
//>MatrixAllocation
float*            fmatrix_allocate_1d(int);
float*            fmatrix_allocate_1d(long int);
float**           fmatrix_allocate_2d(int,int);
float***          fmatrix_allocate_3d(int,int,int);
int*              imatrix_allocate_1d(int);
int**             imatrix_allocate_2d(int,int);
int***            imatrix_allocate_3d(int,int,int);
int****           imatrix_allocate_4d(int,int,int,int);
void  free_fmatrix_1d(float*);
void  free_fmatrix_2d(float**);
void  free_fmatrix_3d(float***,int);
void  free_imatrix_1d(int*);
void  free_imatrix_2d(int**);
void  free_imatrix_3d(int***,int);
void  free_imatrix_4d(int****,int,int);

//>MatrixGestion
void  CopyMat(float**,float**,int,int);
void  CopyMat(float***,float**,int,int);
void  Recal(float**,int,int);
void  Recal(int**,int,int);
void  RecalImgWithSat(float**,int,int,float);
int   DiffMatNb(float**,float**,int,int);
float DiffBetween(float**,float**,int,int);
void InitZero(float**,int,int);
void InitZero(float***,int,int,int);
void AddToMatrix(float**,float**,int,int);
void MeanMatrix(float***,int,int,int,float**);
  
//>Load/SaveFile
void GetLengthWidth(char*,int*,int*);
void LoadImagePpm(char*,float***,int,int);
void SaveImagePgm(char*,char*,int**,int,int);
void SaveImagePgm(char*,char*,float**,int,int);
void SaveImagePpm(char*,char*,float***,int,int);

//>SizeReduction
void Multires(float**,int,int,float**,int);
void Multires(int**,int,int,int**,int);
void DecreasedSize(float***,float***,float***,int*,int*,int*);
void DecreasedSizeByTwo(float***,float***,float***,int*,int*,int*);
void InterpolBilineaire(int**,int**,int,int,float);
void InterpolBilineaire(float**,float**,int,int,float);

//>HistoManip
void Compute_histo(float**,int,int,float*);
void SpecifHisto(float**,int,int,float**,int,int);
void DoubleSpecifHisto(float**,float**,int,int);
void FillPictHist(float**,int,float**,int,int,float**);
float funcgauss(float,float,float,float);

//>Result
void ConfusionMatrix(float***,float**,float**,int,int,float*);
float FMeasure(float**,float**,int,int);
float Precis(float**,float**,int,int);

//>Gestion
void AbsDiff(float**,float**,float**,int,int);
void Diff(float**,float**,float**,int,int);
void MedianFilter(int***,int,int,int,int**);
void InsertionSort(int*,int);
void MeanFilter(int***,int,int,int,int**);
void Grad(float**,int,int);
void FctLog(float**,int,int);
void EdgeBooster(float**,int,int,float);
void GaussianFilter(float**,int,int,int);
void MedianFilter(float**,int,int,int);
void FilterMat(int***,int,int,int,int,int);

//>KMean
int Identical(float*,float**,int,int);
void Kmean(float**,int,int,int,int*,int,int);
void KmeanEstimate(float**,int,int,int,float**,int,int);
  
//>Model_CCL
void MakeSymmetry(int**,int**,int,int);
void EstimateGaussianPar(int***,int,int,int,int***);
void EstimateGaussianParRobust(int***,int,int,int,int***,float,int);
float funcgauss(int,float,float);
void FillBinomProbMatrix(float***,int,int,int***,float**);
int GiveRangeGreyLevelValues(float**,int,int,float);

//>Model_FRCT
void EstimateNScaleSimilarity(float**,int,int,float,int,int***,int,int);
void KNNFractalIter(float**,int,int,float**,int,float,int***,int,int,int,int);
void BestFilter(int***,int,int,int,int**,int**);
void BestNFilter(int***,int,int,int,int**,int**,int);
void EstimFrctDiffMap(float**,float**,float**,int,int,int,float,int,int,float);

//>Stat
float CallHalfSampleMode(int*,int,int);
float HalfSampleMode(int*,int);
float Shorth(int*,int);
float LeastMedianOfSquares(int*,int);
