//------------------------------------------------------
// modul   : MCDCCL.cc
// author  : Mignotte Max
// date    : 
// version : 1.0
// language: C++
// Labo    : DIRO
//------------------------------------------------------
//  

//------------------------------------------------
// INCLUDED FILES --------------------------------
//------------------------------------------------
#include "MCDCCL.h"

//------------------------------------------------
// GLOBAL VARIABLES ------------------------------
//------------------------------------------------
char NameImgBef[NCHAR];
char NameImgAft[NCHAR];
char NameImgGtr[NCHAR];
char Comment[NCHAR];

const float PARAM1=0;
const float MULT_PAR=0;

float Param1;

int zoom;
int flag_save;
int flag_quit;
int flag_visu;
int flag_test;

//-------------------------
// WINDOWS 
//-------------------------
#include <X11/Xutil.h>

Display   *display;
int	  screen_num;
int 	  depth;
Window	  root;
Visual*	  visual;
GC	  gc;

/************************************************************************/
/* OPEN_DISPLAY()							*/
/************************************************************************/
int open_display()
{
  if ((display=XOpenDisplay(NULL))==NULL)
   { printf("Connection impossible\n");
     return(-1); }

  else
   { screen_num=DefaultScreen(display);
     visual=DefaultVisual(display,screen_num);
     depth=DefaultDepth(display,screen_num);
     root=RootWindow(display,screen_num);
     return 0; }
}

/************************************************************************/
/* FABRIQUE_WINDOW()							*/
/************************************************************************/
Window fabrique_window(char *nom_fen,int x,int y,int width,int height,int zoom)
{
  Window                 win;
  XSizeHints      size_hints;
  XWMHints          wm_hints;
  XClassHint     class_hints;
  XTextProperty  windowName, iconName;

  char *name=nom_fen;

  if(zoom<0) { width/=-zoom; height/=-zoom; }
  if(zoom>0) { width*=zoom;  height*=zoom;  }

  win=XCreateSimpleWindow(display,root,x,y,width,height,1,0,255);

  size_hints.flags=PPosition|PSize|PMinSize;
  size_hints.min_width=width;
  size_hints.min_height=height;

  XStringListToTextProperty(&name,1,&windowName);
  XStringListToTextProperty(&name,1,&iconName);
  wm_hints.initial_state=NormalState;
  wm_hints.input=True;
  wm_hints.flags=StateHint|InputHint;
  class_hints.res_name=nom_fen;
  class_hints.res_class=nom_fen;

  XSetWMProperties(display,win,&windowName,&iconName,
                   NULL,0,&size_hints,&wm_hints,&class_hints);

  gc=XCreateGC(display,win,0,NULL);

  XSelectInput(display,win,ExposureMask|KeyPressMask|ButtonPressMask| 
               ButtonReleaseMask|ButtonMotionMask|PointerMotionHintMask| 
               StructureNotifyMask);

  XMapWindow(display,win);
  return(win);
}

/****************************************************************************/
/* CREE_XIMAGE()							    */
/****************************************************************************/
XImage* cree_Ximage(float** mat,int z,int length,int width)
{
  int lgth,wdth,lig,col,zoom_col,zoom_lig;
  float somme;
  unsigned char	 pix;
  unsigned char* dat;
  XImage* imageX;

  /*Zoom positif*/
  if (z>0)
  {
   lgth=length*z;
   wdth=width*z;

   dat=(unsigned char*)malloc(lgth*(wdth*4)*sizeof(unsigned char));
   if (dat==NULL)
      { printf("Impossible d'allouer de la memoire.");
        exit(-1); }

  for(lig=0;lig<lgth;lig=lig+z) for(col=0;col<wdth;col=col+z)
   { 
    pix=(unsigned char)mat[lig/z][col/z];
    for(zoom_lig=0;zoom_lig<z;zoom_lig++) for(zoom_col=0;zoom_col<z;zoom_col++)
      { 
       dat[((lig+zoom_lig)*wdth*4)+((4*(col+zoom_col))+0)]=pix;
       dat[((lig+zoom_lig)*wdth*4)+((4*(col+zoom_col))+1)]=pix;
       dat[((lig+zoom_lig)*wdth*4)+((4*(col+zoom_col))+2)]=pix;
       dat[((lig+zoom_lig)*wdth*4)+((4*(col+zoom_col))+3)]=pix; 
       }
    }
  } /*--------------------------------------------------------*/

  /*Zoom negatif*/
  else
  {
   z=-z;
   lgth=(length/z);
   wdth=(width/z);

   dat=(unsigned char*)malloc(lgth*(wdth*4)*sizeof(unsigned char));
   if (dat==NULL)
      { printf("Impossible d'allouer de la memoire.");
        exit(-1); }

  for(lig=0;lig<(lgth*z);lig=lig+z) for(col=0;col<(wdth*z);col=col+z)
   {  
    somme=0.0;
    for(zoom_lig=0;zoom_lig<z;zoom_lig++) for(zoom_col=0;zoom_col<z;zoom_col++)
       { somme+=mat[lig+zoom_lig][col+zoom_col]; }
           
     somme/=(z*z);    
     dat[((lig/z)*wdth*4)+((4*(col/z))+0)]=(unsigned char)somme;
     dat[((lig/z)*wdth*4)+((4*(col/z))+1)]=(unsigned char)somme;
     dat[((lig/z)*wdth*4)+((4*(col/z))+2)]=(unsigned char)somme;
     dat[((lig/z)*wdth*4)+((4*(col/z))+3)]=(unsigned char)somme; 
   }
  } /*--------------------------------------------------------*/

  imageX=XCreateImage(display,visual,depth,ZPixmap,0,(char*)dat,wdth,lgth,16,wdth*4);
  return (imageX);
}

/****************************************************************************/
/* CREE_XIMAGECOUL()							    */
/****************************************************************************/
XImage* cree_XimageCoul(float*** matRVB,int z,int length,int width)
{
  int i;
  int lgth,wdth,lig,col,zoom_col,zoom_lig;
  float sum[3];
  unsigned char	 pixR,pixV,pixB;
  unsigned char* dat;
  XImage* imageX;

  /*Zoom positif*/
  if (z>0)
  {
   lgth=length*z;
   wdth=width*z;

   dat=(unsigned char*)malloc(lgth*(wdth*4)*sizeof(unsigned char));
   if (dat==NULL)
      { printf("Impossible d'allouer de la memoire.");
        exit(-1); }

  for(lig=0;lig<lgth;lig=lig+z) for(col=0;col<wdth;col=col+z)
   { 
    pixR=(unsigned char)matRVB[0][lig/z][col/z];
    pixV=(unsigned char)matRVB[1][lig/z][col/z];
    pixB=(unsigned char)matRVB[2][lig/z][col/z];

    for(zoom_lig=0;zoom_lig<z;zoom_lig++) for(zoom_col=0;zoom_col<z;zoom_col++)
      { 
       dat[((lig+zoom_lig)*wdth*4)+((4*(col+zoom_col))+0)]=pixB; 
       dat[((lig+zoom_lig)*wdth*4)+((4*(col+zoom_col))+1)]=pixV; 
       dat[((lig+zoom_lig)*wdth*4)+((4*(col+zoom_col))+2)]=pixR; 
       dat[((lig+zoom_lig)*wdth*4)+((4*(col+zoom_col))+3)]=0; 
       }
    }
  } /*--------------------------------------------------------*/

  /*Zoom negatif*/
  else
  {
   z=-z;
   lgth=(length/z);
   wdth=(width/z);

   dat=(unsigned char*)malloc(lgth*(wdth*4)*sizeof(unsigned char));
   if (dat==NULL)
      { printf("Impossible d'allouer de la memoire.");
        exit(-1); }

  for(lig=0;lig<(lgth*z);lig=lig+z) for(col=0;col<(wdth*z);col=col+z)
   {  
    sum[0]=sum[1]=sum[2]=0.0;
    
    for(i=0;i<3;i++)
    for(zoom_lig=0;zoom_lig<z;zoom_lig++) for(zoom_col=0;zoom_col<z;zoom_col++)
     sum[i]+=matRVB[i][lig+zoom_lig][col+zoom_col];
       
    for(i=0;i<3;i++)  sum[i]/=(z*z); 

     dat[((lig/z)*wdth*4)+((4*(col/z))+0)]=(unsigned char)sum[1];
     dat[((lig/z)*wdth*4)+((4*(col/z))+1)]=(unsigned char)sum[1];
     dat[((lig/z)*wdth*4)+((4*(col/z))+2)]=(unsigned char)sum[1];
     dat[((lig/z)*wdth*4)+((4*(col/z))+3)]=(unsigned char)sum[1]; 
   }
  } /*--------------------------------------------------------*/

  imageX=XCreateImage(display,visual,depth,ZPixmap,0,(char*)dat,wdth,lgth,16,wdth*4);
  return (imageX);
}

//---------------------------------------------------------
// Read Argument From Command Line
//---------------------------------------------------------
void ReadArguments(int argc,char** argv)
{
 int i;

   //Options
   if (argc<2) 
    { printf("\n Usage %s [Img.Before][Img.After][Img.GroundTruth]  (in .ppm format)",argv[0]); 
      printf("\n Options : value by default indicated in []");
      printf("\n            -----------------------------------------");
      printf("\n            -c Ident");
      printf("\n            -------------");
      printf("\n            -r Method  > [%.0f](1:ML)(2:MAP)(3:MPM)(4:SMAP)(5:SCMAP)",PARAM1);  
      printf("\n            -----------------------------------------"); 
      printf("\n            -z zoom (%d)",ZOOM);
      printf("\n            -v visu (%d)",VISU);
      printf("\n            -q quit (without)"); 
      printf("\n            -s save (without)");
      printf("\n            -t test alone (without)");
      printf("\n            -------------");
      printf("\n");
      printf("\n  Example: %s Img1-B.ppm Img1-Ac.ppm Img1-C.ppm -t",argv[0]);
      printf("\n  Example: %s Img5-Bc.ppm Img5-A.ppm Img5-C.ppm -t",argv[0]);
      printf("\n  Example: %s Img6-B.ppm Img6-A.ppm Img6-C.ppm -t",argv[0]);
      printf("\n  Example: %s Img7-Bc.ppm Img7-Ac.ppm Img7-C.ppm -t",argv[0]);
      printf("\n  Example: %s Img9-B.ppm Img9-A.ppm Img9-C.ppm -t",argv[0]);
      printf("\n  Example: %s Img10-Bc.ppm Img10-Ac.ppm Img10-C.ppm -t",argv[0]);
      printf("\n  Example: %s Img11-B.ppm Img11-Ac.ppm Img11-C.ppm -t",argv[0]);
      printf("\n  Example: %s Img12-B.ppm Img12-Ac.ppm Img12-C.ppm -t",argv[0]);
      printf("\n  Example: %s Img13-B.ppm Img13-A.ppm Img13-C.ppm -t",argv[0]);
      printf("\n  Example: %s Img17-Bc.ppm Img17-A.ppm Img17-C.ppm -t",argv[0]);
      printf("\n\n\n\n\n");
      exit(-1); }


      //Load_Images
      if (argc>2)
	 { strcpy(NameImgBef,argv[1]);
	   strcpy(NameImgAft,argv[2]);
	   strcpy(NameImgGtr,argv[3]); }
     
   //Loop
   for(i=4;i<argc;i++)
     {   
       switch(argv[i][1])
          {    
           case 'r': Param1=atof(argv[++i]);    break;
	   case 'c': strcpy(Comment,argv[++i]); break;
           case 'z': zoom=atoi(argv[++i]);    break;
	   case 'v': flag_visu=1;             break;
	   case 'q': flag_quit=1;             break;
           case 's': flag_save=1;             break;
	   case 't': flag_test=1;             break;
          }    
     } 
 }

//---------------------------------------------------------
// MultiDetection <CCL>
//---------------------------------------------------------
void MultiDetectionCCL(float MyPar,char* MyComment)
{
 int k;
 int length,width;
 int scale;
 float MeanFmeas;
 float MeanPrec;
 float*** MatImgBef;
 float*** MatImgAft;
 float*** MatImgGtr;

 const int NB_IMAGES=10;
 float VctPrec[NB_IMAGES];
 float VctFmea[NB_IMAGES];

 int elptime=0;
 Chrono chrono;
 chrono.reset();

 //>Color_Images_When_Available_
  char ListNameImg[NB_IMAGES*3][13]=
      {"Img1-B.ppm","Img1-Ac.ppm","Img1-C.ppm",
       "Img5-Bc.ppm","Img5-A.ppm","Img5-C.ppm",
       "Img6-B.ppm","Img6-A.ppm","Img6-C.ppm",
       "Img7-Bc.ppm","Img7-Ac.ppm","Img7-C.ppm",
       "Img9-B.ppm","Img9-A.ppm","Img9-C.ppm",
       "Img10-Bc.ppm","Img10-Ac.ppm","Img10-C.ppm",
       "Img11-B.ppm","Img11-Ac.ppm","Img11-C.ppm",
       "Img12-B.ppm","Img12-Ac.ppm","Img12-C.ppm",       
       "Img13-B.ppm","Img13-A.ppm","Img13-C.ppm",
       "Img17-Bc.ppm","Img17-A.ppm","Img17-C.ppm"};

 //>Presentation
 printf("\n ----------------------");
 printf("\n > MultiDetection <CCL> [Nb:%d Imgs]",NB_IMAGES);
 printf("\n ----------------------");
 fflush(stdout);
 
 //==MAIN-LOOP=====================
 for(k=0;k<NB_IMAGES;k++)
    {
     strcpy(NameImgBef,ListNameImg[(3*k)+0]);
     strcpy(NameImgAft,ListNameImg[(3*k)+1]);
     strcpy(NameImgGtr,ListNameImg[(3*k)+2]);
      
     GetLengthWidth(NameImgBef,&length,&width);
     MatImgBef=fmatrix_allocate_3d(TROIS,length,width);
     MatImgAft=fmatrix_allocate_3d(TROIS,length,width);
     MatImgGtr=fmatrix_allocate_3d(TROIS,length,width);
     LoadImagePpm(NameImgBef,MatImgBef,length,width);
     LoadImagePpm(NameImgAft,MatImgAft,length,width);
     LoadImagePpm(NameImgGtr,MatImgGtr,length,width);

     if (MAX(length,width)/MAXLGTHIMG) DecreasedSize(MatImgBef,MatImgAft,MatImgGtr,&length,&width,&scale);    
 
     printf("\n");
     printf("\n MCD:MultiModal Change Detection <CCL>"); 
     printf("\n -------------------------------------");
     printf("\n Info.:: Images:[%s][%s][%s]",NameImgBef,NameImgAft,NameImgGtr);
     printf("\n         SzeImg:[Lgth=%d::Wdth=%d][scale=%d]",length,width,scale);
     printf("\n         Comment:[%s]",Comment);
     printf("\n         MyPar:[%.0f]",MyPar);
     if (flag_quit)  printf("\n -> Avec Quit");
     if (flag_save)  printf("\n -> Avec Save");
     printf("\n");
     fflush(stdout);

      MCDCCL* mymcd=new MCDCCL(MatImgBef,MatImgAft,MatImgGtr,length,width,NameImgBef,MyPar);
      strcpy((*mymcd).MyCom,Comment);
      (*mymcd).FlgSave=flag_save;
      (*mymcd).DetectionMCD_CCL();
      VctPrec[k]=(*mymcd).precision;
      VctFmea[k]=(*mymcd).fmeasure;
      if (mymcd) delete(mymcd);
      
      if (MatImgBef) free_fmatrix_3d(MatImgBef,TROIS);
      if (MatImgAft) free_fmatrix_3d(MatImgAft,TROIS);
      if (MatImgGtr) free_fmatrix_3d(MatImgGtr,TROIS);
    }//===============================

 //Moyenne
 MeanFmeas=0.0;
 MeanPrec=0.0;
 for(k=0;k<NB_IMAGES;k++)
    { MeanFmeas+=VctFmea[k];
      MeanPrec+=VctPrec[k]; }
 
 printf("\n > Precision:");
 for(k=0;k<NB_IMAGES;k++) printf("[%.2f]",VctPrec[k]);
 printf("\n > Fmeasure:");
 for(k=0;k<NB_IMAGES;k++) printf("[%.2f]",VctFmea[k]);

 MeanFmeas/=NB_IMAGES;
 MeanPrec/=NB_IMAGES;
 printf("\n > PrecMoy=[%.2f]  FmeasMoy=[%.2f]\n\n\n\n",MeanPrec,MeanFmeas);
 fflush(stdout);
 
 elptime=chrono.elapsed(SECOND);
 chrono.print();
 
 float** Mat=fmatrix_allocate_2d(TROIS,TROIS);
 char Info[100];
 char Buf[100];
 //sprintf(Info,"_P%.4f_Fm%.3f_Pr%.4f_",MyPar,MeanFmeas*100,MeanPrec);
 sprintf(Info,"_Fm%.2f_Pr%.3f_Tm%d",MeanFmeas*100,MeanPrec,elptime);
 strcpy(Buf,"RESULTATS_");
 strcat(Buf,MyComment);
 strcat(Buf,Info);
 SaveImagePgm((char*)"",Buf,Mat,TROIS,TROIS);
 if (Mat) free_fmatrix_2d(Mat);
}

//---------------------------------------------------------
// MultiDetection <FRCT>
//---------------------------------------------------------
void MultiDetectionFRCT(float MyPar,char* MyComment)
{
 int k;
 int length,width;
 int scale;
 float MeanFmeas;
 float MeanPrec;
 float*** MatImgBef;
 float*** MatImgAft;
 float*** MatImgGtr;

 const int NB_IMAGES=10;
 float VctPrec[NB_IMAGES];
 float VctFmea[NB_IMAGES];

 int elptime=0;
 Chrono chrono;
 chrono.reset();

 //>Color_Images_When_Available_
  char ListNameImg[NB_IMAGES*3][13]=
      {"Img1-B.ppm","Img1-Ac.ppm","Img1-C.ppm",
       "Img5-Bc.ppm","Img5-A.ppm","Img5-C.ppm",
       "Img6-B.ppm","Img6-A.ppm","Img6-C.ppm",
       "Img7-Bc.ppm","Img7-Ac.ppm","Img7-C.ppm",
       "Img9-B.ppm","Img9-A.ppm","Img9-C.ppm",
       "Img10-Bc.ppm","Img10-Ac.ppm","Img10-C.ppm",
       "Img11-B.ppm","Img11-Ac.ppm","Img11-C.ppm",
       "Img12-B.ppm","Img12-Ac.ppm","Img12-C.ppm",       
       "Img13-B.ppm","Img13-A.ppm","Img13-C.ppm",
       "Img17-Bc.ppm","Img17-A.ppm","Img17-C.ppm",};

 //>Presentation
 printf("\n ------------------------------------");
 printf("\n > MultiDetection <FRCT> [Nb:%d Imgs]",NB_IMAGES);
 printf("\n ------------------------------------");
 fflush(stdout);

 //==MAIN-LOOP=====================
 for(k=0;k<NB_IMAGES;k++)
    {
     strcpy(NameImgBef,ListNameImg[(3*k)+0]);
     strcpy(NameImgAft,ListNameImg[(3*k)+1]);
     strcpy(NameImgGtr,ListNameImg[(3*k)+2]);
      
     GetLengthWidth(NameImgBef,&length,&width);
     MatImgBef=fmatrix_allocate_3d(TROIS,length,width);
     MatImgAft=fmatrix_allocate_3d(TROIS,length,width);
     MatImgGtr=fmatrix_allocate_3d(TROIS,length,width);
     LoadImagePpm(NameImgBef,MatImgBef,length,width);
     LoadImagePpm(NameImgAft,MatImgAft,length,width);
     LoadImagePpm(NameImgGtr,MatImgGtr,length,width);

     if (MAX(length,width)/MAXLGTHIMG) DecreasedSize(MatImgBef,MatImgAft,MatImgGtr,&length,&width,&scale);    
 
     printf("\n");
     printf("\n FRCT:MultiModal Change Detection"); 
     printf("\n --------------------------------");
     printf("\n Info.:: Images:[%s][%s][%s]",NameImgBef,NameImgAft,NameImgGtr);
     printf("\n         SzeImg:[Lgth=%d::Wdth=%d][scale=%d]",length,width,scale);
     printf("\n         Comment:[%s]",Comment);
     printf("\n         MyPar:[%.0f]",MyPar);
     if (flag_quit)  printf("\n -> Avec Quit");
     if (flag_save)  printf("\n -> Avec Save");
     printf("\n");
     fflush(stdout);

      MCDCCL mymcd(MatImgBef,MatImgAft,MatImgGtr,length,width,NameImgBef,MyPar);
      strcpy(mymcd.MyCom,Comment);
      mymcd.DetectionMCD_FRCT();
      VctPrec[k]=mymcd.precision;
      VctFmea[k]=mymcd.fmeasure;
      
      if (MatImgBef) free_fmatrix_3d(MatImgBef,TROIS);
      if (MatImgAft) free_fmatrix_3d(MatImgAft,TROIS);
      if (MatImgGtr) free_fmatrix_3d(MatImgGtr,TROIS);
    }//===============================

 //Moyenne
 MeanFmeas=0.0;
 MeanPrec=0.0;
 for(k=0;k<NB_IMAGES;k++)
    { MeanFmeas+=VctFmea[k];
      MeanPrec+=VctPrec[k]; }
 
 printf("\n > Precision:");
 for(k=0;k<NB_IMAGES;k++) printf("[%.2f]",VctPrec[k]);
 printf("\n > Fmeasure:");
 for(k=0;k<NB_IMAGES;k++) printf("[%.2f]",VctFmea[k]);

 MeanFmeas/=NB_IMAGES;
 MeanPrec/=NB_IMAGES;
 printf("\n > PrecMoy=[%.2f]  FmeasMoy=[%.2f]\n\n\n\n",MeanPrec,MeanFmeas);
 fflush(stdout);

 elptime=chrono.elapsed(SECOND);
 chrono.print();

 float** Mat=fmatrix_allocate_2d(TROIS,TROIS);
 char Info[100];
 char Buf[100];
 //sprintf(Info,"_P%.3f_Fm%.2f_Pr%.3f_",MyPar,MeanFmeas*100,MeanPrec);
 sprintf(Info,"_Fm%.2f_Pr%.3f_Tm%d",MeanFmeas*100,MeanPrec,elptime);
 strcpy(Buf,"RESULTATS_");
 strcat(Buf,MyComment);
 strcat(Buf,Info);
 SaveImagePgm((char*)"",Buf,Mat,TROIS,TROIS);
 if (Mat) free_fmatrix_2d(Mat);
}

//----------------------------------------------------------
//----------------------------------------------------------
// PRINCIPAL PROG. -----------------------------------------
//----------------------------------------------------------
//----------------------------------------------------------
int main(int argc,char** argv)
{
 int flag;

 //For_Xwindow
 XEvent ev;
 Window win_ppicture_img_bef;
 Window win_ppicture_img_aft;
 Window win_ppicture_img_gtr;
 Window win_ppicture_img_seg;
 Window win_ppicture_img_con;
 XImage *x_ppicture_img_bef; 
 XImage *x_ppicture_img_aft;
 XImage *x_ppicture_img_gtr;
 XImage *x_ppicture_img_seg;
 XImage *x_ppicture_img_con; 
 char nomfen_ppicture_img_bef[NCHAR];
 char nomfen_ppicture_img_aft[NCHAR];
 char nomfen_ppicture_img_gtr[NCHAR];
 char nomfen_ppicture_img_seg[NCHAR];
 char nomfen_ppicture_img_con[NCHAR];

 //Init
 Param1=PARAM1;
 zoom=ZOOM;
 flag_save=SAVE;
 flag_quit=QUIT;
 flag_visu=VISU;
 flag_test=0;
 flag=0;

 //Read_Arguments
 ReadArguments(argc,argv);

 //>Multiple-Detection <Markov-CCL><FRCT>
 if (!flag_test)
    {
      //MultiDetectionFRCT(Param1,Comment);
      MultiDetectionCCL(Param1,Comment);
      exit(-1);
    }

 //> Load_Images -----------------
 //-------------------------------
 int length,width;
 GetLengthWidth(NameImgBef,&length,&width);
 float*** MatImgBef=fmatrix_allocate_3d(TROIS,length,width);
 float*** MatImgAft=fmatrix_allocate_3d(TROIS,length,width);
 float*** MatImgGtr=fmatrix_allocate_3d(TROIS,length,width);
 LoadImagePpm(NameImgBef,MatImgBef,length,width);
 LoadImagePpm(NameImgAft,MatImgAft,length,width);
 LoadImagePpm(NameImgGtr,MatImgGtr,length,width);

 //>Decreased_Size_Images
 int scale=1;
 if (MAX(length,width)/MAXLGTHIMG) DecreasedSize(MatImgBef,MatImgAft,MatImgGtr,&length,&width,&scale);

 //Info
 printf("\n\n\n");
 printf("\n MCD:MultiModal Change Detection"); 
 printf("\n -------------------------------");
 printf("\n Info.:: Images:[%s][%s][%s]",NameImgBef,NameImgAft,NameImgGtr);
 printf("\n         SzeImg:[Lgth=%d::Wdth=%d][ScaleImg=%d]",length,width,scale);
 printf("\n         Comment:[%s]",Comment);
 if (flag_quit)  printf("\n -> Avec Quit");
 if (flag_save)  printf("\n -> Avec Save");
 printf("\n");
 fflush(stdout);

 //>Single-Detection <Markov-CCL><FRCT>
 MCDCCL* mymcd=new MCDCCL(MatImgBef,MatImgAft,MatImgGtr,length,width,NameImgBef,MULT_PAR); 
 strcpy((*mymcd).MyCom,Comment);
 (*mymcd).DetectionMCD_CCL();
 //(*mymcd).DetectionMCD_FRCT();
 
//---------------------------------------------------------------
//---------------- XWINDOW visu --------------------------------
//---------------------------------------------------------------
 if (!flag_quit)
 {
 //Open_Graphical_Session
 if (open_display()<0) printf(" Impossible d'ouvrir une session graphique");

 //Img.Comment
 sprintf(nomfen_ppicture_img_con,"Img: %s",NameImgGtr);
 sprintf(nomfen_ppicture_img_seg,"Img: %s",NameImgGtr);
 sprintf(nomfen_ppicture_img_gtr,"Img: %s",NameImgGtr);
 sprintf(nomfen_ppicture_img_bef,"Img: %s",NameImgBef);
 sprintf(nomfen_ppicture_img_aft,"Img: %s",NameImgAft);

 //Window_Creation
 win_ppicture_img_con=fabrique_window(nomfen_ppicture_img_gtr,10,10,width,length,zoom);
 win_ppicture_img_seg=fabrique_window(nomfen_ppicture_img_gtr,10,10,width,length,zoom);
 win_ppicture_img_gtr=fabrique_window(nomfen_ppicture_img_gtr,10,10,width,length,zoom);
 win_ppicture_img_bef=fabrique_window(nomfen_ppicture_img_bef,10,10,width,length,zoom);
 win_ppicture_img_aft=fabrique_window(nomfen_ppicture_img_aft,10,10,width,length,zoom);
 
 //Ximages_Creation
 x_ppicture_img_con=cree_XimageCoul((*mymcd).MatImgCon,zoom,length,width);
 x_ppicture_img_seg=cree_XimageCoul((*mymcd).MatImgSeg,zoom,length,width);
 x_ppicture_img_gtr=cree_XimageCoul(MatImgGtr,zoom,length,width);
 x_ppicture_img_bef=cree_XimageCoul(MatImgBef,zoom,length,width);
 x_ppicture_img_aft=cree_XimageCoul(MatImgAft,zoom,length,width);
  
 printf("\n\n For leaving, press the space bar");
 fflush(stdout);

 //Event_Loop
  for(;;)
     {
      XNextEvent(display,&ev);
       switch(ev.type)
        {
	 case Expose:
	 XPutImage(display,win_ppicture_img_con,gc,x_ppicture_img_con,0,0,0,0,
                   x_ppicture_img_con->width,x_ppicture_img_con->height);
	 XPutImage(display,win_ppicture_img_seg,gc,x_ppicture_img_seg,0,0,0,0,
                   x_ppicture_img_seg->width,x_ppicture_img_seg->height);
	 XPutImage(display,win_ppicture_img_gtr,gc,x_ppicture_img_gtr,0,0,0,0,
                   x_ppicture_img_gtr->width,x_ppicture_img_gtr->height); 
         XPutImage(display,win_ppicture_img_bef,gc,x_ppicture_img_bef,0,0,0,0,
                   x_ppicture_img_bef->width,x_ppicture_img_bef->height);
	 XPutImage(display,win_ppicture_img_aft,gc,x_ppicture_img_aft,0,0,0,0,
                   x_ppicture_img_aft->width,x_ppicture_img_aft->height);               
         break;

         case KeyPress:
	 XDestroyImage(x_ppicture_img_con);
	 XDestroyImage(x_ppicture_img_seg);
	 XDestroyImage(x_ppicture_img_gtr);
         XDestroyImage(x_ppicture_img_bef);
	 XDestroyImage(x_ppicture_img_aft);	 
  
         XFreeGC(display,gc);
         XCloseDisplay(display);
         flag=1;
         break;
         }
   if (flag==1) break;
   }
 } 

//--------------- End_Graphical_Session -------------------     
//----------------------------------------------------------

   //Return
   printf("\n That's all folks... \n");
   return 0;
 }
 


