//------------------------------------------------------
// module  : f_EstimMixtDist.cc
// auteur  : Mignotte Max
// date    : 
// langage : C++
// modifié :             
//------------------------------------------------------


//------------------------------------------------
// FICHIERS INCLUS -------------------------------
//------------------------------------------------
#include "EstimMixtDist.h"
#include "FunctionMCDCCL.h"

//------------------------------------------------
// CONSTANTES & DEFINITIONS ----------------------
//------------------------------------------------

//------------------------------------------------
// FONCTIONS DE LA CLASSE <KMEAN> ---------------
//------------------------------------------------
//----------------------------------------------------------
// constructeur de la classe KMEAN
//----------------------------------------------------------
KMEAN::KMEAN(int Nbclass,int Size,int lgth,int wdth,int sd)
 {
   nbclass=Nbclass;
   size=Size;  
   width=wdth;
   length=lgth;
   myseed=sd;

   //>allocation memoire
   histo=fmatrix_allocate_1d(GREY_LEVEL);
   ppar=fmatrix_allocate_2d(nbclass,NB_ATTRIBUTS+1);
   pmatl=fmatrix_allocate_2d(length,width);
   pmatp=fmatrix_allocate_3d(nbclass,length,width);

   //>calcule le nb de petites fenetres necessaires
  nbwindows=length*width;
  pswindow=(swindow*)malloc(sizeof(swindow)*(int)nbwindows);
  if (pswindow==NULL) { printf("\n erreur d'allocation memoire "); exit(-1); }
  printf("[NbWind:%d][Seed:%d]\n",nbwindows,myseed);
  }

//----------------------------------------------------------
// destructeur  de la classe KMEAN
//----------------------------------------------------------
 KMEAN::~KMEAN()
 { 
  //>libere la memoire---
  if (histo) free_fmatrix_1d(histo);
  if (ppar)  free_fmatrix_2d(ppar);
  if (pmatl) free_fmatrix_2d(pmatl);
  if (pmatp) free_fmatrix_3d(pmatp,nbclass);
  if (pswindow) free(pswindow);
 }

//----------------------------------------------------------
// ESTIMATION par l'algorithme des k moyennes                                
//----------------------------------------------------------
void KMEAN::KMEAN_Estimate(float** ppicture,float** ppara)
{
 int i;
 float Nb;
  
  //>Presentation
  //printf("\n [K-MEAN][seed:%d][lgth=%d:wdth=%d]\n",myseed,length,width);
  printf("\n [K-MEAN][seed:%d][%d:%d]\n",myseed,length,width);
 
  //>Features
  fillarrayswindow(ppicture);
  //normalizeswindow();

  //>Initialisation [K-MEAN]
  srand(myseed);
  for(i=0;i<nbclass;i++)
   { Nb=(((float)rand()/RAND_MAX)*nbwindows)-1;
     ppar[i][1]=pswindow[(int)Nb].par1;
     ppar[i][2]=pswindow[(int)Nb].par2;
     ppar[i][3]=pswindow[(int)Nb].par3;
     ppar[i][4]=pswindow[(int)Nb].par4;
     //printf("[%d]",(int)Nb);
   }

  //>Loop [K-MEAN]
  for(i=0;;i++)
   { if (cluster()==0) break;
     computemean();
     printf("[%d]-",i); }

  //>Parametres Finaux 
  compute_mean_estimates();
  visu_screen(i);
  ClassifyPar();

  //> pmatl au sens MV 
  fill_init_matp(ppicture);
  init_label_matrix();
 
  //>remplie une picture de l'histogramme 
  histo_picture(ppicture);
  
  //>distance de kolmogorov
  printf("\n\n distance de kolmogorov > ");
  printf("[%.4f]",dist_kolmogorov(histo,GREY_LEVEL));

  //>parametres copié dans ppara 
  copy_ppar(nbclass,ppara);

  //>DEBUG
  //FILE* f=fopen("f.dat","w");
  //for(i=0;i<nbwindows;i++)
  //   { fprintf(f,"\n %.2f %.2f %.2f %.2f ",pswindow[i].par1,pswindow[i].par2,pswindow[i].par3,pswindow[i].par4); 
  //     fprintf(f,"[%d]",(int)pswindow[i].pix); }
  //fclose(f);
}

//-------------------
//-------------------
//-------------------
//----------------------------------------------------------
// remplie une picture des pixels de l'image et de leur  
// etiquette associée                                    
//----------------------------------------------------------
void  KMEAN::fillpict_LabelImg(float** pict)
{
  int i,j,k;
  int nc;
 
  for(i=1;i<(length-1);i++) for(j=1;j<(width-1);j++) pict[i][j]=GREY_LEVEL;

  for(k=0,i=0;i<length;i++) for(j=0;j<width;j++)
      {
         nc=pswindow[k].label;
         nc=(int)((nc*GREY_LEVEL)/(nbclass-1));
         pict[i][j]=(short)nc;   
         k++;               
      }
 }

//----------------------------------------------------------
// rempli une picture de l'histogramme et du melange   
// des differentes distributions                       
//----------------------------------------------------------                
void KMEAN::fillpict_DistributionMixture(float** ppicture)
{
int i,j,k;
float tmp,tp,val,row,col;
short pix;

  for(i=1;i<(length-1);i++) for(j=1;j<(width-1);j++) ppicture[i][j]=GREY_LEVEL;

  for(i=0;i<=GREY_LEVEL;i++)
   {
     tmp=(int)(histo[i]*(0.15*width*length));
     if (tmp>=(length-1)) tmp=(length-1);

     for(tp=tmp;tp>0;tp--) 
        {  val=(int)((width*(length-1))-(tp*width)+i);
	   row=(int)(val/width);
           col=(int)((int)(val)%width);
	   ppicture[(int)(row)][(int)(col)]=(GREY_LEVEL/1.2); }
     
      //>dessine les lois 
      for(k=0;k<nbclass;k++)
       {
	tmp=funcgauss(i,ppar[k][0],ppar[k][1],ppar[k][2]);
        if (tmp<0.0) tmp=0.0;
        else tmp=(int)(tmp*(0.15*width*length));
       
        if (tmp>(length-1)) tmp=(length-1);

        val=(int)((width*(length-1))-(tmp*width)+i);
        row=(int)(val/width);
        col=(int)((int)(val)%width);

        if (row>(length-1)) row=(length-1);
	if (row<0)          row=0;
	if (col>(width-1))  col=(width-1);
	if (col<0)          col=0;
	
        pix=ppicture[(int)row][(int)col]; 
        
        if (pix!=0)  ppicture[(int)row][(int)col]=0;
        else         ppicture[(int)row][(int)col]=GREY_LEVEL; 
        }
    }
}

//----------------------------------------------------------
// remplie une matrice de leur etiquette associée                                    
//-----------------------------------------------------------
void KMEAN::fillpict_LabelMatx(float** pict)
{
 int i,j,k;

 for(k=0,i=0;i<length;i++) for(j=0;j<width;j++)
    {  pict[i][j]=(short)pswindow[k].label; 
       k++;  }
}

//----------------------------------------------------------
// remplie une picture Segmentation MV                               
//----------------------------------------------------------
void KMEAN::fillpict_MVLabel(float** ppicturemv)
{
 for(int i=0;i<length;i++) for(int j=0;j<width;j++)
   ppicturemv[i][j]-=(int)(((pmatl[i][j])*GREY_LEVEL)/(nbclass-1)); 
}

//-------------------
//-------------------
//-------------------
//----------------------------------------------------------
// remplie le tableau swindow                            
//----------------------------------------------------------
void KMEAN::fillarrayswindow(float** ppicture)
{
 int i,j,m,n,k;
 int row,col;
 float moy,var,max,min;
 float pix;

 k=0;
 for(i=0;i<length;i++) for(j=0;j<width;j++)
    {
      moy=0.0; var=0.0; max=0; min=GREY_LEVEL;
      for(m=0;m<size;m++) for(n=0;n<size;n++)
	 { row=i+m-(size/2);
           col=j+n-(size/2);
           if (row>(length-1)) row-=length;
           if (col>(width-1))  col-=width;
           if (row<0) row+=length;
           if (col<0) col+=width;
           pix=ppicture[row][col];       
           moy+=(float)pix;
           if (min>pix) min=pix;
           if (max<pix) max=pix; }

      moy/=CARRE(size);

      for(m=0;m<size;m++) for(n=0;n<size;n++)
	 { row=i+m-(size/2);
           col=j+n-(size/2);
           if (row>(length-1)) row-=length;
           if (col>(width-1))  col-=width;
           if (row<0) row+=length;
           if (col<0) col+=width;
           pix=ppicture[row][col];
           var+=CARRE(pix-moy); }

      var/=CARRE(size); 

       pswindow[k].par1=moy;
       pswindow[k].par2=0;
       pswindow[k].par3=0;
       pswindow[k].par4=0;
       pswindow[k].pix=ppicture[i][j];
       pswindow[k].label=-1;
       k++;
    }
}

//----------------------------------------------------------
// normalize                            
//----------------------------------------------------------
void KMEAN::normalizeswindow()
{
 int i;
 float min,max,tmp;
 
 min=BIGNUMB; max=0.0; tmp=0.0;
 for(i=0;i<nbwindows;i++)
  { if ((pswindow[i].par1)<min) min=pswindow[i].par1;
    if ((pswindow[i].par1)>max) max=pswindow[i].par1; }
 for(i=0;i<nbwindows;i++)
  { tmp=pswindow[i].par1; pswindow[i].par1=((tmp-min)*100)/(max-min); }

 min=BIGNUMB; max=0.0; tmp=0.0;
 for(i=0;i<nbwindows;i++)
  { if ((pswindow[i].par2)<min) min=pswindow[i].par2;
    if ((pswindow[i].par2)>max) max=pswindow[i].par2; }
 for(i=0;i<nbwindows;i++)
  { tmp=pswindow[i].par2; pswindow[i].par2=((tmp-min)*100)/(max-min); }

 min=BIGNUMB; max=0.0; tmp=0.0;
 for(i=0;i<nbwindows;i++)
  { if ((pswindow[i].par3)<min) min=pswindow[i].par3;
    if ((pswindow[i].par3)>max) max=pswindow[i].par3; }
 for(i=0;i<nbwindows;i++)
  { tmp=pswindow[i].par3; pswindow[i].par3=((tmp-min)*100)/(max-min); }

 min=BIGNUMB; max=0.0; tmp=0.0;
 for(i=0;i<nbwindows;i++)
  { if ((pswindow[i].par4)<min) min=pswindow[i].par4;
    if ((pswindow[i].par4)>max) max=pswindow[i].par4; }
 for(i=0;i<nbwindows;i++)
  { tmp=pswindow[i].par4; pswindow[i].par4=((tmp-min)*100)/(max-min); }
}

//----------------------------------------------------------
// procedure de rassemblement                        
//----------------------------------------------------------
int KMEAN::cluster()
{
 int i,j,k,flag;
 float dist,distmin;
 float a,b,c,d,e,f,g,h;

 k=0; flag=0;
 for(i=0;i<nbwindows;i++)
   {
    distmin=BIGNUMB;
    for(j=0;j<nbclass;j++)
      {
        a=ppar[j][1]; b=pswindow[i].par1;
        c=ppar[j][2]; d=pswindow[i].par2;
        e=ppar[j][3]; f=pswindow[i].par3;
        g=ppar[j][4]; h=pswindow[i].par4; 

        dist=DIST(a,b,c,d,e,f,g,h);
        if (dist<distmin) { distmin=dist; k=j; }
       }
     if ((pswindow[i].label)!=k) { pswindow[i].label=k; flag=1;}
    }
  return flag;
}

//----------------------------------------------------------
// calcule la moyenne des differentes classes         
//----------------------------------------------------------
void KMEAN::computemean()
{
 int i,j,k;
 float moypar1,moypar2,moypar3,moypar4;
  
  for(j=0;j<nbclass;j++)
   {
     k=0; 
     moypar1=0.0; 
     moypar2=0.0; 
     moypar3=0.0; 
     moypar4=0.0;
     for(i=0;i<nbwindows;i++) if ((pswindow[i].label)==j)
         { k++; 
           moypar1+=pswindow[i].par1; 
           moypar2+=pswindow[i].par2; 
           moypar3+=pswindow[i].par3; 
           moypar4+=pswindow[i].par4; }

    ppar[j][0]=((float)k/(float)nbwindows);
    if (k) ppar[j][1]=(moypar1/(float)k);
    if (k) ppar[j][2]=(moypar2/(float)k);
    if (k) ppar[j][3]=(moypar3/(float)k);
    if (k) ppar[j][4]=(moypar4/(float)k); }  
}


//----------------------------------------------------------
//calcule la moyenne des differentes estimations     
//----------------------------------------------------------
void KMEAN::compute_mean_estimates()
{
 int i,j,k;
 float moy,var;
  
  for(j=0;j<nbclass;j++)
   {
     k=0; moy=0.0; var=0.0;     
      for(i=0;i<nbwindows;i++) if ((pswindow[i].label)==j)
         { k++; 
           moy+=pswindow[i].pix;  }
      if (k) moy/=k;

      for(i=0;i<nbwindows;i++) if ((pswindow[i].label)==j)
	 { var+=CARRE(pswindow[i].pix - moy);  }
      if (k) var/=k;

       ppar[j][0]=((float)k/(float)nbwindows);
       ppar[j][1]=moy;
       ppar[j][2]=var;
   } 
}

//----------------------------------------------------------
//  ClassifyPar                             
//-----------------------------------------------------------
void KMEAN::ClassifyPar(void)
{
 int k,l,m;
 for(k=0;k<nbclass;k++) for(l=0;l<(nbclass-1);l++)
 if (ppar[l][1]>ppar[l+1][1]) for(m=0;m<3;m++) SWAPF(ppar[l][m],ppar[l+1][m]); 
 printf("\n");  
 visu_screen(0);   
}


//----------------------
//------------GESTION---
//----------------------
//----------------------------------------------------------
// on rempli le champ d'etiquette initiale par sa  
// valeur au sens du maximum de vraissemblance.    
//----------------------------------------------------------
void KMEAN::init_label_matrix()
{
 int i,j,k;
 float tmp,pmax;

 tmp=0.0;
 for(i=0;i<length;i++) for(j=0;j<width;j++)
   {
    pmax=0.0;
     for(k=0;k<nbclass;k++)
       { tmp=pmatp[k][i][j];
         if (tmp>pmax) { pmatl[i][j]=k; pmax=tmp;  }
       }
   }
}

//----------------------------------------------------------
// remplie la matrice 3d contenant la probabilite       
// d'appartenance de chaque pixel a chacune des classes 
// (maximum de vraissemblance)                          
//----------------------------------------------------------
void KMEAN::fill_init_matp(float** ppicture)
{
  int i,j,k;
  short pix;
  float tmp,sum;
  
   tmp=0.0;
   for(i=0;i<length;i++) for(j=0;j<width;j++)
        {
          pix=ppicture[i][j];
          sum=0.0;
            for(k=0;k<nbclass;k++)
             {
              tmp=funcgauss(pix,1,ppar[k][1],ppar[k][2]);
              if (tmp>0.0) { pmatp[k][i][j]=tmp; sum+=tmp; }
              else { pmatp[k][i][j]=0.0; tmp=0.0; }
             }

           if(sum>0.0) for(k=0;k<nbclass;k++)  pmatp[k][i][j]/=sum; 
           else { for(k=0;k<nbclass;k++)  pmatp[k][i][j]/=(float)nbclass;  }
         }
}

//----------------------------------------------------------
// calcule l'histogramme d'une image, resultats dans  
// le tableau de flottant hist                        
//----------------------------------------------------------
void KMEAN::histo_picture(float** ppicture)
{
int i,j;
int pix;

 for(i=0;i<=GREY_LEVEL;i++) histo[i]=0.0;

 for(i=0;i<length;i++) for(j=0;j<width;j++)
    { pix=ppicture[i][j];
      (histo[pix])++; }

 for(i=0;i<=GREY_LEVEL;i++) histo[i]/=(length*width);
}

//----------------------------------------------------------
// retourne la probabilite d'un pixel yi d'appartenir
// a la classe correspondante aux parametres
//      coef, moy var
//----------------------------------------------------------
float KMEAN::funcgauss(short pix,float coef,float moy,float var)
{
return (float)((coef)*(1/(sqrt(2*PI*var)))*exp(-1*(CARRE((float)pix-moy))/(2*var)));
}

//----------------------------------------------------------
// visualisation sur ecran des differents parametres  
//----------------------------------------------------------
void KMEAN::visu_screen(int i)
{
 int k;
 printf("\n\n %dieme iteration",i);
 for(k=0;k<nbclass;k++) printf("\n   c=%.2f   m=%.1f  v=%.1f",ppar[k][0],ppar[k][1],ppar[k][2]);
}

//----------------------------------------------------------
// copie dans pparbis les parametres estimé
//----------------------------------------------------------
void KMEAN::copy_ppar(int nbclass,float** pparbis)
{
 for(int k=0;k<nbclass;k++) for(int l=0;l<NBPAR;l++) pparbis[k][l]=ppar[k][l];
}


//----------------------------------------------------------
// calcule la distance de Kolmogorov                 
//----------------------------------------------------------
float KMEAN::dist_kolmogorov(float* hist,int nbgrey_level)
{
int i,k;
float tmp,tp,sum;
double dist;

  for(i=0,dist=0;i<=nbgrey_level;i++)
   { tmp=(float)(hist[i]);

      for(k=0,tp=0,sum=0;k<nbclass;k++)
        { tp=funcgauss(i,ppar[k][0],ppar[k][1],ppar[k][2]);
          if (tp<0) tp=0;
          sum+=tp; }
     
    dist+=fabs((double)tmp-(double)sum);       
    }

return (float)dist;  
}

//------------------------------------------------
// FONCTIONS DE LA CLASSE <ESTIMATOR>  -----------
//------------------------------------------------
//----------------------------------------------------------
// constructeur de la classe estimator
//----------------------------------------------------------
estimator::estimator(int Nbclass,int Law,int lgth,int wdth)
 {
   nbclass=Nbclass;
   law=Law; 
   width=wdth;
   length=lgth;

   //----allocation memoire--- 
   histo=fmatrix_allocate_1d(GREY_LEVEL);
   ppar=fmatrix_allocate_2d(nbclass,NBPAR);
   pparmoy=fmatrix_allocate_2d(nbclass,NBPAR);
   pmatl=fmatrix_allocate_2d(length,width);
   pmatp=fmatrix_allocate_3d(nbclass,length,width);
   pparstock=fmatrix_allocate_3d(NBECH,nbclass,NBPAR);  
  }

//----------------------------------------------------------
// destructeur de la classe estimator
//----------------------------------------------------------
 estimator::~estimator()
 { 
  //---libere la memoire---
  if (histo) free_fmatrix_1d(histo);
  if (ppar)  free_fmatrix_2d(ppar);
  if (pmatl) free_fmatrix_2d(pmatl);
  if (pmatp) free_fmatrix_3d(pmatp,nbclass);
  if (pparstock) free_fmatrix_3d(pparstock,NBECH);
 }

//----------------------------------------------------------
// remplie une picture de pmatl au sens du MV                    
//----------------------------------------------------------
void estimator::fillpict_LabelImg(float** ppicturemv)
{
 init_label_matrix();

 for(int i=0;i<length;i++) for(int j=0;j<width;j++)
   ppicturemv[i][j]=(int)(((pmatl[i][j])*GREY_LEVEL)/(nbclass-1)); 
}
 

//----------------------------------------------------------
// rempli une picture de l'histogramme et du melange   
// des differentes distributions                       
//----------------------------------------------------------           
void estimator::fillpict_DistributionMixture(float** ppicture)
{
int i,j,k;
float tmp,tp,val,row,col;
short pix;

  for(i=1;i<(length-1);i++) for(j=1;j<(width-1);j++) ppicture[i][j]=GREY_LEVEL;
  for(i=0;i<=GREY_LEVEL;i++)
   {    
     tmp=(int)(histo[i]*(0.15*width*length));
     if (tmp>=(length-1)) tmp=(length-1);
     
     for(tp=tmp;tp>0;tp--) 
        {  val=(int)((width*(length-1))-(tp*width)+i);
	   row=(int)(val/width);
           col=(int)((int)(val)%width);
	   ppicture[(int)(row)][(int)(col)]=(GREY_LEVEL/1.2); }

      /* Dessine les lois */
      for(k=0;k<nbclass;k++)
       {
        if  (law==1) tmp=funcgauss(i,ppar[k][0],ppar[k][1],ppar[k][2]);
        if  (law==2) tmp=funcraleygh(i,ppar[k][0],ppar[k][1],ppar[k][2]);
   
        if ((law==3)&&(k==0)) tmp=funcgauss(i,ppar[k][0],ppar[k][1],ppar[k][2]);
        if ((law==3)&&(k==1)) tmp=funcraleygh(i,ppar[k][0],ppar[k][1],ppar[k][2]);

        if (tmp<0.0) tmp=0.0;
        else tmp=(int)(tmp*(0.15*width*length));
       
        if (tmp>(length-1)) tmp=(length-1);

        val=(int)((width*(length-1))-(tmp*width)+i);
        row=(int)(val/width);
        col=(int)((int)(val)%width);

        if (row>(length-1)) row=(length-1);
	if (row<0)          row=0;
	if (col>(width-1))  col=(width-1);
	if (col<0)          col=0;
	
        pix=ppicture[(int)row][(int)col];
        
        if (pix!=0)  ppicture[(int)row][(int)col]=0;
        else         ppicture[(int)row][(int)col]=GREY_LEVEL; 
        }
    }
}

//----------------------------------------------------------
// remplie une matrice de leur etiquette associée                                    
//-----------------------------------------------------------
void estimator::fillpict_LabelMatx(float** pict)
{
 int i,j;
 for(i=0;i<length;i++) for(j=0;j<width;j++) pict[i][j]=pmatl[i][j]; 
}

//----------------------------------------------------------
// MV Treshold  between law1 and law2                                
//-----------------------------------------------------------
int estimator::MV_TresholdForTwoDistribMixture(int LawNumber1,int LawNumber2)
{
 int k;
 float prob1,prob2;
 ClassifyPar();
 for(k=0;k<=GREY_LEVEL;k++)
    { prob1=funcgauss(k,1.0,ppar[LawNumber1][1],ppar[LawNumber1][2]);
      prob2=funcgauss(k,1.0,ppar[LawNumber2][1],ppar[LawNumber2][2]);
      if (prob2>prob1) break; }
 return k;
}

//----------------------------------------------------------
// MAP Treshold  between law1 and law2                                
//-----------------------------------------------------------
int estimator::MAP_TresholdForTwoDistribMixture(int LawNumber1,int LawNumber2)
{
 int k;
 float prob1,prob2;
 ClassifyPar();   
 for(k=0;k<=GREY_LEVEL;k++)
    { prob1=funcgauss(k,ppar[LawNumber1][0],ppar[LawNumber1][1],ppar[LawNumber1][2]);
      prob2=funcgauss(k,ppar[LawNumber2][0],ppar[LawNumber2][1],ppar[LawNumber2][2]);
      if (prob2>prob1) break; }
 return k;
}

//---------------------
//---------------------
//---------------------
//----------------------------------------------------------
//  ClassifyPar                             
//-----------------------------------------------------------
void estimator::ClassifyPar(void)
{
 int k,l,m;
 for(k=0;k<nbclass;k++) for(l=0;l<(nbclass-1);l++)
 if (ppar[l][1]>ppar[l+1][1]) for(m=0;m<3;m++) SWAPF(ppar[l][m],ppar[l+1][m]); 
 printf("\n");  
 visu_screen(0);   
}

//----------------------------------------------------------
// retourne la probabilite d'un pixel yi d'appartenir
// a la classe correspondante aux parametres
//     coef, min alphad
//----------------------------------------------------------
float estimator::funcraleygh(short pix,float coef,float min,float alphad)
{
return
(float)((coef)*(((float)pix-min)/alphad)*exp(-1*(CARRE((float)pix-min))/(2*alphad)));
}

//----------------------------------------------------------
// retourne la probabilite d'un pixel yi d'appartenir
// a la classe correspondante aux parametres
//      coef, moy var
//----------------------------------------------------------
float estimator::funcgauss(short pix,float coef,float moy,float var)
{
return (float)((coef)*(1/(sqrt(2*PI*var)))*exp(-1*(CARRE((float)pix-moy))/(2*var)));
}

//----------------------------------------------------------
// retourne la probabilite d'un pixel yi d'appartenir 
// a la classe WEIBULL                                
//     min C et alpha                                
//----------------------------------------------------------
float estimator::funcweibull(short pix,float coef,float min,float c,float alpha)
{
return(float)(coef)*(c/alpha)*
(pow((((float)pix-min)/alpha),c-1))*exp(-1*pow((((float)pix-min)/alpha),c));
}

//----------------------------------------------------------
// visualisation sur ecran des differents parametres  
//----------------------------------------------------------
void estimator::visu_screen(int i)
{
 int k;

 printf("\n %dieme iteration",i);
 for(k=0;k<nbclass;k++) printf("\n   c=%3.2f   m=%1.2f  v=%1.2f",ppar[k][0],ppar[k][1],ppar[k][2]);
}

//----------------------------------------------------------
// visualisation sur ecran des differents parametres pour
// la loi de WEIBULL
//----------------------------------------------------------
void estimator::visu_screen_weib(int i)
{
 int k;

 printf("\n\n %dieme iteration",i);
 for(k=0;k<nbclass;k++) 
 printf("\n  prop=%3.2f  min=%2.0f  c=%1.2f  v=%3.2f",ppar[k][0],ppar[k][1],ppar[k][2],ppar[k][3]);
}


//----------------------------------------------------------
// calcule l'histogramme d'une image, resultats dans  
// le tableau de flottant histo                        
//----------------------------------------------------------
void estimator::histo_picture(float** ppicture)
{
int i,j;
int pix;

  for(i=0;i<=GREY_LEVEL;i++) histo[i]=0.0;
  for(i=0;i<length;i++) for(j=0;j<width;j++)
      { pix=ppicture[i][j];
        (histo[pix])++; }

  for(i=0;i<=GREY_LEVEL;i++) histo[i]/=(length*width);
}

//----------------------------------------------------------
// calcule la distance de Kolmogorov                 
//----------------------------------------------------------
float estimator::dist_kolmogorov()
{
int i,k;
float tmp,tp,sum;
double dist;

  for(i=0,dist=0;i<=GREY_LEVEL;i++)
   {
    tmp=(float)(histo[i]/(length*width));

      for(k=0,tp=0,sum=0;k<nbclass;k++)
        {      
          if  (law==1) tp=funcgauss(i,ppar[k][0],ppar[k][1],ppar[k][2]);
          if  (law==2) tp=funcraleygh(i,ppar[k][0],ppar[k][1],ppar[k][2]);

          if  ((law==4)&&(k==0)) tp=funcgauss(i,ppar[k][0],ppar[k][1],ppar[k][2]);
          if  ((law==4)&&(k==1)) tp=funcraleygh(i,ppar[k][0],ppar[k][1],ppar[k][2]);

          if ((law==5)&&(ppar[k][1]<=i)) tp=funcweibull(i,ppar[k][0],ppar[k][1],ppar[k][2],ppar[k][3]);
          if ((law==5)&&(ppar[k][1]>i))  tp=0.0;

          if (tp<0) tp=0;
          sum+=tp;
        }
     
    dist+=fabs((double)tmp-(double)sum);   
    }
return (float)dist;  
}


//----------------------------------------------------------
// on rempli le champ d'etiquette initiale par sa  
// valeur au sens du maximum de vraissemblance.    
//----------------------------------------------------------
void estimator::init_label_matrix()
{
 int i,j,k;
 float tmp,pmax;

 tmp=0.0;

 for(i=0;i<length;i++) for(j=0;j<width;j++)
   {
    pmax=0.0;
     for(k=0;k<nbclass;k++)
       { tmp=pmatp[k][i][j];
         if (tmp>pmax) { pmatl[i][j]=k; pmax=tmp;  }
       }
   }
}

//------------------------------------------------
// retourne un nombre aleatoire entre    
//         zero et un                    
//------------------------------------------------
float estimator::randomize(void)
{
 return ((float)rand()/RAND_MAX);
}

//---------------------------------------------------
// calcule un critere d'arret a partir du tableau    
// des NBECH dernieres estimations et la valeur      
// courante des parametres                           
//---------------------------------------------------
float estimator::varpparstock()
{
 int i,j;
 float max,tmp,tmpa,tmpb,minech,maxech;

 max=0.0; 
 
 for(j=0;j<nbclass;j++)
  {
   minech=100000; maxech=0.0;
     { 
      for(i=0;i<NBECH;i++)
          { 
            tmp=pparstock[i][j][2];  
            if (tmp>maxech) maxech=tmp;
            if (tmp<minech) minech=tmp;
          }
            tmpa=fabs(1-((ppar[j][2])/maxech));
            tmpb=fabs(1-((ppar[j][2])/minech));

            if (tmpa>tmpb) max=tmpa; else max=tmpb;          
     }
  }
 return (100*max);

}

//---------------------------------------------------
// donne la moyenne des estimations enregistres dans 
// le tableau pparstock                              
//---------------------------------------------------
void estimator::moypar()
{
 int i,j,k;
 float moy;
 
 for(j=0;j<nbclass;j++) for(k=0;k<NBPAR;k++)
  {
   moy=0.0;

   for(i=0;i<NBECH;i++) moy+=pparstock[i][j][k];

   moy/=(float)NBECH;
   pparmoy[j][k]=moy;
  }
}

//---------------------------------------------------
// rempli le tableau pparstock des estimations       
//---------------------------------------------------
void estimator::fill_pparstock(int iter)
{
 int k,j,i;

 for(j=0;j<nbclass;j++) for(k=0;k<NBPAR;k++)
 { i=(iter%NBECH); pparstock[i][j][k]=ppar[j][k]; }

}

//---------------------------------------------------
// calcule le khi2 requantifie                       
//---------------------------------------------------
float estimator::khi_2()
{
int i,j,k;
float tmp,tp,sum;
float width_win,mid_win;
float dist;

  tmp=0.0;

  width_win=ceil(GREY_LEVEL/(1+3.3*(log(width*length))));
  mid_win=ceil((width_win/2)-1); 

  for(i=0,dist=0.0;i<(GREY_LEVEL-(int)width_win);i+=(int)width_win)
   {
    for(j=i;j<(i+width_win);j++)
    { tmp+=(float)(histo[j]/(length*width)); }
      tmp/=(width_win); 

      for(k=0,tp=0,sum=0;k<nbclass;k++)
        {      
          if  (law==1) tp=funcgauss((int)(i+mid_win),ppar[k][0],ppar[k][1],ppar[k][2]);
          if  (law==2) tp=funcraleygh((int)(i+mid_win),ppar[k][0],ppar[k][1],ppar[k][2]);

          if  ((law==4)&&(k==0)) tp=funcgauss((int)(i+mid_win),ppar[k][0],ppar[k][1],ppar[k][2]);
          if  ((law==4)&&(k==1)) tp=funcraleygh((int)(i+mid_win),ppar[k][0],ppar[k][1],ppar[k][2]);

          if ((law==5)&&(ppar[k][1]<=i)) tp=funcweibull(i,ppar[k][0],ppar[k][1],ppar[k][2],ppar[k][3]);
          if ((law==5)&&(ppar[k][1]>i))  tp=0.0;

          if (tp<=0) tp=0.0;
          sum+=tp;
        }
     
    if (sum!=0.0) { dist+=(width*length*width_win)*(CARRE((double)tmp-(double)sum))/(sum); }    
    }
return dist;  
}


//------------------------------------------------
// FONCTIONS DE LA CLASSE <EM>     ---------------
//------------------------------------------------
//----------------------------------------------------------
// constructeur de la classe EM
//----------------------------------------------------------
EM::EM(int Nbclass,int Law,int lgth,int wdth):estimator(Nbclass,Law,lgth,wdth) { ; }
 
//----------------------------------------------------------
// destructeur  de la classe sem
//----------------------------------------------------------
 EM::~EM() {;}

//----------------------------------------------------------
// remplie la matrice 3d contenant la probabilite       
// d'appartenance de chaque pixel a chacune des classes 
//----------------------------------------------------------
void EM::fill_matp(float** ppicture)
{
  int i,j,k;
  short pix;
  float tmp,sum;

  tmp=0.0;

   for(i=0;i<length;i++) for(j=0;j<width;j++)
        {
          pix=ppicture[i][j];
          sum=0.0;
            for(k=0;k<nbclass;k++)
             {
              if (law==1) tmp=funcgauss(pix,ppar[k][0],ppar[k][1],ppar[k][2]);
              if (law==2) tmp=funcraleygh(pix,ppar[k][0],ppar[k][1],ppar[k][2]);

              if (law==4)
               {  if (k==0) tmp=funcgauss(pix,ppar[k][0],ppar[k][1],ppar[k][2]);
                  if (k==1) tmp=funcraleygh(pix,ppar[k][0],ppar[k][1],ppar[k][2]); }

              if (tmp>0.0) { pmatp[k][i][j]=tmp; sum+=tmp; }
              else { pmatp[k][i][j]=0.0; tmp=0.0; }
             }

           if(sum>0.0) for(k=0;k<nbclass;k++)  pmatp[k][i][j]/=sum; 
           else { for(k=0;k<nbclass;k++)  pmatp[k][i][j]/=(float)nbclass;  }
         }
}

//----------------------------------------------------------
// estimation des differents parametres du melange       
// (estimateur calcule suivant l'algorithme EM) pour le  
// cas loi normale et loi de rayleigh                    
//----------------------------------------------------------
void EM::compute_EMparameter(float** ppicture)
{
  int i,j,k;
  float m,var,alphad;
  float tmp,sum;
  int pix;
  
    for(k=0;k<nbclass;k++)
      {
          m=0.0; var=0.0; alphad=0.0; sum=0.0; tmp=0.0;

           for(i=0;i<(length);i++) for(j=0;j<(width);j++)
              {
               pix=ppicture[i][j];
               tmp=pmatp[k][i][j];
               if (law==1) sum+=((float)(pix)*tmp);
   
               if ((law==4)&&(k==0)) sum+=((float)(pix)*tmp);
               }  

           m=sum/ppar[k][0];  

           for(i=0;i<(length);i++) for(j=0;j<(width);j++)
              {
               pix=ppicture[i][j];
               tmp=pmatp[k][i][j];
               if (law==1) var+=(tmp)*CARRE((float)pix-m);
               if (law==2) alphad+=(tmp)*CARRE((float)pix-ppar[k][1]);
        
               if ((law==4)&&(k==0))  var+=(tmp)*CARRE((float)pix-m);
               if ((law==4)&&(k==1))  alphad+=(tmp)*CARRE((float)pix-ppar[k][1]);
               } 

      if(law==1) 
           { 
              var/=ppar[k][0]; 
              ppar[k][1]=m;
              ppar[k][2]=var;
              ppar[k][0]/=(width*length);
            }

      if (law==2)
            { 
              alphad/=((ppar[k][0])*2); 
              ppar[k][2]=alphad;
              ppar[k][0]/=(width*length);
            }  

      if (law==4)
            { 
              if (k==0) { var/=ppar[k][0]; ppar[k][1]=m; ppar[k][2]=var; }
              if (k==1) { alphad/=((ppar[k][0])*2);   ppar[k][2]=alphad; }               
              ppar[k][0]/=(width*length);
            } 
 
      }
}

//----------------------------------------------------------
// calcule Nk(utilise pour calculer ensuite la proportion  
// des differentes loi du melange)                         
//----------------------------------------------------------
void EM::compute_Nk()
{
 int i,j,k;
 float sum;

  for(k=0;k<nbclass;k++)
   { 
     sum=0.0;
   
     for(i=0;i<(length);i++)  for(j=0;j<(width);j++) 
     sum+=pmatp[k][i][j];

     ppar[k][0]=sum;
   }
} 

//----------------------------------------------------------
//  ESTIMATION E.M                   
//----------------------------------------------------------
void EM::EM_Estimate(float** ppicture,float** ppar_init)
{
  int i,j;
  float stopcond;

  //--presentation--
  printf("\n\n [EM]");

  //--loi de weibull?--
   if (law==5) 
       { printf("\n-----------------------------------------------------------");
         printf("\n EM ne marche pas pour l'estimation d'un melange de Weibull");
         printf("\n-----------------------------------------------------------");
         exit(-1); }

  // ppar_init > ppar
  for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) 
  ppar[i][j]=ppar_init[i][j];                                       /*parametres initiaux*/
  visu_screen(0);                                                   
     
  fill_matp(ppicture);                                               /*initialisation*/

  for(i=1;i<ITER;i++)
     {
        compute_Nk();
        compute_EMparameter(ppicture);                               /*M.aximisation step*/
        fill_matp(ppicture);                                         /*E.stimation step*/
        fill_pparstock(i);

        if (i>ITERMINI)
           {
            moypar();
            stopcond=varpparstock(); 
            printf("\n (%f)",stopcond);                            /*critere d'arret*/
            if (stopcond<STOPCOND) break;
       }
                                                                         
  visu_screen(i);                                                   /*visu sur ecran*/                                     
 }

  // pparmoy --> ppar
  for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) 
  { ppar[i][j]=pparmoy[i][j]; ppar_init[i][j]=pparmoy[i][j]; }
  visu_screen(0);                                                   /*parametres finaux*/

  // calcule la distance de kolmogorov et khi2           
  histo_picture(ppicture);
  printf("\n\n distance de kolmogorov >");
  printf("[%.4f]",dist_kolmogorov());
  printf("\n khi2 >");
  printf("[%.4f]",khi_2());
  dist_kolmo=dist_kolmogorov();                                     /*calcul de l'erreur*/ 
}

//----------------------------------------------------------
//  ESTIMATION E.M                   
//----------------------------------------------------------
void EM::EM_Estimate(float** ppicture,float** ppar_init,int MyNbIter)
{
  int i,j;
  float stopcond;

  //--presentation--
  printf("\n\n [EM]");

  //--loi de weibull?--
   if (law==5) 
       { printf("\n-----------------------------------------------------------");
         printf("\n EM ne marche pas pour l'estimation d'un melange de Weibull");
         printf("\n-----------------------------------------------------------");
         exit(-1); }

  // ppar_init > ppar
  for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) 
  ppar[i][j]=ppar_init[i][j];                                       /*parametres initiaux*/
  visu_screen(0);                                                   
     
  fill_matp(ppicture);                                               /*initialisation*/

  for(i=1;i<MyNbIter;i++)
     {
        compute_Nk();
        compute_EMparameter(ppicture);                               /*M.aximisation step*/
        fill_matp(ppicture);                                         /*E.stimation step*/
        fill_pparstock(i);

        if (i>MyNbIter/2)
           {
            moypar();
            stopcond=varpparstock(); 
            printf("\n (%f)",stopcond);                            /*critere d'arret*/
            if (stopcond<STOPCOND) break;
       }
                                                                         
  visu_screen(i);                                                   /*visu sur ecran*/                                     
 }

  // pparmoy --> ppar
  for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) 
  { ppar[i][j]=pparmoy[i][j]; ppar_init[i][j]=pparmoy[i][j]; }
  visu_screen(0);                                                   /*parametres finaux*/

  // calcule la distance de kolmogorov et khi2           
  histo_picture(ppicture);
  printf("\n\n distance de kolmogorov >");
  printf("[%.4f]",dist_kolmogorov());
  printf("\n khi2 >");
  printf("[%.4f]",khi_2());
  dist_kolmo=dist_kolmogorov();                                     /*calcul de l'erreur*/ 
}



//------------------------------------------------
// FONCTIONS DE LA CLASSE <SEM>    ---------------
//------------------------------------------------
//----------------------------------------------------------
// constructeur de la classe estimator
//----------------------------------------------------------
 SEM::SEM(int Nbclass,int Law,int lgth,int wdth):estimator(Nbclass,Law,lgth,wdth) { ; }
 
//----------------------------------------------------------
// destructeur de la classe SEM
//----------------------------------------------------------
 SEM::~SEM() {;}

//----------------------------------------------------------
//  ESTIMATION S.E.M                   
//----------------------------------------------------------
void  SEM::SEM_Estimate(float** ppicture,float** ppar_init,int wp)
{
  int i,j;
  float stopcond;

  //>Presentation--
  printf("\n\n [SEM]");

  //>ppar_init --> ppar
  if (wp==1)
    { for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) { ppar[i][j]=ppar_init[i][j]; }  /*par. initiaux*/

      if (law<5)   visu_screen(0); 
      if (law==5)  visu_screen_weib(0);  }                                                  

  if (wp==0) init_random_matrix();         
  else  fill_matp(ppicture);                           /*initialisation*/

 for(i=1;i<ITER;i++)
  {
   choose_label();                                          /*S.tochastic step*/
   if (law<5) compute_parameter(ppicture);                  /*M.aximisation step*/
     // compute_parameter(ppicture); //
     // visu_screen(i); //
     // exit(-1); //

   if (law==5) weib_estimate(ppicture);
   fill_matp(ppicture);                                     /*E.stimation step*/

   fill_pparstock(i);

   if (i>ITERMINI)
    { moypar();
      stopcond=varpparstock(); 
      printf("\n (%f)\n",stopcond);                           /*critere d'arret*/
      if (stopcond<STOPCOND) break; }
                                                                                
   /*visu sur ecran*/ 
    if (law<5)   visu_screen(i);
    if (law==5)  visu_screen_weib(i);                                                            
   }

  //>pparmoy > ppar
  for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) 
  { ppar[i][j]=pparmoy[i][j]; ppar_init[i][j]=pparmoy[i][j]; }
                                                                    /*parametres finaux*/
  if (law<5)   visu_screen(0);
  if (law==5)  visu_screen_weib(0);


  // calcule la distance de kolmogorov et khi2           
  histo_picture(ppicture);
  printf("\n\n distance de kolmogorov -->");
  printf("%f",dist_kolmogorov());
  printf("\n khi2-->");
  printf("%f",khi_2());                                             /*calcul de l'erreur*/
  dist_kolmo=dist_kolmogorov(); 
}

//----------------------------------------------------------
//  ESTIMATION S.E.M                   
//----------------------------------------------------------
void  SEM::SEM_Estimate(float** ppicture,float** ppar_init,int wp,int NBITER)
{
  int i,j;
  float stopcond;

  //>Presentation--
  printf("\n\n [SEM]");

  //>ppar_init --> ppar
  if (wp==1)
    { for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) { ppar[i][j]=ppar_init[i][j]; }  /*par. initiaux*/

      if (law<5)   visu_screen(0); 
      if (law==5)  visu_screen_weib(0);  }                                                  

  if (wp==0) init_random_matrix();         
  else  fill_matp(ppicture);                           /*initialisation*/

 for(i=1;i<NBITER;i++)
  {
   choose_label();                                          /*S.tochastic step*/
   if (law<5) compute_parameter(ppicture);                  /*M.aximisation step*/
     // compute_parameter(ppicture); //
     // visu_screen(i); //
     // exit(-1); //

   if (law==5) weib_estimate(ppicture);
   fill_matp(ppicture);                                     /*E.stimation step*/

   fill_pparstock(i);

   if (i>ITERMINI)
    { moypar();
      stopcond=varpparstock(); 
      printf("\n (%f)\n",stopcond);                           /*critere d'arret*/
      if (stopcond<STOPCOND) break; }
                                                                                
   /*visu sur ecran*/ 
    if (law<5)   visu_screen(i);
    if (law==5)  visu_screen_weib(i);                                                            
   }

  //>pparmoy > ppar
  for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) 
  { ppar[i][j]=pparmoy[i][j]; ppar_init[i][j]=pparmoy[i][j]; }
                                                                    /*parametres finaux*/
  if (law<5)   visu_screen(0);
  if (law==5)  visu_screen_weib(0);


  // calcule la distance de kolmogorov et khi2           
  histo_picture(ppicture);
  printf("\n\n distance de kolmogorov -->");
  printf("%f",dist_kolmogorov());
  printf("\n khi2-->");
  printf("%f",khi_2());                                             /*calcul de l'erreur*/
  dist_kolmo=dist_kolmogorov(); 
}

//----------------------------------------------------------
// en l'absence de parametre initial,on prend pour 
// Pxi/yi(ek/yi) la distribution uniforme          
//----------------------------------------------------------
void SEM::init_random_matrix()
{
 int i,j,k;

 for(i=0;i<length;i++) for(j=0;j<width;j++) for(k=0;k<nbclass;k++)
 pmatp[k][i][j]=(float)(1/(float)nbclass);
}

//----------------------------------------------------------
// pour chaque pixels, on selectionne l'une des    
// classes ek selon les probabilites d'appartenace 
// Pxi/yi(ek,yi)                                   
//----------------------------------------------------------
void SEM::choose_label()
{
 float rd,tmp;
 int i,j,k;
 
  tmp=0.0;
  for(i=0;i<length;i++) for(j=0;j<width;j++) 
     { 
        for(rd=randomize(),k=0;k<nbclass;k++)
           { tmp+=pmatp[k][i][j];
             if (tmp>rd) { pmatl[i][j]=k; tmp=0.0; break; } }
      tmp=0.0;
     }
}

//----------------------------------------------------------
// remplie la matrice 3d contenant la probabilite       
// d'appartenance de chaque pixel a chacune des classes 
//----------------------------------------------------------
void SEM::fill_matp(float** ppicture)
{
  int i,j,k;
  short pix;
  float tmp,sum;

  tmp=0.0;

   for(i=0;i<length;i++)
     for(j=0;j<width;j++)
        {
          pix=ppicture[i][j];
          sum=0.0;
            for(k=0;k<nbclass;k++)
             {
              if (law==1) tmp=funcgauss(pix,ppar[k][0],ppar[k][1],ppar[k][2]);
              if (law==2) tmp=funcraleygh(pix,ppar[k][0],ppar[k][1],ppar[k][2]);

              if (law==4)
               {  if (k==0) tmp=funcgauss(pix,ppar[k][0],ppar[k][1],ppar[k][2]);
                  if (k==1) tmp=funcraleygh(pix,ppar[k][0],ppar[k][1],ppar[k][2]); }

              if (law==5) tmp=funcweibull(pix,1,ppar[k][1],ppar[k][2],ppar[k][3]);

              if (tmp>0.0) { pmatp[k][i][j]=tmp; sum+=tmp; }
              else { pmatp[k][i][j]=0.0; tmp=0.0; }
             }

           if(sum>0.0) for(k=0;k<nbclass;k++)  pmatp[k][i][j]/=sum; 
           else { for(k=0;k<nbclass;k++)  pmatp[k][i][j]/=(float)nbclass;  }
         }
}

//----------------------------------------------------------
// estimation des differents parametres du melange       
// (estimateur du maximum de vraissemblance) pour le     
// cas loi normale et loi de rayleigh                    
//----------------------------------------------------------
void SEM::compute_parameter(float** ppicture)
{
  int i,j,k;
  float m,var,alphad;
  int pix;
  float nb;
  int min;

    for(k=0;k<nbclass;k++)
      {
          m=0.0; var=0.0; alphad=0.0; nb=0; min=255;

           for(i=0;i<(length);i++) for(j=0;j<(width);j++)
           if(pmatl[i][j]==k)
              {
               nb++;  pix=ppicture[i][j];
               if (law==1) m+=pix;
               if (law==2) { if (min>pix) min=pix; }

               if ((law==4)&&(k==0)) { m+=pix; }
               if ((law==4)&&(k==1)) { if (min>pix) min=pix; }
               }  

           m/=nb;  

           for(i=0;i<(length);i++) for(j=0;j<(width);j++)
           if(pmatl[i][j]==k)
              {
	       pix=ppicture[i][j];
               if (law==1) var+=CARRE(pix-m);
               if (law==2) alphad+=CARRE(pix-min);

               if ((law==4)&&(k==0)) { var+=CARRE(pix-m); }
               if ((law==4)&&(k==1)) { alphad+=CARRE(pix-min); }
               } 

      /* variance ou alpha2*/
      if (law==1) var/=nb; 
      if (law==2) alphad/=(2*nb);

      if ((law==4)&&(k==0))  { var/=nb; }
      if ((law==4)&&(k==1))  { alphad/=(2*nb); }

      /* proportion */
      nb/=(width*length);
      ppar[k][0]=nb;


      /* minimum ou moyenne */ 
      if (law==1) ppar[k][1]=m;   
      /*if (law==2) ppar[k][1]=min;*/

      if ((law==4)&&(k==0)) { ppar[k][1]=m; }
      /*if ((law==4)&&(k==1)) { ppar[k][1]=min }*/

      /* enregistrement */
      if (law==1) { if (var!=0)     ppar[k][2]=var;     else ppar[k][2]=0.000001; }
      if (law==2) { if (alphad!=0)  ppar[k][2]=alphad;  else ppar[k][2]=0.000001; }

      if ((law==4)&&(k==0))  { if (var!=0)     ppar[k][2]=var;     else ppar[k][2]=0.000001; }
      if ((law==4)&&(k==1))  { if (alphad!=0)  ppar[k][2]=alphad;  else ppar[k][2]=0.000001; }
 
       }
}   

//------------------------------------------------------------
// estimation des differents parametres du melange       
//------------------------------------------------------------
void SEM::weib_estimate(float** ppicture)
{
  //--declaration variable--
  int i,j,k,n;
  int pix,nb_pix;
  double tmp1,tmp2,tmp3,tmp4,c;
  int flag;

  //--declaration constante--
  int ITER_MAX=20;
  float PRECISION=0.1;
  float CMAX=4.0;
  float CMIN=1.0;
  float CUTILMIN=1.1;
  float CUTILMAX=4.0;
  
 for(n=0;n<nbclass;n++)
 { 

  //--initialisation--
  c=0.0; nb_pix=0; tmp1=0; tmp2=0; tmp3=0; tmp4=0; flag=0; 
  printf("\n\n\n");

 //----- calcul du nb_pixel/min -----
  for(i=1;i<(length-1);i++) for(j=1;j<(width-1);j++)
    { 
     if (pmatl[i][j]==n) 
      nb_pix++;     
    }
    

 //----- proportion des classes ---
  ppar[n][0]=((float)(nb_pix)/((float)((width-2)*(length-2))));

  //----- calcul de c -----
 for (c=1,k=0;;k++)
  {  
   tmp1=0; tmp2=0; tmp3=0; tmp4=0; flag=0;
 
  for(i=1;i<(length-1);i++) for(j=1;j<(width-1);j++)  
   { 
     if (pmatl[i][j]==n) pix=ppicture[i][j];
     else  continue;
     tmp1+=pow(((double)pix-(double)ppar[n][1]),c);
     tmp2+=log(((double)pix-(double)ppar[n][1]));
     tmp3+=(pow(((double)pix-(double)ppar[n][1]),c))*(log(((double)pix-(double)ppar[n][1])));   
   }
  tmp4=(nb_pix*tmp1)/((nb_pix*tmp3)-(tmp1*tmp2));

  printf("[%f]\n",c);
  if (((fabs(c-tmp4)<PRECISION)&&(k>2))||(k>ITER_MAX)) flag=1;

  c=tmp4;

  if (flag==1) { if (c>CMAX) c=CUTILMAX; 
                 if (c<CMIN) c=CUTILMIN;
                 break;}

  }

  //---- calcul de alpha -----
  tmp1=0;
  for(i=1;i<(length-1);i++) for(j=1;j<(width-1);j++)  
   { 
     if (pmatl[i][j]==n) pix=ppicture[i][j];
     else  continue;
     tmp1+=pow(((double)pix-(double)ppar[n][1]),c); }
     tmp1/=nb_pix;
     tmp1=pow(tmp1,(1/c));

  //--- enregistrement ----- 
  ppar[n][2]=c;
  ppar[n][3]=tmp1;
 }
 
  printf("\nWeibull(1)-->");
  printf("prop=%3.2f -- min=%2.0f -- c=%1.2f-- v=%3.2f",ppar[0][0],ppar[0][1],ppar[0][2],ppar[0][3]);
  
  printf("\nWeibull(2)-->");
  printf("prop=%3.2f -- min=%2.0f -- c=%1.2f-- v=%3.2f",ppar[1][0],ppar[1][1],ppar[1][2],ppar[1][3]);
}


//------------------------------------------------
// FONCTIONS DE LA CLASSE <ECI>      -------------
//------------------------------------------------
//----------------------------------------------------------
// constructeur de la classe ECI
//----------------------------------------------------------
ECI::ECI(int Nbclass,int Law,int lgth,int wdth):estimator(Nbclass,Law,lgth,wdth) 
 {
  pparstockf=fmatrix_allocate_3d(NBECH,nbclass,NBPAR);
 }
  
//----------------------------------------------------------
// destructeur de la classe ECI
//----------------------------------------------------------
 ECI::~ECI() 
 { 
  if (pparstockf) free_fmatrix_3d(pparstockf,NBECH); 
 }

//----------------------------------------------------------
//  ESTIMATION ECI                   
//----------------------------------------------------------
void  ECI::ECI_Estimate(float** ppicture,float** ppar_init,float* hyperpar)
{
  int i,j;
  float stopcond;
  float min_begin;

  //>Presentation--
  printf("\n\n [ECI]");

  //>ppar_init > ppar 
  for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) 
  ppar[i][j]=ppar_init[i][j];                                  /*parametres initiaux*/
  min_begin=ppar[1][1];                                                  
                                   
  fill_init_matp(ppicture);  
  init_label_matrix();                                         /*init. chp d'etiq*/       

for(i=1;i<ITER;i++)
{
    
 for(j=0;j<NB_LABEL_FIELD;j++)
 {
  gibbs_sampler(ppicture,hyperpar);
  compute_parameter(pparmoy,ppicture); 
  if (law==4) findmin2(pparmoy,ppicture,1,COEF);

  //visu_screen2(pparmoy,j);
  fill_pparstock(pparstock,pparmoy,j,NB_LABEL_FIELD);           /*simul. N realisat. */
 }                                                              /*avec le par. PHI(k)*/                       
                                                                      
   moypar(pparstock,NB_LABEL_FIELD,ppar);                       /*calcul de PHI(k+1)*/                    
   visu_screen2(ppar,i);
   fill_init_matp(ppicture);  
   init_label_matrix();

   //-- Ajustement de min limité a MAX_DIST=0--
   if ((ppar[1][1]<=(min_begin))&&((law==2)||(law==4))) 
        {
         (ppar[1][1]=min_begin);
          printf("     *");
        }

   fill_pparstock(pparstockf,ppar,i,NBECH);

   if (i>NBECH)
      {
       moypar(pparstockf,NBECH,pparmoy);
       stopcond=varpparstock(pparstockf,pparmoy,NBECH); 
       printf("\n (%f)",stopcond);                                  
       if (stopcond<STOPCOND) break;                             /*critere d'arret*/
      }                                                                                                
}

  // pparmoy > ppar
  for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) 
  { ppar[i][j]=pparmoy[i][j]; ppar_init[i][j]=pparmoy[i][j]; }
  visu_screen(0);                                                   /*parametres finaux*/

  // calcule la distance de kolmogorov et khi2           
  histo_picture(ppicture);
  printf("\n\n distance de kolmogorov=[%.4f]",dist_kolmogorov());
  printf("\n khi2=[%.4f]",khi_2());                                  /*calcul de l'erreur*/ 
}

//----------------------------------------------------------
//  ESTIMATION ECI                   
//----------------------------------------------------------
void  ECI::ECI_Estimate(float** ppicture,float** ppar_init,float* hyperpar,int NBITER)
{
  int i,j;
  float stopcond;
  float min_begin;

  //>Presentation--
  printf("\n\n [ECI]");

  //>ppar_init > ppar 
  for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) 
  ppar[i][j]=ppar_init[i][j];                                  /*parametres initiaux*/
  min_begin=ppar[1][1];                                                  
                                   
  fill_init_matp(ppicture);  
  init_label_matrix();                                         /*init. chp d'etiq*/       

for(i=1;i<NBITER;i++)
{
    
 for(j=0;j<NB_LABEL_FIELD;j++)
 {
  gibbs_sampler(ppicture,hyperpar);
  compute_parameter(pparmoy,ppicture); 
  if (law==4) findmin2(pparmoy,ppicture,1,COEF);

  //visu_screen2(pparmoy,j);
  fill_pparstock(pparstock,pparmoy,j,NB_LABEL_FIELD);           /*simul. N realisat. */
 }                                                              /*avec le par. PHI(k)*/                       
                                                                      
   moypar(pparstock,NB_LABEL_FIELD,ppar);                       /*calcul de PHI(k+1)*/                    
   visu_screen2(ppar,i);
   fill_init_matp(ppicture);  
   init_label_matrix();

   //-- Ajustement de min limité a MAX_DIST=0--
   if ((ppar[1][1]<=(min_begin))&&((law==2)||(law==4))) 
        {
         (ppar[1][1]=min_begin);
          printf("     *");
        }

   fill_pparstock(pparstockf,ppar,i,NBECH);

   if (i>NBECH)
      {
       moypar(pparstockf,NBECH,pparmoy);
       stopcond=varpparstock(pparstockf,pparmoy,NBECH); 
       printf("\n (%f)",stopcond);                                  
       if (stopcond<STOPCOND) break;                             /*critere d'arret*/
      }                                                                                                
}

  // pparmoy > ppar
  for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) 
  { ppar[i][j]=pparmoy[i][j]; ppar_init[i][j]=pparmoy[i][j]; }
  visu_screen(0);                                                   /*parametres finaux*/

  // calcule la distance de kolmogorov et khi2           
  histo_picture(ppicture);
  printf("\n\n distance de kolmogorov=[%.4f]",dist_kolmogorov());
  printf("\n khi2=[%.4f]",khi_2());                                  /*calcul de l'erreur*/ 
}

//-----------------------------------------------------------------
//            ECHANTILLONEUR DE GIBBS                               
//-----------------------------------------------------------------
//----------------------------------------------------------
// pour chaque pixels, on selectionne l'une des    
// classes ek selon les probabilites d'appartenance 
// Pxi/yi(ek,yi)                                   
//----------------------------------------------------------
void ECI::choose_gibbs_label(int length,int width)
{
 float rd,tmp;
 int k;
 
  tmp=0.0;

    for(rd=randomize(),k=0;k<nbclass;k++)
       {
         tmp+=pmatp[k][length][width];
         if (tmp>rd) { pmatl[length][width]=k; tmp=0.0; break; }
        }
      tmp=0.0;
}

//----------------------------------------------------------
// renvoie un flottant correspondant a l'energie   
// d'attache au donnee:fonction des par. des lois, 
// de l'obs., de la loi considere,de la pos. et de 
// l'etiq. du site courant                         
//----------------------------------------------------------
float ECI::data_connexion_nrj(float** ppicture,int row,int col,int classe)
{
 float nrj;
 short pix;

 nrj=0.0;
 pix=ppicture[row][col];

 if (law==1)
 nrj=log(sqrt(2*PI*ppar[classe][2]))+(1/(2*ppar[classe][2]))*CARRE((float)pix-ppar[classe][1]);

 if (law==2)
    { if ((ppar[classe][1])<pix)
      nrj=log(((float)pix-ppar[classe][1])/(ppar[classe][2]))+(CARRE((float)pix-ppar[classe][1])/(2*ppar[classe][2]));
      else nrj=BIGNUMB; }

 if ((law==4)&&(classe==0))
 nrj=log(sqrt(2*PI*ppar[classe][2]))+(1/(2*ppar[classe][2]))*CARRE((float)pix-ppar[classe][1]);

  if  ((law==4)&&(classe==1))
      { if ((ppar[classe][1])<pix)
        nrj=log(((float)pix-ppar[classe][1])/(ppar[classe][2]))+(CARRE((float)pix-ppar[classe][1])/(2*ppar[classe][2]));

        /*else nrj=BIGNUMB;*/
        else nrj=-log(funcraleygh((short)(ppar[1][1]+1),ppar[1][0],ppar[1][1],ppar[1][2])*funcgauss(pix,1,(ppar[1][1]+1),VAR)); }
                         
 return nrj;
}

//----------------------------------------------------------
// renvoie un flottant correspondant a l'energie     
// contextuel: fonction du chps d'etiq. prec.,des    
// parametres de la distribution de gibbs, de la pos 
// et de l'etiq du site courant                      
//----------------------------------------------------------
float ECI::contextual_nrj(float* hyperpar,int row,int col,short classe)
{
 float nrj;

 nrj=0;

 /*cliques horizontales*/
 if (classe!=pmatl[row][col-1]) nrj+=hyperpar[0];
 if (classe!=pmatl[row][col+1]) nrj+=hyperpar[0];

 /*cliques verticales*/
 if (classe!=pmatl[row-1][col]) nrj+=hyperpar[1];
 if (classe!=pmatl[row+1][col]) nrj+=hyperpar[1];

 /*cliques horizontale droite*/
 if (classe!=pmatl[row+1][col+1]) nrj+=hyperpar[2];
 if (classe!=pmatl[row-1][col-1]) nrj+=hyperpar[2];

 /*cliques horizontale gauches*/
 if (classe!=pmatl[row+1][col-1]) nrj+=hyperpar[3];
 if (classe!=pmatl[row-1][col+1]) nrj+=hyperpar[3];

 return nrj;
}

//----------------------------------------------------------
// echantilloneur de gibbs                           
//----------------------------------------------------------
void ECI::gibbs_sampler(float** ppicture,float* hyperpar)
{
 int i,j,k;
 float tmp,sum;

 for(i=1;i<(length-1);i++) for(j=1;j<(width-1);j++)
    {
     sum=0;
     for(k=0;k<nbclass;k++)
       { tmp=exp(-(data_connexion_nrj(ppicture,i,j,k)+contextual_nrj(hyperpar,i,j,k)));
         pmatp[k][i][j]=tmp;  sum+=tmp; }

       for(k=0;k<nbclass;k++)  if (sum) pmatp[k][i][j]/=sum;
       choose_gibbs_label(i,j);
    }
}

//----------------------------------------------------------
// remplie la matrice 3d contenant la probabilite       
// d'appartenance de chaque pixel a chacune des classes 
//----------------------------------------------------------
void ECI::fill_init_matp(float** ppicture)
{
  int i,j,k;
  short pix;
  float tmp,sum;

  tmp=0.0;

   for(i=0;i<length;i++) for(j=0;j<width;j++)
        {
          pix=ppicture[i][j];
          sum=0.0;
            for(k=0;k<nbclass;k++)
             {
              if (law==1) tmp=funcgauss(pix,1,ppar[k][1],ppar[k][2]);
              if (law==2) tmp=funcraleygh(pix,1,ppar[k][1],ppar[k][2]);

              if (law==4)
               {  if (k==0) tmp=funcgauss(pix,1,ppar[k][1],ppar[k][2]);
                  if (k==1) tmp=funcraleygh(pix,1,ppar[k][1],ppar[k][2]); }

              if (tmp>0.0) { pmatp[k][i][j]=tmp; sum+=tmp; }
              else { pmatp[k][i][j]=0.0; tmp=0.0; }
             }

           if(sum>0.0) for(k=0;k<nbclass;k++)  pmatp[k][i][j]/=sum; 
           else { for(k=0;k<nbclass;k++)  pmatp[k][i][j]/=(float)nbclass;  }
         }
}

//----------------------------------------------------------
// estimation des differents parametres du melange       
// (estimateur du maximum de vraissemblance) pour le     
// cas loi normale et loi de rayleigh                    
//----------------------------------------------------------
void ECI::compute_parameter(float** ppar,float** ppicture)
{
  int i,j,k;
  float m,var,alphad;
  int pix;
  float nb;
  int min;

    for(k=0;k<nbclass;k++)
      {
          m=0.0; var=0.0; alphad=0.0; nb=0; min=255;

           for(i=0;i<(length);i++) for(j=0;j<(width);j++)
           if(pmatl[i][j]==k)
              {
               nb++;  pix=ppicture[i][j];
               if (law==1) m+=pix;
               if (law==2) { if (min>pix) min=pix; }

               if ((law==4)&&(k==0)) { m+=pix; }
               if ((law==4)&&(k==1)) { if (min>pix) min=pix; }
               }  

           m/=nb;

           for(i=0;i<(length);i++) for(j=0;j<(width);j++)
           if(pmatl[i][j]==k)
              {
               pix=ppicture[i][j];
               if (law==1) var+=CARRE(pix-m);
               if (law==2) alphad+=CARRE(pix-min);

               if ((law==4)&&(k==0)) { var+=CARRE(pix-m); }
               if ((law==4)&&(k==1)) { alphad+=CARRE(pix-min); }
               } 

      /* variance ou alpha2*/
      if (law==1) var/=nb; 
      if (law==2) alphad/=(2*nb);

      if ((law==4)&&(k==0))  { var/=nb; }
      if ((law==4)&&(k==1))  { alphad/=(2*nb); }

      /* proportion */
      nb/=(width*length);
      ppar[k][0]=nb;

      /* minimum ou moyenne */ 
      if (law==1) ppar[k][1]=m;   
      if (law==2) ppar[k][1]=(min-1);

      if ((law==4)&&(k==0)) { ppar[k][1]=m; }
      if ((law==4)&&(k==1)) { ppar[k][1]=(min-1); }

      /* enregistrement */
      if (law==1) { if (var!=0)     ppar[k][2]=var;     else ppar[k][2]=0.000001; }
      if (law==2) { if (alphad!=0)  ppar[k][2]=alphad;  else ppar[k][2]=0.000001; }

      if ((law==4)&&(k==0))  { if (var!=0)     ppar[k][2]=var;     else ppar[k][2]=0.000001; }
      if ((law==4)&&(k==1))  { if (alphad!=0)  ppar[k][2]=alphad;  else ppar[k][2]=0.000001; } 
       }
}   

//----------------------------------------------------------
// on rempli le champ d'etiquette initiale par sa  
// valeur au sens du maximum de vraissemblance (MV) 
//----------------------------------------------------------
void ECI::init_label_matrix()
{
 int i,j,k;
 float tmp,pmax;

 tmp=0.0;

 for(i=0;i<length;i++) for(j=0;j<width;j++)
   {
    pmax=0.0;
     for(k=0;k<nbclass;k++)
       { tmp=pmatp[k][i][j];
         if (tmp>pmax) { pmatl[i][j]=k; pmax=tmp; }
       }
   }  
}   


//----------------------------------------------------------
// cherche le min. de la classe nbclass               
//----------------------------------------------------------
void ECI::findmin2(float** ppar,float** ppicture,int nbclass,float co)
{
 float moymin,coef;
 float* tab_min;
 int i,j,k,nbech,nb;
 int pix;

     moymin=0.0; nb=0;

     coef=((ppar[nbclass][0])*co*(width)*(length));
     nbech=(int)(coef+1);
     printf("\n..(%d)-->",nbech);
     tab_min=(float*)malloc(nbech*sizeof(float));

    for(k=0;k<GREY_LEVEL;k++)
      {
         for(i=0;i<(length);i++)  for(j=0;j<(width);j++)
           { 
            pix=ppicture[i][j];
            if ((pmatl[i][j]==nbclass)&&(pix==k)&&(nb<nbech))
                                    {  tab_min[nb++]=pix;  printf("(%d)",pix);  }
           }
      }

     for(i=0;i<nbech;i++) { moymin+=tab_min[i]; }
      
     moymin/=nbech;
     printf("  [%f]",moymin);  
     ppar[nbclass][1]=(int)((moymin-1)+0.5);
     free(tab_min); 
}
                      
//----------------------------------------------------------
// visualisation sur ecran des differents parametres  
//----------------------------------------------------------
void ECI::visu_screen2(float** ppar,int i)
{
 int k;

 printf("\n %dieme iteration",i);
 for(k=0;k<nbclass;k++) printf("\n   c=%.2f   m=%.2f  v=%.2f",ppar[k][0],ppar[k][1],ppar[k][2]);
}

//----------------------------------------------------------
// calcule un critere d'arret a partir du tableau    
// des NBECH dernieres estimations et la valeur      
// courante des parametres                           
//----------------------------------------------------------
float ECI::varpparstock(float*** pparstock,float** ppar,int nbech)
{
 int i,j;
 float max,tmp,tmpa,tmpb,minech,maxech;

 max=0.0; 
 
 for(j=0;j<nbclass;j++)
  {
   minech=100000; maxech=0.0;
     { 
      for(i=0;i<nbech;i++)
          { 
            tmp=pparstock[i][j][2];  
            if (tmp>maxech) maxech=tmp;
            if (tmp<minech) minech=tmp;
          }
            tmpa=fabs(1-((ppar[j][2])/maxech));
            tmpb=fabs(1-((ppar[j][2])/minech));

            if (tmpa>tmpb) max=tmpa; else max=tmpb;          
     }
  }
 return (100*max);

}

//----------------------------------------------------------
// donne la moyenne des estimations enregistres dans 
// le tableau pparstock                              
//----------------------------------------------------------
void ECI::moypar(float*** pparstock,int nbech,float** pparmoy)
{
 int i,j,k;
 float moy;
 
 for(j=0;j<nbclass;j++) for(k=0;k<NBPAR;k++)
  {
   moy=0.0;

   for(i=0;i<nbech;i++) moy+=pparstock[i][j][k];

   moy/=(float)nbech;
   pparmoy[j][k]=moy;
  }
}

//----------------------------------------------------------
// rempli le tableau pparstock des estimations       
//----------------------------------------------------------
void ECI::fill_pparstock(float*** pparstock,float** ppar,int iter,int nbech)
{
 int k,j,i;

 for(j=0;j<nbclass;j++) for(k=0;k<NBPAR;k++)
 { i=(iter%nbech); pparstock[i][j][k]=ppar[j][k]; }
}


//------------------------------------------------
// FONCTIONS DE LA CLASSE <ICM>      -------------
//------------------------------------------------
//----------------------------------------------------------
// constructeur de la classe ICM
//----------------------------------------------------------
ICM::ICM(int Nbclass,int Law,int lgth,int wdth):ECI(Nbclass,Law,lgth,wdth) 
 { 
  pmatl_bis=fmatrix_allocate_2d(length,width);
 }
  
//----------------------------------------------------------
// destructeur de la classe ICM
//----------------------------------------------------------
 ICM::~ICM() 
 {  
  //>libere la memoire---
  free_fmatrix_2d(pmatl_bis);
 }

//----------------------------------------------------------
//  ESTIMATION ICM                   
//----------------------------------------------------------
void  ICM::ICM_Estimate(float** ppicture,float** ppar_init,float* hyperpar,float** ppictureSeg)
{
 int i,j;
 int NbChgt;
 float Nrj;

  //>Presentation--
  printf("\n\n [ICM]");

  //>ppar_init > ppar 
  for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) { ppar[i][j]=ppar_init[i][j];  }
  
  fill_init_matp(ppicture);  
  init_label_matrix();  //>Init. Chp. d'Etiq.MV    

  //>ICM Loop
  for(i=1;i<ITER_ICM;i++)
    {
     CopyMatrix(pmatl_bis,pmatl);
     gibbs_sampler(ppicture,hyperpar); 
     NbChgt=diff_pmatl(pmatl_bis,pmatl);
     Nrj=compute_nrj(ppicture,pmatl,hyperpar);
     printf("\n [It%d]> [Nrj:%.1f] [Dif:%d]",i,Nrj,NbChgt);
     if (NbChgt<=CHGT_ICM)  break;                                                    
    }

  //>Result
  CopyMatrix(ppictureSeg,pmatl);
}

//----------------------------------------------------------
//  ML                  
//----------------------------------------------------------
void ICM::ML_Estimate(float** ppicture,float** ppar_init,float** ppictureSeg)
{
 int i,j;

  //>Presentation--
  printf("\n\n [ML]");

  //>ppar_init > ppar 
  for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) { ppar[i][j]=ppar_init[i][j];  }
  
  fill_init_matp(ppicture);  
  init_label_matrix();  //>Init. Chp. d'Etiq.MV    

  //>Result
  CopyMatrix(ppictureSeg,pmatl);
}

//----------------------------------------------------------
//  ESTIMATION ICM  (ppictureSeg->pmatl)                 
//----------------------------------------------------------
void  ICM::ICM_Estimate_(float** ppicture,float** ppar_init,float* hyperpar,float** ppictureSeg)
{
 int i,j;
 int NbChgt;
 float Nrj;

  //>Presentation--
  printf("\n\n [ICM]");

  //>ppar_init > ppar 
  for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) { ppar[i][j]=ppar_init[i][j];  }
  
  fill_init_matp(ppicture);  
  CopyMatrix(pmatl,ppictureSeg);  //>Init. Chp. d'Etiq.MV    

  //>ICM Loop
  for(i=1;i<ITER_ICM;i++)
    {
     CopyMatrix(pmatl_bis,pmatl);
     gibbs_sampler(ppicture,hyperpar); 
     NbChgt=diff_pmatl(pmatl_bis,pmatl);
     Nrj=compute_nrj(ppicture,pmatl,hyperpar);
     printf("\n [It%d]> [Nrj:%.1f] [Dif:%d]",i,Nrj,NbChgt);
     if (NbChgt<=CHGT_ICM)  break;                                                    
    }

  //>Result
  CopyMatrix(ppictureSeg,pmatl);
}

//----------------------------------------------------------
//  ESTIMATION ICM <SEED> <Parcours Aleatoire>                 
//----------------------------------------------------------
void  ICM::ICM_Estimate_Seed(float** ppicture,float** ppar_init,float* hyperpar,float** ppictureSeg,int sd)
{
 int i,j;
 long int k;
 int row,col;
 int NbChgt;
 float Nrj;
 float NbIterEq; 

 //>Presentation--
 printf("\n\n [ICM](seed=%d)",sd);

  //>ppar_init > ppar 
  for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) ppar[i][j]=ppar_init[i][j];

  fill_init_matp(ppicture);  
  init_label_matrix();  //>Init. Chp. d'Etiq. MV  
  CopyMatrix(pmatl_bis,pmatl);

  //>ICM Loop <Parcours Aleat.>
  NbIterEq=0.0;
  srand(sd);
  for(k=1;;k++)
    { row=1+(int)(randomize()*(float)(length-2));
      col=1+(int)(randomize()*(float)(width-2));    
      gibbs_sampler_Pix(ppicture,hyperpar,row,col); 
      //printf("[%d:%d]",row,col);
      //fflush(stdout);
     
     if ((k%(length*width))==0) 
        { NbIterEq=(float)k/(length*width); 
          NbChgt=diff_pmatl(pmatl_bis,pmatl);
          Nrj=compute_nrj(ppicture,pmatl,hyperpar); 
	  printf("\n [ItEq=%.0f]> [Nrj:%.1f] [Dif:%d]",NbIterEq,Nrj,NbChgt);    
          CopyMatrix(pmatl_bis,pmatl);
          if (NbIterEq>ITER_ICM) break;
	  if (NbChgt<=CHGT_ICM)  break;  }                                             
    }

  //>Result
  CopyMatrix(ppictureSeg,pmatl);  
}

//----------------------------------------------------------
// echantilloneur de gibbs                           
//----------------------------------------------------------
void ICM::gibbs_sampler_Pix(float** ppicture,float* hyperpar,int row,int col)
{
 int k;
 float tmp,sum;

 sum=0;
 for(k=0;k<nbclass;k++)
    { tmp=exp(-(data_connexion_nrj(ppicture,row,col,k)+contextual_nrj(hyperpar,row,col,k)));
      pmatp[k][row][col]=tmp;  sum+=tmp; }

 for(k=0;k<nbclass;k++)  if (sum) pmatp[k][row][col]/=sum;
 choose_gibbs_label(row,col);
}

//----------------------------------------------------------
// pour chaque pixels, on selectionne la classe ek
// dont la probabilites d'appartenance est maximum
// Pxi/yi(ek,yi)                                   
//----------------------------------------------------------
void ICM::choose_gibbs_label(int row,int col)
{
 float tmp;
 int k;
 
  tmp=0.0;
  for(k=0;k<nbclass;k++)
  if (pmatp[k][row][col]>tmp) { tmp=pmatp[k][row][col]; pmatl[row][col]=k; }
}

//----------------------------------------------------------
// calcule L'NRJ d'une réalisation pmatl
//----------------------------------------------------------
float ICM::compute_nrj(float** ppicture,float** pmatl,float* hyperpar)
{
 int i,j,label;
 float tmp,sum;

  sum=0;
  for(i=1;i<(length-1);i++) for(j=1;j<(width-1);j++)
    { label=pmatl[i][j];
      tmp=data_connexion_nrj(ppicture,i,j,label)+contextual_nrj(hyperpar,i,j,label);
      sum+=tmp; }

  return sum;
}

//----------------------------------------------------------
// calcule le nombre de differences a chaque iteration
//----------------------------------------------------------
int ICM::diff_pmatl(float** pmatl1,float** pmatl2)
{
 int i,j;
 int chgt=0;

 for(i=0;i<length;i++) for(j=0;j<width;j++)
 if ((pmatl1[i][j])!=(pmatl2[i][j])) chgt++;
   
 return chgt;
}

//----------------------------------------------------------
// copie une matrice dans une autre
//----------------------------------------------------------
void ICM::CopyMatrix(float** pmatl1,float** pmatl2)
{
 int i,j;
 for(i=0;i<length;i++) for(j=0;j<width;j++) pmatl1[i][j]=pmatl2[i][j]; 
}

//-------------
// [PCL]
//-------------
//----------------------------------------------------------
// PCL::Uniform_Law
//----------------------------------------------------------
double ICM::Uniform_PCL(float range)
{
  return (1.0/range);
}

//----------------------------------------------------------
// PCL::contextual_nrj                     
//----------------------------------------------------------
double ICM::contextual_nrj_PCL(float* hyperpar,int row,int col,int classe)
{
 double nrj;

 nrj=0.0;
 //cliques horizontales
 if (classe!=pmatl[row][col-1]) nrj+=hyperpar[0];
 if (classe!=pmatl[row][col+1]) nrj+=hyperpar[0];

 //cliques verticales
 if (classe!=pmatl[row-1][col]) nrj+=hyperpar[1];
 if (classe!=pmatl[row+1][col]) nrj+=hyperpar[1];

 //cliques horizontale droite
 if (classe!=pmatl[row+1][col+1]) nrj+=hyperpar[2];
 if (classe!=pmatl[row-1][col-1]) nrj+=hyperpar[2];

 //cliques horizontale gauches
 if (classe!=pmatl[row+1][col-1]) nrj+=hyperpar[3];
 if (classe!=pmatl[row-1][col+1]) nrj+=hyperpar[3];

 return nrj;
}

//----------------------------------------------------------
//  PCL::gibbs_sampler                         
//----------------------------------------------------------
void ICM::gibbs_sampler_PCL(float** ppicture,float* hyperpar,int*** MatGausPar,float Range)
{
 int i,j,k;
 double tmp,sum;
 short pix;
 const int NBCLASS=2;

 for(i=1;i<(length-1);i++) for(j=1;j<(width-1);j++)
    {
     pix=ppicture[i][j];
     sum=0.0;
     for(k=0;k<NBCLASS;k++)
       { if (k==0) tmp=funcgauss(pix,1,MatGausPar[0][i][j],MatGausPar[1][i][j])*exp(-contextual_nrj_PCL(hyperpar,i,j,k));
	 if (k==1) tmp=(Uniform_PCL(Range))*exp(-contextual_nrj_PCL(hyperpar,i,j,k));
	 pmatp[k][i][j]=tmp;  sum+=tmp; }

       for(k=0;k<NBCLASS;k++)  if (sum) pmatp[k][i][j]/=sum;   
    }
}

//----------------------------------------------------------
// PCL::fill_init_matp
//----------------------------------------------------------
void ICM::fill_init_matp_PCL(float** ppicture,int row,int col,int*** MatGausPar,float Range)
{
  int k;
  short pix;
  float sum;
  const int NBCLASS=2;

  pix=ppicture[row][col];

  //>[Label<0>::NonChgt-Class][Label<1>::Chgt-Class]
  pmatp[0][row][col]=funcgauss(pix,1,MatGausPar[0][row][col],MatGausPar[1][row][col]);
  pmatp[1][row][col]=Uniform_PCL(Range);
  sum=pmatp[0][row][col]+pmatp[1][row][col];
  
  if (sum) for(k=0;k<NBCLASS;k++) pmatp[k][row][col]/=sum;
  else for(k=0;k<NBCLASS;k++) pmatp[k][row][col]=1.0/((float)NBCLASS);
}

//----------------------------------------------------------
// PCL::NRJ d'une réalisation pmatl
//----------------------------------------------------------
double ICM::compute_nrj_PCL(float** ppicture,float** pmatl,float* hyperpar,int*** MatGausPar,float Range)
{
 int i,j,label;
 double tmp,sum;

  sum=0;
  for(i=1;i<(length-1);i++) for(j=1;j<(width-1);j++)
    { label=pmatl[i][j];
      tmp=0;
      if (label==0) tmp=-log(funcgauss(ppicture[i][j],1,MatGausPar[0][i][j],MatGausPar[1][i][j]))+contextual_nrj_PCL(hyperpar,i,j,label);
      if (label==1) tmp=-log(Uniform_PCL(Range))+contextual_nrj_PCL(hyperpar,i,j,label);
      if (!isnan(tmp)) sum+=tmp; }

  return sum;
}

//----------------------------------------------------------
// PCL::ESTIMATION ICM                   
//----------------------------------------------------------
void ICM::ICM_Estimate_PCL(float** ppicture,float* hyperpar,float** ppictureSeg,int*** MatGausPar)
{
 int i,j,k;
 int NbChgt;
 float Nrj,Range;

  //>Presentation--
  printf("\n [ICM-PCL]");
  fflush(stdout);

  //>Init.
  Range=GiveRangeGreyLevelValues(ppicture,length,width,1.0);
  printf("[Range=%.0f]",Range);
  fflush(stdout);
  for(i=0;i<length;i++) for(j=0;j<width;j++) fill_init_matp_PCL(ppicture,i,j,MatGausPar,Range);
  for(i=0;i<length;i++) for(j=0;j<width;j++) pmatl[i][j]=0;
  for(i=0;i<length;i++) for(j=0;j<width;j++) if (pmatp[1][i][j]>pmatp[0][i][j])  pmatl[i][j]=1;
  
  //>ICM Loop
  for(k=1;k<ITER_ICM;k++)
    {
     CopyMatrix(pmatl_bis,pmatl);
     gibbs_sampler_PCL(ppicture,hyperpar,MatGausPar,Range);

     for(i=0;i<length;i++) for(j=0;j<width;j++)
	{ if (pmatp[1][i][j]>pmatp[0][i][j])  pmatl[i][j]=1;
	  else pmatl[i][j]=0; }
     
     NbChgt=diff_pmatl(pmatl_bis,pmatl);
     Nrj=compute_nrj_PCL(ppicture,pmatl,hyperpar,MatGausPar,Range);
     printf("\n [It%d]> [Nrj:%.1f] [Dif:%d]",k,Nrj,NbChgt);
     if (NbChgt<=CHGT_ICM)  break;                                                    
    }

  //>Result
  CopyMatrix(ppictureSeg,pmatl);
}

//----------------------------------------------------------
// PCL::ESTIMATION MPM                  
//----------------------------------------------------------
void ICM::MPM_Estimate_PCL(float** ppicture,float* hyperpar,float** ppictureSeg,int*** MatGausPar)
{
 int i,j,k;
 int NbChgt;
 float tmp,Nrj,pmax,Range;
 const int NBCLASS=2;

  //>Presentation--
  printf("\n [MPM-PCL]");
  fflush(stdout);

  //>Init.
  const int ITER_MPM=100;
  float*** VctMatl=fmatrix_allocate_3d(NBCLASS,length,width);
  for(k=0;k<NBCLASS;k++) for(i=0;i<length;i++) for(j=0;j<width;j++) VctMatl[k][i][j]=0.0;

  Range=GiveRangeGreyLevelValues(ppicture,length,width,1.0);
  printf("[Range=%.0f]",Range);
  fflush(stdout);
  for(i=0;i<length;i++) for(j=0;j<width;j++) fill_init_matp_PCL(ppicture,i,j,MatGausPar,Range);
  for(i=0;i<length;i++) for(j=0;j<width;j++) pmatl[i][j]=0;
  for(i=0;i<length;i++) for(j=0;j<width;j++) if (pmatp[1][i][j]>pmatp[0][i][j])  pmatl[i][j]=1;
  
  //>MPM_Loop_
  for(k=0;k<ITER_MPM;k++)
    {
     CopyMatrix(pmatl_bis,pmatl);
     gibbs_sampler_PCL(ppicture,hyperpar,MatGausPar,Range);

     //-TWO-CLASS-Label-Choice
     for(i=0;i<length;i++) for(j=0;j<width;j++)
        { if (pmatp[1][i][j]>pmatp[0][i][j])  pmatl[i][j]=1; else pmatl[i][j]=0; }
     NbChgt=diff_pmatl(pmatl_bis,pmatl);
     
     for(i=0;i<length;i++) for(j=0;j<width;j++) VctMatl[(int)pmatl[i][j]][i][j]++;;
     
     Nrj=compute_nrj_PCL(ppicture,pmatl,hyperpar,MatGausPar,Range);
     printf("\n [It%d]> [Nrj:%.1f] [Dif:%d]",k,Nrj,NbChgt);                                                  
    }

 //>MPM_Estimator_ 
 for(i=0;i<length;i++) for(j=0;j<width;j++)
    { pmax=0.0;
      for(k=0;k<NBCLASS;k++)
         { tmp=VctMatl[k][i][j];
           if (tmp>pmax) { pmatl[i][j]=k; pmax=tmp; } } }

  //>Result
  CopyMatrix(ppictureSeg,pmatl);

  //>FreeMemory
  free_fmatrix_3d(VctMatl,nbclass);
}

//------------------------------------------------
// FONCTIONS DE LA CLASSE <MPM>      -------------
//------------------------------------------------
//----------------------------------------------------------
// constructeur de la classe MPM
//----------------------------------------------------------
MPM::MPM(int Nbclass,int Law,int Length,int Width):ECI(Nbclass,Law,Length,Width)
 { 
   int i,j,k; 
   IterMini=ITERMINI_MPM; 
   IterMax=ITERMAX_MPM;  

   pmatl_MPM=fmatrix_allocate_2d(length,width);
   pmat_acc=fmatrix_allocate_3d(nbclass,length,width);

   for(i=0;i<length;i++) for(j=0;j<width;j++)  for(k=0;k<nbclass;k++)
   pmat_acc[k][i][j]=0.0;
 }

//----------------------------------------------------------
// destructeur  de la classe MPM
//----------------------------------------------------------
 MPM::~MPM()
 { free_fmatrix_2d(pmatl_MPM);
   free_fmatrix_3d(pmat_acc,nbclass);
 }

//----------------------------------------------------------
// segmentation au sens du MPM
//----------------------------------------------------------
void MPM::MPM_Estimate(float** ppicture,float** ppar_init,float* hyperpar,float** pmatl)
{
 int i,j;
 int NbChgt;
 float Nrj;

 //>Presentation--
  printf("\n\n [MPM]");

 //>ppar_init > ppar 
 for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++) ppar[i][j]=ppar_init[i][j];
 fill_init_matp(ppicture); 
 init_label_matrix();                            //Init. chp. d'etiq. MV
 CopyMatrix(pmatl_MPM,pmatl);                       
 
 //>MPM Loop
 for(i=0;i<IterMax;i++)
 {  
  gibbs_sampler(ppicture,hyperpar);             //Simul. N realisat.

  if (i>IterMini)
     { inc_mat_acc();
       init_label_mpm_matrix(pmatl_MPM);        //MPM > pmatl_MPM

       Nrj=compute_nrj(ppicture,pmatl_MPM,hyperpar);
       NbChgt=diff_pmatl(pmatl,pmatl_MPM);

       printf("\n [It%d]> [Nrj:%.1f] [Dif:%d]",i,Nrj,NbChgt);
       if (NbChgt<=CHGT_MPM) break;  } 
  }

 //>Result
 CopyMatrix(pmatl,pmatl_MPM);
 Nrj=compute_nrj(ppicture,pmatl_MPM,hyperpar);
 printf("\n [It%d]> [Nrj:%.1f]",0,Nrj);
}

//----------------------------------------------------------
// on rempli le champ d'etiquette final par sa
// valeur au sens du MPM
//----------------------------------------------------------
void MPM::init_label_mpm_matrix(float** mypmatl)
{
 int i,j,k;
 float tmp,pmax;

 tmp=0.0;
 for(i=0;i<length;i++) for(j=0;j<width;j++)
   {
    pmax=0.0;
     for(k=0;k<nbclass;k++)
        { tmp=pmat_acc[k][i][j];
          if (tmp>pmax) { mypmatl[i][j]=k; pmax=tmp; } }
   }
}

//----------------------------------------------------------
// incremente la matrice d'accumulation                  
//----------------------------------------------------------
void MPM::inc_mat_acc()
{
 int i,j;
 int pix;

 for(i=0;i<length;i++) for(j=0;j<width;j++)
     { pix=pmatl[i][j]; 
       pmat_acc[pix][i][j]++; }
}

//----------------------------------------------------------
// calcule L'NRJ d'une réalisation pmatl
//----------------------------------------------------------
float MPM::compute_nrj(float** ppicture,float** pmatl,float* hyperpar)
{
 int i,j,label;
 float tmp,sum;

  sum=0;
  for(i=1;i<(length-1);i++) for(j=1;j<(width-1);j++)
    { label=pmatl[i][j];
      tmp=data_connexion_nrj(ppicture,i,j,label)+contextual_nrj(hyperpar,i,j,label);
      sum+=tmp; }
  return sum;
}

//----------------------------------------------------------
// calcule le nombre de differences a chaque iteration
//----------------------------------------------------------
int MPM::diff_pmatl(float** pmatl1,float** pmatl2)
{
 int i,j;
 int chgt=0;

 for(i=0;i<length;i++) for(j=0;j<width;j++)
 if ((pmatl1[i][j])!=(pmatl2[i][j])) chgt++;
   
 return chgt;
}

//----------------------------------------------------------
// copie une matrice dans une autre
//----------------------------------------------------------
void MPM::CopyMatrix(float** pmatl1,float** pmatl2)
{
 int i,j;
 for(i=0;i<length;i++) for(j=0;j<width;j++) pmatl1[i][j]=pmatl2[i][j]; 
}

//------------------------------------------------
// FONCTIONS DE LA CLASSE <SMAP>      ------------
//------------------------------------------------
//----------------------------------------------------------
// Constructeur de la classe smap
//----------------------------------------------------------
SMAP::SMAP(int Nbclass,int Law,int Length,int Width,int Depth):ECI(Nbclass,Law,Length,Width) 
{
  int i,j,k,l;
  
  length_max=Length; 
  width_max=Width;
  nbclass=Nbclass;   
  law=Law;         
  depth=Depth;       

  //MemoryAllocation_&_Init
  py_pmatl=allocate_pyramide_pmatl(Depth+1,Length+10,Width+10);      
  py_pmatp=allocate_pyramide_pmatp(Depth+1,Nbclass,Length+10,Width+10);
  //py_pmatl=allocate_pyramide_pmatl(Depth+1,Length,Width);      
  //py_pmatp=allocate_pyramide_pmatp(Depth+1,Nbclass,Length,Width);

  for(k=0;k<(Depth+1);k++)
  for(i=0;i<(int)(length/pow(2,k));i++) for(j=0;j<(int)(width/pow(2,k));j++) py_pmatl[k][i][j]=0;

  for(k=0;k<(Depth+1);k++) for(l=0;l<Nbclass;l++)
  for(i=0;i<(int)(length/pow(2,k));i++) for(j=0;j<(int)(width/pow(2,k));j++) py_pmatp[k][l][i][j]=0;
}

//----------------------------------------------------------
// Constructeur de la classe smap for MCD
//----------------------------------------------------------
SMAP::SMAP(int Length,int Width,int Depth):ECI(2,1,Length,Width) 
{
  int i,j,k,l;
  int EDGE;

  nbclass=2;   //For-ChangeDetection
  law=1;       //For-ChangeDetection
  length_max=Length; 
  width_max=Width;        
  depth=Depth;
  EDGE=0;     //>50

  //MemoryAllocation_&_Init
  py_pmatl=allocate_pyramide_pmatl(Depth+1,Length+EDGE,Width+EDGE);      
  py_pmatp=allocate_pyramide_pmatp(Depth+1,nbclass,Length+EDGE,Width+EDGE);

  for(k=0;k<(Depth+1);k++)
  for(i=0;i<(int)(length/pow(2,k));i++) for(j=0;j<(int)(width/pow(2,k));j++) py_pmatl[k][i][j]=0;

  for(k=0;k<(Depth+1);k++) for(l=0;l<nbclass;l++)
  for(i=0;i<(int)(length/pow(2,k));i++) for(j=0;j<(int)(width/pow(2,k));j++) py_pmatp[k][l][i][j]=0;
}

//----------------------------------------------------------
// Destructeur de la classe smap
//----------------------------------------------------------
SMAP::~SMAP()
 { 
  free_pyramide_pmatl(py_pmatl,depth);
  free_pyramide_pmatp(py_pmatp,(depth+1),nbclass);
 }

//----------------------------------------------------------
// segmentation au sens du smap
//----------------------------------------------------------
void SMAP::SMAP_Estimate(float** ppicture,float** ppar_init,float Theta,int Versus,float** pmatl)
{
 int i,j; 
 theta=Theta;
 versus=Versus;

 //>Presentation--
 printf("\n\n [SMAP](Theta%0.3f::dpth%d::vers%d)",theta,depth,versus);
 
 //>Init. 
 for(i=0;i<nbclass;i++) for(j=0;j<NBPAR;j++)  ppar[i][j]=ppar_init[i][j];                  

 fill_init_matp(ppicture,py_pmatp[0],ppar);
 printf("\n [fine_to_coarse]>");
 for(i=0;i<depth;i++) fine_to_coarse(i);
 init_top_py_pmatl(i,py_pmatl);
 //if (DEBUG) init_top_py_pmatl(i,py_pmatl_init);
 
 if (versus==1) for(i=(depth-1);i>=0;i--) coarse_to_fine(i);
 if (versus==2) for(i=(depth-1);i>=0;i--) coarse_to_fine_v2(i);
 printf("[coarse_to_fine]");
 fflush(stdout);

 //encadre_py_pmatl(py_pmatl,depth,length_max);
 //convert_pypmatl_pyrmat(py_pmatl,pyrmat,depth,length_max);

 //if (DEBUG)
 //{ encadre_py_pmatl(py_pmatl_init,depth,length_max);
 //  convert_pypmatl_pyrmat(py_pmatl_init,pyrmat_init,depth,length_max); }

 //Result
 //copy_square_mat(py_pmatl[0],pmatl,width_max);
 copy_mat(py_pmatl[0],pmatl,length_max,width_max);
}

//-------------
//----------------------------------------------------------
// progression fine to coarse
//----------------------------------------------------------
void SMAP::fine_to_coarse(int level)
{ 
 int i,j,k,l,m,n;
 float tmp,sum;
 int size_block=2;
 int length_mat=length_max/(int)pow(2,level);
 int width_mat=width_max/(int)pow(2,level);
 
 //MainLoop
 for(i=0;i<length_mat;i+=size_block)  for(j=0;j<width_mat;j+=size_block)
 for(k=0;k<nbclass;k++)
  { sum=0.0;
    for(l=0;l<2;l++)  for(m=0;m<2;m++)
     {
      tmp=0.0;
      //if (((i+l)<length_mat)&&((j+m)<width_mat))
	 {
          for(n=0;n<nbclass;n++) { tmp+=exp(py_pmatp[level][n][i+l][j+m]); }
          sum+=log(theta*exp(py_pmatp[level][k][i+l][j+m])+((1-theta)/nbclass)*tmp);
	 }
      py_pmatp[level+1][k][i/2][j/2]=sum;
     }
   }
}

//----------------------------------------------------------
// progression coarse to fine
//----------------------------------------------------------
void SMAP::coarse_to_fine(int level)
{
 float tmp,tmp2,sum;
 int i,j,k;
 int width_mat=(width_max/(int)pow(2,level));
 int length_mat=(length_max/(int)pow(2,level));

 //MainLoop
 for(i=0;i<length_mat;i++) for(j=0;j<width_mat;j++)
 {
  tmp=-BIGNUMB;
  for(k=0;k<nbclass;k++)
   {
    if (k==py_pmatl[level+1][i/2][j/2]) tmp2=log(theta+((1-theta)/nbclass));
    else tmp2=log(((1-theta)/nbclass));
    
    sum=py_pmatp[level][k][i][j]+tmp2;
    if (sum>tmp) { tmp=sum; py_pmatl[level][i][j]=k; }
   }
  }
}

//----------------------------------------------------------
// progression coarse to fine avec graphe pyramidale
//----------------------------------------------------------
void SMAP::coarse_to_fine_v2(int level)
{
 int i,j,k;
 float tmp,tmp2,tmp3,sum;
 int width_mat=(width_max/(int)pow(2,level));
 int length_mat=(length_max/(int)pow(2,level));
 int litle_size_mat_width=(width_max/(int)pow(2,(level+1)));
 int litle_size_mat_length=(length_max/(int)pow(2,(level+1)));

 for(i=0;i<length_mat;i++) for(j=0;j<width_mat;j++)
 {
  tmp=-BIGNUMB;

  for(k=0;k<nbclass;k++)
   {
    tmp3=0.0;
  
    if (k==py_pmatl[level+1][(int)(i/2)][(int)(j/2)])           tmp3+=3;

    if ((((int)(i/2)+odd(i))<litle_size_mat_length)&&(((int)(i/2)+odd(i))>0)) 
    if (k==py_pmatl[level+1][(int)(i/2)+odd(i)][(int)(j/2)])    tmp3+=2;

    if ((((int)(j/2)+odd(j))<litle_size_mat_width)&&(((int)(j/2)+odd(j))>0))
    if (k==py_pmatl[level+1][(int)(i/2)][(int)(j/2)+odd(j)])    tmp3+=2;

    tmp2=log(((theta*tmp3)/7)+((1-theta)/nbclass));
    
    sum=py_pmatp[level][k][i][j]+tmp2;
    if (sum>tmp) { tmp=sum; py_pmatl[level][i][j]=k; }
   }
  }
}

//----------------------------------------------------------
// initialise le sommet de la pyramide
//----------------------------------------------------------
void SMAP::init_top_py_pmatl(int level,int*** py_pmatl)
{
 int i,j,k;
 float tmp,sum;
 int wdth_mat=(width_max/(int)pow(2,level));
 int lgth_mat=(length_max/(int)pow(2,level));

 for(i=0;i<lgth_mat;i++)  for(j=0;j<wdth_mat;j++) py_pmatl[level][i][j]=0;
 
 for(i=0;i<lgth_mat;i++)  for(j=0;j<wdth_mat;j++)
  {
   tmp=-BIGNUMB;
    for(k=0;k<nbclass;k++)
     { sum=py_pmatp[level][k][i][j];
       if (sum>tmp) { tmp=sum; py_pmatl[level][i][j]=k; }
     }
   }
}

//----------------------------------------------------------
// paire ou non?
//----------------------------------------------------------
int SMAP::odd(int number)
{
 int LSB=(number & 0x1);
 if (LSB) return 1; else return -1;
}

//----------------------------------------------------------
// retourne la probabilite d'un pixel yi d'appartenir
// a la classe correspondante aux parametres
//     coef, min alphad
//----------------------------------------------------------
float SMAP::funcraleygh(short pix,float coef,float min,float alphad)
{
return
(float)((coef)*(((float)pix-min)/alphad)*exp(-1*(CARRE((float)pix-min))/(2*alphad)));
}

//----------------------------------------------------------
// retourne la probabilite d'un pixel yi d'appartenir
// a la classe correspondante aux parametres
//      coef, moy var
//----------------------------------------------------------
float SMAP::funcgauss(short pix,float coef,float moy,float var)
{
return (float)((coef)*(1/(sqrt(2*PI*var)))*exp(-1*(CARRE((float)pix-moy))/(2*var)));
}

//----------------------------------------------------------
// retourne la probabilite d'un pixel yi d'appartenir 
// a la classe WEIBULL                                
//     min C et alpha                                
//----------------------------------------------------------
float SMAP::funcweibull(short pix,float coef,float min,float c,float alpha)
{
return(float)(coef)*(c/alpha)*
(pow((((float)pix-min)/alpha),c-1))*exp(-1*pow((((float)pix-min)/alpha),c));
}

//----------------------------------------------------------
// remplie la matrice 3d contenant la probabilite
// d'appartenance de chaque pixel a chacune des classes
// (maximum de vraissemblance)
//----------------------------------------------------------
void SMAP::fill_init_matp(float** ppicture,float*** pmatp,float** ppar)
{
 int i,j,k;
 short pix;
 float tmp=0.0;
 float sum;

   //MainLoop
   for(i=0;i<length_max;i++) for(j=0;j<width_max;j++)
      {
          pix=ppicture[i][j];
          sum=0.0;
            for(k=0;k<nbclass;k++)
             {
              if (law==1) tmp=funcgauss(pix,1,ppar[k][1],ppar[k][2]);
              if (law==2) tmp=funcraleygh(pix,1,ppar[k][1],ppar[k][2]);
              if (law==3)
                {  if (k==0) tmp=funcgauss(pix,1,ppar[k][1],ppar[k][2]);
                   if (k==1) tmp=funcraleygh(pix,1,ppar[k][1],ppar[k][2]); }

              if (tmp>0.0) { pmatp[k][i][j]=tmp; sum+=tmp; }
              else { pmatp[k][i][j]=0.0; }
             }

           if(sum>0.0) for(k=0;k<nbclass;k++)  pmatp[k][i][j]/=sum;
       }  

   for(i=0;i<length_max;i++) for(j=0;j<width_max;j++) for(k=0;k<nbclass;k++) 
   pmatp[k][i][j]=log(pmatp[k][i][j]);     
}

//----------------------------------------------------------
// fillpict_LabelMat
//----------------------------------------------------------
void SMAP::fillpict_LabelMatx(float** pmatl)
{
 copy_square_mat(py_pmatl[0],pmatl,width_max);
}

//---GESTION ---------  
//----------------------------------------------------------
// alloue de la memoire pour une pyramide d'int
//----------------------------------------------------------
int*** SMAP::allocate_pyramide_pmatl(int depth,int vsize,int hsize)
{
 int k;
 int vcursz,hcursz;
 int*** matrix;
 matrix=new int**[depth];

 for(k=0;k<depth;k++)
    { vcursz=vsize/pow(2,k);
      hcursz=hsize/pow(2,k);
      matrix[k]=imatrix_allocate_2d(vcursz+1,hcursz+1); }
 return matrix;
}

//----------------------------------------------------------
// libere la memoire de la pyramide d'int
//----------------------------------------------------------
void SMAP::free_pyramide_pmatl(int*** py_pmatl,int depth)
{
 for(int i=0;i<depth;i++)
   { delete[] (py_pmatl[i][0]);
     delete[] (py_pmatl[i]); }
 delete[] (py_pmatl);
}

//----------------------------------------------------------
// alloue de la memoire pour une pyramide  4d de float
//----------------------------------------------------------
float**** SMAP::allocate_pyramide_pmatp(int level,int depth,int vsize,int hsize)
{
 int k;
 int vcursz,hcursz;
 float**** matrix;
 matrix=new float***[level];

 for(k=0;k<level;k++)
  { vcursz=vsize/pow(2,k);
    hcursz=hsize/pow(2,k);
    matrix[k]=fmatrix_allocate_3d(depth,vcursz+1,hcursz+1); }
 return matrix;
}

//----------------------------------------------------------
// libere la memoire d'une pyramide  4d de float
//----------------------------------------------------------
void SMAP::free_pyramide_pmatp(float**** pyr_pmatp,int level,int depth)
{
 for(int i=0;i<level;i++)
  free_fmatrix_3d(pyr_pmatp[i],depth);
}

//----------------------------------------------------------
// encadre chaque int** de la pyramide
//----------------------------------------------------------
void SMAP::encadre_py_pmatl(int*** py_pmatl,int depth,int lgth_max,int wdth_max)
 {
  for(int k=0;k<=depth;k++)
    {
      for(int i=0;i<wdth_max;i++)
       { py_pmatl[k][0][i]=0;
         py_pmatl[k][lgth_max-1][i]=0; }

      for(int i=0;i<lgth_max;i++)
       { py_pmatl[k][i][0]=0;
         py_pmatl[k][i][wdth_max-1]=0; }
      lgth_max/=2;
      wdth_max/=2;
     }
 }

//----------------------------------------------------------
// encadre chaque int** de la pyramide
//----------------------------------------------------------
void SMAP::encadre_py_pmatl(int*** py_pmatl,int depth,int size_max)
 {
  for(int k=0;k<=depth;k++)
    {
      for(int i=0;i<size_max;i++)
       { py_pmatl[k][0][i]=0;
         py_pmatl[k][size_max-1][i]=0;
         py_pmatl[k][i][0]=0;
         py_pmatl[k][i][size_max-1]=0; }
      size_max/=2;
     }
 }

//----------------------------------------------------------
// converti la pyramide en int**
//----------------------------------------------------------
void SMAP::convert_pypmatl_pyrmat(int*** py_pmatl,int** pyrmat,int depth,int size_max)
 {
  int size_pyrmat;
  int tmp=0;
  int size_min=(int)((size_max/pow(2,depth)));

  size_pyrmat=size_bigpicture(depth,size_max);

  for(int i=0;i<size_pyrmat;i++) for(int j=0;j<size_max;j++)
   { pyrmat[i][j]=1;}

  for(int k=depth;k>=0;k--)
    {
      for(int i=0;i<size_min;i++) for(int j=0;j<size_min;j++)
         pyrmat[i+tmp][j]=py_pmatl[k][i][j];

      tmp+=size_min;
      size_min*=2;
     }
 }

//----------------------------------------------------------
// donne la taille de la grande image
//----------------------------------------------------------
int SMAP::size_bigpicture(int depth,int size_image_init)
 {
  int size=0;

  for(int i=0;i<=depth;i++)
    { size+=size_image_init;
      size_image_init/=2; }
  return size;
 }

//----------------------------------------------------------
// copie une matrice carre dans une  autre
//----------------------------------------------------------
void SMAP::copy_square_mat(float** pmatl1,float** pmatl2,int size)
{
 for(int i=0;i<size;i++) for(int j=0;j<size;j++) pmatl2[i][j]=pmatl1[i][j]; 
}

//----------------------------------------------------------
// copie une matrice carre dans une  autre
//----------------------------------------------------------
void SMAP::copy_square_mat(int** pmatl1,float** pmatl2,int size)
{
 for(int i=0;i<size;i++) for(int j=0;j<size;j++) pmatl2[i][j]=pmatl1[i][j]; 
}

//----------------------------------------------------------
// copie une matrice carre dans une  autre
//----------------------------------------------------------
void SMAP::copy_mat(int** pmatl1,float** pmatl2,int lgth,int wdth)
{
 for(int i=0;i<lgth;i++) for(int j=0;j<wdth;j++) pmatl2[i][j]=pmatl1[i][j]; 
}

//----------------------------------------------------------
// multiresolution
//----------------------------------------------------------
void SMAP::multires(float** ppicture,int depth,int size_max,int*** py_pmatl_pict)
{ 
 int i,j,k;
 int row,col;
 float sum_pix;
 short pix;
 int row_picture,col_picture,size_block;

 j=0;
  for(k=0;k<=depth;k++)
   {  
   for(row=0;row<size_max;row++) for(col=0;col<size_max;col++)
      {
        row_picture=(int)(row*pow(2,k));
        col_picture=(int)(col*pow(2,k));
        size_block=(int)(pow(2,k));

        sum_pix=0;

          for(i=row_picture;i<(row_picture+size_block);i++)
            for(j=col_picture;j<(col_picture+size_block);j++)
             { pix=ppicture[i][j];
               sum_pix+=(float)(pix); }
      
               sum_pix/=(CARRE((float)(size_block)));
               pix=(int)(sum_pix);
               py_pmatl_pict[k][row][col]=pix;

       }
    size_max/=2;
    }   
} 

/*----------------------------------------------------------*/
/* Recal                                                    */
/*----------------------------------------------------------*/
void SMAP::Recal(float** mat,int lgth,int wdth)
{
 int i,j;
 float max,min;

 /*Initialisation*/
 max=-1000000.0;
 min=100000000;

 /*Recherche du min*/
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    if (mat[i][j]<min) min=mat[i][j];

 /*plus min*/
   for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    mat[i][j]-=min;

 /*Recherche du max*/
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) 
    if (mat[i][j]>max) max=mat[i][j];

 /*Recalibre la matrice*/
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
   if (max) mat[i][j]*=(GREY_LEVEL/max);      
}

/*----------------------------------------------------------*/
/* Recal                                                    */
/*----------------------------------------------------------*/
void SMAP::Recal(int** mat,int lgth,int wdth)
{
 int i,j;
 float max,min;

 /*Initialisation*/
 max=-1000000;
 min=100000000;

 /*Recherche du min*/
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    if (mat[i][j]<min) min=mat[i][j];

 /*plus min*/
   for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
     mat[i][j]-=(int)min;

 /*Recherche du max*/
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) 
    if (mat[i][j]>max) max=mat[i][j];

 /*Recalibre la matrice*/
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
   if (max) mat[i][j]=(int)((float)mat[i][j]*((float)GREY_LEVEL/max));      
}

//--------------------------------
//--------------------------------
//--MULTIMODAL-CHANGE-DETECTION---
//--------------------------------
//----------------------------------------------------------
// SMAP segmentation 
//----------------------------------------------------------
void SMAP::SMAP_MCD(int*** MatGaussParam,float** ImgAft,float Theta,int Versus,float** seg,float PartMedEstim)
{
 int i,j,k;
 short pix;
 float sum;

 //>Presentation_
 theta=Theta;
 versus=Versus;
 printf("\n >  [SMAP](Theta=%0.3f::Dpth=%d::Vers=%d::MedPar=%0.3f)",theta,depth,versus,PartMedEstim);
 fflush(stdout);

 //>Init._py_pmatp[0][nbclass][i][j]_
 for(i=0;i<length_max;i++) for(j=0;j<width_max;j++)
    { pix=(short)ImgAft[i][j];
      py_pmatp[0][0][i][j]=funcgauss(pix,1,MatGaussParam[0][i][j],MatGaussParam[1][i][j]);
      py_pmatp[0][1][i][j]=(1.0/256.0);
      sum=0.0;
      for(k=0;k<nbclass;k++)  sum+=py_pmatp[0][k][i][j];
      for(k=0;k<nbclass;k++)  py_pmatp[0][k][i][j]/=sum; }

  for(i=0;i<length_max;i++) for(j=0;j<width_max;j++) for(k=0;k<nbclass;k++) 
  py_pmatp[0][k][i][j]=log(py_pmatp[0][k][i][j]);

  //>SMAP_Segmentation_
  printf("\n    [fine_to_coarse]");
  fflush(stdout);
  for(i=0;i<depth;i++) { printf("[%d]",i); fflush(stdout); fine_to_coarse(i); }
  init_top_py_pmatl(i,py_pmatl); 
  printf(":&:[coarse_to_fine]");
  if (versus==1) for(i=(depth-1);i>=0;i--) { printf("[%d]",i);  fflush(stdout); coarse_to_fine(i); }
  if (versus==2) for(i=(depth-1);i>=0;i--) { printf("[%d]",i);  fflush(stdout); coarse_to_fine_v2(i); }
  
  //>Result_
  copy_mat(py_pmatl[0],pmatl,length_max,width_max);
  for(i=0;i<length_max;i++) for(j=0;j<width_max;j++)  seg[i][j]=py_pmatl[0][i][j];
}

//----------------------------------------------------------
// SMAP segmentation
//
// [PartMedEstim] used for computing Range
//----------------------------------------------------------
void SMAP::SMAP_MCD(int*** MatGaussParam,float** ImgAft,float Theta,float** seg,float PartMedEstim)
{
 int i,j,k;
 short pix;
 float sum;
 int Range;

 //>Presentation_
 theta=Theta;
 printf("\n >  [SMAP(r)](Theta=%0.3f::Dpth=%d::MedPar=%.2f)",theta,depth,PartMedEstim);
 fflush(stdout);

 //>RangeForUniformLaw
 Range=GiveRangeGreyLevelValues(ImgAft,length_max,width_max,PartMedEstim);
 printf("Range_ImgAft::[%d]",Range);
 fflush(stdout);

 //>Init._py_pmatp[0][nbclass][i][j]_
 for(i=0;i<length_max;i++) for(j=0;j<width_max;j++)
    { pix=(short)ImgAft[i][j];
      py_pmatp[0][0][i][j]=funcgauss(pix,1,MatGaussParam[0][i][j],MatGaussParam[1][i][j]);
      py_pmatp[0][1][i][j]=(1.0/(float(Range)));
      //py_pmatp[0][1][i][j]=(1.0/256.0);
      
      sum=0.0;
      for(k=0;k<nbclass;k++)  sum+=py_pmatp[0][k][i][j];
      for(k=0;k<nbclass;k++)  py_pmatp[0][k][i][j]/=sum; }

  for(i=0;i<length_max;i++) for(j=0;j<width_max;j++) for(k=0;k<nbclass;k++) 
  py_pmatp[0][k][i][j]=log(py_pmatp[0][k][i][j]);

  //>SMAP_Segmentation_
  printf("\n    [fine_to_coarse]");
  fflush(stdout);
  for(i=0;i<depth;i++) { printf("[%d]",i); fflush(stdout); fine_to_coarse(i); }
  init_top_py_pmatl(i,py_pmatl); 
  printf(":&:[coarse_to_fine]");
  for(i=(depth-1);i>=0;i--) { printf("[%d]",i);  fflush(stdout); coarse_to_fine_v2(i); }
  
  //>Result_
  copy_mat(py_pmatl[0],pmatl,length_max,width_max);
  for(i=0;i<length_max;i++) for(j=0;j<width_max;j++)  seg[i][j]=py_pmatl[0][i][j];
}


//----------------------------------------------------------
// Pon/Poff
//----------------------------------------------------------
void SMAP::SMAP_MCD_PonPoff(float** pmatl)
{
 int i,j;

 //MainLoop
 for(i=0;i<length_max;i++) for(j=0;j<width_max;j++)
 if (py_pmatp[0][1][i][j]) pmatl[i][j]=(py_pmatp[0][0][i][j]/py_pmatp[0][1][i][j]);
}


//--------------------------------
//--------------------------------
//---CLEAN------------------------
//--------------------------------
//----------------------------------------------------------
// CopyMatrix       
//----------------------------------------------------------
void CopyMatrix(float** pmatl1,float** pmatl2,int lgth,int wdth)
{
 int i,j;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) pmatl1[i][j]=pmatl2[i][j]; 
}

//----------------------------------------------------------
// Paint        
//----------------------------------------------------------
void Paint(float** mat,float** mattmp,int row,int col,int lgth,int wdth,int lab)
{
   if ((mattmp[row][col]==0)&&(mat[row][col]==lab))
    { 
     mattmp[row][col]=-1;
     
     if ((col+1)<=(wdth-1))   Paint(mat,mattmp,row,col+1,lgth,wdth,lab);
     if ((col-1)>=0)          Paint(mat,mattmp,row,col-1,lgth,wdth,lab);
     if ((row+1)<=(lgth-1))   Paint(mat,mattmp,row+1,col,lgth,wdth,lab);
     if ((row-1)>=0)          Paint(mat,mattmp,row-1,col,lgth,wdth,lab); 
     }

 else return;
}

//----------------------------------------------------------
// FuseRegions
//
// < Petite regions inferieur taille sz fusione avec
//    classe majoritaire l entourant >
//              
//----------------------------------------------------------
int FuseSmallRegions(float** mat,int lgth,int wdth,int* nbreg,int sz)
{
 int i,j,k,l,m,n,t;
 float maxim;
 int  labfuse;
 int cpt;
 int initsize;
 int size_min;
 int nbregion_prec;
 int NbChgt;

 //Allocation 
 float**  mattmp=fmatrix_allocate_2d(lgth,wdth);
 float*   claslb=fmatrix_allocate_1d(256);

 //Init 
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) mat[i][j]=(int)mat[i][j]; 
 NbChgt=0;

 //Init
 size_min=0;
 nbregion_prec=0;
 cpt=10;
 printf("\n    FuseSmallRegions[MinSize%d] NbRegions>",sz);

 //BOUCLE
 //========================================================================
 for(t=0;((t<12)&&(size_min<sz)&&(nbregion_prec!=cpt));t++)
   {

    //Init 
    for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) mattmp[i][j]=0;

       //Boucle
       //-------------------------------------
        for(cpt=0,i=0;i<lgth;i++) for(j=0;j<wdth;j++) if (mattmp[i][j]==0)
              {
	       initsize=0;
               Paint(mat,mattmp,i,j,lgth,wdth,(int)mat[i][j]);
               ++cpt;
               for(k=0;k<256;k++)  claslb[k]=0;

               //RegionsVoisines
               for(k=0;k<lgth;k++) for(l=0;l<wdth;l++) if (mattmp[k][l]==-1)  
	            { initsize++;
                      for(m=-1;m<2;m++) for(n=-1;n<2;n++) 
		        if (((k+m)>=0)&&((k+m)<lgth)&&((l+n)>=0)&&((l+n)<wdth))
		            if (mat[k+m][l+n]<256) claslb[(int)mat[k+m][l+n]]++;  }

               claslb[(int)mat[i][j]]=0;

               //ClasseVoisineMajoritaire
               labfuse=0;
               maxim=0;
               for(k=0;k<256;k++) if (claslb[k]>maxim) { maxim=claslb[k]; labfuse=k; };

               //SiCondition=>Fusion
               if (initsize<=sz)
	          { for(k=0;k<lgth;k++) for(l=0;l<wdth;l++) if (mattmp[k][l]==-1) { mat[k][l]=labfuse; }
                    NbChgt++; }

               for(k=0;k<lgth;k++) for(l=0;l<wdth;l++) if (mattmp[k][l]==-1) mattmp[k][l]=-2;
	      }//---------------------------

     size_min=lgth*wdth;
     for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) mattmp[i][j]=0;

     nbregion_prec=cpt;
     for(cpt=0,i=0;i<lgth;i++) for(j=0;j<wdth;j++) if (mattmp[i][j]==0)
        {
         initsize=0;
         Paint(mat,mattmp,i,j,lgth,wdth,(int)mat[i][j]);
         ++cpt;
 
         for(k=0;k<lgth;k++) for(l=0;l<wdth;l++) if (mattmp[k][l]==-1)  initsize++;

         if (initsize<size_min) size_min=initsize; 

         for(k=0;k<lgth;k++) for(l=0;l<wdth;l++) if (mattmp[k][l]==-1) mattmp[k][l]=-2;  
       }

      printf("[%d]",cpt);
      (*nbreg)=cpt;
      fflush(stdout);
   }//=====================================================================
 
 //Liberation 
 if (mattmp)  free_fmatrix_2d(mattmp); 
 if (claslb)  free_fmatrix_1d(claslb); 

 //Retour
 printf(" NbChgt >[%d]",NbChgt);
 return NbChgt;
}

//----------------------------------------------------------
// duplique float** d'une resolution a l'autre
//----------------------------------------------------------
void Duplique(float** pmatl_init,float** pmatl_final,int size_init)
{
 int row,col;
 int label;

  for(row=0;row<size_init;row++)
    for(col=0;col<size_init;col++)
      {
       label=pmatl_init[row][col];
         pmatl_final[row*2][col*2]=label;
         pmatl_final[(row*2)+1][col*2]=label;
         pmatl_final[(row*2)][(col*2)+1]=label;
         pmatl_final[(row*2)+1][(col*2)+1]=label;
      }
}

//----------------------------------------------------------
// duplique int** d'une resolution a l'autre
//----------------------------------------------------------
void Duplique(int** pmatl_init,int** pmatl_final,int size_init)
{
 int row,col;
 int label;

  for(row=0;row<size_init;row++)
    for(col=0;col<size_init;col++)
      {
       label=pmatl_init[row][col];
       pmatl_final[row*2][col*2]=label;
       pmatl_final[(row*2)+1][col*2]=label;
       pmatl_final[(row*2)][(col*2)+1]=label;
       pmatl_final[(row*2)+1][(col*2)+1]=label;
      }
}

//----------------------------------------------------------
// duplique int** d'une resolution a l'autre
//----------------------------------------------------------
void Duplique(int** pmatl_init,int** pmatl_final,int lsize_init,int wsize_init)
{
 int row,col;
 int label;

  for(row=0;row<lsize_init;row++)
    for(col=0;col<wsize_init;col++)
      {
       label=pmatl_init[row][col];
       pmatl_final[row*2][col*2]=label;
       pmatl_final[(row*2)+1][col*2]=label;
       pmatl_final[(row*2)][(col*2)+1]=label;
       pmatl_final[(row*2)+1][(col*2)+1]=label;
      }
}



//------------------------------------------------
//------------------------------------------------
//------------------------------------------------
// FONCTIONS DE LA CLASSE <SCMAP>      -----------
//------------------------------------------------
//------------------------------------------------
//----------------------------------------------------------
// constructeur de la classe SCMAP
//----------------------------------------------------------
SCMAP::SCMAP(int Lgth,int Wdth,int Dpth)
 {
  int i,j,k;
  const int NB_HYPERPAR_SCMAP=5;
  
  Depth=Dpth;
  Length=Lgth;
  Width=Wdth;
  printf("[Pyr>%d::%d::%d]",Depth,Length,Width);
  fflush(stdout);
  HyperPar=fmatrix_allocate_2d(Dpth+1,NB_HYPERPAR_SCMAP);

  //>DataPyramid
  py_pmatl=allocate_pyramide(Dpth+1,Lgth+10,Width+10);
  py_pmatl_bis=allocate_pyramide(Dpth+1,Lgth+10,Width+10);
  ppictureSeg=fmatrix_allocate_2d(Lgth,Wdth);
  pmatl=fmatrix_allocate_2d(Lgth,Wdth);
  pmatl_bis=fmatrix_allocate_2d(Lgth,Wdth);
  pmatp=fmatrix_allocate_3d(2,Lgth,Wdth);
  
  for(k=0;k<(Dpth+1);k++)
  for(i=0;i<(int)(Lgth/pow(2,k));i++) for(j=0;j<(int)(Wdth/pow(2,k));j++)
     { py_pmatl[k][i][j]=0;
       py_pmatl_bis[k][i][j]=0; }
 }
  
//----------------------------------------------------------
// destructeur de la classe SCMAP
//----------------------------------------------------------
 SCMAP::~SCMAP() 
 {  
  if (HyperPar)     free_fmatrix_2d(HyperPar);
  if (py_pmatl)     free_pyramide(py_pmatl,Depth);
  if (py_pmatl_bis) free_pyramide(py_pmatl_bis,Depth);
  if (ppictureSeg)  free_fmatrix_2d(ppictureSeg);
  if (pmatl)        free_fmatrix_2d(pmatl);
  if (pmatl_bis)    free_fmatrix_2d(pmatl_bis);
  if (pmatp)        free_fmatrix_3d(pmatp,2);
 }

//----------------------------------------------------------
// PCL::Uniform_Law
//----------------------------------------------------------
double SCMAP::Uniform_PCL(float range)
{
  return (1.0/range);
}

//----------------------------------------------------------
// PCL::Gaussian_Law
//----------------------------------------------------------
double SCMAP::Funcgauss_PCL(float pix,float coef,float moy,float var)
{
  return ((coef)*(1/(sqrt(2*PI*var)))*exp(-1*(CARRE(pix-moy))/(2*var)));
}

//----------------------------------------------------------
// calcule le nombre de differences a chaque iteration
//----------------------------------------------------------
int SCMAP::diff_pmatl(float** pmatl1,float** pmatl2,int lgth,int wdth)
{
 int i,j;
 int chgt=0;

 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
 if ((pmatl1[i][j])!=(pmatl2[i][j])) chgt++;
   
 return chgt;
}

//----------------------------------------------------------
// calcule le nombre de differences a chaque iteration
//----------------------------------------------------------
int SCMAP::diff_pmatl(int** pmatl1,int** pmatl2,int lgth,int wdth)
{
 int i,j;
 int chgt=0;

 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
 if ((pmatl1[i][j])!=(pmatl2[i][j])) chgt++;
   
 return chgt;
}

//----------------------------------------------------------
// calcule le nombre de differences a chaque iteration
//----------------------------------------------------------
int SCMAP::diff_pmatl_(int** pmatl1,int** pmatl2,int lgth,int wdth)
{
 int i,j;
 int chgt=0;

 for(i=1;i<(lgth-1);i++) for(j=1;j<(wdth-1);j++)
 if ((pmatl1[i][j])!=(pmatl2[i][j])) chgt++;
   
 return chgt;
}

//----------------------------------------------------------
// alloue de la memoire pour une pyramide d'int
//----------------------------------------------------------
int*** SCMAP::allocate_pyramide(int depth,int vsize,int hsize)
{
 int k;
 int vcursz,hcursz;
 int*** matrix;
 matrix=new int**[depth];

 for(k=0;k<depth;k++)
    { vcursz=vsize/pow(2,k);
      hcursz=hsize/pow(2,k);
      matrix[k]=imatrix_allocate_2d(vcursz,hcursz); }
 return matrix;
}

//----------------------------------------------------------
// libere la memoire de la pyramide d'int
//----------------------------------------------------------
void SCMAP::free_pyramide(int*** py_pmatl,int depth)
{
 for(int i=0;i<depth;i++)
   { delete[] (py_pmatl[i][0]);
     delete[] (py_pmatl[i]); }
 delete[] (py_pmatl);
}


//----------------------------------------------------------
// PCL::contextual_nrj                     
//----------------------------------------------------------
double SCMAP::contextual_nrj_PCL(float* hyperpar,int row,int col,int classe)
{
 double nrj;

 nrj=0.0;
 //cliques horizontales
 if (classe!=pmatl[row][col-1]) nrj+=hyperpar[0];
 if (classe!=pmatl[row][col+1]) nrj+=hyperpar[0];

 //cliques verticales
 if (classe!=pmatl[row-1][col]) nrj+=hyperpar[1];
 if (classe!=pmatl[row+1][col]) nrj+=hyperpar[1];

 //cliques horizontale droite
 if (classe!=pmatl[row+1][col+1]) nrj+=hyperpar[2];
 if (classe!=pmatl[row-1][col-1]) nrj+=hyperpar[2];

 //cliques horizontale gauches
 if (classe!=pmatl[row+1][col-1]) nrj+=hyperpar[3];
 if (classe!=pmatl[row-1][col+1]) nrj+=hyperpar[3];

 return nrj;
}

//----------------------------------------------------------
//  PCL::gibbs_sampler                         
//----------------------------------------------------------
void SCMAP::gibbs_sampler_PCL(float** ppicture,float* hyperpar,int*** MatGausPar,float Range)
{
 int i,j,k;
 double tmp,sum;
 float pix;
 const int NBCLASS=2;

 for(i=1;i<(Length-1);i++) for(j=1;j<(Width-1);j++)
    {
     pix=ppicture[i][j];
     sum=0.0;
     for(k=0;k<NBCLASS;k++)
       { if (k==0) tmp=Funcgauss_PCL(pix,1,MatGausPar[0][i][j],MatGausPar[1][i][j])*exp(-contextual_nrj_PCL(hyperpar,i,j,k));
	 if (k==1) tmp=(Uniform_PCL(Range))*exp(-contextual_nrj_PCL(hyperpar,i,j,k));
	 pmatp[k][i][j]=tmp;  sum+=tmp; }

       for(k=0;k<NBCLASS;k++)  if (sum) pmatp[k][i][j]/=sum;   
    }
}

//----------------------------------------------------------
// PCL::fill_init_matp
//----------------------------------------------------------
void SCMAP::fill_init_matp_PCL(float** ppicture,int row,int col,int*** MatGausPar,float Range)
{
  int k;
  float pix;
  float sum;
  const int NBCLASS=2;

  pix=ppicture[row][col];

  //>[Label<0>::NonChgt-Class][Label<1>::Chgt-Class]
  pmatp[0][row][col]=Funcgauss_PCL(pix,1,MatGausPar[0][row][col],MatGausPar[1][row][col]);
  pmatp[1][row][col]=Uniform_PCL(Range);
  sum=pmatp[0][row][col]+pmatp[1][row][col];
  
  if (sum) for(k=0;k<NBCLASS;k++) pmatp[k][row][col]/=sum;
  else for(k=0;k<NBCLASS;k++) pmatp[k][row][col]=1.0/((float)NBCLASS);
}

//----------------------------------------------------------
// PCL::NRJ d'une réalisation pmatl
//----------------------------------------------------------
double SCMAP::compute_nrj_PCL(float** ppicture,float** pmatl,float* hyperpar,int*** MatGausPar,float Range)
{
 int i,j,label;
 double tmp,sum;

  sum=0;
  for(i=1;i<(Length-1);i++) for(j=1;j<(Width-1);j++)
    { label=pmatl[i][j];
      tmp=0;
      if (label==0) tmp=-log(Funcgauss_PCL(ppicture[i][j],1,MatGausPar[0][i][j],MatGausPar[1][i][j]))+contextual_nrj_PCL(hyperpar,i,j,label);
      if (label==1) tmp=-log(Uniform_PCL(Range))+contextual_nrj_PCL(hyperpar,i,j,label);
      if (!isnan(tmp)) sum+=tmp; }

  return sum;
}

//----------------------------------------------------------
// PCL::ESTIMATION ICM                  
//----------------------------------------------------------
void SCMAP::ICM_Estimate_PCL(float** ppicture,float* hyperpar,float** ppictureSeg,int*** MatGausPar)
{
 int i,j,k;
 int NbChgt;
 float Nrj,Range;

  //>Presentation--
  printf("\n [ICM-PCL]");
  fflush(stdout);

  //>Init.
  Range=GiveRangeGreyLevelValues(ppicture,Length,Width,1.0);
  printf("[Range=%.0f]",Range);
  fflush(stdout);
  for(i=0;i<Length;i++) for(j=0;j<Width;j++) fill_init_matp_PCL(ppicture,i,j,MatGausPar,Range);
  for(i=0;i<Length;i++) for(j=0;j<Width;j++) pmatl[i][j]=0;
  for(i=0;i<Length;i++) for(j=0;j<Width;j++) if (pmatp[1][i][j]>pmatp[0][i][j])  pmatl[i][j]=1;
  
  //>ICM Loop
  for(k=1;k<ITER_ICM;k++)
    {
     for(i=0;i<Length;i++) for(j=0;j<Width;j++) pmatl_bis[i][j]=pmatl[i][j];
     
     gibbs_sampler_PCL(ppicture,hyperpar,MatGausPar,Range);

     for(i=0;i<Length;i++) for(j=0;j<Width;j++)
	{ if (pmatp[1][i][j]>pmatp[0][i][j])  pmatl[i][j]=1;
	  else pmatl[i][j]=0; }
     
     NbChgt=diff_pmatl(pmatl_bis,pmatl,Length,Width);
     Nrj=compute_nrj_PCL(ppicture,pmatl,HyperPar[0],MatGausPar,Range);
     printf("\n [It%d]> [Nrj:%.1f] [Dif:%d]",k,Nrj,NbChgt);
     if (NbChgt<=CHGT_ICM)  break;                                                    
    }

  //>Result
  for(i=0;i<Length;i++) for(j=0;j<Width;j++)  ppictureSeg[i][j]=pmatl[i][j];
}

//------------------
//----------------------------------------------------------
// data_nrj_Block_PCL
//----------------------------------------------------------
double SCMAP::data_nrj_Block_PCL(float** ppicture,int row,int col,int dpth,int label,int*** MatGausPar,float Range)
{
 int i,j; 
 double nrj;
 int rowPic,colPic,SzBlck;

 rowPic=(int)(row*pow(2,dpth));
 colPic=(int)(col*pow(2,dpth));
 SzBlck=(int)(pow(2,dpth));

 nrj=0.0; 
 for(i=rowPic;i<(rowPic+SzBlck);i++) for(j=colPic;j<(colPic+SzBlck);j++)
    {
     if (label==0)
        { if ((i>0)&&(i<Length)&&(j>0)&&(j<Width)) nrj+=-log(Funcgauss_PCL(ppicture[i][j],1,MatGausPar[0][i][j],MatGausPar[1][i][j])); }
     if (label==1)
        { if ((i>0)&&(i<Length)&&(j>0)&&(j<Width)) nrj+=-log(Uniform_PCL(Range)); }
    }
 return nrj;
}

//----------------------------------------------------------
// PCL::contextual_nrj                     
//----------------------------------------------------------
double SCMAP::contextual_nrj_Block_PCL(int row,int col,int dpth,int label,int*** matl,float** HyperPar)
{
 double nrj;

 nrj=0.0;
 //cliques horizontales
 if (label!=matl[dpth][row][col-1]) nrj+=HyperPar[dpth][0];
 if (label!=matl[dpth][row][col+1]) nrj+=HyperPar[dpth][0];

 //cliques verticales
 if (label!=matl[dpth][row-1][col]) nrj+=HyperPar[dpth][1];
 if (label!=matl[dpth][row+1][col]) nrj+=HyperPar[dpth][1];

 //cliques diagonale droite
 if (label!=matl[dpth][row+1][col+1]) nrj+=HyperPar[dpth][2];
 if (label!=matl[dpth][row-1][col-1]) nrj+=HyperPar[dpth][2];

 //cliques diagonale gauches
 if (label!=matl[dpth][row+1][col-1]) nrj+=HyperPar[dpth][3];
 if (label!=matl[dpth][row-1][col+1]) nrj+=HyperPar[dpth][3];

 //clique ascendante
 if (dpth<Depth)
    { if (label!=matl[dpth+1][(int)(row/2)][(int)(col/2)]) nrj+=HyperPar[dpth][4];
      if (label!=matl[dpth+1][(int)(row/2)][(int)(col/2)]) nrj+=HyperPar[dpth][4]; }

 return nrj;
}

//----------------------------------------
// PCL::NRJ d'une réalisation 
//----------------------------------------------------------
double SCMAP::compute_nrj_Block_PCL(float** ppicture,int*** py_pmatl,int Dpth,float* hyperpar,int*** MatGausPar,float Range)
{
 int i,j;
 int label;
 double tmp,sum;

  sum=0.0;
  for(i=1;i<(Length/pow(2,Depth));i++) for(j=1;j<(Width/pow(2,Depth));j++)
    { label=py_pmatl[Dpth][i][j];
      tmp=0.0;
      if (label==0) tmp=data_nrj_Block_PCL(ppicture,i,j,Dpth,label,MatGausPar,Range)+contextual_nrj_PCL(hyperpar,i,j,label); 
      if (label==1) tmp=data_nrj_Block_PCL(ppicture,i,j,Dpth,label,MatGausPar,Range)+contextual_nrj_PCL(hyperpar,i,j,label); 
      if (!isnan(tmp)) sum+=tmp; }

  return sum;
}

//----------------------------------------------------------
// PCL::ESTIMATION SCMAP                  
//----------------------------------------------------------
void SCMAP::SCMAP_Estimate_PCL(float** ppicture,float* HypPar,float** ppictureSeg,int*** MatGausPar)
{
 int i,j,k,l;
 int NbChgt;
 int LgthCur,WdthCur;
 double Nrj,Nrj0,Nrj1,Range;
 const int ITER_SCMAP=10;

  //>Presentation--
  printf("\n [SCMAP-PCL]");
  fflush(stdout);

  //>Init:Range
  Range=GiveRangeGreyLevelValues(ppicture,Length,Width,1.0);
  printf("[Range=%.0f]",Range);
  fflush(stdout);

  //>Init:Hyperparameters
  for(k=0;k<=Depth;k++)
     { //cliques hor.&vert. 
       HyperPar[k][0]=(pow(2,k)+2*(pow(2,k)-1))*HypPar[0];
       HyperPar[k][1]=(pow(2,k)+2*(pow(2,k)-1))*HypPar[1];
       //cliques diag.
       HyperPar[k][2]=HypPar[2];
       HyperPar[k][3]=HypPar[3];  
       //clique ascendante
       HyperPar[k][4]=(pow(4,k))*HypPar[4]; }

  //>Init:TopPyramid
  LgthCur=Length/pow(2,Depth);
  WdthCur=Width/pow(2,Depth);
  for(i=0;i<LgthCur;i++) for(j=0;j<WdthCur;j++)
     { Nrj0=data_nrj_Block_PCL(ppicture,i,j,Depth,0,MatGausPar,Range);
       Nrj1=data_nrj_Block_PCL(ppicture,i,j,Depth,1,MatGausPar,Range);
       if (Nrj1<Nrj0)  py_pmatl[Depth][i][j]=1;
       else            py_pmatl[Depth][i][j]=0; }
  
  printf("...");
  //>DEBUG-(Info)
  //for(k=0;k<5;k++) printf("[%.0f]",HypPar[k]);
  //printf("::");
  //for(k=0;k<5;k++) printf("[%.0f]",HyperPar[Depth][k]);
  fflush(stdout);

  //>DEBUG-(Info)
  //Recal(py_pmatl[Depth],LgthCur,WdthCur);
  //SaveImagePgm((char*)"",(char*)"Seg_ML_SCMAP_TOP",py_pmatl[Depth],LgthCur,WdthCur);
  
  //>MAIN_SCMAP_LOOP______
  for(l=Depth;l>=0;l--)
     {
      //>Var_&_Info
      LgthCur=Length/pow(2,l);
      WdthCur=Width/pow(2,l);
      printf("\n [Dpth:%d][%d::%d]",l,LgthCur,WdthCur);
      fflush(stdout);

      //-LOOP-ITER-----
      for(k=1;k<ITER_SCMAP;k++)
         {
          for(i=0;i<LgthCur;i++) for(j=0;j<WdthCur;j++) py_pmatl_bis[l][i][j]=py_pmatl[l][i][j];

	  //-LOOP-PIXELS-----
	  Nrj=0.0;
	  for(i=1;i<(LgthCur-1);i++) for(j=1;j<(WdthCur-1);j++)
             {
              Nrj0=data_nrj_Block_PCL(ppicture,i,j,l,0,MatGausPar,Range);
              Nrj1=data_nrj_Block_PCL(ppicture,i,j,l,1,MatGausPar,Range);

	      Nrj0+=contextual_nrj_Block_PCL(i,j,l,0,py_pmatl,HyperPar);
	      Nrj1+=contextual_nrj_Block_PCL(i,j,l,1,py_pmatl,HyperPar);

	      if (Nrj1<Nrj0)  { py_pmatl[l][i][j]=1; if (!isnan(Nrj1)) Nrj+=Nrj1; }
	      else            { py_pmatl[l][i][j]=0; if (!isnan(Nrj0)) Nrj+=Nrj0; }
	     }
	  
         NbChgt=diff_pmatl(py_pmatl_bis[l],py_pmatl[l],LgthCur,WdthCur);       
         //Nrj=compute_nrj_Block_PCL(ppicture,py_pmatl,l,HyperPar[l],MatGausPar,Range);
         printf("\n [It%d]> [Nrj:%.1f] [Dif:%d]",k,Nrj,NbChgt);
	 fflush(stdout);
         if (NbChgt<=1)  break;                                                    
         }

      if (l>0) Duplique(py_pmatl[l],py_pmatl[l-1],LgthCur,WdthCur);
      //>DEBUG-(Info)
      //Recal(py_pmatl[l-1],(LgthCur*2),(WdthCur*2));
      //SaveImagePgm((char*)"",(char*)"Seg_SCMAP_DUPL",py_pmatl[l-1],(LgthCur*2),(WdthCur*2));	 
     }

  //>Result
  for(i=0;i<Length;i++) for(j=0;j<Width;j++) ppictureSeg[i][j]=py_pmatl[0][i][j];

  //>DEBUG-(Info)
  //Recal(ppictureSeg,Length,Width);
  //SaveImagePgm((char*)"",(char*)"Seg_SCMAP",ppictureSeg,Length,Width);
}
  
 
