//---------------------------------------------------
// module  : f_MCDCCL.cc                       
// auteur  : Max Mignotte                           
// date    :                                              
// langage : C++                                      
// labo    : DIRO                                 
//---------------------------------------------------

//-----------------------------------------------
// FICHIERS INCLUS ------------------------------
//-----------------------------------------------
#include "MCDCCL.h"

//------------------------------------------------
// METHODES DE LA CLASSE MCDCCL ------------------
//------------------------------------------------
//----------------------------------------------------------
// MCDCCL constructor <Markov-CCL>
//----------------------------------------------------------
MCDCCL::MCDCCL(float*** imgbef,float*** imgaft,float*** imggtr,int lgth,int wdth,char* NmImg,float MyPar)           
 {
  int i,j,k;

  //>Initialization
  length=lgth;
  width=wdth;
  strcpy(NameImg,NmImg);

  MyParam=MyPar;
  FlgSave=0;
  
  //>Memory_Allocation 
  MatImgBef=fmatrix_allocate_3d(TROIS,length,width);
  MatImgAft=fmatrix_allocate_3d(TROIS,length,width);
  MatImgGtr=fmatrix_allocate_3d(TROIS,length,width);
  MatImgSeg=fmatrix_allocate_3d(TROIS,length,width);
  MatImgCon=fmatrix_allocate_3d(TROIS,length,width);
  MatImgBefWB=fmatrix_allocate_2d(length,width);
  MatImgAftWB=fmatrix_allocate_2d(length,width);
  MatImgGtrWB=fmatrix_allocate_2d(length,width);
  MatImgSegWB=fmatrix_allocate_2d(length,width);
  MatImgIniWB=fmatrix_allocate_2d(length,width);

  MatImgTmp1=fmatrix_allocate_2d(length,width);
  MatImgTmp2=fmatrix_allocate_2d(length,width);
  MatImgTmp3=fmatrix_allocate_2d(length,width);
  MatImgTmp4=fmatrix_allocate_2d(length,width);

  //>Init_&_LoadMatrix
  for(k=0;k<TROIS;k++) for(i=0;i<length;i++) for(j=0;j<width;j++) 
     { MatImgBef[k][i][j]=imgbef[k][i][j];     
       MatImgAft[k][i][j]=imgaft[k][i][j];
       MatImgGtr[k][i][j]=imggtr[k][i][j];
       MatImgSeg[k][i][j]=0.0;
       MatImgCon[k][i][j]=0.0; }

  //>Flag_Color_Img
  FlgColorImgB=0;
  for(i=0;i<length;i++) for(j=0;j<width;j++) if (MatImgBef[1][i][j]!=MatImgBef[2][i][j]) { FlgColorImgB=1; }
  FlgColorImgA=0;
  for(i=0;i<length;i++) for(j=0;j<width;j++) if (MatImgAft[0][i][j]!=MatImgAft[2][i][j]) { FlgColorImgA=1; }
  if (FlgColorImgB) printf(" [Image_Before_In_Color]");
  if (FlgColorImgA) printf(" [Image_After_In_Color]");
  if ((FlgColorImgB==0)&&(FlgColorImgA==0)) printf(" [Image_Before_&_After_In_GreyScale]");
  printf("\n Parameters::[MyPar=%.3f]",MyPar);
  printf("\n");

  //>Color-GreyScale Conversion
  //---------------------------
  //>Average_based-Method 
  if (1)
  for(i=0;i<length;i++) for(j=0;j<width;j++)
    { MatImgBefWB[i][j]=((1.0/3.0)*MatImgBef[0][i][j])+((1.0/3.0)*MatImgBef[1][i][j])+((1.0/3.0)*MatImgBef[2][i][j]);
      MatImgAftWB[i][j]=((1.0/3.0)*MatImgAft[0][i][j])+((1.0/3.0)*MatImgAft[1][i][j])+((1.0/3.0)*MatImgAft[2][i][j]); }

  //>Luminosity_based-Method 
  if (0)
  for(i=0;i<length;i++) for(j=0;j<width;j++)
    { MatImgBefWB[i][j]=0.21*MatImgBef[0][i][j]+0.72*MatImgBef[1][i][j]+0.07*MatImgBef[2][i][j];
      MatImgAftWB[i][j]=0.21*MatImgAft[0][i][j]+0.72*MatImgAft[1][i][j]+0.07*MatImgAft[2][i][j]; }

  //>lightnesss_based-Method 
  if (0)
  for(i=0;i<length;i++) for(j=0;j<width;j++)
    { MatImgBefWB[i][j]=0.50*MAX(MAX(MatImgBef[0][i][j],MatImgBef[1][i][j]),MatImgBef[2][i][j]);
      MatImgBefWB[i][j]+=0.50*MIN(MIN(MatImgBef[0][i][j],MatImgBef[1][i][j]),MatImgBef[2][i][j]);
      MatImgAftWB[i][j]=0.50*MAX(MAX(MatImgAft[0][i][j],MatImgAft[1][i][j]),MatImgAft[2][i][j]);
      MatImgAftWB[i][j]+=0.50*MIN(MIN(MatImgAft[0][i][j],MatImgAft[1][i][j]),MatImgAft[2][i][j]); }

   for(i=0;i<length;i++) for(j=0;j<width;j++) MatImgIniWB[i][j]=0;
  				  
   for(i=0;i<length;i++) for(j=0;j<width;j++) MatImgGtrWB[i][j]=MatImgGtr[0][i][j];
   for(i=0;i<length;i++) for(j=0;j<width;j++) MatImgSegWB[i][j]=0;
  
   //>Verif->MatImgGtrWB
   k=0;
   for(i=0;i<length;i++) for(j=0;j<width;j++) if (!((MatImgGtrWB[i][j]==0)||(MatImgGtrWB[i][j]==255))) k++;
   if (k) { printf(" > Probleme: VeriteTerrain avec %d NonWhite || NonBlack pixels\n",k);
            fflush(stdout); }
 
 //Stack_Size_Increased_[128 MB]
 const rlim_t kStackSize=128*1024*1024;   
 struct rlimit rl;
 int result=getrlimit(RLIMIT_STACK,&rl);
 if (result==0)
 if (rl.rlim_cur<kStackSize)
    {  rl.rlim_cur=kStackSize;
       result=setrlimit(RLIMIT_STACK,&rl);
       if (result!=0) fprintf(stderr,"setrlimit returned result = %d\n",result); } 
 }

//----------------------------------------------------------
// MCDCCL destructor
//----------------------------------------------------------
MCDCCL::~MCDCCL()
{ 
  //Memory_Liberation
  if (MatImgBef)  free_fmatrix_3d(MatImgBef,3);
  if (MatImgAft)  free_fmatrix_3d(MatImgAft,3);
  if (MatImgGtr)  free_fmatrix_3d(MatImgGtr,3);
  if (MatImgSeg)  free_fmatrix_3d(MatImgSeg,3);
  if (MatImgCon)  free_fmatrix_3d(MatImgCon,3);
  if (MatImgBefWB)  free_fmatrix_2d(MatImgBefWB);
  if (MatImgAftWB)  free_fmatrix_2d(MatImgAftWB);
  if (MatImgGtrWB)  free_fmatrix_2d(MatImgGtrWB);
  if (MatImgSegWB)  free_fmatrix_2d(MatImgSegWB);
  if (MatImgIniWB)  free_fmatrix_2d(MatImgIniWB);
  if (MatImgTmp1)   free_fmatrix_2d(MatImgTmp1);
  if (MatImgTmp2)   free_fmatrix_2d(MatImgTmp2);
  if (MatImgTmp3)   free_fmatrix_2d(MatImgTmp3);
  if (MatImgTmp4)   free_fmatrix_2d(MatImgTmp4);
}

//----------------------------------------------------------
//----------------------------------------------------------
// Multimodal Detection : <FRCT>
// ----------------------------
//----------------------------------------------------------
void MCDCCL::DetectionMCD_FRCT()
{
  int k;
  int nbreg;
  Chrono chrono;
  
  //>Model_Parameters
  int SZWNDIM;    
  const int EPS=10;           //-Ok----Not-Sensitive--//
  const int KNN=5;            //-Ok----Not very sensitive--//
  const int SIZEMINREG=600;   //-Ok--Sensitive--//
  
  const float POURCSAT=0.0005; //-Ok--Optimal--//
  const int NBGAUSSFILT=10;    //-Ok--Optimal--//

  const float HYPERPARAM=1.0; //-Ok----Not very sensitive--//
  const int NBITEREM=15;      //-Ok--//
  const int NBCLASS=2;
  const int GAUSSIAN_LAW=1;

  //>MemoryAllocation_&_Init
  chrono.reset();
  float*** VctImgDif=fmatrix_allocate_3d(12,length,width);
  float**  ImgDifMean=fmatrix_allocate_2d(length,width);
  float** ImgHist=fmatrix_allocate_2d(256,256);
  float*  hyperpar=fmatrix_allocate_1d(NB_HYPERPAR);
  float** ppar=fmatrix_allocate_2d(NBCLASS,TROIS);
  
  for(k=0;k<NB_HYPERPAR;k++) hyperpar[k]=HYPERPARAM;
  InitZero(ImgDifMean,length,width);

  //>DiffMaps_Estimation_(SZWNDIM:8,16)_(SCALE:1,2,3)
  //-------------------------------------------------
  SZWNDIM=8;  //>8
  EstimFrctDiffMap(MatImgBefWB,MatImgAftWB,VctImgDif[0],length,width,SZWNDIM,2.0,KNN,EPS,POURCSAT);
  SZWNDIM=12; //>12
  EstimFrctDiffMap(MatImgBefWB,MatImgAftWB,VctImgDif[1],length,width,SZWNDIM,2.0,KNN,EPS,POURCSAT);
  SZWNDIM=16; //>16
  EstimFrctDiffMap(MatImgBefWB,MatImgAftWB,VctImgDif[1],length,width,SZWNDIM,2.0,KNN,EPS,POURCSAT);

  MeanMatrix(VctImgDif,length,width,3,ImgDifMean);
  //MeanMatrix(VctImgDif,length,width,1,ImgDifMean);  //-FOR-TESTS
  //SaveImagePgm((char*)"",(char*)"_ImgDif",VctImgDif[0],length,width);
  GaussianFilter(ImgDifMean,length,width,NBGAUSSFILT); 
  //SaveImagePgm(InfoCD,(char*)"_Dif",ImgDifMean,length,width);
  

  //>Estimation-Segmentation_[Full-Resolution]
  //------------------------------------------
  ppar[0][0]=ppar[1][0]=0.5;
  ppar[0][2]=ppar[1][2]=100;
  ppar[0][1]=100;
  ppar[1][1]=200;
  //KmeanEstimate(ImgDifMean,length,width,NBCLASS,ppar,0,1);
  EM MyEm(NBCLASS,GAUSSIAN_LAW,length,width);
  MyEm.EM_Estimate(ImgDifMean,ppar,NBITEREM);
  //SEM MySem(NBCLASS,GAUSSIAN_LAW,length,width);
  //MySem.SEM_Estimate(ImgDifMean,ppar,1,NBITEREM);
  //ECI MyEci(NBCLASS,GAUSSIAN_LAW,length,width);
  //MyEci.ECI_Estimate(ImgDifMean,ppar,hyperpar,NBITEREM);
  //FillPictHist(ImgHist,256,ImgDifMean,length,width,ppar);
  //SaveImagePgm((char*)"",(char*)"_ImgHist",ImgHist,256,256);

  //--MPM MyMpm(NBCLASS,GAUSSIAN_LAW,length,width);
  //--MyMpm.MPM_Estimate(ImgDifMean,ppar,hyperpar,MatImgSegWB);
  ICM MyIcm(NBCLASS,GAUSSIAN_LAW,length,width);
  (MyIcm).ICM_Estimate(ImgDifMean,ppar,hyperpar,MatImgSegWB);
  //(MyIcm).ML_Estimate(ImgDifMean,ppar,MatImgSegWB);
  //const float ThetaPar=0.995;
  //const int SCALETREE=6;
  //SMAP MySmap(NBCLASS,GAUSSIAN_LAW,length,width,SCALETREE);         
  //MySmap.SMAP_Estimate(ImgDifMean,ppar,ThetaPar,2,MatImgSegWB);  
  FuseSmallRegions(MatImgSegWB,length,width,&nbreg,SIZEMINREG);
  Recal(MatImgSegWB,length,width);
  //SaveImagePgm((char*)"",(char*)"_ImgDifSeg",MatImgSegWB,length,width); 

  //>[Result_&_Save]
  //----------------
  printf("\n\n  _Result_Step_[%s]",NameImg);
  elptime=chrono.elapsed(SECOND);
  chrono.print();
  
  float* Result=fmatrix_allocate_1d(4);
  CopyMat(MatImgSeg,MatImgSegWB,length,width);
  ConfusionMatrix(MatImgCon,MatImgSegWB,MatImgGtrWB,length,width,Result);
  fmeasure=FMeasure(MatImgSegWB,MatImgGtrWB,length,width);
  precision=Precis(MatImgSegWB,MatImgGtrWB,length,width);
  
  sprintf(InfoCD,"%s_%sFRCT_K%d_R%d_Fm%.2f_Pr%.1f_Tm%d",NameImg,MyCom,KNN,SIZEMINREG,fmeasure,precision,elptime);
  printf("\n > FMeasure=%.3f  Precision=%.1f  (%s)",fmeasure,precision,InfoCD);

  //if (FlgSave)
     { SaveImagePgm(InfoCD,(char*)"_Dif",ImgDifMean,length,width);
       SaveImagePpm(InfoCD,(char*)"_SegConfus",MatImgCon,length,width);
       SaveImagePgm(InfoCD,(char*)"_SegResult",MatImgSegWB,length,width); }
  
  //>FreeMemory_&_END
  if (VctImgDif)  free_fmatrix_3d(VctImgDif,12);
  if (ImgDifMean) free_fmatrix_2d(ImgDifMean);
  if (ImgHist)    free_fmatrix_2d(ImgHist);
  if (hyperpar)   free_fmatrix_1d(hyperpar);
  if (ppar)       free_fmatrix_2d(ppar);
  if (Result)     free_fmatrix_1d(Result);
  printf("\n\n [END-]\n");
  fflush(stdout);
}

//----------------------------------------------------------
//----------------------------------------------------------
// Multimodal Detection : <CCL>
// ----------------------------
//
//
//----------------------------------------------------------
void MCDCCL::DetectionMCD_CCL()
{
  int k;
  int nbreg;
  Chrono chrono;
  
  //>---[Optimisation]------
  printf(" <<%.0f::",MyParam);   /*--------->TESTS*/

  //>Option
  int ML_SEGMENTATION    =    0;  //-1-
  int ICM_SEGMENTATION   =    1;  //-2-
  int MPM_SEGMENTATION   =    0;  //-3- 
  int SMAP_SEGMENTATION  =    0;  //-4-
  int SCMAP_SEGMENTATION =    0;  //-5-

  if (MyParam)
     { ML_SEGMENTATION=0;
       ICM_SEGMENTATION=0; 
       MPM_SEGMENTATION=0; 
       SMAP_SEGMENTATION=0; 
       SCMAP_SEGMENTATION=0;  
       if (MyParam==1) { ML_SEGMENTATION=1; printf("ML>>"); }
       if (MyParam==2) { ICM_SEGMENTATION=1; printf("MAP>>"); }
       if (MyParam==3) { MPM_SEGMENTATION=1; printf("MPM>>"); }
       if (MyParam==4) { SMAP_SEGMENTATION=1; printf("SMAP>>"); }
       if (MyParam==5) { SCMAP_SEGMENTATION=1; printf("SCMAP>>"); } }
  fflush(stdout);

  //>Model-Parameters
  const int TWO_STEPS=1;     //::ByDefault
  const int SZWND=5;  
  const int KNN=20;   //::EstimationStep
   const float SPATIALBETA=1.0;
  const int DEPTH=9;
  const float THETA=0.9999999;        
  const int DEPTH_SCMAP=2;
  const float INTERSCALEBETA=0.5;  
  //const int SIZEMINREG=200; //::SegmentationStep
  const int SIZEMINREG=0;

  //---Useless------------
  const float TRIMMED=0.0;   
  const int OPT_ESTIM=0;     //--OptionEstimator-[0:Trimmed 1:HSM 2:Shorth 3:LMS]--//
  //const float MEDEST=0.99; //--ForComputingRange--//
  const float MEDEST=1.00;
  //----------------------
  
  //>[Initialization]
  chrono.reset();
  int*** MatGaussParam=imatrix_allocate_3d(2,length,width);
  float**  ImgDifMean=fmatrix_allocate_2d(length,width);
  float*** MatProb=fmatrix_allocate_3d(2,length,width);
  InitZero(MatImgTmp1,length,width);
  InitZero(MatImgTmp2,length,width);

  float*  hyperpar=fmatrix_allocate_1d(5);
  for(k=0;k<4;k++) hyperpar[k]=SPATIALBETA;
  hyperpar[4]=INTERSCALEBETA;

  
  //>---[1]------
  printf("\n [1] _PreProcessing_Step_[%s]",NameImg);
  fflush(stdout);
  //printf(" <<%.2f>>",MyParam);   //------------------------------->TESTS
  //MEDEST=MyParam;                //------------------------------->TESTS
  DoubleSpecifHisto(MatImgBefWB,MatImgAftWB,length,width); 

  //>---[2]------
  printf("\n\n [2] _Parameter_Estimation_Step_[%s]",NameImg);
  NonParaLike* myNPL=new NonParaLike();
  (*myNPL).BuildLikelihood(MatImgBefWB,MatImgAftWB,length,width,SZWND,KNN,MatGaussParam,TRIMMED,OPT_ESTIM);
  FilterMat(MatGaussParam,length,width,0,1,1);  //>NbMap::Nb:::Methd

  //>---[3]------
  printf("\n [3] _Rough_Segmentation_Step_[%s]",NameImg);

  if (ML_SEGMENTATION)
     { ICM* MyMlStep1=new ICM(2,0,length,width);
       for(k=0;k<4;k++) hyperpar[k]=0.0;
       (*MyMlStep1).ICM_Estimate_PCL(MatImgAftWB,hyperpar,MatImgTmp1,MatGaussParam);
       if (MyMlStep1) delete (MyMlStep1);  }
  if (SMAP_SEGMENTATION)
     { SMAP* MySmapStep1=new SMAP(length,width,DEPTH);
       (*MySmapStep1).SMAP_MCD(MatGaussParam,MatImgAftWB,THETA,MatImgTmp1,MEDEST);
       if (MySmapStep1) delete (MySmapStep1); }
  if (ICM_SEGMENTATION)
     { ICM* MyIcmStep1=new ICM(2,0,length,width);
       (*MyIcmStep1).ICM_Estimate_PCL(MatImgAftWB,hyperpar,MatImgTmp1,MatGaussParam);
       if (MyIcmStep1) delete (MyIcmStep1); }
  if (MPM_SEGMENTATION)
     { ICM* MyMpmStep1=new ICM(2,0,length,width);
       (*MyMpmStep1).MPM_Estimate_PCL(MatImgAftWB,hyperpar,MatImgTmp1,MatGaussParam);
       if (MyMpmStep1) delete (MyMpmStep1); }
  if (SCMAP_SEGMENTATION)
    { SCMAP* MyScmapStep1=new SCMAP(length,width,DEPTH_SCMAP);
      (*MyScmapStep1).SCMAP_Estimate_PCL(MatImgAftWB,hyperpar,MatImgTmp1,MatGaussParam);
      if (MyScmapStep1) delete (MyScmapStep1); }
       
  FuseSmallRegions(MatImgTmp1,length,width,&nbreg,SIZEMINREG);  
  Recal(MatImgTmp1,length,width); 
  CopyMat(MatImgTmp2,MatImgTmp1,length,width);
  //SaveImagePgm((char*)"",(char*)"_RoughMarkovSeg",MatImgTmp1,length,width);

  //>---[4]----
  if (TWO_STEPS)
     { printf("\n\n [4] _Refine_Parameter_Estimation_And_Segmentation_Step_[%s]",NameImg);
       (*myNPL).ReBuildLikelihood(MatImgBefWB,MatImgAftWB,length,width,SZWND,KNN,MatGaussParam,MatImgTmp1,TRIMMED,OPT_ESTIM);
       FilterMat(MatGaussParam,length,width,0,1,1);  //>NbMap::Nb:::Methd

       if (ML_SEGMENTATION)
          { ICM* MyMlStep2=new ICM(2,0,length,width);
            for(k=0;k<4;k++) hyperpar[k]=0.0;
            (*MyMlStep2).ICM_Estimate_PCL(MatImgAftWB,hyperpar,MatImgTmp1,MatGaussParam);
            if (MyMlStep2) delete (MyMlStep2);  }
       if (SMAP_SEGMENTATION)
          { SMAP* MySmapStep2=new SMAP(length,width,DEPTH);
           (*MySmapStep2).SMAP_MCD(MatGaussParam,MatImgAftWB,THETA,MatImgTmp2,MEDEST);
           (*MySmapStep2).SMAP_MCD_PonPoff(ImgDifMean); 
           if (MySmapStep2) delete (MySmapStep2); }
       if (ICM_SEGMENTATION)
          { ICM* MyIcmStep2=new ICM(2,0,length,width);
           (*MyIcmStep2).ICM_Estimate_PCL(MatImgAftWB,hyperpar,MatImgTmp2,MatGaussParam);
           if (MyIcmStep2) delete (MyIcmStep2); }
       if (MPM_SEGMENTATION)
          { ICM* MyMpmStep2=new ICM(2,0,length,width);
	    (*MyMpmStep2).MPM_Estimate_PCL(MatImgAftWB,hyperpar,MatImgTmp2,MatGaussParam);
            if (MyMpmStep2) delete (MyMpmStep2); }
       if (SCMAP_SEGMENTATION)
	  { SCMAP* MyScmapStep2=new SCMAP(length,width,DEPTH_SCMAP);
            (*MyScmapStep2).SCMAP_Estimate_PCL(MatImgAftWB,hyperpar,MatImgTmp2,MatGaussParam);
            if (MyScmapStep2) delete (MyScmapStep2); }    
       
       FuseSmallRegions(MatImgTmp2,length,width,&nbreg,SIZEMINREG);
       Recal(MatImgTmp2,length,width);       
       //SaveImagePgm((char*)"",(char*)"_MarkovSeg_SMAP",MatImgTmp2,length,width);
     }

  //>[Result_&_Save]
  printf("\n\n  _Result_Step_[%s]",NameImg);
  printf("\n");
  elptime=chrono.elapsed(SECOND);
  chrono.print();
  float* Result=fmatrix_allocate_1d(4);
  CopyMat(MatImgSegWB,MatImgTmp2,length,width);
  CopyMat(MatImgSeg,MatImgTmp2,length,width);
  ConfusionMatrix(MatImgCon,MatImgSegWB,MatImgGtrWB,length,width,Result);
  fmeasure=FMeasure(MatImgSegWB,MatImgGtrWB,length,width);
  precision=Precis(MatImgSegWB,MatImgGtrWB,length,width);

  sprintf(InfoCD,"%s_%s-CCL_Fm%.2f_Pr%.1f_Tm%d",NameImg,MyCom,fmeasure,precision,elptime);
  //sprintf(InfoCD,"%s_%sCCL_K%d_M%.2f_T%.3f_Fm%.2f_Pr%.1f_Tm%d",NameImg,MyCom,KNN,MEDEST,THETA,fmeasure,precision,elptime);
  //sprintf(InfoCD,"%s_%sCCL-Fm%.2f_Pr%.1f",NameImg,MyCom,fmeasure,precision);
  //sprintf(InfoCD,"%s_%sCCL_S%d_K%d_D%d_M%.2f_T%.3f_Fm%.2f_Pr%.1f_Tm%d",NameImg,MyCom,SZWND,KNN,DEPTH,MEDEST,THETA,fmeasure,precision,elptime);
  printf("\n > FMeasure=%.3f  Precision=%.1f  (%s)",fmeasure,precision,InfoCD);

  //if (FlgSave)
     { //SaveImagePgm(InfoCD,(char*)"_Dif",ImgDifMean,length,width);
       SaveImagePgm(InfoCD,(char*)"_SegResult",MatImgSegWB,length,width);
       SaveImagePpm(InfoCD,(char*)"_SegConfus",MatImgCon,length,width); }
  
  //>FreeMemory_&_END
  if (MatGaussParam) free_imatrix_3d(MatGaussParam,2);
  if (ImgDifMean)    free_fmatrix_2d(ImgDifMean);
  if (MatProb)       free_fmatrix_3d(MatProb,2);
  if (myNPL)         delete(myNPL);
  if (hyperpar)   free_fmatrix_1d(hyperpar);
  printf("\n\n [END]\n");
}
