//---------------------------------------------------
// module  : f_NonParaLike.cc                       
// auteur  : Max Mignotte                           
// date    :                                              
// langage : C++                                      
// labo    : DIRO                                 
//---------------------------------------------------

//-----------------------------------------------
// FICHIERS INCLUS ------------------------------
//-----------------------------------------------
#include "NonParaLike.h"

//------------------------------------------------
// METHODES DE LA CLASSE NONPARALIKE  ------------
//------------------------------------------------
//----------------------------------------------------------
// NONPARALIKE constructor
//----------------------------------------------------------
NonParaLike::NonParaLike()           
 {
   ;
 }

//----------------------------------------------------------
// NONPARALIKE destructor
//----------------------------------------------------------
NonParaLike::~NonParaLike()
{ 
  ;
}


//----------------------------------------------------------
// BuildLikelihood<Test2>
//----------------------------------------------------------
void NonParaLike::BuildLikelihoodTest2(float** ImgBef,float** ImgAft,int lgth,int wdth,int SzW,int knn)
{
 int i,j,k,l,m,r,c;
 int simnb;
 int posr,posc;
 int nb;
  
 //>ModelParameters_
 const int nb_sym=8;
 const int EPS=0;
 const int KNN=knn; 
 const int n_pts=(lgth*wdth*nb_sym);
 const int dim=(SzW*SzW);

 //>AnnParameters_&_Allocation_
 ANNpointArray data_pts;
 ANNpoint       query_pt;
 ANNidxArray    nn_idx;
 ANNdistArray   dists;
 ANNkd_tree      *the_tree;

 query_pt=annAllocPt(dim);
 data_pts=annAllocPts(n_pts,dim);
 nn_idx=new ANNidx[KNN];
 dists=new ANNdist[KNN];

 //>AllocateMemory_&_Init_
 int** SquWinIn=imatrix_allocate_2d(SzW,SzW);
 int** SquWinOut=imatrix_allocate_2d(SzW,SzW);
 int** PosPix=imatrix_allocate_2d(3,n_pts);

 //>Read_Data_
 nb=0;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    {
     for(k=0;k<SzW;k++) for(l=0;l<SzW;l++)
	{ posr=i-(SzW/2)+k;
          posc=j-(SzW/2)+l;
          if (posr<0)          posr+=lgth;
          if (posr>(lgth-1))   posr-=lgth;  
          if (posc<0)          posc+=wdth;
          if (posc>(wdth-1))   posc-=wdth;
	  SquWinIn[k][l]=ImgBef[posr][posc]; }

	  for(m=0;m<nb_sym;m++)
	     { MakeSymmetry(SquWinIn,SquWinOut,SzW,m);
               for(r=0;r<SzW;r++) for(c=0;c<SzW;c++) data_pts[nb][(r*SzW)+c]=SquWinOut[r][c];
	       PosPix[0][nb]=m;
	       PosPix[1][nb]=i;
	       PosPix[2][nb]=j;
	       nb++; }
    }

 //>BuildSearchStrucure_
 the_tree=(ANNkd_tree*)new ANNkd_tree(data_pts,n_pts,dim);

 //>Test
 for(k=0;k<SzW;k++) for(l=0;l<SzW;l++)
    { posr=101-(SzW/2)+k;
      posc=102-(SzW/2)+l;
      SquWinIn[k][l]=ImgBef[posr][posc]; }
 for(r=0;r<SzW;r++) for(c=0;c<SzW;c++) query_pt[(r*SzW)+c]=SquWinIn[r][c];

 the_tree->annkSearch(query_pt,KNN,nn_idx,dists,EPS);
 for(k=0;k<KNN;k++)
    { printf("\n %d::index=%d  dist=%.0f",k,nn_idx[k],dists[k]);
      simnb=PosPix[0][nn_idx[k]];
      posr=PosPix[1][nn_idx[k]];
      posc=PosPix[2][nn_idx[k]];
      printf(" [Sim=%d::Row=%d::Col=%d]",simnb,posr,posc);
      printf(" > [%.0f]::[%.0f]",ImgBef[posr][posc],ImgAft[posr][posc]); }
 
 //>FreeMemory
 if (data_pts!=NULL)  delete data_pts;
 if (the_tree!=NULL)  delete the_tree;
 if (dists!=NULL)     delete dists;
 if (query_pt!=NULL)  delete query_pt;
 if (nn_idx!=NULL)    delete nn_idx;
 if (SquWinIn)  free_imatrix_2d(SquWinIn);
 if (SquWinOut) free_imatrix_2d(SquWinOut);
 if (PosPix)    free_imatrix_2d(PosPix);
}

//----------------------------------------------------------
// BuildLikelihood
//----------------------------------------------------------
void NonParaLike::BuildLikelihood(float** ImgBef,float** ImgAft,\
				  int lgth,int wdth,int SzW,int knn,int*** MatGaussParam,float Trim,int OptEstim)
{
 int i,j,k,l,m,p,r,c;
 int posr,posc;
 int cpt;

 //>Presenetation
 printf("\n > 1--Build Non-Parametric Likelihood [SzW:%d][Knn:%d][Tr:%.3f]",SzW,knn,Trim);
 fflush(stdout);
  
 //>ModelParameters_
 const int nb_sym=8;
 const int EPS=10;   //-A-TESTER_(20,50,100)
 const int KNN=knn; 
 const int n_pts=(lgth*wdth*nb_sym);
 const int dim=(SzW*SzW);
 const float FACT_VAR=1.0;

 //>AnnParameters_&_Allocation_
 ANNpointArray data_pts;
 ANNpoint       query_pt;
 ANNidxArray    nn_idx;
 ANNdistArray   dists;
 ANNkd_tree      *the_tree;

 query_pt=annAllocPt(dim);
 data_pts=annAllocPts(n_pts,dim);
 nn_idx=new ANNidx[KNN];
 dists=new ANNdist[KNN];

 //>AllocateMemory_&_Init_
 int** SquWinIn=imatrix_allocate_2d(SzW,SzW);
 int** SquWinOut=imatrix_allocate_2d(SzW,SzW);
 int** PosPix=imatrix_allocate_2d(3,n_pts);
 int*** MatCorGL=imatrix_allocate_3d(KNN,lgth,wdth);
 int*** MatGaussPar=imatrix_allocate_3d(2,lgth,wdth);

 //>_BuildTreeSearchStructure_
 printf("\n   :A::Build_Tree_Search_Structure_...");
 fflush(stdout);
 cpt=0;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    { for(k=0;k<SzW;k++) for(l=0;l<SzW;l++)
	 { posr=i-(SzW/2)+k;
           posc=j-(SzW/2)+l;
           if (posr<0)          posr+=lgth;
           if (posr>(lgth-1))   posr-=lgth;  
           if (posc<0)          posc+=wdth;
           if (posc>(wdth-1))   posc-=wdth;
	   SquWinIn[k][l]=ImgBef[posr][posc]; }

	   for(m=0;m<nb_sym;m++)
	      { MakeSymmetry(SquWinIn,SquWinOut,SzW,m);
                for(r=0;r<SzW;r++) for(c=0;c<SzW;c++) data_pts[cpt][(r*SzW)+c]=SquWinOut[r][c];
	        PosPix[0][cpt]=m;
	        PosPix[1][cpt]=i;
	        PosPix[2][cpt]=j;
	        cpt++; }  }
 the_tree=(ANNkd_tree*)new ANNkd_tree(data_pts,n_pts,dim);

 //>BuildCorrespondanceInImgAft_
 printf("\n   :B::Build_Correspondance_In_ImgAft_...\n");
 fflush(stdout);
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    { printf("\r   [%d/%d]",i+1,lgth);
      fflush(stdout); 
      for(k=0;k<SzW;k++) for(l=0;l<SzW;l++)
	 { posr=i-(SzW/2)+k;
           posc=j-(SzW/2)+l;
           if (posr<0)          posr+=lgth;
           if (posr>(lgth-1))   posr-=lgth;  
           if (posc<0)          posc+=wdth;
           if (posc>(wdth-1))   posc-=wdth;
	   SquWinIn[k][l]=ImgBef[posr][posc]; }
      
      for(r=0;r<SzW;r++) for(c=0;c<SzW;c++) query_pt[(r*SzW)+c]=SquWinIn[r][c];
      the_tree->annkSearch(query_pt,KNN,nn_idx,dists,EPS);

      for(p=0;p<KNN;p++)
         { posr=PosPix[1][nn_idx[p]];
           posc=PosPix[2][nn_idx[p]];
	   MatCorGL[p][i][j]=ImgAft[posr][posc]; }  }
  
  //>DEBUG
  //if (1)
  //   { for(k=0;k<KNN;k++) printf("[%d]",MatCorGL[k][100][100]);
  //     EstimateGaussianPar2(MatCorGL,KNN,100,100,MatGaussPar);
  //     printf(" <%d:%d>",MatGaussPar[0][100][100],MatGaussPar[1][100][100]); }
  //     exit(-1);

  //>EstimateGaussianParameters
  printf("\n   :C::Estimate_Gaussian_Parameters_...\n");
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) EstimateGaussianParRobust(MatCorGL,KNN,i,j,MatGaussPar,Trim,OptEstim);      
  for(k=0;k<2;k++) for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) MatGaussParam[k][i][j]=MatGaussPar[k][i][j];
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) MatGaussParam[1][i][j]/=FACT_VAR;
  
  //>DEBUG
  //if (1)
  //   { for(k=0;k<KNN;k++) printf("[%d]",MatCorGL[k][100][100]);
  //     printf(" <%d:%d>",MatGaussPar[0][100][100],MatGaussPar[1][100][100]); }
  //   exit(-1);

 //>FreeMemory
 if (data_pts!=NULL)  delete data_pts;
 if (the_tree!=NULL)  delete the_tree;
 if (dists!=NULL)     delete dists;
 if (query_pt!=NULL)  delete query_pt;
 if (nn_idx!=NULL)    delete nn_idx;
 if (SquWinIn)    free_imatrix_2d(SquWinIn);
 if (SquWinOut)   free_imatrix_2d(SquWinOut);
 if (PosPix)      free_imatrix_2d(PosPix);
 if (MatCorGL)    free_imatrix_3d(MatCorGL,KNN);
 if (MatGaussPar) free_imatrix_3d(MatGaussPar,2);
}

//----------------------------------------------------------
// Re-BuildLikelihood
//----------------------------------------------------------
void NonParaLike::ReBuildLikelihood(float** ImgBef,float** ImgAft,\
     int lgth,int wdth,int SzW,int knn,int*** MatGaussParam,float** RoughSeg,float Trim,int OptEstim)
{
 int i,j,k,l,m,p,r,c;
 int posr,posc;
 int cpt;
 int flag;

 //>Presenetation
 printf("\n > 2--Re-Build Non-Parametric Likelihood [SzW:%d][Knn:%d][Tr:%.3f]",SzW,knn,Trim);
 fflush(stdout);
  
 //>ModelParameters_
 const int nb_sym=8;
 const int EPS=10;   
 const int KNN=knn; 
 const int n_pts=(lgth*wdth*nb_sym);
 const int dim=(SzW*SzW);
 const int ABERANTVALUE=300;
 const float FACT_VAR=1.0;

 //>AnnParameters_&_Allocation_
 ANNpointArray data_pts;
 ANNpoint       query_pt;
 ANNidxArray    nn_idx;
 ANNdistArray   dists;
 ANNkd_tree      *the_tree;

 query_pt=annAllocPt(dim);
 data_pts=annAllocPts(n_pts,dim);
 nn_idx=new ANNidx[KNN];
 dists=new ANNdist[KNN];

 //>AllocateMemory_&_Init_
 int** SquWinIn=imatrix_allocate_2d(SzW,SzW);
 int** SquWinOut=imatrix_allocate_2d(SzW,SzW);
 int** PosPix=imatrix_allocate_2d(3,n_pts);
 int*** MatCorGL=imatrix_allocate_3d(KNN,lgth,wdth);
 int*** MatGaussPar=imatrix_allocate_3d(2,lgth,wdth);

 //>_BuildTreeSearchStructure_
 printf("\n   :A::Re-Build_Tree_Search_Structure_...");
 fflush(stdout);
 cpt=0;
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    { flag=0;
      for(k=0;k<SzW;k++) for(l=0;l<SzW;l++)
	 { posr=i-(SzW/2)+k;
           posc=j-(SzW/2)+l;
           if (posr<0)          posr+=lgth;
           if (posr>(lgth-1))   posr-=lgth;  
           if (posc<0)          posc+=wdth;
           if (posc>(wdth-1))   posc-=wdth;
	   if (RoughSeg[posr][posc])  flag=1;
	   SquWinIn[k][l]=ImgBef[posr][posc]; }

          //-Option-[0]-::[RoughSeg in [i][j]]
          //if ((opt==0)&&(RoughSeg[i][j]))
	  //   { for(r=0;r<SzW;r++) for(c=0;c<SzW;c++) SquWinIn[r][c]=ABERANTVALUE; }  

	  //-Option-[1]-<Best>::[RoughSeg in SquWinIn]
	  //if ((opt==1)&&(flag==1))
          if (flag==1)
	     { for(r=0;r<SzW;r++) for(c=0;c<SzW;c++) SquWinIn[r][c]=ABERANTVALUE; }

	   for(m=0;m<nb_sym;m++)
	      { MakeSymmetry(SquWinIn,SquWinOut,SzW,m);
                for(r=0;r<SzW;r++) for(c=0;c<SzW;c++) data_pts[cpt][(r*SzW)+c]=SquWinOut[r][c];
	        PosPix[0][cpt]=m;
	        PosPix[1][cpt]=i;
	        PosPix[2][cpt]=j;
	        cpt++; }  }
 the_tree=(ANNkd_tree*)new ANNkd_tree(data_pts,n_pts,dim);

 //>BuildCorrespondanceInImgAft_
 printf("\n   :B::Re-Build_Correspondance_In_ImgAft_...\n");
 fflush(stdout);
 for(i=0;i<lgth;i++) for(j=0;j<wdth;j++)
    { printf("\r   [%d/%d]",i+1,lgth);
      fflush(stdout); 
      for(k=0;k<SzW;k++) for(l=0;l<SzW;l++)
	 { posr=i-(SzW/2)+k;
           posc=j-(SzW/2)+l;
           if (posr<0)          posr+=lgth;
           if (posr>(lgth-1))   posr-=lgth;  
           if (posc<0)          posc+=wdth;
           if (posc>(wdth-1))   posc-=wdth;
	   SquWinIn[k][l]=ImgBef[posr][posc]; }
      
      for(r=0;r<SzW;r++) for(c=0;c<SzW;c++) query_pt[(r*SzW)+c]=SquWinIn[r][c];
      the_tree->annkSearch(query_pt,KNN,nn_idx,dists,EPS);

      for(p=0;p<KNN;p++)
         { posr=PosPix[1][nn_idx[p]];
           posc=PosPix[2][nn_idx[p]];
	   MatCorGL[p][i][j]=ImgAft[posr][posc]; }  }

  //>DEBUG::CHECK
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) for(p=0;p<KNN;p++)
  if (MatCorGL[p][i][j]==ABERANTVALUE) printf("!");
  fflush(stdout);
  
  //>EstimateGaussianParameters
  printf("\n   :C::Re-Estimate_Gaussian_Parameters_...\n");
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) EstimateGaussianParRobust(MatCorGL,KNN,i,j,MatGaussPar,Trim,OptEstim);  
  for(k=0;k<2;k++) for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) MatGaussParam[k][i][j]=MatGaussPar[k][i][j];
  for(i=0;i<lgth;i++) for(j=0;j<wdth;j++) MatGaussParam[1][i][j]/=FACT_VAR;

 //>FreeMemory
 if (data_pts!=NULL)  delete data_pts;
 if (the_tree!=NULL)  delete the_tree;
 if (dists!=NULL)     delete dists;
 if (query_pt!=NULL)  delete query_pt;
 if (nn_idx!=NULL)    delete nn_idx;
 if (SquWinIn)    free_imatrix_2d(SquWinIn);
 if (SquWinOut)   free_imatrix_2d(SquWinOut);
 if (PosPix)      free_imatrix_2d(PosPix);
 if (MatCorGL)    free_imatrix_3d(MatCorGL,KNN);
 if (MatGaussPar) free_imatrix_3d(MatGaussPar,2);
}

