/*

IFT1166 - Spécificités C++ -

29 - décembre  - 2025 v1.00	M.Lokbani - C++23, gcc 15.2


Contact: lokbani@iro.umontreal.ca

        
	Copyright (C) 2003 - 2026 Université de Montréal
	Département d'Informatique et de Recherche Opérationnelle
	Mohamed Lokbani
	-- Tous Droits Réservés -- All Rights Reserved --

Description:
------------

	[Chapitre 04] Spécificités C++
	Portée d'une variable et généralisation de la résolution de portée.
	
	Nous avons déclaré la variable « :: » dans 3 endroits:
		- au niveau global (i=700)
		- au niveau local dans une boucle (i=0)
		- au niveau local dans « main » (i=50)
	
	Dans chaque bloc, la variable locale masque la présence de la variable globale.
	
	Il y a un moyen pour récupérer la variable globale (i=700). On utilise pour cela
	l'opérateur de résolution de portée « :: ». C'est le même principe que « std::cout ».
	
	La valeur de « i » déclarée telle quelle dans le « main » n'est jamais visible dans
	la boucle « for ».
	
	
*/


#include <iostream>

using namespace std;

int i = 700; // i au niveau global

int main(){

	cout << "i (dans global au debut): " << ::i << endl;
	
	int i=50; // i est locale a ce bloc (main) 

	cout << "i (dans main au debut): " << i << endl;
	
	for (int i=0;i<1;i++) {  // i est locale a ce bloc (for)
		cout << "i (dans for): " << i << endl;
		cout << "i (dans main ou global?): " << ::i << endl;

	} // Fin de portee de i (dans for)
	
	cout << "i (dans main a la fin): " << i << endl;
	cout << "i (dans global a la fin): " << ::i << endl;
	
	return 0;
} // Fin de portée de tous les variables du programme i/main et i/global