/*
Historique:
-----------
    Module:        demo05exo1.cpp
    Auteur:        Mohamed Lokbani
    Date cration: 11 octobre 2003
    Version:       1.05
    
    Modifications:
        11 octobre 2003 - M.Lokbani - gcc3.2
        26 sept    1999 - M.Lokbani - nonc + correction de l'exercice

    Copyright (C) 2003 Universit de Montral
            Dpartement d'informatique et de Recherche Oprationnelle
            Mohamed Lokbani
    -- Tous Droits Rservs -- All Rights Reserved --

Description:
------------
    Le but de cet exercice est de vous pratiquer  la conception d'une classe.
    Ses constructeurs et son destructeur.
    
*/

#include <iostream>
#include <iomanip>

using namespace std;

// on affiche aussi l'adresse de l'objet. Cela va nous permettre de mieux voir
// le droulement des oprations de construction et de destruction des objets
// pour une meilleure description voir l'affichage en sortie

class date {
private: // facultatif si en tete
    int jour;
    int mois;
    int annee;
public:
    date (int jour,int mois, int annee); // constructeur initialiseur
    date (void); // constructeur par dfaut
    ~date (void); // destructeur
    void affiche_date (void); // fonction membre
};

// constructeur initialiseur
date::date(int j,int m,int a) {
    jour = j;
    mois = m;
    annee = a;
    cout << "constructeur initialiseur Obj: " << this << " " \
        << setw(2) << setfill('0') << jour << "/" << setw(2) \
        << setfill('0') << mois << "/" << annee << endl;
    affiche_date();
}

// constructeur par dfaut
date::date(void) {
    cout << "constructeur par dfaut Obj: " << this  << endl;
}

// destructeur
date::~date(void) {
    cout << "destructeur obj " << this << " " << setw(2) << setfill('0') \
        << jour << "/" << setw(2) << setfill('0') << mois << "/" << annee << endl;
    affiche_date();
}

void date::affiche_date (void) {
    cout << "Obj " << this << " jour: " << jour << " mois: " \
        << mois << " anne: " << annee << endl;
}

int main () {

    date fetes[2]; // 2 constructeurs par dfaut

    date nouvel_an(1,1,2000); // constructeur init + affichage
    date travail(4,9,2000); // constructeur init + affichage
  
    fetes[0] = nouvel_an; 
    fetes[1] = travail;

    fetes[0].affiche_date(); // affichage

    // Question en plus: que se passe t-il si on a un espace alloue par un constructeur
    // au moment de la recopie ? => l'oprateur de recopie date(const &date)
  return 0;
}


/*

    Ce que vous obtenez en sortie est comme suit:

        >demo05exo1sol
            constructeur par dfaut Obj: 0x22ff40
            constructeur par dfaut Obj: 0x22ff4c
            constructeur initialiseur Obj: 0x22fef0 01/01/2000
            Obj 0x22fef0 jour: 1 mois: 1 anne: 2000
            constructeur initialiseur Obj: 0x22fed0 04/09/2000
            Obj 0x22fed0 jour: 4 mois: 9 anne: 2000
            Obj 0x22ff40 jour: 1 mois: 1 anne: 2000
            destructeur obj 0x22fed0 04/09/2000
            Obj 0x22fed0 jour: 4 mois: 9 anne: 2000
            destructeur obj 0x22fef0 01/01/2000
            Obj 0x22fef0 jour: 1 mois: 1 anne: 2000
            destructeur obj 0x22ff4c 04/09/2000
            Obj 0x22ff4c jour: 4 mois: 9 anne: 2000
            destructeur obj 0x22ff40 01/01/2000
            Obj 0x22ff40 jour: 1 mois: 1 anne: 2000
        >Exit code: 0



*/

